/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.Line2Offset;
import org.openide.filesystems.FileSystem;

public final class FileBufferSnapshot
implements APTFileBuffer {
    private final CharSequence absPath;
    private final FileSystem fileSystem;
    private final char[] buffer;
    private final long timeStamp;
    private Reference<Line2Offset> lines;

    public FileBufferSnapshot(FileSystem fileSystem, CharSequence charSequence, char[] cArray, int[] nArray, long l) {
        this.absPath = charSequence;
        this.fileSystem = fileSystem;
        this.buffer = cArray;
        this.timeStamp = l;
        this.lines = nArray != null ? new WeakReference<Line2Offset>(new Line2Offset(cArray, nArray)) : new WeakReference<Object>(null);
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public CharSequence getAbsolutePath() {
        return this.absPath;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public char[] getCharBuffer() throws IOException {
        return this.buffer;
    }

    public int[] getLineColumnByOffset(int n) throws IOException {
        return this.getLine2Offset().getLineColumnByOffset(n);
    }

    public int getOffsetByLineColumn(int n, int n2) throws IOException {
        return this.getLine2Offset().getOffsetByLineColumn(n, n2);
    }

    private Line2Offset getLine2Offset() throws IOException {
        Line2Offset line2Offset = null;
        Reference<Line2Offset> reference = this.lines;
        if (reference != null) {
            line2Offset = reference.get();
        }
        if (line2Offset == null) {
            line2Offset = new Line2Offset(this.getText());
            this.lines = new WeakReference<Line2Offset>(line2Offset);
        }
        return line2Offset;
    }

    public String getText(int n, int n2) {
        return new String(this.buffer, n, n2 - n);
    }

    public String getText() {
        return new String(this.buffer);
    }
}

