/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmCompilationUnit;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.GraphContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;

public final class DeepReparsingUtils {
    private DeepReparsingUtils() {
    }

    static void reparseOnEditingFile(ProjectImpl projectImpl, FileImpl fileImpl) {
        projectImpl.markAsParsingPreprocStates(fileImpl.getAbsolutePath());
        fileImpl.markReparseNeeded(false);
        ParserQueue.instance().add(fileImpl, Collections.singleton(FileImpl.DUMMY_STATE), ParserQueue.Position.HEAD, false, ParserQueue.FileAction.NOTHING);
    }

    public static void reparseOnChangedFile(FileImpl fileImpl, ProjectBase projectBase) {
        boolean bl = true;
        GraphContainer.ParentFiles parentFiles = projectBase.getGraph().getTopParentFiles(fileImpl);
        Set<CsmFile> set = parentFiles.getCompilationUnits();
        Set<CsmFile> set2 = parentFiles.getParentFiles();
        if (set.size() > 0) {
            fileImpl.clearStateCache();
            Set<CsmFile> set3 = projectBase.getGraph().getCoherenceFiles(fileImpl).getCoherenceFiles();
            DeepReparsingUtils.updateStartFilesWithBestStartFiles(set3, set);
            for (CsmFile csmFile : set3) {
                if (set.contains(csmFile)) {
                    ((FileImpl)csmFile).clearStateCache();
                    continue;
                }
                if (set2.contains(csmFile)) {
                    ((FileImpl)csmFile).clearStateCache();
                    DeepReparsingUtils.invalidateFileAndPreprocState(projectBase, csmFile);
                    continue;
                }
                DeepReparsingUtils.invalidateFileAndPreprocState(projectBase, csmFile);
            }
            if (bl) {
                DeepReparsingUtils.addToReparse(projectBase, set, new HashSet<CsmFile>(0), false);
            }
        } else if (bl) {
            ParserQueue.instance().add(fileImpl, projectBase.getPreprocHandler(fileImpl.getAbsolutePath()).getState(), ParserQueue.Position.HEAD);
        }
    }

    static void reparseOnEdit(Collection<FileImpl> collection, ProjectBase projectBase, boolean bl) {
        CsmFile csmFile;
        HashSet hashSet = new HashSet();
        HashSet<CsmUID<CsmFile>> hashSet2 = new HashSet<CsmUID<CsmFile>>();
        HashSet<CsmUID<CsmFile>> hashSet3 = new HashSet<CsmUID<CsmFile>>();
        for (FileImpl iterator : collection) {
            GraphContainer.ParentFiles parentFiles = projectBase.getGraph().getTopParentFiles(iterator);
            csmFile = parentFiles.getCompilationUnitsUids();
            if (csmFile.size() > 0) {
                hashSet.addAll(csmFile);
                hashSet2.addAll(parentFiles.getParentFilesUids());
                hashSet3.addAll(projectBase.getGraph().getCoherenceFiles(iterator).getCoherenceFilesUids());
                continue;
            }
            if (!bl) continue;
            ParserQueue.instance().add(iterator, projectBase.getPreprocHandler(iterator.getAbsolutePath()).getState(), ParserQueue.Position.HEAD);
        }
        if (hashSet.size() > 0) {
            HashSet hashSet4 = new HashSet();
            for (CsmUID csmUID : hashSet3) {
                csmFile = UIDCsmConverter.UIDtoFile((CsmUID<CsmFile>)csmUID);
                DeepReparsingUtils.updateStartFilesWithBestStartFiles(Collections.singleton(csmFile), hashSet4);
            }
            for (CsmUID csmUID : hashSet3) {
                csmFile = (FileImpl)UIDCsmConverter.UIDtoFile((CsmUID<CsmFile>)csmUID);
                if (csmFile == null) continue;
                if (hashSet.contains(csmUID)) {
                    hashSet4.add(csmFile);
                    csmFile.clearStateCache();
                    continue;
                }
                if (hashSet2.contains(csmUID)) {
                    csmFile.clearStateCache();
                    DeepReparsingUtils.invalidateFileAndPreprocState(projectBase, csmFile);
                    continue;
                }
                DeepReparsingUtils.invalidateFileAndPreprocState(projectBase, csmFile);
            }
            if (bl) {
                DeepReparsingUtils.addToReparse(projectBase, hashSet4, new HashSet<CsmFile>(0), false);
            }
        }
    }

    private static void gatherCoherenceLibrary(Set<CsmFile> set) {
        while (true) {
            HashSet<CsmFile> hashSet = new HashSet<CsmFile>();
            for (CsmFile csmFile : set) {
                hashSet.add(csmFile);
                ProjectBase projectBase = (ProjectBase)csmFile.getProject();
                hashSet.addAll(projectBase.getGraph().getIncludedFiles(csmFile));
            }
            if (hashSet.size() == set.size()) {
                return;
            }
            set.addAll(hashSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reparseOnPropertyChanged(Collection<NativeFileItem> collection, ProjectBase projectBase) {
        try {
            FileImpl fileImpl;
            ParserQueue.instance().onStartAddingProjectFiles(projectBase);
            HashMap<FileImpl, NativeFileItem> hashMap = new HashMap<FileImpl, NativeFileItem>();
            HashSet<CsmFile> hashSet = new HashSet<CsmFile>();
            HashSet<CsmFile> hashSet2 = new HashSet<CsmFile>();
            HashSet<CsmFile> hashSet3 = new HashSet<CsmFile>();
            for (NativeFileItem nativeFileItem : collection) {
                if (!Utils.acceptNativeItem(nativeFileItem) || (fileImpl = projectBase.getFile(nativeFileItem.getAbsolutePath(), false)) == null) continue;
                fileImpl.clearStateCache();
                hashMap.put(fileImpl, nativeFileItem);
                hashSet.addAll(projectBase.getGraph().getTopParentFiles(fileImpl).getCompilationUnits());
                hashSet2.addAll(projectBase.getGraph().getIncludedFiles(fileImpl));
            }
            DeepReparsingUtils.updateStartFilesWithBestStartFiles(hashSet2, hashSet);
            for (CsmFile csmFile : hashSet2) {
                if (hashSet.contains(csmFile)) continue;
                fileImpl = csmFile.getProject();
                if (projectBase.equals(fileImpl)) {
                    DeepReparsingUtils.invalidateFileAndPreprocState(projectBase, csmFile);
                    continue;
                }
                hashSet3.add(csmFile);
            }
            if (!TraceFlags.DEEP_REPARSING_OPTIMISTIC) {
                DeepReparsingUtils.gatherCoherenceLibrary(hashSet3);
                DeepReparsingUtils.invalidateFileAndPreprocState(hashSet3);
            }
            for (CsmFile csmFile : hashSet) {
                if (csmFile.getProject() != projectBase) continue;
                fileImpl = (FileImpl)csmFile;
                if (hashMap.containsKey(fileImpl)) {
                    NativeFileItem nativeFileItem = (NativeFileItem)hashMap.get(fileImpl);
                    DeepReparsingUtils.addToReparse(projectBase, nativeFileItem, fileImpl);
                    continue;
                }
                DeepReparsingUtils.addToReparse(projectBase, fileImpl, true);
            }
        }
        catch (Exception exception) {
            DiagnosticExceptoins.register(exception);
        }
        finally {
            ParserQueue.instance().onEndAddingProjectFiles(projectBase);
        }
    }

    public static void reparseOnAdded(FileObject fileObject, ProjectBase projectBase) {
        DeepReparsingUtils.reparseOnAdded(Collections.singleton(fileObject.getNameExt()), projectBase);
    }

    static void reparseOnAdded(List<NativeFileItem> list, ProjectBase projectBase) {
        HashSet<String> hashSet = new HashSet<String>();
        for (NativeFileItem nativeFileItem : list) {
            hashSet.add(nativeFileItem.getName());
        }
        DeepReparsingUtils.reparseOnAdded(hashSet, projectBase);
    }

    private static void reparseOnAdded(Set<String> set, ProjectBase projectBase) {
        HashSet<CsmFile> hashSet = new HashSet<CsmFile>();
        for (CsmFile object : projectBase.getAllFiles()) {
            DeepReparsingUtils.findResolved(set, hashSet, object);
        }
        if (hashSet.size() > 0) {
            HashSet hashSet2 = new HashSet();
            HashSet<CsmFile> hashSet3 = new HashSet<CsmFile>();
            for (CsmFile csmFile : hashSet) {
                hashSet2.addAll(projectBase.getGraph().getTopParentFiles(csmFile).getCompilationUnits());
                hashSet3.add(csmFile);
                hashSet3.addAll(projectBase.getGraph().getIncludedFiles(csmFile));
            }
            DeepReparsingUtils.updateStartFilesWithBestStartFiles(hashSet3, hashSet2);
            DeepReparsingUtils.addToReparse(projectBase, hashSet2, hashSet3, true);
        }
    }

    private static void findResolved(Set<String> set, Set<CsmFile> set2, CsmFile csmFile) {
        for (CsmInclude csmInclude : csmFile.getIncludes()) {
            String string = ((Object)csmInclude.getIncludeName()).toString();
            int n = Math.max(string.lastIndexOf(92), string.lastIndexOf(47));
            if (n > 0) {
                string = string.substring(n);
            }
            if (!set.contains(string)) continue;
            set2.add(csmFile);
            break;
        }
    }

    static void reparseOnRemoved(Collection<FileImpl> collection, ProjectBase projectBase) {
        CndFileUtils.clearFileExistenceCache();
        HashSet<CsmFile> hashSet = new HashSet<CsmFile>();
        HashSet<CsmFile> hashSet2 = new HashSet<CsmFile>();
        for (FileImpl fileImpl : collection) {
            if (fileImpl == null) continue;
            hashSet.addAll(projectBase.getGraph().getTopParentFiles(fileImpl).getCompilationUnits());
            hashSet2.addAll(projectBase.getGraph().getCoherenceFiles(fileImpl).getCoherenceFiles());
            projectBase.getGraph().removeFile(fileImpl);
            hashSet.remove(fileImpl);
            hashSet2.remove(fileImpl);
        }
        DeepReparsingUtils.addToReparse(projectBase, hashSet, hashSet2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToReparse(ProjectBase projectBase, Set<CsmFile> set, Set<CsmFile> set2, boolean bl) {
        for (CsmFile csmFile : set2) {
            if (set.contains(csmFile)) continue;
            DeepReparsingUtils.invalidateFileAndPreprocState(projectBase, csmFile);
        }
        if (!set.isEmpty()) {
            try {
                ParserQueue.instance().onStartAddingProjectFiles(projectBase);
                for (CsmFile csmFile : set) {
                    if (csmFile.getProject() != projectBase) continue;
                    FileImpl fileImpl = (FileImpl)csmFile;
                    DeepReparsingUtils.addToReparse(projectBase, fileImpl, bl);
                }
            }
            catch (Exception exception) {
                DiagnosticExceptoins.register(exception);
            }
            finally {
                ParserQueue.instance().onEndAddingProjectFiles(projectBase);
            }
        }
    }

    private static void addToReparse(ProjectBase projectBase, FileImpl fileImpl, boolean bl) {
        projectBase.invalidatePreprocState(fileImpl.getAbsolutePath());
        fileImpl.markReparseNeeded(bl);
        ParserQueue.instance().add(fileImpl, projectBase.getPreprocHandler(fileImpl.getAbsolutePath()).getState(), ParserQueue.Position.HEAD);
        if (TraceFlags.USE_DEEP_REPARSING_TRACE) {
            System.out.println("Add file to reparse " + fileImpl.getAbsolutePath());
        }
    }

    private static void addToReparse(ProjectBase projectBase, NativeFileItem nativeFileItem, FileImpl fileImpl) {
        if (nativeFileItem.getFileObject() != null && nativeFileItem.getFileObject().isValid()) {
            fileImpl.markReparseNeeded(true);
            APTPreprocHandler.State state = projectBase.setChangedFileState(nativeFileItem);
            if (TraceFlags.USE_DEEP_REPARSING_TRACE) {
                System.out.println("Add file to reparse " + fileImpl.getAbsolutePath());
            }
            ParserQueue.instance().add(fileImpl, state, ParserQueue.Position.HEAD);
        } else assert (false);
    }

    private static void invalidateFileAndPreprocState(ProjectBase projectBase, CsmFile csmFile) {
        if (csmFile.getProject() == projectBase) {
            FileImpl fileImpl = (FileImpl)csmFile;
            fileImpl.clearStateCache();
            projectBase.invalidatePreprocState(fileImpl.getAbsolutePath());
            fileImpl.markReparseNeeded(false);
            if (TraceFlags.USE_DEEP_REPARSING_TRACE) {
                System.out.println("Invalidate file to reparse " + csmFile.getAbsolutePath());
            }
        }
    }

    private static void invalidateFileAndPreprocState(Set<CsmFile> set) {
        for (CsmFile csmFile : set) {
            CsmProject csmProject = csmFile.getProject();
            if (!(csmProject instanceof ProjectBase)) continue;
            FileImpl fileImpl = (FileImpl)csmFile;
            fileImpl.clearStateCache();
            ((ProjectBase)csmProject).invalidatePreprocState(fileImpl.getAbsolutePath());
            fileImpl.markReparseNeeded(false);
            if (!TraceFlags.USE_DEEP_REPARSING_TRACE) continue;
            System.out.println("Invalidate file to reparse " + csmFile.getAbsolutePath());
        }
    }

    private static void updateStartFilesWithBestStartFiles(Set<CsmFile> set, Set<CsmFile> set2) {
        for (CsmFile csmFile : set) {
            if (set2.contains(csmFile)) continue;
            Collection collection = CsmFileInfoQuery.getDefault().getCompilationUnits(csmFile, 0);
            for (CsmCompilationUnit csmCompilationUnit : collection) {
                CsmFile csmFile2 = csmCompilationUnit.getStartFile();
                if (csmFile2 == null) continue;
                set2.add(csmFile2);
            }
        }
    }
}

