/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.parser.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.editor.ext.html.parser.SyntaxAnalyzer;
import org.netbeans.editor.ext.html.parser.SyntaxAnalyzerElements;
import org.netbeans.editor.ext.html.parser.SyntaxElement;
import org.netbeans.editor.ext.html.parser.XmlSyntaxTreeBuilder;
import org.netbeans.editor.ext.html.parser.api.AstNode;
import org.netbeans.editor.ext.html.parser.api.HtmlParserFactory;
import org.netbeans.editor.ext.html.parser.api.HtmlSource;
import org.netbeans.editor.ext.html.parser.api.HtmlSourceVersionQuery;
import org.netbeans.editor.ext.html.parser.api.HtmlVersion;
import org.netbeans.editor.ext.html.parser.api.ParseException;
import org.netbeans.editor.ext.html.parser.api.ProblemDescription;
import org.netbeans.editor.ext.html.parser.spi.DefaultParseResult;
import org.netbeans.editor.ext.html.parser.spi.EmptyResult;
import org.netbeans.editor.ext.html.parser.spi.HtmlModel;
import org.netbeans.editor.ext.html.parser.spi.HtmlParseResult;
import org.netbeans.editor.ext.html.parser.spi.HtmlParser;
import org.netbeans.editor.ext.html.parser.spi.ParseResult;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class SyntaxAnalyzerResult {
    private SyntaxAnalyzer analyzer;
    private SyntaxElement.Declaration declaration;
    private HtmlVersion detectedHtmlVersion;
    private HtmlParseResult htmlParseResult;
    private Map<String, ParseResult> embeddedCodeParseResults;
    private Map<String, List<String>> namespaces;
    private ParseResult undeclaredEmbeddedCodeParseResult;
    private Set<String> allPrefixes;
    private static final char REPLACE_CHAR = ' ';

    public SyntaxAnalyzerResult(SyntaxAnalyzer source) {
        this.analyzer = source;
    }

    public HtmlSource getSource() {
        return this.analyzer.source();
    }

    public SyntaxAnalyzerElements getElements() {
        return this.analyzer.elements();
    }

    public HtmlVersion getHtmlVersion() {
        HtmlVersion detected = this.getDetectedHtmlVersion();
        HtmlVersion found = HtmlSourceVersionQuery.getSourceCodeVersion(this, detected);
        if (found != null) {
            return found;
        }
        return detected != null ? detected : (this.mayBeXhtml() ? HtmlVersion.getDefaultXhtmlVersion() : HtmlVersion.getDefaultVersion());
    }

    public HtmlModel getHtmlModel() {
        return this.findParser().getModel(this.getHtmlVersion());
    }

    public synchronized HtmlVersion getDetectedHtmlVersion() {
        if (this.detectedHtmlVersion == null) {
            this.detectedHtmlVersion = this.detectHtmlVersion();
        }
        return this.detectedHtmlVersion;
    }

    public boolean mayBeXhtml() {
        FileObject fo = this.getSource().getSourceFileObject();
        String mimeType = fo != null ? fo.getMIMEType() : null;
        return this.getHtmlTagDefaultNamespace() != null || "text/xhtml".equals(mimeType);
    }

    private HtmlVersion detectHtmlVersion() {
        SyntaxElement.Declaration doctypeDeclaration = this.getDoctypeDeclaration();
        if (doctypeDeclaration == null) {
            return null;
        }
        String publicId = this.getPublicID();
        String namespace = this.getHtmlTagDefaultNamespace();
        return HtmlVersion.find(publicId, namespace);
    }

    public Collection<ParseResult> getAllParseResults() throws ParseException {
        ArrayList<ParseResult> all = new ArrayList<ParseResult>();
        all.add(this.parseHtml());
        for (String ns : this.getAllDeclaredNamespaces().keySet()) {
            all.add(this.parseEmbeddedCode(ns));
        }
        all.add(this.parseUndeclaredEmbeddedCode());
        return all;
    }

    public synchronized HtmlParseResult parseHtml() throws ParseException {
        if (this.htmlParseResult == null) {
            this.htmlParseResult = this.doParseHtml();
        }
        return this.htmlParseResult;
    }

    private HtmlParser findParser() {
        HtmlVersion version = this.getHtmlVersion();
        HtmlParser parser = HtmlParserFactory.findParser(version);
        if (parser == null) {
            throw new IllegalStateException("Cannot find an HtmlParser implementation for " + this.getHtmlVersion().name());
        }
        return parser;
    }

    private HtmlParseResult doParseHtml() throws ParseException {
        HtmlVersion version = this.getHtmlVersion();
        HtmlParser parser = this.findParser();
        final List<String> prefixes = version.getDefaultNamespace() != null ? this.getAllDeclaredNamespaces().get(version.getDefaultNamespace()) : null;
        LocalSourceContext context = this.createLocalContext(new TagsFilter(){

            @Override
            public boolean accepts(SyntaxElement.Tag tag, String prefix) {
                if (prefix == null) {
                    return true;
                }
                return prefixes != null && prefixes.contains(prefix);
            }
        });
        CharSequence clearedSource = SyntaxAnalyzerResult.clearIgnoredAreas(this.getSource().getSourceCode(), context.getIgnoredAreas());
        List<SyntaxElement> filtered = context.getFiltered();
        HtmlSource source = new HtmlSource(clearedSource, this.analyzer.source().getSnapshot(), this.analyzer.source().getSourceFileObject());
        InstanceContent content = new InstanceContent();
        content.add((Object)new SyntaxAnalyzerElements(filtered));
        AbstractLookup lookup = new AbstractLookup((AbstractLookup.Content)content);
        return parser.parse(source, this.getHtmlVersion(), (Lookup)lookup);
    }

    public synchronized ParseResult parseEmbeddedCode(String namespace) throws ParseException {
        ParseResult result;
        if (this.embeddedCodeParseResults == null) {
            this.embeddedCodeParseResults = new HashMap<String, ParseResult>();
        }
        if ((result = this.embeddedCodeParseResults.get(namespace)) == null) {
            result = this.doParseEmbeddedCode(namespace);
            this.embeddedCodeParseResults.put(namespace, result);
        }
        return result;
    }

    private ParseResult doParseEmbeddedCode(String namespace) throws ParseException {
        final Collection prefixes = this.getAllDeclaredNamespaces().get(namespace);
        if (prefixes == null || prefixes.isEmpty()) {
            return new EmptyResult(this.getSource());
        }
        LocalSourceContext context = this.createLocalContext(new TagsFilter(){

            @Override
            public boolean accepts(SyntaxElement.Tag tag, String prefix) {
                return prefix != null && prefixes.contains(prefix);
            }
        });
        CharSequence clearedSource = SyntaxAnalyzerResult.clearIgnoredAreas(this.getSource().getSourceCode(), context.getIgnoredAreas());
        HtmlSource source = new HtmlSource(clearedSource, this.analyzer.source().getSnapshot(), this.analyzer.source().getSourceFileObject());
        AstNode root = XmlSyntaxTreeBuilder.makeUncheckedTree(source, context.getFiltered());
        root.setProperty("namespace", namespace);
        return new DefaultParseResult(source, root, Collections.<ProblemDescription>emptyList());
    }

    public ParseResult parseUndeclaredEmbeddedCode() throws ParseException {
        if (this.undeclaredEmbeddedCodeParseResult == null) {
            this.undeclaredEmbeddedCodeParseResult = this.doParseUndeclaredEmbeddedCode();
        }
        return this.undeclaredEmbeddedCodeParseResult;
    }

    private ParseResult doParseUndeclaredEmbeddedCode() throws ParseException {
        final Set<String> prefixes = this.getAllDeclaredPrefixes();
        LocalSourceContext context = this.createLocalContext(new TagsFilter(){

            @Override
            public boolean accepts(SyntaxElement.Tag tag, String prefix) {
                return prefix != null && !prefixes.contains(prefix);
            }
        });
        CharSequence clearedSource = SyntaxAnalyzerResult.clearIgnoredAreas(this.getSource().getSourceCode(), context.getIgnoredAreas());
        HtmlSource source = new HtmlSource(clearedSource, this.analyzer.source().getSnapshot(), this.analyzer.source().getSourceFileObject());
        AstNode root = XmlSyntaxTreeBuilder.makeUncheckedTree(source, context.getFiltered());
        return new DefaultParseResult(source, root, Collections.<ProblemDescription>emptyList());
    }

    private LocalSourceContext createLocalContext(TagsFilter filter) {
        ArrayList<IgnoredArea> ignoredAreas = new ArrayList<IgnoredArea>();
        ArrayList<SyntaxElement> filtered = new ArrayList<SyntaxElement>();
        for (SyntaxElement e : this.getElements().items()) {
            if (e.type() == 4 || e.type() == 5) {
                SyntaxElement.Tag tag = (SyntaxElement.Tag)e;
                String tagNamePrefix = SyntaxAnalyzerResult.getTagNamePrefix(tag);
                if (filter.accepts(tag, tagNamePrefix)) {
                    filtered.add(e);
                    for (SyntaxElement.TagAttribute a : tag.getAttributes()) {
                        if (!a.getName().startsWith("xmlns:")) continue;
                        ignoredAreas.add(new IgnoredArea(a.getNameOffset(), a.getValueOffset() + a.getValueLength()));
                    }
                    continue;
                }
                ignoredAreas.add(new IgnoredArea(e.offset(), e.offset() + e.length()));
                continue;
            }
            filtered.add(e);
        }
        return new LocalSourceContext(ignoredAreas, filtered);
    }

    private static String getTagNamePrefix(SyntaxElement.Tag tag) {
        String tName = tag.getName();
        int colonPrefix = tName.indexOf(58);
        if (colonPrefix == -1) {
            return null;
        }
        return tName.substring(0, colonPrefix);
    }

    public String getPublicID() {
        return this.getDoctypeDeclaration() != null ? this.getDoctypeDeclaration().getPublicIdentifier() : null;
    }

    public synchronized SyntaxElement.Declaration getDoctypeDeclaration() {
        if (this.declaration == null) {
            for (SyntaxElement e : this.getElements().items()) {
                SyntaxElement.Declaration decl;
                if (e.type() != 1 || !(decl = (SyntaxElement.Declaration)e).isValidDoctype()) continue;
                this.declaration = (SyntaxElement.Declaration)e;
                break;
            }
        }
        return this.declaration;
    }

    @Deprecated
    public Map<String, String> getDeclaredNamespaces() {
        Map<String, List<String>> all = this.getAllDeclaredNamespaces();
        HashMap<String, String> firstPrefixOnly = new HashMap<String, String>();
        for (String namespace : all.keySet()) {
            List<String> prefixes = all.get(namespace);
            if (prefixes == null || prefixes.size() <= 0) continue;
            firstPrefixOnly.put(namespace, prefixes.get(0));
        }
        return firstPrefixOnly;
    }

    public synchronized Set<String> getAllDeclaredPrefixes() {
        if (this.allPrefixes == null) {
            this.allPrefixes = this.findAllDeclaredPrefixes();
        }
        return this.allPrefixes;
    }

    private Set<String> findAllDeclaredPrefixes() {
        HashSet<String> all = new HashSet<String>();
        for (List<String> prefixes : this.getAllDeclaredNamespaces().values()) {
            all.addAll(prefixes);
        }
        return all;
    }

    public String getHtmlTagDefaultNamespace() {
        for (SyntaxElement se : this.getElements().items()) {
            if (se.type() != 4) continue;
            SyntaxElement.Tag tag = (SyntaxElement.Tag)se;
            if (tag.getName().equalsIgnoreCase("html")) {
                SyntaxElement.TagAttribute xmlns = tag.getAttribute("xmlns");
                return xmlns != null ? SyntaxAnalyzerResult.dequote(xmlns.getValue()) : null;
            }
            return null;
        }
        return null;
    }

    public synchronized Map<String, List<String>> getAllDeclaredNamespaces() {
        if (this.namespaces == null) {
            this.namespaces = new HashMap<String, List<String>>();
            for (SyntaxElement se : this.getElements().items()) {
                if (se.type() != 4) continue;
                SyntaxElement.Tag tag = (SyntaxElement.Tag)se;
                for (SyntaxElement.TagAttribute attr : tag.getAttributes()) {
                    String attrName = attr.getName();
                    if (!attrName.startsWith("xmlns")) continue;
                    int colonIndex = attrName.indexOf(58);
                    String nsPrefix = colonIndex == -1 ? null : attrName.substring(colonIndex + 1);
                    String value = attr.getValue();
                    String key = SyntaxAnalyzerResult.dequote(value);
                    List<String> prefixes = this.namespaces.get(key);
                    if (prefixes == null) {
                        prefixes = new LinkedList<String>();
                        prefixes.add(nsPrefix);
                        this.namespaces.put(key, prefixes);
                        continue;
                    }
                    if (prefixes.contains(key)) continue;
                    prefixes.add(nsPrefix);
                }
            }
        }
        return this.namespaces;
    }

    private static String dequote(String text) {
        if (text.length() < 2) {
            return text;
        }
        if (!(text.charAt(0) != '\'' && text.charAt(0) != '\"' || text.charAt(text.length() - 1) != '\'' && text.charAt(text.length() - 1) != '\"')) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    private static CharSequence clearIgnoredAreas(CharSequence source, Collection<IgnoredArea> areas) {
        StringBuilder sb = new StringBuilder(source);
        for (IgnoredArea area : areas) {
            for (int i = area.from; i < area.to; ++i) {
                sb.setCharAt(i, ' ');
            }
        }
        return sb;
    }

    private static class IgnoredArea {
        int from;
        int to;

        public IgnoredArea(int from, int to) {
            this.from = from;
            this.to = to;
        }
    }

    private static interface TagsFilter {
        public boolean accepts(SyntaxElement.Tag var1, String var2);
    }

    private static class LocalSourceContext {
        private Collection<IgnoredArea> ignoredAreas;
        private List<SyntaxElement> filtered;

        public LocalSourceContext(Collection<IgnoredArea> ignoredAreas, List<SyntaxElement> filtered) {
            this.ignoredAreas = ignoredAreas;
            this.filtered = filtered;
        }

        public List<SyntaxElement> getFiltered() {
            return this.filtered;
        }

        public Collection<IgnoredArea> getIgnoredAreas() {
            return this.ignoredAreas;
        }
    }
}

