/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import org.jdesktop.application.View;
import org.netbeans.modules.form.ViewConverter;

public class ViewConverterImpl
implements ViewConverter {
    public boolean canVisualize(Class componentClass) {
        return ViewConverterImpl.isViewClass(componentClass);
    }

    public ViewConverter.Convert convert(Object component, boolean root, boolean designRestrictions) {
        if (root && component != null && ViewConverterImpl.isViewClass(component.getClass())) {
            return new ConvertResult(designRestrictions ? new AppDesignView() : new AppPreview(), null);
        }
        return null;
    }

    private static boolean isViewClass(Class cls) {
        while (cls != null) {
            if (cls.getName().equals(View.class.getName())) {
                return true;
            }
            cls = cls.getSuperclass();
        }
        return false;
    }

    private static class ConvertResult
    implements ViewConverter.Convert {
        private Object converted;
        private Object enclosed;

        ConvertResult(Object converted, Object enclosed) {
            this.converted = converted;
            this.enclosed = enclosed;
        }

        public Object getConverted() {
            return this.converted;
        }

        public Object getEnclosed() {
            return this.enclosed;
        }
    }

    public static class AppPreview
    extends JFrame {
        public void setComponent(JComponent component) {
            this.getContentPane().add(component);
        }

        public void setMenuBar(JMenuBar menuBar) {
            this.setJMenuBar(menuBar);
        }

        public void setToolBar(JToolBar toolBar) {
            this.getContentPane().add((Component)toolBar, "First");
        }

        public void setStatusBar(JComponent statusBar) {
            this.getContentPane().add((Component)statusBar, "Last");
        }
    }

    public static class AppDesignView
    extends JRootPane {
        private JComponent component;
        private JToolBar toolBar;
        private JComponent statusBar;

        public void setComponent(JComponent component) {
            Container contentPane = this.getContentPane();
            if (this.component != null && this.component.getParent() == contentPane) {
                contentPane.remove(this.component);
            }
            this.component = component;
            if (component != null) {
                contentPane.add((Component)component, "Center");
            }
        }

        public void setToolBar(JToolBar toolBar) {
            Container contentPane = this.getContentPane();
            if (this.toolBar != null && this.toolBar.getParent() == contentPane) {
                contentPane.remove(this.toolBar);
            }
            this.toolBar = toolBar;
            if (toolBar != null) {
                contentPane.add((Component)toolBar, "First");
            }
        }

        public void setStatusBar(JComponent statusBar) {
            Container contentPane = this.getContentPane();
            if (this.statusBar != null && this.statusBar.getParent() == contentPane) {
                contentPane.remove(this.statusBar);
            }
            this.statusBar = statusBar;
            if (statusBar != null) {
                contentPane.add((Component)statusBar, "Last");
            }
        }
    }
}

