/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.settings;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.openide.loaders.CreateFromTemplateAttributesProvider;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.SharedClassObject;

public final class CppSettings
extends SharedClassObject {
    static final long serialVersionUID = -2942467713237077336L;
    private static final String PROP_REPLACEABLE_STRINGS_TABLE = "replaceableStringsTable";
    private static ResourceBundle bundle;
    private static CppSettings cppSettings;

    protected void initialize() {
        super.initialize();
    }

    public static CppSettings getDefault() {
        if (cppSettings == null) {
            cppSettings = (CppSettings)CppSettings.findObject(CppSettings.class, (boolean)true);
        }
        return cppSettings;
    }

    public void setReplaceableStringsTable(String table) {
        String t = this.getReplaceableStringsTable();
        if (t.equals(table)) {
            return;
        }
        this.getPreferences().put(PROP_REPLACEABLE_STRINGS_TABLE, table);
        this.firePropertyChange(PROP_REPLACEABLE_STRINGS_TABLE, t, table);
    }

    public String getReplaceableStringsTable() {
        String table = this.getPreferences().get(PROP_REPLACEABLE_STRINGS_TABLE, null);
        if (table == null) {
            return "USER=" + System.getProperty("user.name");
        }
        return table;
    }

    public Properties getReplaceableStringsProps() {
        Properties props = new Properties();
        try {
            props.load(new StringReader(this.getReplaceableStringsTable()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return props;
    }

    public String displayName() {
        return CppSettings.getString("OPTION_CPP_SETTINGS_NAME");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("Welcome_opt_editing_sources");
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(CppSettings.class);
    }

    public ResourceBundle getBundle() {
        return bundle;
    }

    static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(CppSettings.class);
        }
        return bundle.getString(s);
    }

    static {
        cppSettings = null;
    }

    public static final class AttributesProvider
    implements CreateFromTemplateAttributesProvider {
        public Map<String, ?> attributesFor(DataObject template, DataFolder target, String name) {
            if (MIMENames.CND_TEXT_MIME_TYPES.contains(template.getPrimaryFile().getMIMEType())) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (Map.Entry<Object, Object> entry : CppSettings.getDefault().getReplaceableStringsProps().entrySet()) {
                    if (!(entry.getKey() instanceof String)) continue;
                    map.put((String)entry.getKey(), entry.getValue());
                }
                return map;
            }
            return null;
        }
    }
}

