/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.archive.project;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.j2ee.archive.Util;
import org.netbeans.modules.j2ee.archive.customizer.ProvidesCustomizer;
import org.netbeans.modules.j2ee.archive.project.ArchiveProjectOperations;
import org.netbeans.modules.j2ee.archive.project.ArchiveProjectProperties;
import org.netbeans.modules.j2ee.archive.project.ProvidesAction;
import org.netbeans.modules.j2ee.archive.project.ProvidesJ2eeModule;
import org.netbeans.modules.j2ee.archive.project.ProvidesLogicalView;
import org.netbeans.modules.j2ee.archive.project.UpdateHelper;
import org.netbeans.modules.j2ee.common.ui.BrokenServerSupport;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.application.DDProvider;
import org.netbeans.modules.j2ee.dd.api.application.Module;
import org.netbeans.modules.j2ee.dd.api.application.Web;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleFactory;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleImplementation2;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.java.api.common.queries.QuerySupport;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.netbeans.spi.project.support.LookupProviderSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.netbeans.spi.project.ui.support.UILookupMergerSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.NotImplementedException;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ArchiveProject
implements Project {
    private final AuxiliaryConfiguration aux;
    private final AntProjectHelper helper;
    private final PropertyEvaluator eval;
    private final GeneratedFilesHelper genFilesHelper;
    private final Lookup lookup;
    private ArchiveProjectProperties projProperties;
    private final Icon ARCHIVE_PROJECT_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/j2ee/archive/project/resources/packaged_archive_16.png", (boolean)false);
    private final UpdateHelper updateHelper;
    private HashMap<String, String> nameMap;
    private static final String NAME_LIT = "name";

    public ArchiveProject(AntProjectHelper helper) {
        this.helper = helper;
        this.eval = helper.getStandardPropertyEvaluator();
        this.aux = helper.createAuxiliaryConfiguration();
        this.genFilesHelper = new GeneratedFilesHelper(helper);
        this.lookup = new HelpfulLookup();
        this.updateHelper = new UpdateHelper(this, this.helper, this.aux, this.genFilesHelper, UpdateHelper.createDefaultNotifier());
        this.nameMap = new HashMap(5);
    }

    public FileObject getProjectDirectory() {
        return this.helper.getProjectDirectory();
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.helper;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public PropertyEvaluator getPropertyEvaluator() {
        return this.eval;
    }

    public String getProjectProperty(String propName) {
        return (String)this.getArchiveProjectProperties().get(propName);
    }

    public String getEarPath(String key) {
        return this.nameMap.get(key);
    }

    public void setEarPath(String key, String val) {
        this.nameMap.put(key, val);
    }

    public void setName(final String name) {
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Object>(){

            public Object run() {
                Element nameEl;
                Element data = ArchiveProject.this.helper.getPrimaryConfigurationData(true);
                NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/archive-project/1", ArchiveProject.NAME_LIT);
                if (nl.getLength() == 1) {
                    nameEl = (Element)nl.item(0);
                    NodeList deadKids = nameEl.getChildNodes();
                    while (deadKids.getLength() > 0) {
                        nameEl.removeChild(deadKids.item(0));
                    }
                } else {
                    nameEl = data.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/archive-project/1", ArchiveProject.NAME_LIT);
                    data.insertBefore(nameEl, data.getChildNodes().item(0));
                }
                nameEl.appendChild(data.getOwnerDocument().createTextNode(name));
                ArchiveProject.this.helper.putPrimaryConfigurationData(data, true);
                return null;
            }
        });
    }

    public String getName() {
        return ProjectUtils.getInformation((Project)this).getName();
    }

    public ArchiveProjectProperties getArchiveProjectProperties() {
        this.projProperties = new ArchiveProjectProperties(this, this.getAntProjectHelper());
        return this.projProperties;
    }

    public String getNamedProjectAttribute(final String attr) {
        return (String)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String>(){

            public String run() {
                Element data = ArchiveProject.this.helper.getPrimaryConfigurationData(true);
                NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/archive-project/1", attr);
                if (nl.getLength() == 1 && (nl = nl.item(0).getChildNodes()).getLength() == 1 && nl.item(0).getNodeType() == 3) {
                    return ((Text)nl.item(0)).getNodeValue();
                }
                return "???";
            }
        });
    }

    public void setNamedProjectAttribute(final String attr, final String value) {
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Object>(){

            public Object run() {
                Element nameEl;
                Element data = ArchiveProject.this.helper.getPrimaryConfigurationData(true);
                NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/archive-project/1", attr);
                if (nl.getLength() == 1) {
                    nameEl = (Element)nl.item(0);
                    NodeList deadKids = nameEl.getChildNodes();
                    while (deadKids.getLength() > 0) {
                        nameEl.removeChild(deadKids.item(0));
                    }
                } else {
                    nameEl = data.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/archive-project/1", attr);
                    data.insertBefore(nameEl, data.getChildNodes().item(0));
                }
                nameEl.appendChild(data.getOwnerDocument().createTextNode(value));
                ArchiveProject.this.helper.putPrimaryConfigurationData(data, true);
                return null;
            }
        });
    }

    private void doRegeneration() {
        GeneratedFilesHelper gFH = new GeneratedFilesHelper(this.helper);
        ArchiveProjectProperties app = this.getArchiveProjectProperties();
        String sourceArchive = this.eval.evaluate((String)app.get("source.archive"));
        try {
            if (sourceArchive.endsWith("war")) {
                gFH.refreshBuildScript("nbproject/build-impl.xml", ArchiveProject.class.getResource("resources/build-impl-war.xsl"), true);
            } else {
                gFH.refreshBuildScript("nbproject/build-impl.xml", ArchiveProject.class.getResource("resources/build-impl.xsl"), true);
            }
        }
        catch (IllegalStateException ex) {
            ErrorManager.getDefault().log(1, "IllegalStateException while opening project: " + ex);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().log(1, "IOException while opening project: " + ex);
        }
        try {
            gFH.refreshBuildScript("build.xml", ArchiveProject.class.getResource("resources/build.xsl"), true);
        }
        catch (IllegalStateException ex) {
            ErrorManager.getDefault().log(1, "IllegalStateException while opening project: " + ex);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().log(1, "IOException while opening project: " + ex);
        }
        String servInstID = (String)app.get("j2ee.server.instance");
        J2eePlatform platform = null;
        try {
            platform = Deployment.getDefault().getServerInstance(servInstID).getJ2eePlatform();
        }
        catch (InstanceRemovedException ex) {
            Logger.getLogger("global").log(Level.INFO, servInstID, ex);
        }
        if (platform != null) {
            ArchiveProjectProperties.setServerInstance(this, this.helper, servInstID);
        } else {
            String[] servInstIDs;
            String serverType = (String)app.get("j2ee.server.type");
            if (serverType != null && (servInstIDs = Deployment.getDefault().getInstancesOfServer(serverType)).length > 0) {
                ArchiveProjectProperties.setServerInstance(this, this.helper, servInstIDs[0]);
                try {
                    platform = Deployment.getDefault().getServerInstance(servInstIDs[0]).getJ2eePlatform();
                }
                catch (InstanceRemovedException ex) {
                    Logger.getLogger("global").log(Level.INFO, servInstIDs[0], ex);
                }
            }
            if (platform == null) {
                BrokenServerSupport.showAlert();
            }
        }
        FileObject dir = this.helper.getProjectDirectory();
        try {
            FileUtil.createFolder((FileObject)dir, (String)"setup");
        }
        catch (IOException ex) {
            ErrorManager.getDefault().log(1, "Error while opening project: " + ex);
        }
    }

    static /* synthetic */ Icon access$200(ArchiveProject x0) {
        return x0.ARCHIVE_PROJECT_ICON;
    }

    static /* synthetic */ PropertyEvaluator access$300(ArchiveProject x0) {
        return x0.eval;
    }

    class MyOpenHook {
        MyOpenHook() {
        }

        public void regenerateBuildFiles() {
            ArchiveProject.this.doRegeneration();
        }
    }

    private static final class RecommendedTemplatesImpl
    implements RecommendedTemplates,
    PrivilegedTemplates {
        private static final String[] APPLICATION_TYPES = new String[]{"sunresource-types", "XML", "simple-files"};
        private static final String[] PRIVILEGED_NAMES = new String[]{"Templates/SunResources/JDBC_Connection_Pool", "Templates/SunResources/JDBC_Resource", "Templates/SunResources/JMS_Resource", "Templates/SunResources/JavaMail_Resource", "Templates/Persistence/Schema.dbschema"};

        RecommendedTemplatesImpl() {
        }

        public String[] getRecommendedTypes() {
            return APPLICATION_TYPES;
        }

        public String[] getPrivilegedTemplates() {
            return PRIVILEGED_NAMES;
        }
    }

    private class J2eeModuleForAddModuleAction
    implements J2eeModuleImplementation2 {
        private final J2eeModule.Type mt;

        J2eeModuleForAddModuleAction(J2eeModule.Type mt) {
            this.mt = mt;
        }

        public String getModuleVersion() {
            return "1.5";
        }

        public J2eeModule.Type getModuleType() {
            return this.mt;
        }

        public String getUrl() {
            return null;
        }

        public void setUrl(String url) {
            throw new UnsupportedOperationException();
        }

        public FileObject getArchive() throws IOException {
            FileObject distDir = ArchiveProject.this.getProjectDirectory().getFileObject("dist");
            FileObject[] kids = distDir.getChildren();
            FileObject retVal = null;
            if (null != kids && kids.length == 1) {
                retVal = kids[0];
            } else if (null != kids && kids.length > 1) {
                for (FileObject kid : kids) {
                    if (!kid.isData() || !kid.getNameExt().endsWith("ar")) continue;
                    retVal = kid;
                }
            }
            return retVal;
        }

        public Iterator getArchiveContents() throws IOException {
            throw new UnsupportedOperationException();
        }

        public FileObject getContentDirectory() throws IOException {
            return null;
        }

        public <T> MetadataModel<T> getMetadataModel(Class<T> type) {
            throw new NotImplementedException();
        }

        public File getResourceDirectory() {
            return new File(FileUtil.toFile((FileObject)ArchiveProject.this.getProjectDirectory()), "setup");
        }

        public File getDeploymentConfigurationFile(String name) {
            String dir = (String)ArchiveProject.this.getArchiveProjectProperties().get("proxy.project.dir");
            FileObject parent = ArchiveProject.this.getProjectDirectory().getFileObject(dir).getFileObject("src").getFileObject("conf");
            int slashDex = name.lastIndexOf("/");
            String fname = -1 < slashDex ? name.substring(slashDex) : name;
            FileObject appFile = parent.getFileObject(fname);
            File retVal = null == appFile ? new File(FileUtil.toFile((FileObject)parent), fname) : FileUtil.toFile((FileObject)appFile);
            return retVal;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            throw new UnsupportedOperationException();
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            throw new UnsupportedOperationException();
        }
    }

    class ProjectXmlSaved
    extends ProjectXmlSavedHook {
        ProjectXmlSaved() {
        }

        protected void projectXmlSaved() throws IOException {
            FileObject subDir = ArchiveProject.this.getProjectDirectory().getFileObject("tmpproj");
            if (subDir != null) {
                Project tmpproj = null;
                try {
                    tmpproj = ProjectManager.getDefault().findProject(subDir);
                }
                catch (IllegalArgumentException ex) {
                    ErrorManager.getDefault().log(1, "" + ex);
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().log(1, "" + ex);
                }
                ProvidesJ2eeModule tmp = (ProvidesJ2eeModule)((Object)ArchiveProject.this.getLookup().lookup(ProvidesJ2eeModule.class));
                if (null != tmpproj) {
                    tmp.setServerInstanceID((String)ArchiveProject.this.getArchiveProjectProperties().get("j2ee.server.instance"));
                }
            }
        }
    }

    class OpenCloseHook
    extends ProjectOpenedHook {
        List<ClassPath[]> paths = new ArrayList<ClassPath[]>();

        OpenCloseHook() {
        }

        protected void projectOpened() {
            ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Object>(){

                public Object run() {
                    ArchiveProject.this.doRegeneration();
                    FileObject dir = ArchiveProject.this.helper.getProjectDirectory();
                    ArchiveProjectProperties app = ArchiveProject.this.getArchiveProjectProperties();
                    String type = (String)app.get("javaee.archive.type");
                    boolean isEar = "ear".equals(type);
                    FileObject subDir = dir.getFileObject("tmpproj");
                    if (subDir != null) {
                        Project tmpproj = null;
                        try {
                            tmpproj = ProjectManager.getDefault().findProject(subDir);
                        }
                        catch (IllegalArgumentException ex) {
                            ErrorManager.getDefault().log(1, "" + ex);
                        }
                        catch (IOException ex) {
                            ErrorManager.getDefault().log(1, "" + ex);
                        }
                        ProvidesJ2eeModule tmp = (ProvidesJ2eeModule)((Object)ArchiveProject.this.getLookup().lookup(ProvidesJ2eeModule.class));
                        if (null != tmpproj) {
                            ArrayList<FileObject> roots = new ArrayList<FileObject>();
                            FileObject cpe = tmpproj.getProjectDirectory().getFileObject("src/java");
                            if (null != cpe) {
                                roots.add(cpe);
                            }
                            if (null != (cpe = tmpproj.getProjectDirectory().getFileObject("src/conf"))) {
                                roots.add(cpe);
                            }
                            if (null != (cpe = tmpproj.getProjectDirectory().getFileObject("web/WEB-INF/classes"))) {
                                roots.add(cpe);
                            }
                            if (roots.size() > 0) {
                                ClassPath cp = ClassPathSupport.createClassPath((FileObject[])roots.toArray(new FileObject[roots.size()]));
                                ClassPath[] aofcp = new ClassPath[]{cp};
                                GlobalPathRegistry.getDefault().register("classpath/source", aofcp);
                                GlobalPathRegistry.getDefault().register("classpath/compile", aofcp);
                                OpenCloseHook.this.paths.add(aofcp);
                            }
                            J2eeModuleProvider jmp = (J2eeModuleProvider)tmpproj.getLookup().lookup(J2eeModuleProvider.class);
                            jmp.getConfigSupport().ensureConfigurationReady();
                            tmp.setInner(jmp);
                        } else {
                            J2eeModule.Type mt = isEar ? J2eeModule.Type.EAR : J2eeModule.Type.RAR;
                            tmp.setJ2eeModule(J2eeModuleFactory.createJ2eeModule((J2eeModuleImplementation2)new J2eeModuleForAddModuleAction(mt)));
                            tmp.setServerInstanceID((String)app.get("j2ee.server.instance"));
                            if (isEar) {
                                tmp.getConfigSupport().ensureConfigurationReady();
                            }
                        }
                    }
                    if (!isEar) {
                        return null;
                    }
                    FileObject appXml = ArchiveProject.this.getProjectDirectory().getFileObject("nbproject").getFileObject("application.xml");
                    if (null != appXml) {
                        try {
                            Module[] ms;
                            Application appDD = DDProvider.getDefault().getDDRoot(appXml);
                            for (Module m : ms = appDD.getModule()) {
                                String archivePath = m.getEjb();
                                if (null != archivePath) {
                                    OpenCloseHook.this.openSubarchiveProject(archivePath);
                                    continue;
                                }
                                archivePath = m.getJava();
                                if (null != archivePath) {
                                    OpenCloseHook.this.openSubarchiveProject(archivePath);
                                    continue;
                                }
                                archivePath = m.getConnector();
                                if (null != archivePath) {
                                    OpenCloseHook.this.openSubarchiveProject(archivePath);
                                    continue;
                                }
                                Web w = m.getWeb();
                                if (null == w || null == (archivePath = w.getWebUri())) continue;
                                OpenCloseHook.this.openSubarchiveProject(archivePath);
                            }
                        }
                        catch (IOException ex) {
                            Logger.getLogger("global").log(Level.INFO, null, ex);
                        }
                    } else {
                        ErrorManager.getDefault().log(16, NbBundle.getMessage(ArchiveProject.class, (String)"WARN_EAR_ARCH_MISSING_APPLICATION_XML", (Object)ArchiveProject.this.getName()));
                    }
                    return null;
                }
            });
        }

        private void openSubarchiveProject(String pathInEar) throws IOException {
            block11: {
                FileObject root = ArchiveProject.this.getProjectDirectory();
                FileObject subprojRoot = root.getFileObject("subarchives");
                String subprojkey = Util.getKey(pathInEar);
                try {
                    FileObject projDest = subprojRoot.getFileObject(subprojkey);
                    ArchiveProject.this.nameMap.put(subprojkey, pathInEar);
                    FileObject fo = projDest.getFileObject("tmpproj");
                    Project tmpproj = ProjectManager.getDefault().findProject(fo);
                    Project subproj = ProjectManager.getDefault().findProject(projDest);
                    MyOpenHook eh = (MyOpenHook)subproj.getLookup().lookup(MyOpenHook.class);
                    eh.regenerateBuildFiles();
                    ProvidesJ2eeModule tmp = (ProvidesJ2eeModule)((Object)subproj.getLookup().lookup(ProvidesJ2eeModule.class));
                    if (null != tmpproj) {
                        J2eeModuleProvider jmp = (J2eeModuleProvider)tmpproj.getLookup().lookup(J2eeModuleProvider.class);
                        ArrayList<FileObject> roots = new ArrayList<FileObject>();
                        FileObject cpe = tmpproj.getProjectDirectory().getFileObject("src/java");
                        if (null != cpe) {
                            roots.add(cpe);
                        }
                        if (null != (cpe = tmpproj.getProjectDirectory().getFileObject("src/conf"))) {
                            roots.add(cpe);
                        }
                        if (null != (cpe = tmpproj.getProjectDirectory().getFileObject("web/WEB-INF/classes"))) {
                            roots.add(cpe);
                        }
                        if (roots.size() > 0) {
                            ClassPath cp = ClassPathSupport.createClassPath((FileObject[])roots.toArray(new FileObject[roots.size()]));
                            ClassPath[] aofcp = new ClassPath[]{cp};
                            GlobalPathRegistry.getDefault().register("classpath/source", aofcp);
                            GlobalPathRegistry.getDefault().register("classpath/compile", aofcp);
                            this.paths.add(aofcp);
                        }
                        try {
                            jmp.getConfigSupport().ensureConfigurationReady();
                        }
                        catch (IllegalArgumentException iae) {
                            FileObject tfo = tmpproj.getProjectDirectory();
                            if (null != tfo) {
                                ErrorManager.getDefault().log(1, tmpproj.getProjectDirectory().toString());
                            } else {
                                ErrorManager.getDefault().log(1, "null");
                            }
                            throw iae;
                        }
                        tmp.setInner(jmp);
                        break block11;
                    }
                    J2eeModule.Type mt = J2eeModule.Type.RAR;
                    tmp.setJ2eeModule(J2eeModuleFactory.createJ2eeModule((J2eeModuleImplementation2)new J2eeModuleForAddModuleAction(mt)));
                    tmp.setServerInstanceID((String)ArchiveProject.this.getArchiveProjectProperties().get("j2ee.server.instance"));
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().log(1, "" + ex);
                }
            }
        }

        protected void projectClosed() {
            ArrayList<ClassPath[]> tmplist = new ArrayList<ClassPath[]>();
            for (ClassPath[] aofcp : this.paths) {
                GlobalPathRegistry.getDefault().unregister("classpath/source", aofcp);
                GlobalPathRegistry.getDefault().unregister("classpath/compile", aofcp);
                tmplist.add(aofcp);
            }
            for (ClassPath[] aofcp : tmplist) {
                this.paths.remove(aofcp);
            }
        }
    }

    private final class MyAntProvider
    implements AntArtifactProvider {
        private MyAntProvider() {
        }

        public AntArtifact[] getBuildArtifacts() {
            return new AntArtifact[]{ArchiveProject.this.helper.createSimpleAntArtifact("j2ee_ear_archive", "dist.archive", ArchiveProject.this.helper.getStandardPropertyEvaluator(), "dist", "clean")};
        }
    }

    private final class HelpfulLookup
    extends Lookup {
        private boolean verbose = Boolean.getBoolean("archiveproject.lookup.verbose");
        Lookup inner = LookupProviderSupport.createCompositeLookup((Lookup)Lookups.fixed((Object[])new Object[]{QuerySupport.createProjectInformation((AntProjectHelper)ArchiveProject.access$100(ArchiveProject.this), (Project)ArchiveProject.this, (Icon)ArchiveProject.access$200(ArchiveProject.this)), ArchiveProject.access$100(ArchiveProject.this).createAuxiliaryConfiguration(), ArchiveProject.access$100(ArchiveProject.this).createCacheDirectoryProvider(), ArchiveProject.access$100(ArchiveProject.this).createGlobFileBuiltQuery(ArchiveProject.access$300(ArchiveProject.this), new String[]{"${src.dir}/*.java"}, new String[]{"${build.classes.dir}/*.class"}), ArchiveProject.access$100(ArchiveProject.this).createSharabilityQuery(ArchiveProject.access$300(ArchiveProject.this), new String[]{"${src.dir}"}, new String[]{"${build.dir}", "${dist.dir}", "${proxy.project.dir}"}), UILookupMergerSupport.createProjectOpenHookMerger((ProjectOpenedHook)new OpenCloseHook()), new ProvidesAction(ArchiveProject.this), new ProvidesLogicalView(ArchiveProject.this), ArchiveProject.access$100(ArchiveProject.this), new ProvidesJ2eeModule(ArchiveProject.access$100(ArchiveProject.this), ArchiveProject.this), new J2eeModuleForAddModuleAction(J2eeModule.Type.EAR), new MyAntProvider(), new ProvidesCustomizer(ArchiveProject.this, ArchiveProject.access$100(ArchiveProject.this)), new RecommendedTemplatesImpl(), new ArchiveProjectOperations(ArchiveProject.this), ArchiveProject.this, new MyOpenHook(), new ProjectXmlSaved()}), (String)"Projects/org-netbeans-modules-j2ee-archiveproject/Lookup");

        private HelpfulLookup() {
        }

        public <T> Lookup.Item<T> lookupItem(Lookup.Template<T> template) {
            Lookup.Item retValue = this.inner.lookupItem(template);
            if (this.verbose && null == retValue && ErrorManager.getDefault().isNotifiable(4096)) {
                StackTraceElement[] sTEs = Thread.currentThread().getStackTrace();
                ErrorManager.getDefault().log(4096, NbBundle.getMessage(ArchiveProject.class, (String)"LOOKUP_MISS", (Object)template.toString(), (Object)sTEs[3], (Object)sTEs[4]));
            }
            return retValue;
        }

        public <T> Lookup.Result<T> lookupResult(Class<T> clazz) {
            Lookup.Result retValue = this.inner.lookupResult(clazz);
            if (this.verbose && null == retValue && ErrorManager.getDefault().isNotifiable(4096)) {
                StackTraceElement[] sTEs = Thread.currentThread().getStackTrace();
                ErrorManager.getDefault().log(4096, NbBundle.getMessage(ArchiveProject.class, (String)"LOOKUP_MISS", (Object)clazz.toString(), (Object)sTEs[3], (Object)sTEs[4]));
            }
            return retValue;
        }

        public <T> Collection<? extends T> lookupAll(Class<T> clazz) {
            Collection retValue = this.inner.lookupAll(clazz);
            if (this.verbose && null == retValue && ErrorManager.getDefault().isNotifiable(4096)) {
                StackTraceElement[] sTEs = Thread.currentThread().getStackTrace();
                ErrorManager.getDefault().log(4096, NbBundle.getMessage(ArchiveProject.class, (String)"LOOKUP_MISS", (Object)clazz.toString(), (Object)sTEs[3], (Object)sTEs[4]));
            }
            return retValue;
        }

        public <T> T lookup(Class<T> clazz) {
            Object ret = this.inner.lookup(clazz);
            if (this.verbose && null == ret && ErrorManager.getDefault().isNotifiable(4096)) {
                StackTraceElement[] sTEs = Thread.currentThread().getStackTrace();
                ErrorManager.getDefault().log(4096, NbBundle.getMessage(ArchiveProject.class, (String)"LOOKUP_MISS", (Object)clazz.getName(), (Object)sTEs[3], (Object)sTEs[4]));
            }
            return (T)ret;
        }

        public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
            Lookup.Result ret = this.inner.lookup(template);
            if (this.verbose && null == ret && ErrorManager.getDefault().isNotifiable(4096)) {
                StackTraceElement[] sTEs = Thread.currentThread().getStackTrace();
                ErrorManager.getDefault().log(4096, NbBundle.getMessage(ArchiveProject.class, (String)"LOOKUP_MISS", (Object)template.toString(), (Object)sTEs[3], (Object)sTEs[4]));
            }
            return ret;
        }
    }
}

