/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.StopwatchCustomizer;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public final class StopwatchProfilingPoint
extends CodeProfilingPoint.Paired
implements PropertyChangeListener {
    private static final String ONE_HIT_STRING = NbBundle.getMessage(StopwatchProfilingPoint.class, (String)"StopwatchProfilingPoint_OneHitString");
    private static final String N_HITS_STRING = NbBundle.getMessage(StopwatchProfilingPoint.class, (String)"StopwatchProfilingPoint_NHitsString");
    private static final String NO_RESULTS_STRING = NbBundle.getMessage(StopwatchProfilingPoint.class, (String)"StopwatchProfilingPoint_NoResultsString");
    private static final String REPORT_ACCESS_DESCR = NbBundle.getMessage(StopwatchProfilingPoint.class, (String)"StopwatchProfilingPoint_ReportAccessDescr");
    private static final String NO_HITS_STRING = NbBundle.getMessage(StopwatchProfilingPoint.class, (String)"StopwatchProfilingPoint_NoHitsString");
    private static final String HEADER_TYPE_STRING = NbBundle.getMessage(StopwatchProfilingPoint.class, (String)"StopwatchProfilingPoint_HeaderTypeString");
    private static final String HEADER_ENABLED_STRING = NbBundle.getMessage(StopwatchProfilingPoint.class, (String)"StopwatchProfilingPoint_HeaderEnabledString");
    private static final String HEADER_PROJECT_STRING = NbBundle.getMessage(StopwatchProfilingPoint.class, (String)"StopwatchProfilingPoint_HeaderProjectString");
    private static final String HEADER_LOCATION_STRING = NbBundle.getMessage(StopwatchProfilingPoint.class, (String)"StopwatchProfilingPoint_HeaderLocationString");
    private static final String HEADER_START_LOCATION_STRING = NbBundle.getMessage(StopwatchProfilingPoint.class, (String)"StopwatchProfilingPoint_HeaderStartLocationString");
    private static final String HEADER_END_LOCATION_STRING = NbBundle.getMessage(StopwatchProfilingPoint.class, (String)"StopwatchProfilingPoint_HeaderEndLocationString");
    private static final String HEADER_MEASURE_DURATION_STRING = NbBundle.getMessage(StopwatchProfilingPoint.class, (String)"StopwatchProfilingPoint_HeaderMeasureDurationString");
    private static final String HEADER_MEASURE_TIMESTAMP_STRING = NbBundle.getMessage(StopwatchProfilingPoint.class, (String)"StopwatchProfilingPoint_HeaderMeasureTimestampString");
    private static final String HEADER_HITS_STRING = NbBundle.getMessage(StopwatchProfilingPoint.class, (String)"StopwatchProfilingPoint_HeaderHitsString");
    private static final String HIT_STRING = NbBundle.getMessage(StopwatchProfilingPoint.class, (String)"StopwatchProfilingPoint_HitString");
    private static final String HIT_DURATION_PENDING_STRING = NbBundle.getMessage(StopwatchProfilingPoint.class, (String)"StopwatchProfilingPoint_HitDurationPendingString");
    private static final String HIT_DURATION_KNOWN_STRING = NbBundle.getMessage(StopwatchProfilingPoint.class, (String)"StopwatchProfilingPoint_HitDurationKnownString");
    private static final String DATA_STRING = NbBundle.getMessage(StopwatchProfilingPoint.class, (String)"StopwatchProfilingPoint_DataString");
    private static final String ANNOTATION_START_STRING = NbBundle.getMessage(StopwatchProfilingPoint.class, (String)"StopwatchProfilingPoint_AnnotationStartString");
    private static final String ANNOTATION_END_STRING = NbBundle.getMessage(StopwatchProfilingPoint.class, (String)"StopwatchProfilingPoint_AnnotationEndString");
    private static final String ANNOTATION_ENABLED = "stopwatchProfilingPoint";
    private static final String ANNOTATION_DISABLED = "stopwatchProfilingPointD";
    private Annotation endAnnotation;
    private Annotation startAnnotation;
    private List<Result> results = new ArrayList<Result>();
    private final Object resultsSync = new Object();
    private WeakReference<Report> reportReference;

    public StopwatchProfilingPoint(String name, CodeProfilingPoint.Location startLocation, CodeProfilingPoint.Location endLocation, Project project, ProfilingPointFactory factory) {
        this(name, startLocation, endLocation, project, factory, false);
    }

    public StopwatchProfilingPoint(String name, CodeProfilingPoint.Location startLocation, CodeProfilingPoint.Location endLocation, Project project, ProfilingPointFactory factory, boolean existing) {
        super(name, startLocation, endLocation, project, factory, existing);
        this.getChangeSupport().addPropertyChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasResults() {
        Object object = this.resultsSync;
        synchronized (object) {
            return this.results.size() > 0;
        }
    }

    @Override
    public void hideResults() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (StopwatchProfilingPoint.this.hasReport()) {
                    StopwatchProfilingPoint.this.getReport().close();
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.hasReport()) {
            if (evt.getPropertyName() == "p_name") {
                this.getReport().refreshProperties();
            }
            this.getReport().refreshData();
        }
    }

    @Override
    public void showResults(URL url) {
        Report topComponent = this.getReport();
        topComponent.open();
        topComponent.requestActive();
    }

    @Override
    protected CodeProfilingPoint.Annotation getEndAnnotation() {
        if (!this.usesEndLocation()) {
            this.endAnnotation = null;
        } else if (this.endAnnotation == null) {
            this.endAnnotation = new Annotation(false);
        }
        return this.endAnnotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getResultsText() {
        Object object = this.resultsSync;
        synchronized (object) {
            if (this.hasResults()) {
                return this.results.size() == 1 ? MessageFormat.format(ONE_HIT_STRING, Utils.formatProfilingPointTime(this.results.get(this.results.size() - 1).getTimestamp())) : MessageFormat.format(N_HITS_STRING, this.results.size(), Utils.formatProfilingPointTime(this.results.get(this.results.size() - 1).getTimestamp()));
            }
            return NO_RESULTS_STRING;
        }
    }

    @Override
    protected CodeProfilingPoint.Annotation getStartAnnotation() {
        if (this.startAnnotation == null) {
            this.startAnnotation = new Annotation(true);
        }
        return this.startAnnotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void timeAdjust(int threadId, long timeDiff0, long timeDiff1) {
        if (this.usesEndLocation()) {
            Object object = this.resultsSync;
            synchronized (object) {
                for (Result result : this.results) {
                    if (result.getEndTimestamp() != -1L || result.getThreadID() != threadId) continue;
                    result.timeAdjust(timeDiff0);
                }
            }
        }
    }

    @Override
    protected void updateCustomizer(ValidityAwarePanel c) {
        StopwatchCustomizer customizer = (StopwatchCustomizer)c;
        customizer.setPPName(this.getName());
        customizer.setPPStartLocation(this.getStartLocation());
        customizer.setPPEndLocation(this.getEndLocation());
    }

    @Override
    protected boolean usesEndLocation() {
        return this.getEndLocation() != null;
    }

    @Override
    void setValues(ValidityAwarePanel c) {
        StopwatchCustomizer customizer = (StopwatchCustomizer)c;
        this.setName(customizer.getPPName());
        this.setStartLocation(customizer.getPPStartLocation());
        this.setEndLocation(customizer.getPPEndLocation());
        Utils.checkLocation(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void hit(RuntimeProfilingPoint.HitEvent hitEvent, int index) {
        Object object = this.resultsSync;
        synchronized (object) {
            if (!this.usesEndLocation() || index == 0) {
                this.results.add(new Result(hitEvent.getTimestamp(), hitEvent.getThreadId()));
            } else {
                for (Result result : this.results) {
                    if (result.getEndTimestamp() != -1L || result.getThreadID() != hitEvent.getThreadId()) continue;
                    result.setEndTimestamp(hitEvent.getTimestamp());
                    break;
                }
            }
        }
        this.getChangeSupport().firePropertyChange("p_results", false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void reset() {
        Object object = this.resultsSync;
        synchronized (object) {
            boolean change = this.results.size() > 0;
            this.results.clear();
            if (change) {
                this.getChangeSupport().firePropertyChange("p_results", false, true);
            }
        }
    }

    private Report getReport() {
        if (this.hasReport()) {
            return (Report)((Object)this.reportReference.get());
        }
        Report report = new Report();
        this.reportReference = new WeakReference<Report>(report);
        return report;
    }

    private boolean hasReport() {
        return this.reportReference != null && this.reportReference.get() != null;
    }

    private static class Result {
        private final int threadId;
        private final long timestamp;
        private long endTimestamp = -1L;
        private long timeAdjustment;

        private Result(long timestamp, int threadId) {
            this.timestamp = timestamp;
            this.threadId = threadId;
        }

        private void setEndTimestamp(long endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        private long getEndTimestamp() {
            return this.endTimestamp;
        }

        private int getThreadID() {
            return this.threadId;
        }

        private long getTimeAdjustment() {
            return this.timeAdjustment;
        }

        private long getTimestamp() {
            return this.timestamp;
        }

        private void timeAdjust(long timeDiff) {
            this.timeAdjustment += timeDiff;
        }
    }

    private class Report
    extends TopComponent {
        private static final String START_LOCATION_URLMASK = "file:/1";
        private static final String END_LOCATION_URLMASK = "file:/2";
        private HTMLTextArea dataArea;
        private HTMLTextArea headerArea;

        public Report() {
            this.initDefaults();
            this.initComponents();
            this.refreshData();
        }

        public int getPersistenceType() {
            return 2;
        }

        protected String preferredID() {
            return ((Object)((Object)this)).getClass().getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void refreshData() {
            StringBuilder headerAreaTextBuilder = new StringBuilder();
            headerAreaTextBuilder.append(this.getHeaderName());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderType());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderEnabled());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderProject());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderStartLocation());
            headerAreaTextBuilder.append("<br>");
            if (StopwatchProfilingPoint.this.usesEndLocation()) {
                headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                headerAreaTextBuilder.append(this.getHeaderEndLocation());
                headerAreaTextBuilder.append("<br>");
            }
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderMeasureLocation());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderHitsCount());
            this.headerArea.setText(headerAreaTextBuilder.toString());
            StringBuilder dataAreaTextBuilder = new StringBuilder();
            Object object = StopwatchProfilingPoint.this.resultsSync;
            synchronized (object) {
                if (StopwatchProfilingPoint.this.results.size() == 0) {
                    dataAreaTextBuilder.append("&nbsp;&nbsp;&lt;" + NO_HITS_STRING + "&gt;");
                } else {
                    for (int i = 0; i < StopwatchProfilingPoint.this.results.size(); ++i) {
                        dataAreaTextBuilder.append("&nbsp;&nbsp;");
                        dataAreaTextBuilder.append(this.getDataResultItem(i));
                        dataAreaTextBuilder.append("<br>");
                    }
                }
            }
            this.dataArea.setText(dataAreaTextBuilder.toString());
        }

        void refreshProperties() {
            this.setName(StopwatchProfilingPoint.this.getName());
            this.setIcon(((ImageIcon)StopwatchProfilingPoint.this.getFactory().getIcon()).getImage());
            this.getAccessibleContext().setAccessibleDescription(MessageFormat.format(REPORT_ACCESS_DESCR, this.getName()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getDataResultItem(int index) {
            Object object = StopwatchProfilingPoint.this.resultsSync;
            synchronized (object) {
                Result result = (Result)StopwatchProfilingPoint.this.results.get(index);
                String hitTime = Utils.formatProfilingPointTimeHiRes(result.getTimestamp());
                if (!StopwatchProfilingPoint.this.usesEndLocation()) {
                    return MessageFormat.format(HIT_STRING, index + 1, hitTime);
                }
                if (result.getEndTimestamp() == -1L) {
                    return MessageFormat.format(HIT_DURATION_PENDING_STRING, index + 1, hitTime);
                }
                return MessageFormat.format(HIT_DURATION_KNOWN_STRING, index + 1, hitTime, Utils.getDurationInMicroSec(result.getTimestamp(), result.getEndTimestamp() - result.getTimeAdjustment()));
            }
        }

        private String getHeaderEnabled() {
            return MessageFormat.format(HEADER_ENABLED_STRING, StopwatchProfilingPoint.this.isEnabled());
        }

        private String getHeaderEndLocation() {
            CodeProfilingPoint.Location location = StopwatchProfilingPoint.this.getEndLocation();
            File file = new File(location.getFile());
            String shortFileName = file.getName();
            int lineNumber = location.getLine();
            String locationUrl = "<a href='file:/2'>";
            return MessageFormat.format(HEADER_END_LOCATION_STRING, locationUrl + shortFileName, lineNumber) + "</a>";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getHeaderHitsCount() {
            Object object = StopwatchProfilingPoint.this.resultsSync;
            synchronized (object) {
                return MessageFormat.format(HEADER_HITS_STRING, StopwatchProfilingPoint.this.results.size());
            }
        }

        private String getHeaderMeasureLocation() {
            return StopwatchProfilingPoint.this.usesEndLocation() ? HEADER_MEASURE_DURATION_STRING : HEADER_MEASURE_TIMESTAMP_STRING;
        }

        private String getHeaderName() {
            return "<h2><b>" + StopwatchProfilingPoint.this.getName() + "</b></h2>";
        }

        private String getHeaderProject() {
            return MessageFormat.format(HEADER_PROJECT_STRING, ProjectUtils.getInformation((Project)StopwatchProfilingPoint.this.getProject()).getDisplayName());
        }

        private String getHeaderStartLocation() {
            CodeProfilingPoint.Location location = StopwatchProfilingPoint.this.getStartLocation();
            File file = new File(location.getFile());
            String shortFileName = file.getName();
            int lineNumber = location.getLine();
            String locationUrl = "<a href='file:/1'>";
            return StopwatchProfilingPoint.this.usesEndLocation() ? MessageFormat.format(HEADER_START_LOCATION_STRING, locationUrl + shortFileName, lineNumber) + "</a>" : MessageFormat.format(HEADER_LOCATION_STRING, locationUrl + shortFileName, lineNumber) + "</a>";
        }

        private String getHeaderType() {
            return MessageFormat.format(HEADER_TYPE_STRING, StopwatchProfilingPoint.this.getFactory().getType());
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            JPanel contentsPanel = new JPanel(new BorderLayout());
            contentsPanel.setBackground(UIUtils.getProfilerResultsBackground());
            contentsPanel.setOpaque(true);
            contentsPanel.setBorder(BorderFactory.createMatteBorder(0, 15, 15, 15, UIUtils.getProfilerResultsBackground()));
            this.headerArea = new HTMLTextArea(){

                protected void showURL(URL url) {
                    String urlString = url.toString();
                    if (Report.START_LOCATION_URLMASK.equals(urlString)) {
                        Utils.openLocation(StopwatchProfilingPoint.this.getStartLocation());
                    } else if (StopwatchProfilingPoint.this.usesEndLocation()) {
                        Utils.openLocation(StopwatchProfilingPoint.this.getEndLocation());
                    }
                }
            };
            JScrollPane headerAreaScrollPane = new JScrollPane((Component)this.headerArea, 20, 30);
            headerAreaScrollPane.setBorder(BorderFactory.createMatteBorder(0, 0, 15, 0, UIUtils.getProfilerResultsBackground()));
            headerAreaScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            contentsPanel.add((Component)headerAreaScrollPane, "North");
            this.dataArea = new HTMLTextArea();
            JScrollPane dataAreaScrollPane = new JScrollPane((Component)this.dataArea, 20, 30);
            TitledBorder tb = new TitledBorder(DATA_STRING);
            tb.setTitleFont(tb.getTitleFont().deriveFont(1));
            tb.setTitleColor(UIManager.getColor("Label.foreground"));
            dataAreaScrollPane.setBorder(tb);
            dataAreaScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            dataAreaScrollPane.setBackground(UIUtils.getProfilerResultsBackground());
            contentsPanel.add((Component)dataAreaScrollPane, "Center");
            this.add(contentsPanel, "Center");
        }

        private void initDefaults() {
            this.refreshProperties();
            this.setFocusable(true);
        }
    }

    private class Annotation
    extends CodeProfilingPoint.Annotation {
        private boolean isStartAnnotation;

        public Annotation(boolean isStartAnnotation) {
            this.isStartAnnotation = isStartAnnotation;
        }

        public String getAnnotationType() {
            return StopwatchProfilingPoint.this.isEnabled() ? StopwatchProfilingPoint.ANNOTATION_ENABLED : StopwatchProfilingPoint.ANNOTATION_DISABLED;
        }

        public String getShortDescription() {
            if (!StopwatchProfilingPoint.this.usesEndLocation()) {
                return StopwatchProfilingPoint.this.getName();
            }
            return this.isStartAnnotation ? MessageFormat.format(ANNOTATION_START_STRING, StopwatchProfilingPoint.this.getName()) : MessageFormat.format(ANNOTATION_END_STRING, StopwatchProfilingPoint.this.getName());
        }

        @Override
        public CodeProfilingPoint profilingPoint() {
            return StopwatchProfilingPoint.this;
        }
    }
}

