/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.lib.profiler.common.filters.FilterUtils;
import org.netbeans.lib.profiler.common.filters.SimpleFilter;
import org.netbeans.modules.profiler.spi.ProjectProfilingSupport;
import org.netbeans.modules.profiler.spi.ProjectTypeProfiler;
import org.netbeans.modules.profiler.ui.stp.DefaultSettingsConfigurator;
import org.netbeans.modules.profiler.ui.stp.SelectProfilingTask;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.netbeans.modules.profiler.utils.ProjectUtilities;
import org.openide.filesystems.FileObject;

public abstract class AbstractProjectTypeProfiler
implements ProjectTypeProfiler {
    protected static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.profiler.spi.ProjectTypeProfiler");

    @Override
    public abstract String getProfilerTargetName(Project var1, FileObject var2, int var3, FileObject var4);

    @Override
    public abstract boolean isProfilingSupported(Project var1);

    @Override
    public JComponent getAdditionalConfigurationComponent(Project project) {
        return null;
    }

    @Override
    public boolean isAttachSupported(Project project) {
        return true;
    }

    @Override
    public ClientUtils.SourceCodeSelection[] getDefaultRootMethods(Project project, FileObject profiledClassFile, boolean profileUnderlyingFramework, String[][] projectPackagesDescr) {
        if (profileUnderlyingFramework) {
            return new ClientUtils.SourceCodeSelection[0];
        }
        Collection supports = project.getLookup().lookupAll(ProjectProfilingSupport.class);
        HashSet<ClientUtils.SourceCodeSelection> allRoots = new HashSet<ClientUtils.SourceCodeSelection>();
        for (ProjectProfilingSupport support : supports) {
            ClientUtils.SourceCodeSelection[] roots = support.getRootMethods(profiledClassFile);
            allRoots.addAll(Arrays.asList(roots));
        }
        return allRoots.toArray(new ClientUtils.SourceCodeSelection[allRoots.size()]);
    }

    @Override
    public boolean isFileObjectSupported(Project project, FileObject fo) {
        Collection supports = project.getLookup().lookupAll(ProjectProfilingSupport.class);
        for (ProjectProfilingSupport support : supports) {
            if (!support.canProfileFile(fo)) continue;
            return true;
        }
        return false;
    }

    @Override
    public abstract boolean checkProjectCanBeProfiled(Project var1, FileObject var2);

    @Override
    public boolean checkProjectIsModifiedForProfiler(Project project) {
        return true;
    }

    @Override
    public List<SimpleFilter> getPredefinedInstrumentationFilters(Project project) {
        return org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.getProjectDefaultInstrFilters((Project)project);
    }

    @Override
    public float getProfilingOverhead(ProfilingSettings settings) {
        float o = 0.0f;
        if (!Utils.isMonitorSettings(settings)) {
            if (Utils.isCPUSettings(settings)) {
                if (settings.getProfilingType() == 8) {
                    o += 0.5f;
                } else if (settings.getProfilingType() == 16) {
                    o += 0.2f;
                }
                if (FilterUtils.NONE_FILTER.equals(settings.getSelectedInstrumentationFilter())) {
                    o += 0.5f;
                }
            } else if (Utils.isMemorySettings(settings)) {
                if (settings.getProfilingType() == 2) {
                    o += 0.5f;
                } else if (settings.getProfilingType() == 4) {
                    o += 0.7f;
                }
                if (settings.getAllocStackTraceLimit() != 0) {
                    o += 0.3f;
                }
            }
        }
        return o;
    }

    @Override
    public FileObject getProjectBuildScript(Project project) {
        return ProjectUtilities.findBuildFile(project);
    }

    @Override
    public JavaPlatform getProjectJavaPlatform(Project project) {
        return null;
    }

    @Override
    public SelectProfilingTask.SettingsConfigurator getSettingsConfigurator() {
        return DefaultSettingsConfigurator.SHARED_INSTANCE;
    }

    @Override
    public SimpleFilter computePredefinedInstrumentationFilter(Project project, SimpleFilter predefinedInstrFilter, String[][] projectPackagesDescr) {
        Collection supports = project.getLookup().lookupAll(ProjectProfilingSupport.class);
        StringBuilder filterValue = new StringBuilder();
        for (ProjectProfilingSupport support : supports) {
            String partialFilter = support.getFilter(org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.isIncludeSubprojects((SimpleFilter)predefinedInstrFilter));
            filterValue.append(" ").append(partialFilter);
        }
        return new SimpleFilter(predefinedInstrFilter.getFilterName(), predefinedInstrFilter.getFilterType(), filterValue.toString().trim());
    }

    @Override
    public void computeProjectPackages(Project project, boolean subprojects, String[][] storage) {
        org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.computeProjectPackages((Project)project, (boolean)subprojects, (String[][])storage);
    }

    @Override
    public void configurePropertiesForProfiling(Properties props, Project project, FileObject profiledClassFile) {
    }

    @Override
    public void setupProjectSessionSettings(Project project, SessionSettings ss) {
    }

    @Override
    public boolean supportsSettingsOverride() {
        return false;
    }

    @Override
    public boolean supportsUnintegrate(Project project) {
        return false;
    }

    @Override
    public void unintegrateProfiler(Project project) {
    }

    @Override
    public boolean startProfilingSession(Project project, FileObject profiledClassFile, boolean isTest, Properties properties) {
        return false;
    }
}

