/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.File;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.remote.support.RemoteLogger;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WritingQueue {
    private static final Map<ExecutionEnvironment, WritingQueue> instances = new HashMap<ExecutionEnvironment, WritingQueue>();
    private static final Logger LOGGER = Logger.getLogger("cnd.remote.writing.queue.logger");
    private final ExecutionEnvironment execEnv;
    private final Map<String, Entry> entries = new HashMap<String, Entry>();
    private final Object lock = new Object();
    private final Set<String> failed = new HashSet<String>();
    private final Object monitor = new Object();

    public WritingQueue(ExecutionEnvironment env) {
        this.execEnv = env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WritingQueue getInstance(ExecutionEnvironment env) {
        Class<WritingQueue> clazz = WritingQueue.class;
        synchronized (WritingQueue.class) {
            WritingQueue instance = instances.get(env);
            if (instance == null) {
                instance = new WritingQueue(env);
                instances.put(env, instance);
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(File srcFile, String dstFileName, int mask, Writer error) {
        LOGGER.log(Level.FINEST, "WritingQueue: adding file {0}:{2}", new Object[]{this.execEnv, dstFileName});
        Object object = this.lock;
        synchronized (object) {
            Entry entry = this.entries.get(dstFileName);
            if (entry == null) {
                entry = new Entry(dstFileName);
                this.entries.put(dstFileName, entry);
            }
            entry.add(srcFile, mask, error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean entriesEmpty(Collection<FileObject> filesToWait, Collection<String> failedFiles) {
        Object object = this.lock;
        synchronized (object) {
            if (this.entries.isEmpty()) {
                failedFiles.clear();
                failedFiles.addAll(this.failed);
                return true;
            }
            if (filesToWait.isEmpty()) {
                return false;
            }
            for (FileObject fo : filesToWait) {
                if (!this.entries.containsKey(fo.getPath())) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBusy() {
        Object object = this.lock;
        synchronized (object) {
            return !this.entries.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitFinished(Collection<String> failedFiles) throws InterruptedException {
        if (failedFiles == null) {
            failedFiles = new ArrayList<String>();
        }
        while (!this.entriesEmpty(Collections.<FileObject>emptyList(), failedFiles) || !this.entries.isEmpty()) {
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.wait();
            }
        }
        return failedFiles.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitFinished(Collection<FileObject> filesToWait, Collection<String> failedFiles) throws InterruptedException {
        if (failedFiles == null) {
            failedFiles = new ArrayList<String>();
        }
        while (!this.entriesEmpty(filesToWait, failedFiles) || !this.entries.isEmpty()) {
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.wait();
            }
        }
        return failedFiles.isEmpty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entry
    implements ChangeListener {
        private volatile Future<Integer> currentTask;
        private final String dstFileName;

        public Entry(String dstFileName) {
            this.dstFileName = dstFileName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(File srcFile, int mask, Writer error) {
            Object object = WritingQueue.this.lock;
            synchronized (object) {
                WritingQueue.this.failed.remove(this.dstFileName);
                if (this.currentTask != null) {
                    RemoteLogger.getInstance().log(Level.FINE, "Waiting for previous upload task for {0}", this.dstFileName);
                    try {
                        this.currentTask.get();
                    }
                    catch (InterruptedException ex) {
                        RemoteLogger.getInstance().log(Level.INFO, "InterruptedException when waiting for previous task", ex);
                    }
                    catch (ExecutionException ex) {
                        RemoteLogger.getInstance().log(Level.INFO, "ExecutionException when waiting for previous task", ex);
                    }
                    this.currentTask = null;
                }
                CommonTasksSupport.UploadParameters params = new CommonTasksSupport.UploadParameters(srcFile, WritingQueue.this.execEnv, this.dstFileName, mask, error, false, (ChangeListener)this);
                this.currentTask = CommonTasksSupport.uploadFile((CommonTasksSupport.UploadParameters)params);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent e) {
            Object source = e.getSource();
            if (!(source instanceof Future)) {
                RemoteLogger.assertTrue(false, "Wrong class, should be Future<Integer>: " + (source == null ? "null" : source.getClass()));
                return;
            }
            try {
                this.taskFinished((Future)source);
            }
            finally {
                Object object = WritingQueue.this.monitor;
                synchronized (object) {
                    WritingQueue.this.monitor.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void taskFinished(Future<Integer> finishedTask) {
            LOGGER.log(Level.FINEST, "WritingQueue: Task {0} at {1} finished", new Object[]{finishedTask, WritingQueue.this.execEnv});
            Object object = WritingQueue.this.lock;
            synchronized (object) {
                if (this.currentTask != null && this.currentTask != finishedTask) {
                    return;
                }
                try {
                    if (finishedTask.get() == 0) {
                        LOGGER.log(Level.FINEST, "WritingQueue: uploading {0}:{2} succeeded", new Object[]{WritingQueue.this.execEnv, this.dstFileName});
                        WritingQueue.this.failed.remove(this.dstFileName);
                    } else {
                        LOGGER.log(Level.FINEST, "WritingQueue: uploading {0}:{2} failed", new Object[]{WritingQueue.this.execEnv, this.dstFileName});
                        WritingQueue.this.failed.add(this.dstFileName);
                    }
                }
                catch (InterruptedException ex) {
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    WritingQueue.this.entries.remove(this.dstFileName);
                }
            }
        }
    }
}

