/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import org.netbeans.modules.dlight.libs.common.InvalidFileObjectSupport;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.remote.impl.fs.FileType;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;
import org.netbeans.modules.remote.impl.fs.RemoteFileSupport;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemManager;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.netbeans.modules.remote.support.RemoteLogger;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteFileObjectBase
extends FileObject
implements Serializable {
    private final RemoteFileSystem fileSystem;
    private final RemoteFileObjectBase parent;
    private volatile String remotePath;
    private final File cache;
    private CopyOnWriteArrayList<FileChangeListener> listeners = new CopyOnWriteArrayList();
    private final FileLock lock = new FileLock();
    static final long serialVersionUID = 1931650016889811086L;
    private byte flags;
    private static final byte MASK_VALID = 1;
    private static final byte CHECK_CAN_WRITE = 2;

    public RemoteFileObjectBase(RemoteFileSystem fileSystem, ExecutionEnvironment execEnv, RemoteFileObjectBase parent, String remotePath, File cache) {
        RemoteLogger.assertTrue(execEnv.isRemote());
        this.fileSystem = fileSystem;
        this.parent = parent;
        this.remotePath = remotePath;
        this.cache = cache;
        this.setFlag((byte)1, true);
    }

    private boolean getFlag(byte mask) {
        return (this.flags & mask) == mask;
    }

    private void setFlag(byte mask, boolean value) {
        this.flags = value ? (byte)(this.flags | mask) : (byte)(this.flags & ~mask);
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.fileSystem.getExecutionEnvironment();
    }

    protected final File getCache() {
        return this.cache;
    }

    public String getPath() {
        return this.remotePath;
    }

    public void addFileChangeListener(FileChangeListener fcl) {
        this.listeners.add(fcl);
    }

    public void removeFileChangeListener(FileChangeListener fcl) {
        this.listeners.remove(fcl);
    }

    protected final Enumeration<FileChangeListener> getListeners() {
        return Collections.enumeration(this.listeners);
    }

    protected abstract void deleteImpl() throws IOException;

    protected abstract void postDeleteChild(FileObject var1);

    public void delete(FileLock lock) throws IOException {
        this.deleteImpl();
        this.invalidate();
        RemoteFileObjectBase p = this.getParent();
        if (p != null) {
            p.postDeleteChild(this);
        }
    }

    public String getExt() {
        String nameExt = this.getNameExt();
        int pointPos = nameExt.lastIndexOf(46);
        return pointPos < 0 ? "" : nameExt.substring(pointPos + 1);
    }

    public RemoteFileSystem getFileSystem() {
        return this.fileSystem;
    }

    protected RemoteFileSupport getRemoteFileSupport() {
        return this.getFileSystem().getRemoteFileSupport();
    }

    public String getName() {
        String nameExt = this.getNameExt();
        int pointPos = nameExt.lastIndexOf(46);
        return pointPos < 0 ? nameExt : nameExt.substring(0, pointPos);
    }

    public String getNameExt() {
        int slashPos = this.getPath().lastIndexOf(47);
        return slashPos < 0 ? "" : this.getPath().substring(slashPos + 1);
    }

    public OutputStream getOutputStream(FileLock lock) throws IOException {
        throw new ReadOnlyException();
    }

    public abstract RemoteFileObjectBase getFileObject(String var1);

    public abstract RemoteFileObjectBase getFileObject(String var1, String var2);

    public abstract RemoteFileObjectBase[] getChildren();

    protected RemoteFileObjectBase[] getExistentChildren() {
        return new RemoteFileObjectBase[0];
    }

    public RemoteFileObjectBase getParent() {
        return this.parent;
    }

    public long getSize() {
        try {
            RemoteDirectory canonicalParent = RemoteFileSystemUtils.getCanonicalParent(this);
            if (canonicalParent != null) {
                return canonicalParent.getSize(this);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return 0L;
    }

    @Deprecated
    public boolean isReadOnly() {
        return true;
    }

    public boolean canRead() {
        try {
            RemoteDirectory canonicalParent = RemoteFileSystemUtils.getCanonicalParent(this);
            if (canonicalParent == null) {
                return true;
            }
            return canonicalParent.canRead(this.getNameExt());
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return true;
        }
    }

    void connectionChanged() {
        if (this.getFlag((byte)2)) {
            this.setFlag((byte)2, false);
            this.fireFileAttributeChangedEvent(this.getListeners(), new FileAttributeEvent((FileObject)this, (FileObject)this, "DataEditorSupport.read-only.refresh", null, null));
        }
    }

    public boolean canWrite() {
        this.setFlag((byte)2, true);
        if (!ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment())) {
            return false;
        }
        try {
            RemoteDirectory canonicalParent = RemoteFileSystemUtils.getCanonicalParent(this);
            if (canonicalParent == null) {
                return false;
            }
            boolean result = canonicalParent.canWrite(this.getNameExt());
            if (!result) {
                this.setFlag((byte)2, false);
            }
            return result;
        }
        catch (ConnectException ex) {
            return false;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    protected void refreshImpl(boolean recursive) throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
    }

    public void refresh(boolean expected) {
        try {
            this.refreshImpl(true);
        }
        catch (ConnectException ex) {
            RemoteLogger.finest(ex);
        }
        catch (IOException ex) {
            RemoteLogger.info(ex);
        }
        catch (InterruptedException ex) {
            RemoteLogger.finest(ex);
        }
        catch (CancellationException ex) {
            RemoteLogger.finest(ex);
        }
        catch (ExecutionException ex) {
            RemoteLogger.info(ex);
        }
    }

    public void refresh() {
        this.refresh(false);
    }

    public boolean isRoot() {
        return false;
    }

    public boolean isValid() {
        if (this.getFlag((byte)1)) {
            RemoteFileObjectBase p = this.getParent();
            return p == null || p.isValid();
        }
        return false;
    }

    void invalidate() {
        this.setFlag((byte)1, false);
    }

    public boolean isVirtual() {
        return false;
    }

    public Date lastModified() {
        try {
            RemoteDirectory canonicalParent = RemoteFileSystemUtils.getCanonicalParent(this);
            if (canonicalParent != null) {
                return canonicalParent.lastModified(this);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return new Date(0L);
    }

    public FileLock lock() throws IOException {
        return this.lock;
    }

    public void rename(FileLock lock, String name, String ext) throws IOException {
        RemoteFileObjectBase p = this.getParent();
        if (p != null) {
            String newNameExt = RemoteFileObjectBase.composeName(name, ext);
            if (newNameExt.equals(this.getNameExt())) {
                return;
            }
            if (!p.isValid()) {
                throw new IOException("Can not rename in " + p.getPath());
            }
            if (!p.canWrite()) {
                throw new IOException("Can not rename in read only " + p.getPath());
            }
            if (p.getFileObject(newNameExt) != null) {
                throw new IOException("Can not rename to " + newNameExt);
            }
            if (!ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment())) {
                throw new IOException("No connection: Can not rename in " + p.getPath());
            }
            try {
                p.renameChild(lock, this, newNameExt);
            }
            catch (ConnectException ex) {
                throw new IOException("No connection: Can not rename in " + p.getPath(), ex);
            }
            catch (InterruptedException ex) {
                InterruptedIOException outEx = new InterruptedIOException("interrupted: Can not rename in " + p.getPath());
                outEx.initCause(ex);
                throw outEx;
            }
            catch (CancellationException ex) {
                throw new IOException("cancelled: Can not rename in " + p.getPath(), ex);
            }
            catch (ExecutionException ex) {
                throw new IOException("Can not rename to " + newNameExt + ": exception occurred", ex);
            }
        }
    }

    public Object getAttribute(String attrName) {
        return this.getFileSystem().getAttribute(this, attrName);
    }

    public Enumeration<String> getAttributes() {
        return this.getFileSystem().getAttributes(this);
    }

    public void setAttribute(String attrName, Object value) throws IOException {
        this.getFileSystem().setAttribute(this, attrName, value);
    }

    @Deprecated
    public void setImportant(boolean b) {
    }

    public abstract FileType getType();

    protected abstract void renameChild(FileLock var1, RemoteFileObjectBase var2, String var3) throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException;

    final void renamePath(String newPath) {
        this.remotePath = newPath;
    }

    public String toString() {
        return this.getExecutionEnvironment().toString() + ":" + this.getPath();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteFileObjectBase other = (RemoteFileObjectBase)obj;
        if (this.flags != other.flags) {
            return false;
        }
        if (!(this.getFileSystem() == other.getFileSystem() || this.getFileSystem() != null && ((Object)((Object)this.fileSystem)).equals((Object)other.fileSystem))) {
            return false;
        }
        if (!(this.getExecutionEnvironment() == other.getExecutionEnvironment() || this.getExecutionEnvironment() != null && this.getExecutionEnvironment().equals(other.getExecutionEnvironment()))) {
            return false;
        }
        return this.getCache() == other.getCache() || this.getCache() != null && this.cache.equals(other.cache);
    }

    public int hashCode() {
        int hash = 3;
        hash = 11 * hash + (this.getFileSystem() != null ? ((Object)((Object)this.getFileSystem())).hashCode() : 0);
        hash = 11 * hash + (this.getExecutionEnvironment() != null ? this.getExecutionEnvironment().hashCode() : 0);
        hash = 11 * hash + (this.getCache() != null ? this.getCache().hashCode() : 0);
        return hash;
    }

    protected static String composeName(String name, String ext) {
        return ext != null && ext.length() > 0 ? name + "." + ext : name;
    }

    Object writeReplace() throws ObjectStreamException {
        return new SerializedForm(this.getExecutionEnvironment(), this.getPath());
    }

    private static class SerializedForm
    implements Serializable {
        private final ExecutionEnvironment env;
        private final String remotePath;

        public SerializedForm(ExecutionEnvironment env, String remotePath) {
            this.env = env;
            this.remotePath = remotePath;
        }

        Object readResolve() throws ObjectStreamException {
            RemoteFileSystem fs = RemoteFileSystemManager.getInstance().getFileSystem(this.env);
            RemoteFileObjectBase fo = fs.findResource(this.remotePath);
            if (fo == null) {
                fo = InvalidFileObjectSupport.getInvalidFileObject((FileSystem)fs, (CharSequence)this.remotePath);
            }
            return fo;
        }
    }

    private static class ReadOnlyException
    extends IOException {
        public ReadOnlyException() {
            super("The remote file system is read-only");
        }
    }
}

