/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.remote.impl.fs.DirEntry;
import org.netbeans.modules.remote.impl.fs.DirEntryLs;
import org.netbeans.modules.remote.impl.fs.DirectoryReader;
import org.netbeans.modules.remote.support.RemoteLogger;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryReaderLs
implements DirectoryReader {
    private static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss Z";
    private static final String DUMMY_TIMESTAMP = "N/A";
    private final ExecutionEnvironment execEnv;
    private final String remoteDirectory;
    private final List<DirEntry> entries = new ArrayList<DirEntry>();
    private final AtomicReference<IOException> criticalException = new AtomicReference();
    private final AtomicReference<IOException> nonCriticalException = new AtomicReference();
    private final StringBuilder errorOutput = new StringBuilder();
    private LsLineParser lineParser;
    private final CountDownLatch latch = new CountDownLatch(2);
    private static final RequestProcessor RP = new RequestProcessor("Reading remote directory", 32);

    public DirectoryReaderLs(ExecutionEnvironment execEnv, String remoteDirectory) {
        this.execEnv = execEnv;
        this.remoteDirectory = remoteDirectory.endsWith("/") ? remoteDirectory : remoteDirectory + "/";
    }

    @Override
    public final void readDirectory() throws IOException, InterruptedException, CancellationException {
        RemoteLogger.assertTrue(ConnectionManager.getInstance().isConnectedTo(this.execEnv), this.execEnv.getDisplayName() + " shoud");
        HostInfo.OSFamily oSFamily = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.execEnv).getOSFamily();
        this.lineParser = DirectoryReaderLs.createLsLineParser(oSFamily, this.remoteDirectory);
        String option = this.getFullTimeLsOption(oSFamily);
        NativeProcessBuilder pb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.execEnv);
        pb.setExecutable("/bin/ls");
        pb.setArguments(new String[]{option, "-A", this.remoteDirectory});
        NativeProcess process = pb.call();
        RP.post((Runnable)new StdOutReader(process.getInputStream(), this.execEnv.isRemote()));
        RP.post((Runnable)new StdErrReader(process.getErrorStream(), this.execEnv.isRemote()));
        int rc = process.waitFor();
        this.latch.await();
        if (rc != 0) {
            if (process.getState() == NativeProcess.State.CANCELLED) {
                throw new InterruptedException("ls has been cancelled");
            }
            if (rc == 2) {
                throw new FileNotFoundException(this.errorOutput.toString());
            }
            throw new IOException(this.errorOutput.toString());
        }
        if (this.criticalException.get() != null) {
            throw this.criticalException.get();
        }
    }

    @Override
    public List<DirEntry> getEntries() {
        return this.entries;
    }

    public static Date getDate(String timeStamp) throws ParseException {
        Parameters.notNull((CharSequence)"timeStamp", (Object)timeStamp);
        if (DUMMY_TIMESTAMP.equals(timeStamp)) {
            return null;
        }
        return new SimpleDateFormat(TIMESTAMP_FORMAT).parse(timeStamp);
    }

    private String getFullTimeLsOption(HostInfo.OSFamily oSFamily) {
        switch (oSFamily) {
            case LINUX: {
                return "--full-time";
            }
            case MACOSX: {
                return "-lT";
            }
            case SUNOS: {
                return "-lE";
            }
            case WINDOWS: {
                throw new IllegalStateException("Windows in unsupported");
            }
        }
        return "-l";
    }

    private static LsLineParser createLsLineParser(HostInfo.OSFamily oSFamily, String remoteDir) {
        return new LsLineParser(oSFamily, remoteDir);
    }

    static List<DirEntry> testLsLineParser(HostInfo.OSFamily oSFamily, String[] lines) {
        LsLineParser lp = DirectoryReaderLs.createLsLineParser(oSFamily, "/dummy");
        ArrayList<DirEntry> result = new ArrayList<DirEntry>();
        for (String line : lines) {
            DirEntry entry = lp.parseLine(line);
            result.add(entry);
        }
        return result;
    }

    private class StdErrReader
    implements Runnable {
        private final BufferedReader reader;

        public StdErrReader(InputStream stream, boolean isRemote) {
            this.reader = ProcessUtils.getReader((InputStream)stream, (boolean)isRemote);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (true) {
                    try {
                        String line;
                        while ((line = this.reader.readLine()) != null) {
                            DirectoryReaderLs.this.errorOutput.append(line).append('\n');
                        }
                    }
                    catch (IOException ex) {
                        DirectoryReaderLs.this.nonCriticalException.set(ex);
                        continue;
                    }
                    break;
                }
            }
            finally {
                DirectoryReaderLs.this.latch.countDown();
            }
        }
    }

    private class StdOutReader
    implements Runnable {
        private final BufferedReader reader;

        public StdOutReader(InputStream stream, boolean isRemote) {
            this.reader = ProcessUtils.getReader((InputStream)stream, (boolean)isRemote);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                boolean first = true;
                while (true) {
                    try {
                        String line;
                        while ((line = this.reader.readLine()) != null) {
                            if (first) {
                                first = false;
                                continue;
                            }
                            DirEntry entry = DirectoryReaderLs.this.lineParser.parseLine(line);
                            if (entry == null) continue;
                            DirectoryReaderLs.this.entries.add(entry);
                        }
                    }
                    catch (IOException ex) {
                        DirectoryReaderLs.this.criticalException.set(ex);
                        continue;
                    }
                    break;
                }
            }
            finally {
                DirectoryReaderLs.this.latch.countDown();
            }
        }
    }

    private static class LsLineParser {
        private final HostInfo.OSFamily oSFamily;
        private final int timestampWordCount;
        private final String remoteDir;

        public LsLineParser(HostInfo.OSFamily oSFamily, String remoteDir) {
            this.remoteDir = remoteDir;
            this.oSFamily = oSFamily;
            this.timestampWordCount = LsLineParser.getTimestampWordCount(oSFamily);
        }

        private static int getTimestampWordCount(HostInfo.OSFamily oSFamily) {
            switch (oSFamily) {
                case LINUX: {
                    return 3;
                }
                case MACOSX: {
                    return 4;
                }
                case SUNOS: {
                    return 3;
                }
                case WINDOWS: {
                    throw new IllegalStateException("Windows in unsupported");
                }
            }
            return 4;
        }

        private String convertTimestamp(String timestamp) {
            switch (this.oSFamily) {
                case LINUX: 
                case SUNOS: {
                    int space;
                    int dot = timestamp.indexOf(46);
                    if (dot > 0 && (space = timestamp.indexOf(32, dot)) > 0) {
                        timestamp = timestamp.substring(0, dot) + timestamp.substring(space);
                        return timestamp;
                    }
                }
                case MACOSX: {
                    break;
                }
                case WINDOWS: {
                    throw new IllegalStateException("Windows in unsupported");
                }
            }
            return DirectoryReaderLs.DUMMY_TIMESTAMP;
        }

        public DirEntry parseLine(String line) {
            long size;
            String[] words = line.split(" +");
            if (words.length < 6 + this.timestampWordCount) {
                RemoteLogger.getInstance().log(Level.INFO, "Unexpected ls output format for {0}: {0}", new Object[]{this.remoteDir, line});
                return null;
            }
            StringBuilder timestamp = new StringBuilder();
            for (int i = 5; i < 5 + this.timestampWordCount; ++i) {
                if (timestamp.length() > 0) {
                    timestamp.append(' ');
                }
                timestamp.append(words[i]);
            }
            try {
                if (words[4].endsWith(",")) {
                    words[4] = words[4].substring(0, words[4].length() - 1);
                }
                size = Long.parseLong(words[4]);
            }
            catch (NumberFormatException e) {
                RemoteLogger.getInstance().log(Level.INFO, "Unexpected ls output format (size) for {0}: {0}", new Object[]{this.remoteDir, line});
                size = 1024L;
            }
            StringBuilder name = new StringBuilder();
            StringBuilder link = new StringBuilder();
            StringBuilder curr = name;
            for (int i = 5 + this.timestampWordCount; i < words.length; ++i) {
                String word = words[i];
                if ("->".equals(word)) {
                    curr = link;
                    continue;
                }
                if (curr.length() > 0) {
                    curr.append(' ');
                }
                curr.append(word);
            }
            DirEntryLs result = new DirEntryLs(name.toString(), null, words[0], words[2], words[3], size, this.convertTimestamp(timestamp.toString()), link.length() == 0 ? null : link.toString());
            return result;
        }
    }
}

