/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.impl.fs.DirEntry;
import org.netbeans.modules.remote.impl.fs.DirectoryReaderLs;
import org.netbeans.modules.remote.impl.fs.FileType;
import org.netbeans.modules.remote.impl.fs.FormatException;
import org.netbeans.modules.remote.support.RemoteLogger;
import org.openide.util.Exceptions;

class DirEntryLs
implements DirEntry {
    private static final short USR_R = 256;
    private static final short USR_W = 128;
    private static final short USR_X = 64;
    private static final short GRP_R = 32;
    private static final short GRP_W = 16;
    private static final short GRP_X = 8;
    private static final short ALL_R = 4;
    private static final short ALL_W = 2;
    private static final short ALL_X = 1;
    private final String name;
    private final char type;
    private final short access;
    private final String user;
    private final String group;
    private final long size;
    private final String timestamp;
    private final String link;
    private String cache;
    private static boolean wrongDateFormatReported = false;

    public DirEntryLs(String name, String cache, String access, String user, String group, long size, String timestamp, String link) {
        if (name == null) {
            throw new NullPointerException("Null name");
        }
        boolean assertions = false;
        if (!$assertionsDisabled) {
            assertions = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertions) {
            char c;
            int i;
            String assertionText = "Wrong access format: " + access;
            RemoteLogger.assertTrue(access.length() >= 10, assertionText);
            block5: for (i = 1; i < 0; ++i) {
                c = access.charAt(i);
                switch (i % 3) {
                    case 1: {
                        RemoteLogger.assertTrue(c == 'r' || c == '-', assertionText);
                        continue block5;
                    }
                    case 2: {
                        RemoteLogger.assertTrue(c == 'w' || c == '-', assertionText);
                        continue block5;
                    }
                    case 0: {
                        RemoteLogger.assertTrue(c == 'x' || c == '-' || c == 's' || c == 'S' || c == 't' || c == 'T', assertionText);
                    }
                }
            }
            for (i = 1; i < 9; i += 3) {
                c = access.charAt(i);
            }
            RemoteLogger.assertTrue(FileType.fromChar(access.charAt(0)) != null, "Can't get file type from access string: " + access);
        }
        this.type = access.charAt(0);
        this.name = name;
        this.cache = cache;
        this.access = this.stringToAcces(access);
        this.user = user;
        this.group = group;
        this.size = size;
        this.timestamp = timestamp;
        this.link = link;
    }

    public FileType getFileType() {
        return FileType.fromChar(this.type);
    }

    public boolean isLink() {
        return this.type == FileType.Symlink.toChar();
    }

    public boolean isPlainFile() {
        return !this.isLink() && !this.isDirectory();
    }

    public boolean isDirectory() {
        return this.type == FileType.Directory.toChar();
    }

    public boolean isSameType(DirEntry other) {
        return other != null && this.isLink() == other.isLink() && this.isDirectory() == other.isDirectory();
    }

    public boolean isSameGroup(DirEntry other) {
        if (other instanceof DirEntryLs) {
            return this.group.equals(((DirEntryLs)other).group);
        }
        return false;
    }

    public boolean isSameUser(DirEntry other) {
        if (other instanceof DirEntryLs) {
            return this.user.equals(((DirEntryLs)other).user);
        }
        return false;
    }

    public boolean isSameLastModified(DirEntry other) {
        if (other instanceof DirEntryLs) {
            return this.timestamp.equals(((DirEntryLs)other).timestamp);
        }
        return false;
    }

    public Date getLastModified() {
        block3: {
            try {
                Date date;
                if (this.timestamp != null && (date = DirectoryReaderLs.getDate(this.timestamp)) != null) {
                    return date;
                }
            }
            catch (ParseException ex) {
                if (wrongDateFormatReported) break block3;
                wrongDateFormatReported = true;
                RemoteLogger.getInstance().log(Level.INFO, "Error parsing date string : " + this.timestamp, ex);
            }
        }
        return new Date(0L);
    }

    public String getName() {
        return this.name;
    }

    public String getCache() {
        return this.cache;
    }

    public void setCache(String cache) {
        this.cache = cache;
    }

    public String getLinkTarget() {
        return this.link;
    }

    public long getSize() {
        return this.size;
    }

    private HostInfo getHostInfo(ExecutionEnvironment execEnv) {
        if (HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)execEnv)) {
            try {
                return HostInfoUtils.getHostInfo((ExecutionEnvironment)execEnv);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (CancellationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    public boolean canRead(ExecutionEnvironment execEnv) {
        HostInfo hostInfo = this.getHostInfo(execEnv);
        if (hostInfo == null) {
            return false;
        }
        String[] groups = hostInfo.getAllGroups();
        if ((this.access & 4) > 0) {
            return true;
        }
        if ((this.access & 0x100) > 0 && this.user.equals(execEnv.getUser())) {
            return true;
        }
        if ((this.access & 0x20) > 0 && groups != null) {
            for (String g : groups) {
                if (!this.group.equals(g)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canWrite(ExecutionEnvironment execEnv) {
        HostInfo hostInfo = this.getHostInfo(execEnv);
        if (hostInfo == null) {
            return false;
        }
        String[] groups = hostInfo.getAllGroups();
        if ((this.access & 2) > 0) {
            return true;
        }
        if ((this.access & 0x80) > 0 && this.user.equals(execEnv.getUser())) {
            return true;
        }
        if ((this.access & 0x10) > 0 && groups != null) {
            for (String g : groups) {
                if (!this.group.equals(g)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canExecute(ExecutionEnvironment execEnv) {
        HostInfo hostInfo = this.getHostInfo(execEnv);
        if (hostInfo == null) {
            return false;
        }
        String[] groups = hostInfo.getAllGroups();
        if ((this.access & 1) > 0) {
            return true;
        }
        if ((this.access & 0x40) > 0 && this.user.equals(execEnv.getUser())) {
            return true;
        }
        if ((this.access & 8) > 0 && groups != null) {
            for (String g : groups) {
                if (!this.group.equals(g)) continue;
                return true;
            }
        }
        return false;
    }

    public String getAccessAsString() {
        char[] accessChars = new char[]{(this.access & 0x100) == 0 ? (char)'-' : 'r', (this.access & 0x80) == 0 ? (char)'-' : 'w', (this.access & 0x40) == 0 ? (char)'-' : 'x', (this.access & 0x20) == 0 ? (char)'-' : 'r', (this.access & 0x10) == 0 ? (char)'-' : 'w', (this.access & 8) == 0 ? (char)'-' : 'x', (this.access & 4) == 0 ? (char)'-' : 'r', (this.access & 2) == 0 ? (char)'-' : 'w', (this.access & 1) == 0 ? (char)'-' : 'x'};
        return new String(accessChars);
    }

    private short stringToAcces(String accessString) {
        short result = 0;
        result = (short)(result | (accessString.charAt(1) == 'r' ? 256 : 0));
        result = (short)(result | (accessString.charAt(2) == 'w' ? 128 : 0));
        result = (short)(result | (accessString.charAt(3) == 'x' ? 64 : 0));
        result = (short)(result | (accessString.charAt(4) == 'r' ? 32 : 0));
        result = (short)(result | (accessString.charAt(5) == 'w' ? 16 : 0));
        result = (short)(result | (accessString.charAt(6) == 'x' ? 8 : 0));
        result = (short)(result | (accessString.charAt(7) == 'r' ? 4 : 0));
        result = (short)(result | (accessString.charAt(8) == 'w' ? 2 : 0));
        result = (short)(result | (accessString.charAt(9) == 'x' ? 1 : 0));
        return result;
    }

    public String toString() {
        return this.name + ' ' + this.getAccessAsString() + ' ' + this.user + ' ' + this.group + ' ' + this.timestamp + ' ' + this.link;
    }

    public static DirEntry fromExternalForm(String line) throws FormatException {
        long sz;
        String[] params = new String[8];
        int name = 0;
        int cache = 1;
        int access = 2;
        int user = 3;
        int group = 4;
        int size = 5;
        int timestamp = 6;
        int link = 7;
        StringBuilder currText = new StringBuilder();
        int currIndex = name;
        boolean escape = false;
        block7: for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            switch (c) {
                case '\\': {
                    if (!(currIndex != name && currIndex != cache || escape)) {
                        escape = true;
                        continue block7;
                    }
                    currText.append(c);
                    escape = false;
                    continue block7;
                }
                case ' ': {
                    if (currIndex == timestamp || escape) {
                        currText.append(c);
                    } else {
                        params[currIndex] = currText.toString();
                        currText = new StringBuilder();
                        ++currIndex;
                    }
                    escape = false;
                    continue block7;
                }
                case '\"': {
                    if (currIndex == timestamp) {
                        if (currText.length() != 0) {
                            params[timestamp] = currText.toString();
                            String t = line.substring(i + 1).trim();
                            params[link] = t.length() == 0 ? null : t;
                            break block7;
                        }
                    } else if (currIndex + 1 == timestamp) {
                        currIndex = timestamp;
                    } else {
                        currText.append(c);
                    }
                    escape = false;
                    continue block7;
                }
                default: {
                    currText.append(c);
                    escape = false;
                }
            }
        }
        if (currIndex < link - 1) {
            throw new FormatException("Wrong directory entry format: " + line, false);
        }
        try {
            sz = Long.parseLong(params[size]);
        }
        catch (NumberFormatException ex) {
            throw new FormatException("Wrong directory entry format: " + line, false);
        }
        return new DirEntryLs(params[name], params[cache], params[access], params[user], params[group], sz, params[timestamp], params[link]);
    }

    public String toExternalForm() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.escape(this.name));
        sb.append(' ');
        sb.append(this.escape(this.cache));
        sb.append(' ');
        sb.append(this.type);
        sb.append(this.getAccessAsString());
        sb.append(' ');
        sb.append(this.user);
        sb.append(' ');
        sb.append(this.group);
        sb.append(' ');
        sb.append(Long.toString(this.size));
        sb.append(' ');
        sb.append('\"');
        sb.append(this.timestamp);
        sb.append('\"');
        if (this.link != null && this.link.length() > 0) {
            sb.append(' ');
            sb.append(this.link);
        }
        return sb.toString();
    }

    public boolean isValid() {
        return true;
    }

    private String escape(String text) {
        if (text.indexOf(32) < 0 && text.indexOf(92) < 0) {
            return text;
        }
        StringBuilder result = new StringBuilder();
        block4: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case ' ': {
                    result.append("\\ ");
                    continue block4;
                }
                case '\\': {
                    result.append("\\\\");
                    continue block4;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }
}

