/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.registration;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.tomcat5.TomcatFactory;
import org.netbeans.modules.tomcat5.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class AutomaticRegistration {
    private static final Logger LOGGER = Logger.getLogger(AutomaticRegistration.class.getName());

    public static void main(String[] args) {
        if (args.length <= 0) {
            AutomaticRegistration.printHelpAndExit();
        }
        if ("--add".equals(args[0])) {
            if (args.length < 3) {
                AutomaticRegistration.printHelpAndExit();
            }
            int status = AutomaticRegistration.registerTomcatInstance(args[1], args[2]);
            System.exit(status);
        } else if ("--remove".equals(args[0])) {
            if (args.length < 3) {
                AutomaticRegistration.printHelpAndExit();
            }
            int status = AutomaticRegistration.unregisterTomcatInstance(args[1], args[2]);
            System.exit(status);
        } else if ("--list".equals(args[0])) {
            if (args.length < 2) {
                AutomaticRegistration.printHelpAndExit();
            }
            AutomaticRegistration.list(args[1]);
        } else {
            AutomaticRegistration.printHelpAndExit();
        }
    }

    private static void printHelpAndExit() {
        System.out.println("Available actions:");
        System.out.println("\t--add <clusterDir> <catalinaHome>");
        System.out.println("\t--remove <clusterDir> <catalinaHome>");
        System.out.println("\t--list <clusterDir>");
        System.exit(-1);
    }

    private static int registerTomcatInstance(String clusterDirValue, String catalinaHomeValue) {
        StringBuilder urlTmp;
        String version;
        System.setProperty("netbeans.user", clusterDirValue);
        FileObject serverInstanceDir = FileUtil.getConfigFile((String)"J2EE/InstalledServers");
        if (serverInstanceDir == null) {
            LOGGER.log(Level.INFO, "Cannot register the default Tomcat server. The config/J2EE/InstalledServers folder cannot be created.");
            return 2;
        }
        File catalinaHome = new File(catalinaHomeValue);
        if (!catalinaHome.exists()) {
            LOGGER.log(Level.INFO, "Cannot register the default Tomcat server. The Catalina Home directory " + catalinaHomeValue + " does not exist.");
            return 3;
        }
        try {
            version = TomcatFactory.getTomcatVersion(catalinaHome);
        }
        catch (IllegalStateException e) {
            LOGGER.log(Level.INFO, "Cannot register the default Tomcat server.  Cannot recognize the Tomcat version.");
            LOGGER.log(Level.INFO, null, e);
            return 4;
        }
        if (version.startsWith("5.0.")) {
            urlTmp = new StringBuilder("tomcat:");
        } else if (version.startsWith("5.5.")) {
            urlTmp = new StringBuilder("tomcat55:");
        } else if (version.startsWith("6.")) {
            urlTmp = new StringBuilder("tomcat60:");
        } else if (version.startsWith("7.")) {
            urlTmp = new StringBuilder("tomcat70:");
        } else {
            LOGGER.log(Level.INFO, "Cannot register the default Tomcat server.  The version " + version + " is not supported.");
            return 5;
        }
        urlTmp.append("home=");
        urlTmp.append(catalinaHomeValue);
        urlTmp.append(":base=");
        urlTmp.append("apache-tomcat-");
        urlTmp.append(version);
        urlTmp.append("_base");
        String url = urlTmp.toString();
        for (FileObject fo : serverInstanceDir.getChildren()) {
            if (!url.equals(fo.getAttribute("url"))) continue;
            return 0;
        }
        String displayName = AutomaticRegistration.generateUniqueDisplayName(serverInstanceDir, version);
        boolean ok = AutomaticRegistration.registerServerInstanceFO(serverInstanceDir, url, displayName);
        if (ok) {
            return 0;
        }
        return 6;
    }

    private static int unregisterTomcatInstance(String clusterDirValue, String catalinaHomeValue) {
        System.setProperty("netbeans.user", clusterDirValue);
        FileObject serverInstanceDir = FileUtil.getConfigFile((String)"J2EE/InstalledServers");
        if (serverInstanceDir == null) {
            LOGGER.log(Level.INFO, "The config/J2EE/InstalledServers folder does not exist.");
            return 2;
        }
        Pattern pattern = Pattern.compile("^(" + Pattern.quote("tomcat:") + "|" + Pattern.quote("tomcat55:") + "|" + Pattern.quote("tomcat60:") + "|" + Pattern.quote("tomcat70:") + ")" + Pattern.quote("home=") + Pattern.quote(catalinaHomeValue) + "(" + Pattern.quote(":base=") + ".+)?$");
        try {
            for (FileObject f : serverInstanceDir.getChildren()) {
                String url = f.getAttribute("url").toString();
                if (url == null || !pattern.matcher(url).matches()) continue;
                f.delete();
                return 0;
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "Cannot unregister the default Tomcat server.");
            LOGGER.log(Level.INFO, null, ex);
            return 6;
        }
        return 0;
    }

    private static int list(String clusterDirValue) {
        System.setProperty("netbeans.user", clusterDirValue);
        FileObject serverInstanceDir = FileUtil.getConfigFile((String)"J2EE/InstalledServers");
        if (serverInstanceDir == null) {
            LOGGER.log(Level.INFO, "The config/J2EE/InstalledServers folder does not exist.");
            return 2;
        }
        Pattern pattern = Pattern.compile("^(" + Pattern.quote("tomcat:") + "|" + Pattern.quote("tomcat55:") + "|" + Pattern.quote("tomcat60:") + "|" + Pattern.quote("tomcat70:") + ")" + Pattern.quote("home=") + "(.+)$");
        for (FileObject f : serverInstanceDir.getChildren()) {
            Matcher matcher;
            String url = f.getAttribute("url").toString();
            if (url == null || !(matcher = pattern.matcher(url)).matches()) continue;
            String loc = matcher.group(2);
            int base = loc.indexOf(":base=");
            System.out.println(loc.substring(0, base));
        }
        return 0;
    }

    private static String generateUniqueDisplayName(FileObject serverInstanceDir, String version) {
        String displayName = NbBundle.getMessage(TomcatFactory.class, (String)"LBL_ApacheTomcat", (Object)version);
        boolean unique = true;
        int i = 1;
        while (true) {
            for (FileObject fo : serverInstanceDir.getChildren()) {
                if (!displayName.equals(fo.getAttribute("displayName"))) continue;
                unique = false;
                break;
            }
            if (unique) break;
            displayName = NbBundle.getMessage(TomcatFactory.class, (String)"LBL_ApacheTomcatAlt", (Object)version, (Object)i++);
            unique = true;
        }
        return displayName;
    }

    private static boolean registerServerInstanceFO(FileObject serverInstanceDir, String url, String displayName) {
        String name = FileUtil.findFreeFileName((FileObject)serverInstanceDir, (String)"tomcat_autoregistered_instance", null);
        try {
            FileObject instanceFO = serverInstanceDir.createData(name);
            instanceFO.setAttribute("url", (Object)url);
            instanceFO.setAttribute("username", (Object)"ide");
            String password = Utils.generatePassword(8);
            instanceFO.setAttribute("password", (Object)password);
            instanceFO.setAttribute("displayName", (Object)displayName);
            instanceFO.setAttribute("httpportnumber", (Object)"8084");
            instanceFO.setAttribute("admin_port", (Object)"8025");
            instanceFO.setAttribute("monitor_enabled", (Object)"true");
            instanceFO.setAttribute("is_it_bundled_tomcat", (Object)"true");
            instanceFO.setAttribute("autoregistered", (Object)"true");
            return true;
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Cannot register the default Tomcat server.");
            LOGGER.log(Level.INFO, null, e);
            return false;
        }
    }
}

