/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.wizard;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.tabview.Tab;
import org.primefaces.component.wizard.Wizard;
import org.primefaces.context.RequestContext;
import org.primefaces.event.FlowEvent;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class WizardRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext fc, UIComponent component) throws IOException {
        Wizard wizard = (Wizard)component;
        if (wizard.isWizardRequest(fc)) {
            Map params = fc.getExternalContext().getRequestParameterMap();
            String stepToDisplay = null;
            String clientId = wizard.getClientId(fc);
            String currentStep = wizard.getStep();
            String stepToGo = (String)params.get(clientId + "_stepToGo");
            if (fc.isValidationFailed()) {
                stepToDisplay = currentStep;
            } else if (wizard.getFlowListener() != null) {
                FlowEvent flowEvent = new FlowEvent((UIComponent)wizard, currentStep, stepToGo);
                Object outcome = wizard.getFlowListener().invoke(fc.getELContext(), new Object[]{flowEvent});
                stepToDisplay = (String)outcome;
            } else {
                stepToDisplay = stepToGo;
            }
            wizard.setStep(stepToDisplay);
            UIComponent tabToDisplay = null;
            for (UIComponent child : wizard.getChildren()) {
                if (!child.getId().equals(stepToDisplay)) continue;
                tabToDisplay = child;
            }
            tabToDisplay.encodeAll(fc);
            RequestContext.getCurrentInstance().addCallbackParam("currentStep", wizard.getStep());
        } else {
            this.encodeMarkup(fc, wizard);
            this.encodeScript(fc, wizard);
        }
    }

    protected void encodeScript(FacesContext facesContext, Wizard wizard) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = wizard.getClientId(facesContext);
        UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)wizard);
        if (form == null) {
            throw new FacesException("Wizard : \"" + clientId + "\" must be inside a form element");
        }
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(wizard.resolveWidgetVar() + " = new PrimeFaces.widget.Wizard('" + clientId + "',{");
        writer.write("formId:'" + form.getClientId(facesContext) + "'");
        writer.write(",url:'" + this.getActionURL(facesContext) + "'");
        writer.write(",showStepStatus:" + wizard.isShowStepStatus());
        writer.write(",showNavBar:" + wizard.isShowNavBar());
        if (wizard.getOnback() != null) {
            writer.write(",onback:function(){" + wizard.getOnback() + "}");
        }
        if (wizard.getOnnext() != null) {
            writer.write(",onnext:function(){" + wizard.getOnnext() + "}");
        }
        writer.write(",steps:[");
        boolean firstStep = true;
        String defaultStep = null;
        for (UIComponent child : wizard.getChildren()) {
            if (!(child instanceof Tab) || !child.isRendered()) continue;
            Tab tab = (Tab)child;
            if (defaultStep == null) {
                defaultStep = tab.getId();
            }
            if (!firstStep) {
                writer.write(",");
            } else {
                firstStep = false;
            }
            writer.write("'" + tab.getId() + "'");
        }
        writer.write("]");
        if (wizard.getStep() == null) {
            wizard.setStep(defaultStep);
        }
        writer.write(",initialStep:'" + wizard.getStep() + "'");
        if (wizard.isEffect()) {
            writer.write(",effect:true");
            writer.write(",effectSpeed:'" + wizard.getEffectSpeed() + "'");
        }
        writer.write("});");
        writer.endElement("script");
    }

    protected void encodeMarkup(FacesContext facesContext, Wizard wizard) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = wizard.getClientId(facesContext);
        String styleClass = wizard.getStyleClass() == null ? "ui-wizard ui-widget" : "ui-wizard ui-widget " + wizard.getStyleClass();
        writer.startElement("div", (UIComponent)wizard);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (wizard.getStyle() != null) {
            writer.writeAttribute("style", (Object)wizard.getStyle(), "style");
        }
        if (wizard.isShowStepStatus()) {
            this.encodeStepStatus(facesContext, wizard);
        }
        this.encodeContent(facesContext, wizard);
        if (wizard.isShowNavBar()) {
            this.encodeNavigators(facesContext, wizard);
        }
        writer.endElement("div");
    }

    protected void encodeCurrentStep(FacesContext facesContext, Wizard wizard) throws IOException {
        for (UIComponent child : wizard.getChildren()) {
            if (!(child instanceof Tab) || !child.isRendered()) continue;
            Tab tab = (Tab)child;
            if (wizard.getStep() != null && !tab.getId().equals(wizard.getStep())) continue;
            tab.encodeAll(facesContext);
            break;
        }
    }

    protected void encodeNavigators(FacesContext facesContext, Wizard wizard) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = wizard.getClientId(facesContext);
        String widgetVar = wizard.resolveWidgetVar();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-wizard-navbar ui-helper-clearfix", null);
        this.encodeNavigator(facesContext, wizard, clientId + "_back", widgetVar + ".back()", wizard.getBackLabel(), "ui-wizard-nav-back");
        this.encodeNavigator(facesContext, wizard, clientId + "_next", widgetVar + ".next()", wizard.getNextLabel(), "ui-wizard-nav-next");
        writer.endElement("div");
    }

    protected void encodeContent(FacesContext facesContext, Wizard wizard) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = wizard.getClientId(facesContext);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_content"), "id");
        writer.writeAttribute("class", (Object)"ui-wizard-content", null);
        this.encodeCurrentStep(facesContext, wizard);
        writer.endElement("div");
    }

    protected void encodeStepStatus(FacesContext context, Wizard wizard) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String currentStep = wizard.getStep();
        boolean currentFound = false;
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-wizard-step-titles ui-helper-reset ui-helper-clearfix", null);
        for (UIComponent child : wizard.getChildren()) {
            if (!(child instanceof Tab) || !child.isRendered()) continue;
            Tab tab = (Tab)child;
            String styleClass = "ui-wizard-step-title ui-state-default";
            if (!currentFound && (currentStep == null || tab.getId().equals(currentStep))) {
                styleClass = styleClass + " ui-state-hover";
                currentFound = true;
            }
            styleClass = styleClass + " ui-corner-all";
            writer.startElement("li", null);
            writer.writeAttribute("class", (Object)styleClass, null);
            writer.write(tab.getTitle());
            writer.endElement("li");
        }
        writer.endElement("ul");
    }

    protected void encodeNavigator(FacesContext facesContext, Wizard wizard, String id, String onclick, String label, String styleClass) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("button", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("onclick", (Object)onclick, null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.write(label);
        writer.endElement("button");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

