/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tree;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.tree.Tree;
import org.primefaces.component.tree.UITreeNode;
import org.primefaces.event.NodeCollapseEvent;
import org.primefaces.event.NodeExpandEvent;
import org.primefaces.event.NodeSelectEvent;
import org.primefaces.model.TreeExplorer;
import org.primefaces.model.TreeExplorerImpl;
import org.primefaces.model.TreeModel;
import org.primefaces.model.TreeNode;
import org.primefaces.model.TreeNodeEvent;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class TreeRenderer
extends CoreRenderer {
    private TreeExplorer treeExplorer = new TreeExplorerImpl();

    public void decode(FacesContext facesContext, UIComponent component) {
        Tree tree = (Tree)component;
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        String clientId = tree.getClientId(facesContext);
        String rowKeyParam = clientId + "_rowKey";
        String actionParam = clientId + "_action";
        String selectionParam = clientId + "_selection";
        if (params.containsKey(clientId) && params.containsKey(rowKeyParam) && params.containsKey(actionParam)) {
            String rowKey = (String)params.get(rowKeyParam);
            String event = (String)params.get(actionParam);
            TreeNode root = (TreeNode)tree.getValue();
            TreeNode currentNode = this.treeExplorer.findTreeNode(rowKey, new TreeModel(root));
            switch (TreeNodeEvent.valueOf(event)) {
                case SELECT: {
                    tree.queueEvent(new NodeSelectEvent((UIComponent)tree, currentNode));
                    break;
                }
                case EXPAND: {
                    currentNode.setExpanded(true);
                    tree.queueEvent(new NodeExpandEvent((UIComponent)tree, currentNode));
                    break;
                }
                case COLLAPSE: {
                    currentNode.setExpanded(false);
                    tree.queueEvent(new NodeCollapseEvent((UIComponent)tree, currentNode));
                }
            }
        }
        if (params.containsKey(selectionParam)) {
            String selectedNodesValue = (String)params.get(selectionParam);
            boolean isSingle = tree.getSelectionMode().equalsIgnoreCase("single");
            if (selectedNodesValue.equals("")) {
                if (isSingle) {
                    tree.setSelection(null);
                } else {
                    tree.setSelection(new TreeNode[0]);
                }
            } else {
                String[] selectedRowKeys = selectedNodesValue.split(",");
                TreeModel model = new TreeModel((TreeNode)tree.getValue());
                if (isSingle) {
                    TreeNode selectedNode = this.treeExplorer.findTreeNode(selectedRowKeys[0], model);
                    tree.setSelection(selectedNode);
                } else {
                    TreeNode[] selectedNodes = new TreeNode[selectedRowKeys.length];
                    for (int i = 0; i < selectedRowKeys.length; ++i) {
                        selectedNodes[i] = this.treeExplorer.findTreeNode(selectedRowKeys[i], model);
                        model.setRowIndex(-1);
                    }
                    tree.setSelection(selectedNodes);
                }
            }
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Tree tree = (Tree)component;
        if (tree.isNodeLoadRequest(context)) {
            this.encodeDynamicNodes(context, tree);
        } else {
            this.encodeMarkup(context, tree);
            this.encodeScript(context, tree);
        }
    }

    public void encodeDynamicNodes(FacesContext facesContext, Tree tree) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        String clientId = tree.getClientId(facesContext);
        TreeNode root = (TreeNode)tree.getValue();
        String rowKey = (String)params.get(clientId + "_rowKey");
        TreeNode currentNode = this.treeExplorer.findTreeNode(rowKey, new TreeModel(root));
        int rowIndex = 0;
        writer.write("{\"nodes\":[");
        Iterator<TreeNode> iterator = currentNode.getChildren().iterator();
        while (iterator.hasNext()) {
            TreeNode child = iterator.next();
            UITreeNode uiTreeNode = tree.getUITreeNodeByType(child.getType());
            facesContext.getExternalContext().getRequestMap().put(tree.getVar(), child.getData());
            writer.write("{");
            writer.write("\"html\":\"");
            this.renderChildren(facesContext, (UIComponent)uiTreeNode);
            writer.write("\"");
            writer.write(",\"rowKey\":\"" + rowKey + "." + rowIndex + "\"");
            writer.write(",\"isLeaf\":" + child.isLeaf());
            if (uiTreeNode.getStyleClass() != null) {
                writer.write(",\"contentStyle\":\"" + uiTreeNode.getStyleClass() + "\"");
            }
            writer.write("}");
            ++rowIndex;
            facesContext.getExternalContext().getRequestMap().remove(tree.getVar());
            if (!iterator.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]}");
    }

    protected void encodeScript(FacesContext facesContext, Tree tree) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = tree.getClientId(facesContext);
        String formClientId = null;
        TreeNode root = (TreeNode)tree.getValue();
        String widgetVar = tree.resolveWidgetVar();
        UIComponent parentForm = ComponentUtils.findParentForm(facesContext, (UIComponent)tree);
        if (parentForm == null) {
            throw new FacesException("Tree:" + clientId + " needs to be enclosed in a form");
        }
        formClientId = parentForm.getClientId(facesContext);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(widgetVar + " = new PrimeFaces.widget.TreeView('" + clientId + "', [");
        if (root != null) {
            int rowIndex = 0;
            Iterator<TreeNode> iterator = root.getChildren().iterator();
            while (iterator.hasNext()) {
                this.encodeTreeNode(facesContext, tree, iterator.next(), String.valueOf(rowIndex));
                ++rowIndex;
                if (!iterator.hasNext()) continue;
                writer.write(",");
            }
        }
        writer.write("],{");
        writer.write("dynamic:" + tree.isDynamic());
        writer.write(",url:'" + this.getActionURL(facesContext) + "'");
        writer.write(",formId:'" + formClientId + "'");
        writer.write(",cache:" + tree.isCache());
        if (tree.getSelectionMode() != null) {
            writer.write(",selectionMode:'" + tree.getSelectionMode() + "'");
            writer.write(",propagateHighlightDown:" + tree.isPropagateSelectionDown());
            writer.write(",propagateHighlightUp:" + tree.isPropagateSelectionUp());
            if (tree.getUpdate() != null) {
                writer.write(",update:'" + ComponentUtils.findClientIds(facesContext, (UIComponent)tree, tree.getUpdate()) + "'");
            }
            if (tree.getOnselectStart() != null) {
                writer.write(",onselectStart:function(){" + tree.getOnselectStart() + ";}");
            }
            if (tree.getOnselectComplete() != null) {
                writer.write(",onselectComplete:function(xhr,status,args){" + tree.getOnselectComplete() + ";}");
            }
        }
        if (tree.getNodeSelectListener() != null) {
            writer.write(",hasSelectListener:true");
        }
        if (tree.getNodeExpandListener() != null) {
            writer.write(",hasExpandListener:true");
        }
        if (tree.getNodeCollapseListener() != null) {
            writer.write(",hasCollapseListener:true");
        }
        if (tree.getOnNodeClick() != null) {
            writer.write(",onNodeClick:" + tree.getOnNodeClick());
        }
        writer.write("});\n");
        if (tree.getExpandAnim() != null) {
            writer.write(widgetVar + ".setExpandAnim(YAHOO.widget.TVAnim." + tree.getExpandAnim() + ");\n");
        }
        if (tree.getCollapseAnim() != null) {
            writer.write(widgetVar + ".setCollapseAnim(YAHOO.widget.TVAnim." + tree.getCollapseAnim() + ");\n");
        }
        writer.write(widgetVar + ".render();\n");
        writer.endElement("script");
    }

    protected void encodeTreeNode(FacesContext facesContext, Tree tree, TreeNode node, String rowKey) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        int rowIndex = 0;
        UITreeNode uiTreeNode = tree.getUITreeNodeByType(node.getType());
        if (!this.isPostBack() && tree.isExpanded()) {
            node.setExpanded(true);
        }
        facesContext.getExternalContext().getRequestMap().put(tree.getVar(), node.getData());
        writer.write("{html:'");
        this.renderChildren(facesContext, (UIComponent)uiTreeNode);
        facesContext.getExternalContext().getRequestMap().remove(tree.getVar());
        writer.write("',type:'html'");
        writer.write(",rowKey:'" + rowKey + "'");
        if (node.isLeaf()) {
            writer.write(",isLeaf:true");
        }
        if (uiTreeNode.getStyleClass() != null) {
            writer.write(",contentStyle:'" + uiTreeNode.getStyleClass() + "'");
        }
        if (node.isSelected()) {
            writer.write(",selected:true");
        }
        if (node.isExpanded()) {
            writer.write(",expanded:true");
            if (tree.isDynamic()) {
                writer.write(",dynamicLoadComplete:true");
            }
        }
        if (node.isExpanded() || !tree.isDynamic()) {
            writer.write(",children:[");
            Iterator<TreeNode> iterator = node.getChildren().iterator();
            while (iterator.hasNext()) {
                String childRowKey = rowKey + "." + rowIndex;
                this.encodeTreeNode(facesContext, tree, iterator.next(), childRowKey);
                ++rowIndex;
                if (!iterator.hasNext()) continue;
                writer.write(",");
            }
            writer.write("]");
        }
        writer.write("}");
    }

    protected void encodeMarkup(FacesContext facesContext, Tree tree) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = tree.getClientId(facesContext);
        boolean selectionEnabled = tree.getSelectionMode() != null;
        writer.startElement("div", (UIComponent)tree);
        writer.writeAttribute("id", (Object)clientId, null);
        if (tree.getStyle() != null) {
            writer.writeAttribute("style", (Object)tree.getStyle(), null);
        }
        if (tree.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)tree.getStyleClass(), null);
        }
        writer.startElement("div", (UIComponent)tree);
        writer.writeAttribute("id", (Object)(clientId + "_container"), null);
        if (selectionEnabled) {
            String selectionClass = tree.getSelectionMode().equalsIgnoreCase("checkbox") ? "ygtv-checkbox" : "ygtv-highlight";
            writer.writeAttribute("class", (Object)selectionClass, null);
        }
        writer.endElement("div");
        if (selectionEnabled) {
            writer.startElement("input", null);
            writer.writeAttribute("id", (Object)(clientId + "_selection"), null);
            writer.writeAttribute("name", (Object)(clientId + "_selection"), null);
            writer.writeAttribute("type", (Object)"hidden", null);
            writer.endElement("input");
        }
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

