/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.css.editor.model.CssRuleContent;
import org.netbeans.modules.css.visual.model.BorderModel;
import org.netbeans.modules.css.visual.model.PropertyData;
import org.netbeans.modules.css.visual.ui.BorderWidthField;
import org.netbeans.modules.css.visual.ui.ColorSelectionField;
import org.netbeans.modules.css.visual.ui.FlexibleGridLayout;
import org.netbeans.modules.css.visual.ui.StyleEditor;
import org.openide.util.NbBundle;

public class BorderStyleEditor
extends StyleEditor {
    BorderDataTable borderDataTable;
    private JPanel borderPanel;

    public BorderStyleEditor() {
        super("borderStyleEditor", NbBundle.getMessage(BorderStyleEditor.class, (String)"BORDER_EDITOR_DISPNAME"));
    }

    @Override
    protected void lazyInitializePanel() {
        this.borderDataTable = new BorderDataTable();
        this.initComponents();
        this.borderPanel.add((Component)this.borderDataTable, "Center");
    }

    @Override
    protected void setCssPropertyValues(CssRuleContent cssStyleData) {
        this.removeCssPropertyChangeListener();
        this.borderDataTable.setCssPropertyValues(cssStyleData);
        this.setCssPropertyChangeListener(cssStyleData);
    }

    private void initComponents() {
        this.borderPanel = new JPanel();
        this.setLayout(new BorderLayout(0, 5));
        this.borderPanel.setLayout(new BorderLayout());
        this.add((Component)this.borderPanel, "North");
    }

    class BorderDataTable
    extends JPanel {
        CssRuleContent cssStyleData;
        BorderModel borderModel = new BorderModel();
        JComboBox allStyleCombo;
        BorderWidthField allWidthField;
        ColorSelectionField allColorField;
        JComboBox topStyleCombo;
        BorderWidthField topWidthField;
        ColorSelectionField topColorField;
        JComboBox bottomStyleCombo;
        BorderWidthField bottomWidthField;
        ColorSelectionField bottomColorField;
        JComboBox leftStyleCombo;
        BorderWidthField leftWidthField;
        ColorSelectionField leftColorField;
        JComboBox rightStyleCombo;
        BorderWidthField rightWidthField;
        ColorSelectionField rightColorField;

        public BorderDataTable() {
            this.setLayout(new FlexibleGridLayout(6, 4, 5, 5));
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int aheight = fontMetrics.getHeight() + 10 > 25 ? fontMetrics.getHeight() + 10 : 25;
            this.initCells(aheight);
            this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"BORDER_STYLE_TABLE_ACCESS_NAME"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"BORDER_STYLE_TABLE_ACCESS_DESC"));
        }

        protected void setCssPropertyValues(CssRuleContent cssStyleData) {
            BorderStyleEditor.this.removeCssPropertyChangeListener();
            String topStyle = cssStyleData.getProperty("border-top-style");
            String bottomStyle = cssStyleData.getProperty("border-bottom-style");
            String leftStyle = cssStyleData.getProperty("border-left-style");
            String rightStyle = cssStyleData.getProperty("border-right-style");
            if (topStyle != null && bottomStyle != null && leftStyle != null && rightStyle != null && topStyle.equals(bottomStyle) && topStyle.equals(leftStyle) && topStyle.equals(rightStyle)) {
                this.allStyleCombo.setSelectedItem(topStyle);
            } else {
                this.allStyleCombo.setSelectedIndex(0);
                if (topStyle != null) {
                    this.topStyleCombo.setSelectedItem(topStyle);
                } else {
                    this.topStyleCombo.setSelectedIndex(0);
                }
                if (bottomStyle != null) {
                    this.bottomStyleCombo.setSelectedItem(bottomStyle);
                } else {
                    this.bottomStyleCombo.setSelectedIndex(0);
                }
                if (leftStyle != null) {
                    this.leftStyleCombo.setSelectedItem(leftStyle);
                } else {
                    this.leftStyleCombo.setSelectedIndex(0);
                }
                if (rightStyle != null) {
                    this.rightStyleCombo.setSelectedItem(rightStyle);
                } else {
                    this.rightStyleCombo.setSelectedIndex(0);
                }
            }
            String topWidth = cssStyleData.getProperty("border-top-width");
            String bottomWidth = cssStyleData.getProperty("border-bottom-width");
            String leftWidth = cssStyleData.getProperty("border-left-width");
            String rightWidth = cssStyleData.getProperty("border-right-width");
            if (topWidth != null && bottomWidth != null && leftWidth != null && rightWidth != null && topWidth.equals(bottomWidth) && topWidth.equals(leftWidth) && topWidth.equals(rightWidth)) {
                this.allWidthField.setWidthString(topWidth);
            } else {
                this.allWidthField.setWidthString(null);
                this.topWidthField.setWidthString(topWidth);
                this.bottomWidthField.setWidthString(bottomWidth);
                this.leftWidthField.setWidthString(leftWidth);
                this.rightWidthField.setWidthString(rightWidth);
            }
            String topColor = cssStyleData.getProperty("border-top-color");
            String bottomColor = cssStyleData.getProperty("border-bottom-color");
            String leftColor = cssStyleData.getProperty("border-left-color");
            String rightColor = cssStyleData.getProperty("border-right-color");
            if (topColor != null && bottomColor != null && leftColor != null && rightColor != null && topColor.equals(bottomColor) && topColor.equals(leftColor) && topColor.equals(rightColor)) {
                this.allColorField.setColorString(topColor);
            } else {
                this.allColorField.setColorString(null);
                this.topColorField.setColorString(topColor);
                this.bottomColorField.setColorString(bottomColor);
                this.leftColorField.setColorString(leftColor);
                this.rightColorField.setColorString(rightColor);
            }
            BorderStyleEditor.this.borderDataTable.validate();
            BorderStyleEditor.this.borderDataTable.repaint();
            BorderStyleEditor.this.setCssPropertyChangeListener(cssStyleData);
        }

        public void initCells(int aheight) {
            JLabel colHeader1 = new JLabel("");
            JPanel colHeader2 = new JPanel();
            colHeader2.add(new JLabel(NbBundle.getMessage(BorderDataTable.class, (String)"BORDER_STYLE")));
            JPanel colHeader3 = new JPanel();
            colHeader3.add(new JLabel(NbBundle.getMessage(BorderDataTable.class, (String)"BORDER_WIDTH")));
            JPanel colHeader6 = new JPanel();
            colHeader6.add(new JLabel(NbBundle.getMessage(BorderDataTable.class, (String)"BORDER_COLOR")));
            JPanel rowHeader1 = new JPanel();
            rowHeader1.add(new JLabel(NbBundle.getMessage(BorderDataTable.class, (String)"BORDER_ALL")));
            JPanel rowHeader2 = new JPanel();
            rowHeader2.add(new JLabel(NbBundle.getMessage(BorderDataTable.class, (String)"BORDER_TOP")));
            JPanel rowHeader3 = new JPanel();
            rowHeader3.add(new JLabel(NbBundle.getMessage(BorderDataTable.class, (String)"BORDER_BOTTOM")));
            JPanel rowHeader4 = new JPanel();
            rowHeader4.add(new JLabel(NbBundle.getMessage(BorderDataTable.class, (String)"BORDER_LEFT")));
            JPanel rowHeader5 = new JPanel();
            rowHeader5.add(new JLabel(NbBundle.getMessage(BorderDataTable.class, (String)"BORDER_RIGHT")));
            this.allStyleCombo = new JComboBox();
            this.allStyleCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"ALL_SIDE_BORDER_STYLE_ACCESS_NAME"));
            this.allStyleCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"ALL_SIDE_BORDER_STYLE_ACCESS_DESC"));
            this.allStyleCombo.setModel(this.borderModel.getStyleList());
            this.allStyleCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    BorderStyleEditor.this.startAggregatedEventsSession();
                    BorderDataTable.this.topStyleCombo.setSelectedIndex(BorderDataTable.this.allStyleCombo.getSelectedIndex());
                    BorderDataTable.this.bottomStyleCombo.setSelectedIndex(BorderDataTable.this.allStyleCombo.getSelectedIndex());
                    BorderDataTable.this.leftStyleCombo.setSelectedIndex(BorderDataTable.this.allStyleCombo.getSelectedIndex());
                    BorderDataTable.this.rightStyleCombo.setSelectedIndex(BorderDataTable.this.allStyleCombo.getSelectedIndex());
                    BorderStyleEditor.this.closeAggregatedEventsSession();
                }
            });
            this.allWidthField = new BorderWidthField();
            this.allWidthField.setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"ALL_SIDE_BORDER_WIDTH_ACCESS_NAME"), NbBundle.getMessage(BorderDataTable.class, (String)"ALL_SIDE_BORDER_WIDTH_UNIT_ACCESS_NAME"));
            this.allWidthField.setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"ALL_SIDE_BORDER_WIDTH_ACCESS_DESC"), NbBundle.getMessage(BorderDataTable.class, (String)"ALL_SIDE_BORDER_WIDTH_UNIT_ACCESS_DESC"));
            this.allWidthField.addPropertyChangeListener("border-width", new PropertyChangeListenerImpl(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    BorderStyleEditor.this.startAggregatedEventsSession();
                    BorderDataTable.this.topWidthField.setWidthString(evt.getNewValue().toString());
                    BorderDataTable.this.bottomWidthField.setWidthString(evt.getNewValue().toString());
                    BorderDataTable.this.leftWidthField.setWidthString(evt.getNewValue().toString());
                    BorderDataTable.this.rightWidthField.setWidthString(evt.getNewValue().toString());
                    BorderStyleEditor.this.closeAggregatedEventsSession();
                }
            });
            this.allColorField = new ColorSelectionField();
            this.allColorField.addPropertyChangeListener("color", new PropertyChangeListenerImpl(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    BorderStyleEditor.this.startAggregatedEventsSession();
                    BorderDataTable.this.topColorField.setColorString(BorderDataTable.this.allColorField.getColorString());
                    BorderDataTable.this.bottomColorField.setColorString(BorderDataTable.this.allColorField.getColorString());
                    BorderDataTable.this.leftColorField.setColorString(BorderDataTable.this.allColorField.getColorString());
                    BorderDataTable.this.rightColorField.setColorString(BorderDataTable.this.allColorField.getColorString());
                    BorderStyleEditor.this.closeAggregatedEventsSession();
                }
            });
            this.topStyleCombo = new JComboBox();
            this.topStyleCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"TOP_SIDE_BORDER_STYLE_ACCESS_NAME"));
            this.topStyleCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"TOP_SIDE_BORDER_STYLE_ACCESS_DESC"));
            this.topStyleCombo.setModel(this.borderModel.getStyleList());
            this.topStyleCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    if (evt.getStateChange() == 1) {
                        PropertyData pd = new PropertyData();
                        pd.setValue(evt.getItem().toString());
                        BorderStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("border-top-style", null, pd.toString());
                    }
                }
            });
            this.topWidthField = new BorderWidthField();
            this.topWidthField.setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"TOP_SIDE_BORDER_WIDTH_ACCESS_NAME"), NbBundle.getMessage(BorderDataTable.class, (String)"TOP_SIDE_BORDER_WIDTH_UNIT_ACCESS_NAME"));
            this.topWidthField.setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"TOP_SIDE_BORDER_WIDTH_ACCESS_DESC"), NbBundle.getMessage(BorderDataTable.class, (String)"TOP_SIDE_BORDER_WIDTH_UNIT_ACCESS_DESC"));
            this.topWidthField.addPropertyChangeListener("border-width", new PropertyChangeListenerImpl(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    BorderStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("border-top-width", null, evt.getNewValue().toString());
                }
            });
            this.topColorField = new ColorSelectionField();
            this.topColorField.addPropertyChangeListener("color", new PropertyChangeListenerImpl(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    BorderStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("border-top-color", null, evt.getNewValue().toString());
                }
            });
            this.bottomStyleCombo = new JComboBox();
            this.bottomStyleCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"BOTTOM_SIDE_BORDER_STYLE_ACCESS_NAME"));
            this.bottomStyleCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"BOTTOM_SIDE_BORDER_STYLE_ACCESS_DESC"));
            this.bottomStyleCombo.setModel(this.borderModel.getStyleList());
            this.bottomStyleCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    if (evt.getStateChange() == 1) {
                        PropertyData pd = new PropertyData();
                        pd.setValue(evt.getItem().toString());
                        BorderStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("border-bottom-style", null, pd.toString());
                    }
                }
            });
            this.bottomWidthField = new BorderWidthField();
            this.bottomWidthField.setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"BOTTOM_SIDE_BORDER_WIDTH_ACCESS_NAME"), NbBundle.getMessage(BorderDataTable.class, (String)"BOTTOM_SIDE_BORDER_WIDTH_UNIT_ACCESS_NAME"));
            this.bottomWidthField.setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"BOTTOM_SIDE_BORDER_WIDTH_ACCESS_DESC"), NbBundle.getMessage(BorderDataTable.class, (String)"BOTTOM_SIDE_BORDER_WIDTH_UNIT_ACCESS_DESC"));
            this.bottomWidthField.addPropertyChangeListener("border-width", new PropertyChangeListenerImpl(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    BorderStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("border-bottom-width", null, evt.getNewValue().toString());
                }
            });
            this.bottomColorField = new ColorSelectionField();
            this.bottomColorField.addPropertyChangeListener("color", new PropertyChangeListenerImpl(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    BorderStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("border-bottom-color", null, evt.getNewValue().toString());
                }
            });
            this.leftStyleCombo = new JComboBox<String>(new String[0]);
            this.leftStyleCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"LEFT_SIDE_BORDER_STYLE_ACCESS_NAME"));
            this.leftStyleCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"LEFT_SIDE_BORDER_STYLE_ACCESS_DESC"));
            this.leftStyleCombo.setModel(this.borderModel.getStyleList());
            this.leftStyleCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    if (evt.getStateChange() == 1) {
                        PropertyData pd = new PropertyData();
                        pd.setValue(evt.getItem().toString());
                        BorderStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("border-left-style", null, pd.toString());
                    }
                }
            });
            this.leftWidthField = new BorderWidthField();
            this.leftWidthField.setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"LEFT_SIDE_BORDER_WIDTH_ACCESS_NAME"), NbBundle.getMessage(BorderDataTable.class, (String)"LEFT_SIDE_BORDER_WIDTH_UNIT_ACCESS_NAME"));
            this.leftWidthField.setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"LEFT_SIDE_BORDER_WIDTH_ACCESS_DESC"), NbBundle.getMessage(BorderDataTable.class, (String)"LEFT_SIDE_BORDER_WIDTH_UNIT_ACCESS_DESC"));
            this.leftWidthField.addPropertyChangeListener("border-width", new PropertyChangeListenerImpl(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    BorderStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("border-left-width", null, evt.getNewValue().toString());
                }
            });
            this.leftColorField = new ColorSelectionField();
            this.leftColorField.addPropertyChangeListener("color", new PropertyChangeListenerImpl(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    BorderStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("border-left-color", null, evt.getNewValue().toString());
                }
            });
            this.rightStyleCombo = new JComboBox();
            this.rightStyleCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"RIGHT_SIDE_BORDER_STYLE_ACCESS_NAME"));
            this.rightStyleCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"RIGHT_SIDE_BORDER_STYLE_ACCESS_DESC"));
            this.rightStyleCombo.setModel(this.borderModel.getStyleList());
            this.rightStyleCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    if (evt.getStateChange() == 1) {
                        PropertyData pd = new PropertyData();
                        pd.setValue(evt.getItem().toString());
                        BorderStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("border-right-style", null, pd.toString());
                    }
                }
            });
            this.rightWidthField = new BorderWidthField();
            this.rightWidthField.setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"RIGHT_SIDE_BORDER_WIDTH_ACCESS_NAME"), NbBundle.getMessage(BorderDataTable.class, (String)"RIGHT_SIDE_BORDER_WIDTH_UNIT_ACCESS_NAME"));
            this.rightWidthField.setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"RIGHT_SIDE_BORDER_WIDTH_ACCESS_DESC"), NbBundle.getMessage(BorderDataTable.class, (String)"RIGHT_SIDE_BORDER_WIDTH_UNIT_ACCESS_DESC"));
            this.rightWidthField.addPropertyChangeListener("border-width", new PropertyChangeListenerImpl(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    BorderStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("border-right-width", null, evt.getNewValue().toString());
                }
            });
            this.rightColorField = new ColorSelectionField();
            this.rightColorField.addPropertyChangeListener("color", new PropertyChangeListenerImpl(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    BorderStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("border-right-color", null, evt.getNewValue().toString());
                }
            });
            this.add(colHeader1);
            this.add(colHeader2);
            this.add(colHeader3);
            this.add(colHeader6);
            this.add(rowHeader1);
            this.add(this.allStyleCombo);
            this.add(this.allWidthField);
            this.add(this.allColorField);
            this.add(rowHeader2);
            this.add(this.topStyleCombo);
            this.add(this.topWidthField);
            this.add(this.topColorField);
            this.add(rowHeader3);
            this.add(this.bottomStyleCombo);
            this.add(this.bottomWidthField);
            this.add(this.bottomColorField);
            this.add(rowHeader4);
            this.add(this.leftStyleCombo);
            this.add(this.leftWidthField);
            this.add(this.leftColorField);
            this.add(rowHeader5);
            this.add(this.rightStyleCombo);
            this.add(this.rightWidthField);
            this.add(this.rightColorField);
            int cnt = this.getComponentCount();
            int[] widths = new int[]{50, 75, 125, 125};
            for (int i = 0; i < cnt; ++i) {
                int awidth = widths[i % 4];
                this.getComponent(i).setPreferredSize(new Dimension(awidth, aheight));
                this.getComponent(i).setMinimumSize(new Dimension(awidth, aheight));
                this.getComponent(i).setMaximumSize(new Dimension(awidth, aheight));
            }
        }

        class PropertyChangeListenerImpl
        implements PropertyChangeListener {
            PropertyChangeListenerImpl() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
            }
        }
    }
}

