/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.spi.utils;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.dlight.libs.common.InvalidFileObjectSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public abstract class CndFileSystemProvider {
    private static final CndFileSystemProvider DEFAULT = new DefaultProvider();

    private static CndFileSystemProvider getDefault() {
        return DEFAULT;
    }

    public static File toFile(FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null && fileObject != null && !fileObject.isValid()) {
            file = new File(fileObject.getPath());
        }
        return file;
    }

    public static FileObject toFileObject(File file) {
        return CndFileSystemProvider.getDefault().toFileObjectImpl(file);
    }

    public static Boolean exists(CharSequence path) {
        return CndFileSystemProvider.getDefault().existsImpl(path);
    }

    public static Boolean canRead(CharSequence path) {
        return CndFileSystemProvider.getDefault().canReadImpl(path);
    }

    public static FileInfo[] getChildInfo(CharSequence path) {
        return CndFileSystemProvider.getDefault().getChildInfoImpl(path);
    }

    public static FileObject toFileObject(CharSequence absPath) {
        FileObject result = CndFileSystemProvider.getDefault().toFileObjectImpl(absPath);
        CndUtils.assertNotNull(result, "Null file object for " + absPath);
        return result;
    }

    public static FileObject urlToFileObject(CharSequence url) {
        return CndFileSystemProvider.getDefault().urlToFileObjectImpl(url);
    }

    public static CharSequence toUrl(FSPath fsPath) {
        return CndFileSystemProvider.getDefault().toUrlImpl(fsPath);
    }

    public static CharSequence toUrl(FileSystem fileSystem, CharSequence absPath) {
        return CndFileSystemProvider.getDefault().toUrlImpl(fileSystem, absPath);
    }

    public static CharSequence fileObjectToUrl(FileObject fileObject) {
        CharSequence result = CndFileSystemProvider.getDefault().fileObjectToUrlImpl(fileObject);
        CndUtils.assertNotNull(result, "Null URL for file object " + fileObject);
        return result;
    }

    public static CharSequence getCanonicalPath(FileSystem fileSystem, CharSequence absPath) throws IOException {
        CndUtils.assertAbsolutePathInConsole(((Object)absPath).toString());
        return CndFileSystemProvider.getDefault().getCanonicalPathImpl(fileSystem, absPath);
    }

    public static FileObject getCanonicalFileObject(FileObject fo) throws IOException {
        return CndFileSystemProvider.getDefault().getCanonicalFileObjectImpl(fo);
    }

    public static String getCanonicalPath(FileObject fo) throws IOException {
        return CndFileSystemProvider.getDefault().getCanonicalPathImpl(fo);
    }

    protected abstract Boolean existsImpl(CharSequence var1);

    protected abstract Boolean canReadImpl(CharSequence var1);

    protected abstract FileInfo[] getChildInfoImpl(CharSequence var1);

    protected abstract FileObject toFileObjectImpl(CharSequence var1);

    protected abstract CharSequence fileObjectToUrlImpl(FileObject var1);

    protected abstract CharSequence toUrlImpl(FSPath var1);

    protected abstract CharSequence toUrlImpl(FileSystem var1, CharSequence var2);

    protected abstract FileObject urlToFileObjectImpl(CharSequence var1);

    protected abstract FileObject toFileObjectImpl(File var1);

    protected abstract CharSequence getCanonicalPathImpl(FileSystem var1, CharSequence var2) throws IOException;

    protected abstract FileObject getCanonicalFileObjectImpl(FileObject var1) throws IOException;

    protected abstract String getCanonicalPathImpl(FileObject var1) throws IOException;

    private static class DefaultProvider
    extends CndFileSystemProvider {
        private CndFileSystemProvider[] cache;

        DefaultProvider() {
            Collection instances = Lookup.getDefault().lookupAll(CndFileSystemProvider.class);
            this.cache = instances.toArray(new CndFileSystemProvider[instances.size()]);
        }

        @Override
        public FileObject toFileObjectImpl(CharSequence absPath) {
            FileObject fo;
            for (CndFileSystemProvider provider : this.cache) {
                fo = provider.toFileObjectImpl(absPath);
                if (fo == null) continue;
                return fo;
            }
            File file = new File(FileUtil.normalizePath((String)((Object)absPath).toString()));
            fo = FileUtil.toFileObject((File)file);
            if (fo == null) {
                fo = InvalidFileObjectSupport.getInvalidFileObject((File)file);
            }
            return fo;
        }

        @Override
        protected FileObject toFileObjectImpl(File file) {
            FileObject fo;
            for (CndFileSystemProvider provider : this.cache) {
                fo = provider.toFileObjectImpl(file);
                if (fo == null) continue;
                return fo;
            }
            fo = FileUtil.toFileObject((File)file);
            if (fo == null) {
                fo = InvalidFileObjectSupport.getInvalidFileObject((File)file);
            }
            return fo;
        }

        @Override
        protected Boolean canReadImpl(CharSequence path) {
            for (CndFileSystemProvider provider : this.cache) {
                Boolean result = provider.canReadImpl(path);
                if (result == null) continue;
                return result;
            }
            return new File(((Object)path).toString()).canRead();
        }

        @Override
        protected Boolean existsImpl(CharSequence path) {
            for (CndFileSystemProvider provider : this.cache) {
                Boolean result = provider.existsImpl(path);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @Override
        protected FileInfo[] getChildInfoImpl(CharSequence path) {
            for (CndFileSystemProvider provider : this.cache) {
                FileInfo[] result = provider.getChildInfoImpl(path);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @Override
        protected FileObject urlToFileObjectImpl(CharSequence url) {
            for (CndFileSystemProvider provider : this.cache) {
                FileObject fo = provider.urlToFileObjectImpl(url);
                if (fo == null) continue;
                return fo;
            }
            File file = new File(FileUtil.normalizePath((String)((Object)url).toString()));
            return FileUtil.toFileObject((File)file);
        }

        @Override
        protected CharSequence fileObjectToUrlImpl(FileObject fileObject) {
            for (CndFileSystemProvider provider : this.cache) {
                CharSequence path = provider.fileObjectToUrlImpl(fileObject);
                if (path == null) continue;
                return path;
            }
            return fileObject.getPath();
        }

        @Override
        protected CharSequence toUrlImpl(FSPath fSPath) {
            for (CndFileSystemProvider provider : this.cache) {
                CharSequence url = provider.toUrlImpl(fSPath);
                if (url == null) continue;
                return url;
            }
            return fSPath.getPath();
        }

        @Override
        protected CharSequence toUrlImpl(FileSystem fileSystem, CharSequence absPath) {
            for (CndFileSystemProvider provider : this.cache) {
                CharSequence url = provider.toUrlImpl(fileSystem, absPath);
                if (url == null) continue;
                return url;
            }
            return absPath;
        }

        @Override
        protected CharSequence getCanonicalPathImpl(FileSystem fileSystem, CharSequence absPath) throws IOException {
            for (CndFileSystemProvider provider : this.cache) {
                CharSequence canonical = provider.getCanonicalPathImpl(fileSystem, absPath);
                if (canonical == null) continue;
                return canonical;
            }
            return absPath;
        }

        @Override
        protected FileObject getCanonicalFileObjectImpl(FileObject fo) throws IOException {
            for (CndFileSystemProvider provider : this.cache) {
                FileObject canonical = provider.getCanonicalFileObjectImpl(fo);
                if (canonical == null) continue;
                return canonical;
            }
            return fo;
        }

        @Override
        protected String getCanonicalPathImpl(FileObject fo) throws IOException {
            for (CndFileSystemProvider provider : this.cache) {
                String canonical = provider.getCanonicalPathImpl(fo);
                if (canonical == null) continue;
                return canonical;
            }
            return fo.getPath();
        }
    }

    public static class FileInfo {
        public final String absolutePath;
        public final boolean directory;

        public FileInfo(String absolutePath, boolean directory) {
            this.absolutePath = absolutePath;
            this.directory = directory;
        }

        public String toString() {
            return "FileInfo{absolutePath=" + this.absolutePath + "directory=" + this.directory + '}';
        }
    }
}

