/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.quicksearch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.netbeans.modules.jumpto.EntityComparator;
import org.netbeans.modules.jumpto.type.TypeComparator;
import org.netbeans.modules.jumpto.type.TypeProviderAccessor;
import org.netbeans.spi.jumpto.type.SearchType;
import org.netbeans.spi.jumpto.type.TypeDescriptor;
import org.netbeans.spi.jumpto.type.TypeProvider;
import org.openide.util.Lookup;

public class GoToTypeWorker
implements Runnable {
    private volatile boolean isCanceled = false;
    private final String text;
    private Logger LOGGER = Logger.getLogger(GoToTypeWorker.class.getName());
    private final long createTime;
    private List<? extends TypeDescriptor> types;

    public GoToTypeWorker(String text) {
        this.text = text;
        this.createTime = System.currentTimeMillis();
    }

    public List<? extends TypeDescriptor> getTypes() {
        return this.types == null ? Collections.emptyList() : this.types;
    }

    @Override
    public void run() {
        this.LOGGER.fine("Worker for " + this.text + " - started " + (System.currentTimeMillis() - this.createTime) + " ms.");
        this.types = this.getTypeNames(this.text);
        if (this.isCanceled) {
            this.LOGGER.fine("Worker for " + this.text + " exited after cancel " + (System.currentTimeMillis() - this.createTime) + " ms.");
            return;
        }
        if (this.isCanceled) {
            this.LOGGER.fine("Worker for " + this.text + " exited after cancel " + (System.currentTimeMillis() - this.createTime) + " ms.");
            return;
        }
    }

    public void cancel() {
        this.isCanceled = true;
    }

    private List<? extends TypeDescriptor> getTypeNames(String text) {
        ArrayList<TypeDescriptor> items = new ArrayList<TypeDescriptor>(128);
        ArrayList ccItems = new ArrayList(128);
        String[] message = new String[1];
        TypeProviderAccessor tpa = TypeProviderAccessor.DEFAULT;
        TypeProvider.Context context = tpa.createContext(null, text, SearchType.CASE_INSENSITIVE_PREFIX);
        TypeProvider.Result result = tpa.createResult(items, message);
        TypeProvider.Context ccContext = tpa.createContext(null, text, SearchType.CAMEL_CASE);
        TypeProvider.Result ccResult = tpa.createResult(ccItems, message);
        Collection providers = Lookup.getDefault().lookupAll(TypeProvider.class);
        try {
            this.computeTypeNames(providers, context, result);
            this.computeTypeNames(providers, ccContext, ccResult);
            if (this.isCanceled) {
                throw new IllegalStateException();
            }
        }
        catch (IllegalStateException ise) {
            return null;
        }
        TreeSet<TypeDescriptor> ts = new TreeSet<TypeDescriptor>(new TypeComparatorFO());
        ts.addAll(ccItems);
        ts.addAll(items);
        items.clear();
        items.addAll(ts);
        Collections.sort(items, new TypeComparator());
        return items;
    }

    private void computeTypeNames(Collection<TypeProvider> providers, TypeProvider.Context context, TypeProvider.Result result) throws IllegalStateException {
        for (TypeProvider provider : providers) {
            if (this.isCanceled) {
                throw new IllegalStateException();
            }
            provider.computeTypeNames(context, result);
        }
    }

    private class TypeComparatorFO
    extends EntityComparator<TypeDescriptor> {
        private TypeComparatorFO() {
        }

        @Override
        public int compare(TypeDescriptor t1, TypeDescriptor t2) {
            int cmpr = this.compare(t1.getTypeName(), t2.getTypeName());
            if (cmpr != 0) {
                return cmpr;
            }
            cmpr = this.compare(t1.getOuterName(), t2.getOuterName());
            if (cmpr != 0) {
                return cmpr;
            }
            if (t1.getFileObject() != null && !t1.getFileObject().equals(t2.getFileObject())) {
                return -1;
            }
            return this.compare(t1.getContextName(), t2.getContextName());
        }
    }
}

