/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.historystore;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.versioning.historystore.Storage;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.NbPreferences;

public class StorageManager {
    private static StorageManager INSTANCE;
    private final Map<String, Storage> storages = new HashMap<String, Storage>(3);
    static final Logger LOG;

    public static synchronized StorageManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new StorageManager();
            INSTANCE.cleanUp();
        }
        return INSTANCE;
    }

    private StorageManager() {
    }

    public Storage getStorage(String root) {
        String storeFileName = Storage.getMD5(root);
        return this.getStorageIntern(storeFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Storage getStorageIntern(String storeName) {
        Map<String, Storage> map = this.storages;
        synchronized (map) {
            Storage storage = this.storages.get(storeName);
            if (storage == null) {
                storage = this.createStorage(storeName);
                this.storages.put(storeName, storage);
            }
            return storage;
        }
    }

    private Storage createStorage(String storeFileName) {
        File storageBaseFolder = this.getBaseFolder();
        File storageFolder = new File(storageBaseFolder, storeFileName);
        return new Storage(storageFolder);
    }

    private File getBaseFolder() {
        String userDir = System.getProperty("netbeans.user");
        return new File(new File(new File(userDir, "var"), "cache"), "vcshistory");
    }

    private void cleanUp() {
        if (NbPreferences.forModule(StorageManager.class).getInt("HistoryStorage.ttl", Integer.MAX_VALUE) == Integer.MAX_VALUE) {
            return;
        }
        Utils.postParallel(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LOG.log(Level.FINE, "SM.cleanUp: cleanup started");
                long ts = System.currentTimeMillis();
                File baseFolder = StorageManager.this.getBaseFolder();
                File[] storageFolders = baseFolder.listFiles();
                if (storageFolders != null) {
                    for (File storageFolder : storageFolders) {
                        Storage storage = StorageManager.this.getStorageIntern(storageFolder.getName());
                        storage.cleanUp();
                    }
                    Map map = StorageManager.this.storages;
                    synchronized (map) {
                        storageFolders = baseFolder.listFiles();
                        if (storageFolders != null && storageFolders.length == 0) {
                            Utils.deleteRecursively(baseFolder);
                        }
                    }
                }
                LOG.log(Level.FINE, "SM.cleanUp: cleanup complete in {0} ms", System.currentTimeMillis() - ts);
            }
        }, 0);
    }

    static {
        LOG = Logger.getLogger(StorageManager.class.getPackage().getName());
    }
}

