/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.web.core.syntax.JspUtils;
import org.netbeans.modules.web.el.spi.ELPlugin;
import org.netbeans.modules.web.el.spi.ImplicitObject;
import org.netbeans.modules.web.el.spi.ImplicitObjectType;
import org.openide.filesystems.FileObject;

public class JSPELPlugin
implements ELPlugin {
    private static final String PLUGIN_NAME = "JSP EL Plugin";
    private Collection<String> MIMETYPES = Arrays.asList("text/x-jsp", "text/x-tag");
    private Collection<ImplicitObject> implicitObjects;

    public String getName() {
        return PLUGIN_NAME;
    }

    public Collection<String> getMimeTypes() {
        return this.MIMETYPES;
    }

    public Collection<ImplicitObject> getImplicitObjects(FileObject file) {
        if (JspUtils.isJSPOrTagFile(file)) {
            return this.getImplicitObjects();
        }
        return Collections.emptyList();
    }

    public List<String> getResourceBundles(FileObject file) {
        return Collections.emptyList();
    }

    private synchronized Collection<ImplicitObject> getImplicitObjects() {
        if (this.implicitObjects == null) {
            this.initImplicitObjects();
        }
        return this.implicitObjects;
    }

    private synchronized void initImplicitObjects() {
        this.implicitObjects = new ArrayList<ImplicitObject>(11);
        this.implicitObjects.addAll(JSPELPlugin.getScopeObjects());
        this.implicitObjects.add(new PageContextObject("pageContext"));
        this.implicitObjects.add(new ELImplicitObject("param"));
        this.implicitObjects.add(new ELImplicitObject("paramValues"));
        this.implicitObjects.add(new ELImplicitObject("header"));
        this.implicitObjects.add(new ELImplicitObject("headerValues"));
        this.implicitObjects.add(new ELImplicitObject("initParam"));
        this.implicitObjects.add(new ELImplicitObject("cookie"));
    }

    private static Collection<ELImplicitObject> getScopeObjects() {
        ArrayList<ELImplicitObject> result = new ArrayList<ELImplicitObject>(4);
        result.add(new ELImplicitObject("pageScope"));
        result.add(new ELImplicitObject("sessionScope"));
        result.add(new ELImplicitObject("applicationScope"));
        result.add(new ELImplicitObject("requestScope"));
        for (ELImplicitObject each : result) {
            each.setType(ImplicitObjectType.SCOPE_TYPE);
        }
        return result;
    }

    private static class ELImplicitObject
    implements ImplicitObject {
        private String myName;
        private ImplicitObjectType myType;
        private String myClazz;

        public ELImplicitObject(String name) {
            this.myName = name;
            this.myType = ImplicitObjectType.MAP_TYPE;
        }

        public String getName() {
            return this.myName;
        }

        public ImplicitObjectType getType() {
            return this.myType;
        }

        public void setType(ImplicitObjectType type) {
            this.myType = type;
        }

        public String getClazz() {
            return this.myClazz;
        }

        public void setClazz(String clazz) {
            this.myClazz = clazz;
        }
    }

    static class PageContextObject
    extends ELImplicitObject {
        public PageContextObject(String name) {
            super(name);
            this.setType(ImplicitObjectType.OBJECT_TYPE);
            this.setClazz("javax.servlet.jsp.PageContext");
        }
    }
}

