/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.apache.maven.artifact.Artifact;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.options.MavenCommandSettings;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class InstallPanel
extends JPanel {
    private static File lastFolder = new File(System.getProperty("user.home"));
    private JButton btnFile;
    private JLabel lblFile;
    private JLabel lblHint;
    private JTextField txtFile;

    private InstallPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.lblFile = new JLabel();
        this.txtFile = new JTextField();
        this.btnFile = new JButton();
        this.lblHint = new JLabel();
        this.lblFile.setLabelFor(this.txtFile);
        Mnemonics.setLocalizedText((JLabel)this.lblFile, (String)NbBundle.getMessage(InstallPanel.class, (String)"InstallPanel.lblFile.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnFile, (String)NbBundle.getMessage(InstallPanel.class, (String)"InstallPanel.btnFile.text"));
        this.btnFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstallPanel.this.btnFileActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lblHint, (String)NbBundle.getMessage(InstallPanel.class, (String)"InstallPanel.lblHint.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblFile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtFile, -1, 237, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnFile)).addComponent(this.lblHint, -2, -1, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblFile).addComponent(this.btnFile).addComponent(this.txtFile, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblHint, -2, -1, -2).addContainerGap(72, Short.MAX_VALUE)));
        this.txtFile.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanel.class, (String)"InstallPanel.txtFile.accessiblename"));
        this.txtFile.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanel.class, (String)"InstallPanel.txtFile.accessibledesc"));
        this.btnFile.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanel.class, (String)"InstallPanel.btnFile.accessibledesc"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanel.class, (String)"InstallPanel.panel.accessibledesc"));
    }

    private void btnFileActionPerformed(ActionEvent evt) {
        int ret;
        File fil;
        JFileChooser chooser = new JFileChooser(lastFolder);
        chooser.setDialogTitle(NbBundle.getMessage(InstallPanel.class, (String)"TIT_Select_Artifact"));
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".jar");
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(InstallPanel.class, (String)"SEL_Jars");
            }
        });
        chooser.setMultiSelectionEnabled(false);
        if (this.txtFile.getText().trim().length() > 0 && (fil = new File(this.txtFile.getText().trim())).exists()) {
            chooser.setSelectedFile(fil);
        }
        if ((ret = chooser.showDialog(SwingUtilities.getWindowAncestor(this), NbBundle.getMessage(InstallPanel.class, (String)"TIT_Select"))) == 0) {
            this.txtFile.setText(chooser.getSelectedFile().getAbsolutePath());
            this.txtFile.requestFocusInWindow();
        }
    }

    File getFile() {
        File fil = this.txtFile.getText().trim().length() > 0 ? new File(this.txtFile.getText().trim()) : null;
        return fil != null && fil.exists() ? fil : null;
    }

    public static File showInstallDialog(Artifact art) {
        final InstallPanel panel = new InstallPanel();
        panel.setExplainText(NbBundle.getMessage(InstallPanel.class, (String)"MSG_Instructions", (Object)art.getGroupId(), (Object)art.getArtifactId(), (Object)art.getVersion()));
        final JButton btnSelect = new JButton(NbBundle.getMessage(InstallPanel.class, (String)"BTN_Install_locally"));
        btnSelect.setEnabled(panel.getFile() != null);
        panel.addDocListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                btnSelect.setEnabled(panel.getFile() != null);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                btnSelect.setEnabled(panel.getFile() != null);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                btnSelect.setEnabled(panel.getFile() != null);
            }
        });
        Object[] options = new Object[]{btnSelect, NotifyDescriptor.CANCEL_OPTION};
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(InstallPanel.class, (String)"TIT_Install_locally"), true, options, (Object)btnSelect, 0, HelpCtx.DEFAULT_HELP, null);
        dd.setClosingOptions(options);
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (ret == btnSelect) {
            lastFolder = panel.getFile().getParentFile();
            return panel.getFile();
        }
        return null;
    }

    public static void runInstallGoal(NbMavenProjectImpl project, File fil, Artifact art) {
        BeanRunConfig brc = new BeanRunConfig();
        brc.setExecutionDirectory(project.getPOMFile().getParentFile());
        brc.setProject(project);
        brc.setGoals(Collections.singletonList(MavenCommandSettings.getDefault().getCommand("installFile")));
        brc.setExecutionName("install-artifact");
        Properties props = new Properties();
        props.put("artifactId", art.getArtifactId());
        props.put("groupId", art.getGroupId());
        props.put("version", art.getVersion());
        props.put("packaging", art.getType());
        props.put("file", fil.getAbsolutePath());
        props.put("generatePom", "false");
        brc.setProperties(props);
        brc.setActivatedProfiles(Collections.<String>emptyList());
        brc.setTaskDisplayName(NbBundle.getMessage(InstallPanel.class, (String)"TXT_InstallTask"));
        RunUtils.executeMaven(brc);
    }

    private void addDocListener(DocumentListener documentListener) {
        this.txtFile.getDocument().addDocumentListener(documentListener);
    }

    private void setExplainText(String string) {
        this.lblHint.setText(string);
    }
}

