/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.execute.AbstractOutputHandler;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

class CommandLineOutputHandler
extends AbstractOutputHandler {
    private static final RequestProcessor PROCESSOR = new RequestProcessor("Maven ComandLine Output Redirection", 8);
    private static final Logger LOG = Logger.getLogger(CommandLineOutputHandler.class.getName());
    private InputOutput inputOutput;
    private static final Pattern linePattern = Pattern.compile("\\[(DEBUG|INFO|WARNING|ERROR|FATAL)\\] (.*)");
    static final Pattern startPatternM2 = Pattern.compile("\\[INFO\\] \\[([\\w]*):([\\w]*)[ ]?.*\\]");
    static final Pattern startPatternM3 = Pattern.compile("\\[INFO\\] --- (\\S+):\\S+:(\\S+)(?: [(]\\S+[)])? @ \\S+ ---");
    private static final Pattern mavenSomethingPlugin = Pattern.compile("maven-(.+)-plugin");
    private static final Pattern somethingMavenPlugin = Pattern.compile("(.+)-maven-plugin");
    private OutputWriter stdOut;
    private String currentProject;
    private String currentTag;
    RequestProcessor.Task outTask;
    private Input inp;
    private ProgressHandle handle;
    private static final String SEC_MOJO_EXEC = "mojo-execute";
    private ProgressState state = ProgressState.INITIAL;
    private int forkCount;
    private int reactorSize;
    private int projectCount;

    CommandLineOutputHandler(ProgressHandle hand) {
        super(hand);
        this.handle = hand;
    }

    public CommandLineOutputHandler(InputOutput io, Project proj, ProgressHandle hand, RunConfig config) {
        this(hand);
        this.inputOutput = io;
        this.stdOut = this.inputOutput.getOut();
        this.initProcessorList(proj, config);
    }

    @Override
    protected final void checkSleepiness() {
        this.handle.progress(this.currentProject == null ? "" : (this.currentTag == null ? this.currentProject : this.currentProject + " " + this.currentTag));
        super.checkSleepiness();
    }

    void setStdOut(InputStream inStr) {
        this.outTask = PROCESSOR.post((Runnable)new Output(inStr));
    }

    void setStdIn(OutputStream in) {
        this.inp = new Input(in, this.inputOutput);
        PROCESSOR.post((Runnable)this.inp);
    }

    void waitFor() {
        this.inp.stopInput();
        if (this.outTask != null) {
            this.outTask.waitFinished();
        }
    }

    @Override
    protected InputOutput getIO() {
        return this.inputOutput;
    }

    private void closeCurrentTag() {
        if (this.currentTag != null) {
            this.processEnd(this.getEventId(SEC_MOJO_EXEC, this.currentTag), this.stdOut);
            this.currentTag = null;
        }
    }

    private void checkProgress(String text) {
        switch (this.state) {
            case INITIAL: {
                if (!text.equals("Reactor Build Order:")) break;
                this.state = ProgressState.GOT_REACTOR_BUILD_ORDER;
                break;
            }
            case GOT_REACTOR_BUILD_ORDER: {
                if (text.trim().isEmpty()) {
                    this.state = ProgressState.GETTING_REACTOR_PROJECTS;
                    break;
                }
                this.state = ProgressState.INITIAL;
                break;
            }
            case GETTING_REACTOR_PROJECTS: {
                if (text.trim().isEmpty()) {
                    this.state = ProgressState.NORMAL;
                    ++this.reactorSize;
                    this.handle.switchToDeterminate(this.reactorSize);
                    LOG.log(Level.FINE, "reactor size: {0}", this.reactorSize);
                    break;
                }
                ++this.reactorSize;
                break;
            }
            case NORMAL: {
                if (this.forkCount == 0 && text.matches("-+")) {
                    this.state = ProgressState.GOT_DASHES;
                    break;
                }
                if (text.startsWith("<<< ")) {
                    ++this.forkCount;
                    LOG.log(Level.FINE, "fork count up to {0}", this.forkCount);
                    break;
                }
                if (this.forkCount <= 0 || !text.startsWith(">>> ")) break;
                --this.forkCount;
                LOG.log(Level.FINE, "fork count down to {0}", this.forkCount);
                break;
            }
            case GOT_DASHES: {
                if (text.startsWith("Building ") && !text.startsWith("Building in ") || text.startsWith("Skipping ")) {
                    this.currentProject = text.substring(9);
                    this.closeCurrentTag();
                    this.handle.progress(this.currentProject, Math.min(++this.projectCount, this.reactorSize));
                    LOG.log(Level.FINE, "got project #{0}: {1}", new Object[]{this.projectCount, this.currentProject});
                }
                this.state = ProgressState.NORMAL;
                break;
            }
            default: {
                assert (false) : this.state;
                break;
            }
        }
    }

    static enum ProgressState {
        INITIAL,
        GOT_REACTOR_BUILD_ORDER,
        GETTING_REACTOR_PROJECTS,
        NORMAL,
        GOT_DASHES;

    }

    static class Input
    implements Runnable {
        private InputOutput inputOutput;
        private OutputStream str;
        private boolean stopIn = false;

        public Input(OutputStream out, InputOutput inputOutput) {
            this.str = out;
            this.inputOutput = inputOutput;
        }

        public void stopInput() {
            this.stopIn = true;
            try {
                this.inputOutput.getIn().close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Reader in = this.inputOutput.getIn();
            try {
                while (true) {
                    int read;
                    if ((read = in.read()) == -1) {
                        this.str.close();
                        return;
                    }
                    this.str.write(read);
                    this.str.flush();
                    if (this.stopIn) {
                        return;
                    }
                    continue;
                    break;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return;
            }
            finally {
                try {
                    this.str.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private class Output
    implements Runnable {
        private BufferedReader str;
        private boolean skipLF = false;

        public Output(InputStream instream) {
            this.str = new BufferedReader(new InputStreamReader(instream));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String readLine() throws IOException {
            char[] char1 = new char[1];
            boolean isReady = true;
            StringBuilder buf = new StringBuilder();
            while (isReady) {
                int ret = this.str.read(char1);
                if (ret != 1) {
                    if (ret == -1 && buf.length() == 0) {
                        return null;
                    }
                    return buf.toString();
                }
                if (this.skipLF) {
                    this.skipLF = false;
                    if (char1[0] == '\n') continue;
                }
                if (char1[0] == '\n') {
                    return buf.toString();
                }
                if (char1[0] == '\r') {
                    this.skipLF = true;
                    return buf.toString();
                }
                buf.append(char1[0]);
                isReady = this.str.ready();
                if (isReady) continue;
                Output output = this;
                synchronized (output) {
                    try {
                        this.wait(500L);
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        if (!this.str.ready()) {
                            break;
                        }
                        isReady = true;
                    }
                }
            }
            return "&^#INCOMPLINE:" + buf.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CommandLineOutputHandler.this.processStart(CommandLineOutputHandler.this.getEventId("project-execute", null), CommandLineOutputHandler.this.stdOut);
            try {
                String line = this.readLine();
                while (line != null) {
                    if (line.startsWith("&^#INCOMPLINE:")) {
                        CommandLineOutputHandler.this.stdOut.print(line.substring("&^#INCOMPLINE:".length()));
                        line = this.readLine();
                        continue;
                    }
                    if (line.startsWith("[INFO] Final Memory:")) {
                        CommandLineOutputHandler.this.closeCurrentTag();
                    }
                    String tag = null;
                    Matcher match = startPatternM3.matcher(line);
                    if (match.matches()) {
                        String mojoArtifact = match.group(1);
                        Matcher match2 = mavenSomethingPlugin.matcher(mojoArtifact);
                        if (match2.matches()) {
                            mojoArtifact = match2.group(1);
                        } else {
                            match2 = somethingMavenPlugin.matcher(mojoArtifact);
                            if (match2.matches()) {
                                mojoArtifact = match2.group(1);
                            }
                        }
                        tag = mojoArtifact + ':' + match.group(2);
                    } else {
                        match = startPatternM2.matcher(line);
                        if (match.matches()) {
                            tag = match.group(1) + ':' + match.group(2);
                        }
                    }
                    if (tag != null) {
                        CommandLineOutputHandler.this.closeCurrentTag();
                        CommandLineOutputHandler.this.currentTag = tag;
                        CommandLineOutputHandler.this.processStart(CommandLineOutputHandler.this.getEventId(CommandLineOutputHandler.SEC_MOJO_EXEC, tag), CommandLineOutputHandler.this.stdOut);
                        CommandLineOutputHandler.this.checkSleepiness();
                    } else {
                        match = linePattern.matcher(line);
                        if (match.matches()) {
                            String levelS = match.group(1);
                            AbstractOutputHandler.Level level = AbstractOutputHandler.Level.valueOf(levelS);
                            String text = match.group(2);
                            CommandLineOutputHandler.this.processLine(text, CommandLineOutputHandler.this.stdOut, level);
                            if (level == AbstractOutputHandler.Level.INFO) {
                                CommandLineOutputHandler.this.checkProgress(text);
                            }
                        } else {
                            CommandLineOutputHandler.this.processLine(line, CommandLineOutputHandler.this.stdOut, AbstractOutputHandler.Level.INFO);
                        }
                    }
                    line = this.readLine();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(CommandLineOutputHandler.class.getName()).log(Level.FINE, null, ex);
            }
            finally {
                CommandLineOutputHandler.this.processEnd(CommandLineOutputHandler.this.getEventId("project-execute", null), CommandLineOutputHandler.this.stdOut);
                try {
                    this.str.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

