/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.customizer;

public class PropertySplitter {
    private String line;
    private char[] quotes;
    private char separator;
    private char newline;
    private boolean trim = true;
    private char escape;
    private int location = 0;
    private char quoteChar = '\u0000';
    private boolean inQuote = false;
    private boolean escapeNext = false;

    public PropertySplitter(String line) {
        this(line, new char[]{'\"'}, '\\', '\n', '\n');
    }

    private PropertySplitter(String line, char[] quotes, char escape, char separator, char nl) {
        this.line = line;
        this.quotes = quotes;
        this.separator = separator;
        this.escape = escape;
        this.newline = nl;
    }

    void setSeparator(char sep) {
        this.separator = sep;
    }

    public String nextPair() {
        StringBuffer buffer = new StringBuffer();
        if (this.location >= this.line.length()) {
            return null;
        }
        while (this.location < this.line.length() && (this.line.charAt(this.location) != this.separator && this.line.charAt(this.location) != this.newline || this.inQuote || this.escapeNext)) {
            char c = this.line.charAt(this.location);
            if (this.escapeNext) {
                buffer.append(c);
                this.escapeNext = false;
            } else if (!this.inQuote && c == this.escape) {
                this.escapeNext = true;
            } else if (this.inQuote) {
                if (c == this.quoteChar) {
                    this.inQuote = false;
                }
                buffer.append(c);
            } else {
                if (this.isQuoteChar(c)) {
                    this.inQuote = true;
                    this.quoteChar = c;
                }
                buffer.append(c);
            }
            ++this.location;
        }
        ++this.location;
        return this.trim ? buffer.toString().trim() : buffer.toString();
    }

    private boolean isQuoteChar(char c) {
        for (int i = 0; i < this.quotes.length; ++i) {
            char quote = this.quotes[i];
            if (c != quote) continue;
            return true;
        }
        return false;
    }
}

