/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.customizer;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import org.codehaus.plexus.util.StringUtils;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.TextValueCompleter;
import org.netbeans.modules.maven.api.ProjectProfileHandler;
import org.netbeans.modules.maven.api.customizer.ModelHandle;
import org.netbeans.modules.maven.customizer.AddPropertyDialog;
import org.netbeans.modules.maven.customizer.PropertySplitter;
import org.netbeans.modules.maven.customizer.WarnPanel;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.execute.ActionToGoalUtils;
import org.netbeans.modules.maven.execute.DefaultReplaceTokenProvider;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.options.DontShowAgainSettings;
import org.netbeans.modules.maven.spi.grammar.GoalsProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ActionMappings
extends JPanel {
    private static final String CUSTOM_ACTION_PREFIX = "CUSTOM-";
    private NbMavenProjectImpl project;
    private ModelHandle handle;
    private HashMap<String, String> titles = new HashMap();
    private final GoalsListener goalsListener;
    private final TextValueCompleter goalcompleter;
    private final TextValueCompleter profilecompleter;
    private final ProfilesListener profilesListener;
    private final PropertiesListener propertiesListener;
    private final RecursiveListener recursiveListener;
    private final DepsListener depsListener;
    private ActionToGoalMapping actionmappings;
    private ActionListener comboListener;
    private JButton btnAdd;
    private JButton btnAddProps;
    private JButton btnRemove;
    private JCheckBox cbBuildWithDeps;
    private JCheckBox cbRecursively;
    private JComboBox comConfiguration;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel lblConfiguration;
    private JLabel lblGoals;
    private JLabel lblHint;
    private JLabel lblMappings;
    private JLabel lblProfiles;
    private JLabel lblProperties;
    private JList lstMappings;
    private JTextArea taProperties;
    private JTextField txtGoals;
    private JTextField txtProfiles;

    private ActionMappings() {
        this.initComponents();
        this.lstMappings.setCellRenderer(new Renderer());
        this.lstMappings.setSelectionMode(0);
        this.goalsListener = new GoalsListener();
        this.profilesListener = new ProfilesListener();
        this.propertiesListener = new PropertiesListener();
        this.recursiveListener = new RecursiveListener();
        this.depsListener = new DepsListener();
        FocusListener focus = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (e.getComponent() == ActionMappings.this.txtGoals) {
                    ActionMappings.this.lblHint.setText(NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.txtGoals.hint"));
                }
                if (e.getComponent() == ActionMappings.this.txtProfiles) {
                    ActionMappings.this.lblHint.setText(NbBundle.getMessage(ActionMappings.class, (String)"ActinMappings.txtProfiles.hint"));
                }
                if (e.getComponent() == ActionMappings.this.taProperties) {
                    ActionMappings.this.lblHint.setText(NbBundle.getMessage(ActionMappings.class, (String)"ActinMappings.txtProperties.hint"));
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                ActionMappings.this.lblHint.setText("");
            }
        };
        this.txtGoals.addFocusListener(focus);
        this.txtProfiles.addFocusListener(focus);
        this.taProperties.addFocusListener(focus);
        this.goalcompleter = new TextValueCompleter(Collections.<String>emptyList(), this.txtGoals, " ");
        this.profilecompleter = new TextValueCompleter(Collections.<String>emptyList(), this.txtProfiles, " ");
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.lblHint.setOpaque(true);
            this.jScrollPane2.setBorder(null);
        }
    }

    public ActionMappings(ActionToGoalMapping mapp) {
        this();
        this.actionmappings = mapp;
        this.loadMappings();
        this.cbRecursively.setVisible(false);
        this.comConfiguration.setVisible(false);
        this.lblConfiguration.setVisible(false);
        this.clearFields();
        Mnemonics.setLocalizedText((AbstractButton)this.btnAdd, (String)NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.btnAdd.text2"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.btnRemove.text2"));
    }

    public ActionMappings(ModelHandle hand, NbMavenProjectImpl proj) {
        this();
        this.project = proj;
        this.handle = hand;
        this.titles.put("build", NbBundle.getMessage(ActionMappings.class, (String)"COM_Build_project"));
        this.titles.put("clean", NbBundle.getMessage(ActionMappings.class, (String)"COM_Clean_project"));
        this.titles.put("compile.single", NbBundle.getMessage(ActionMappings.class, (String)"COM_Compile_file"));
        this.titles.put("debug", NbBundle.getMessage(ActionMappings.class, (String)"COM_Debug_project"));
        this.titles.put("debug.single.main", NbBundle.getMessage(ActionMappings.class, (String)"COM_Debug_file_main"));
        this.titles.put("debug.single.deploy", NbBundle.getMessage(ActionMappings.class, (String)"COM_Debug_file_deploy"));
        this.titles.put("debug.stepinto", null);
        this.titles.put("debug.test.single", NbBundle.getMessage(ActionMappings.class, (String)"COM_Debug_test"));
        this.titles.put("rebuild", NbBundle.getMessage(ActionMappings.class, (String)"COM_ReBuild_project"));
        this.titles.put("run", NbBundle.getMessage(ActionMappings.class, (String)"COM_Run_project"));
        this.titles.put("run.single.main", NbBundle.getMessage(ActionMappings.class, (String)"COM_Run_file_main"));
        this.titles.put("run.single.deploy", NbBundle.getMessage(ActionMappings.class, (String)"COM_Run_file_deploy"));
        this.titles.put("test", NbBundle.getMessage(ActionMappings.class, (String)"COM_Test_project"));
        this.titles.put("test.single", NbBundle.getMessage(ActionMappings.class, (String)"COM_Test_file"));
        this.titles.put("profile", NbBundle.getMessage(ActionMappings.class, (String)"COM_Profile_project"));
        this.titles.put("javadoc", NbBundle.getMessage(ActionMappings.class, (String)"COM_Javadoc_project"));
        this.titles.put("build-with-dependencies", NbBundle.getMessage(ActionMappings.class, (String)"COM_Build_WithDeps_project"));
        this.comConfiguration.setEditable(false);
        this.comConfiguration.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component com = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (com instanceof JLabel && value == ActionMappings.this.handle.getActiveConfiguration()) {
                    com.setFont(com.getFont().deriveFont(1));
                }
                return com;
            }
        });
        this.setupConfigurations();
        this.loadMappings();
        this.clearFields();
        this.comboListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionMappings.this.clearFields();
                ActionMappings.this.loadMappings();
                ActionMappings.this.addListeners();
            }
        };
    }

    private void addListeners() {
        this.comConfiguration.addActionListener(this.comboListener);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.clearFields();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setupConfigurations();
        this.loadMappings();
        this.addListeners();
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                final GoalsProvider provider = (GoalsProvider)Lookup.getDefault().lookup(GoalsProvider.class);
                final Set<String> strs = provider.getAvailableGoals();
                if (provider != null) {
                    try {
                        List phases = EmbedderFactory.getProjectEmbedder().getLifecyclePhases();
                        strs.addAll(phases);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                List<String> allProfiles = null;
                if (ActionMappings.this.project != null) {
                    ProjectProfileHandler profileHandler = (ProjectProfileHandler)ActionMappings.this.project.getLookup().lookup(ProjectProfileHandler.class);
                    allProfiles = profileHandler.getAllProfiles();
                }
                final List<String> profiles = allProfiles;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (provider != null) {
                            ActionMappings.this.goalcompleter.setValueList(strs);
                        }
                        if (profiles != null) {
                            ActionMappings.this.profilecompleter.setValueList(profiles);
                        }
                    }
                });
            }
        });
    }

    private void initComponents() {
        this.lblConfiguration = new JLabel();
        this.comConfiguration = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.lstMappings = new JList();
        this.btnAdd = new JButton();
        this.btnRemove = new JButton();
        this.lblGoals = new JLabel();
        this.txtGoals = new JTextField();
        this.lblProfiles = new JLabel();
        this.txtProfiles = new JTextField();
        this.lblProperties = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.taProperties = new JTextArea();
        this.cbRecursively = new JCheckBox();
        this.lblMappings = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.lblHint = new JLabel();
        this.btnAddProps = new JButton();
        this.cbBuildWithDeps = new JCheckBox();
        this.lblConfiguration.setLabelFor(this.comConfiguration);
        Mnemonics.setLocalizedText((JLabel)this.lblConfiguration, (String)NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.lblConfiguration.text"));
        this.lstMappings.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ActionMappings.this.lstMappingsValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstMappings);
        this.lstMappings.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.lstMappings.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAdd, (String)NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.btnAdd.text"));
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionMappings.this.btnAddActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.btnRemove.text"));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionMappings.this.btnRemoveActionPerformed(evt);
            }
        });
        this.lblGoals.setLabelFor(this.txtGoals);
        Mnemonics.setLocalizedText((JLabel)this.lblGoals, (String)NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.lblGoals.text"));
        this.lblProfiles.setLabelFor(this.txtProfiles);
        Mnemonics.setLocalizedText((JLabel)this.lblProfiles, (String)NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.lblProfiles.text"));
        this.lblProperties.setLabelFor(this.taProperties);
        Mnemonics.setLocalizedText((JLabel)this.lblProperties, (String)NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.lblProperties.text"));
        this.taProperties.setColumns(20);
        this.taProperties.setRows(5);
        this.jScrollPane3.setViewportView(this.taProperties);
        this.taProperties.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.taProperties.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbRecursively, (String)NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.cbRecursively.text"));
        this.lblMappings.setLabelFor(this.lstMappings);
        Mnemonics.setLocalizedText((JLabel)this.lblMappings, (String)NbBundle.getMessage(ActionMappings.class, (String)"LBL_Actions"));
        this.lblMappings.setVerticalAlignment(3);
        this.jScrollPane2.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.lblHint.setVerticalAlignment(3);
        this.jScrollPane2.setViewportView(this.lblHint);
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddProps, (String)NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.btnAddProps.text"));
        this.btnAddProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionMappings.this.btnAddPropsActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbBuildWithDeps, (String)NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.cbBuildWithDeps.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 668, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblConfiguration).addComponent(this.lblGoals).addComponent(this.lblMappings)).addGap(28, 28, 28).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtGoals, -1, 532, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 392, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnRemove).addComponent(this.btnAdd))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.comConfiguration, 0, 389, Short.MAX_VALUE).addGap(143, 143, 143)))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblProfiles).addComponent(this.lblProperties).addComponent(this.btnAddProps)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtProfiles, -1, 532, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.cbRecursively).addGap(18, 18, 18).addComponent(this.cbBuildWithDeps)).addComponent(this.jScrollPane3, -1, 532, Short.MAX_VALUE)))).addContainerGap()));
        layout.linkSize(0, this.btnAdd, this.btnRemove);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblConfiguration).addComponent(this.comConfiguration, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.btnAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRemove)).addComponent(this.jScrollPane1, -2, 109, -2).addComponent(this.lblMappings)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblGoals).addComponent(this.txtGoals, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblProfiles).addComponent(this.txtProfiles, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblProperties).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnAddProps)).addComponent(this.jScrollPane3, -1, 46, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbRecursively).addComponent(this.cbBuildWithDeps)).addGap(41, 41, 41).addComponent(this.jScrollPane2, -2, 105, -2).addContainerGap()));
        this.comConfiguration.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.comConfiguration.AccessibleContext.accessibleDescription"));
        this.btnAdd.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.btnAdd.AccessibleContext.accessibleDescription"));
        this.btnRemove.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.btnRemove.AccessibleContext.accessibleDescription"));
        this.txtGoals.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.txtGoals.AccessibleContext.accessibleDescription"));
        this.txtProfiles.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.txtProfiles.AccessibleContext.accessibleDescription"));
        this.btnAddProps.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.btnAddProps.AccessibleContext.accessibleDescription"));
        this.cbBuildWithDeps.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.cbBuildWithDeps.AccessibleContext.accessibleDescription"));
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        NonEmptyInputLine nd = new NonEmptyInputLine(NbBundle.getMessage(ActionMappings.class, (String)"TIT_Add_action"), NbBundle.getMessage(ActionMappings.class, (String)"LBL_AddAction"));
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        if (ret == NotifyDescriptor.OK_OPTION) {
            NetbeansActionMapping nam = new NetbeansActionMapping();
            nam.setDisplayName(nd.getInputText());
            nam.setActionName(CUSTOM_ACTION_PREFIX + nd.getInputText());
            this.getActionMappings().addAction(nam);
            if (this.handle != null) {
                this.handle.markAsModified(this.getActionMappings());
            }
            MappingWrapper wr = new MappingWrapper(nam);
            wr.setUserDefined(true);
            ((DefaultListModel)this.lstMappings.getModel()).addElement(wr);
            this.lstMappings.setSelectedIndex(this.lstMappings.getModel().getSize() - 1);
            this.lstMappings.ensureIndexIsVisible(this.lstMappings.getModel().getSize() - 1);
        }
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        Object obj = this.lstMappings.getSelectedValue();
        if (obj == null) {
            return;
        }
        MappingWrapper wr = (MappingWrapper)obj;
        NetbeansActionMapping mapp = wr.getMapping();
        if (mapp != null) {
            List<NetbeansActionMapping> lst;
            if (mapp.getActionName().startsWith(CUSTOM_ACTION_PREFIX)) {
                ((DefaultListModel)this.lstMappings.getModel()).removeElement(wr);
            }
            if ((lst = this.getActionMappings().getActions()) != null) {
                Iterator<NetbeansActionMapping> it = lst.iterator();
                while (it.hasNext()) {
                    NetbeansActionMapping elem = it.next();
                    if (!mapp.getActionName().equals(elem.getActionName())) continue;
                    it.remove();
                    mapp = this.handle != null ? ActionToGoalUtils.getDefaultMapping(mapp.getActionName(), this.project) : null;
                    wr.setMapping(mapp);
                    wr.setUserDefined(false);
                    this.lstMappingsValueChanged(null);
                    if (this.handle == null) break;
                    this.handle.markAsModified(this.getActionMappings());
                    break;
                }
            }
        }
    }

    private void lstMappingsValueChanged(ListSelectionEvent evt) {
        Object obj = this.lstMappings.getSelectedValue();
        if (obj == null) {
            this.clearFields();
        } else {
            MappingWrapper wr = (MappingWrapper)obj;
            NetbeansActionMapping mapp = wr.getMapping();
            this.txtGoals.setEnabled(true);
            this.taProperties.setEnabled(true);
            this.txtProfiles.setEnabled(true);
            this.txtGoals.getDocument().removeDocumentListener(this.goalsListener);
            this.txtProfiles.getDocument().removeDocumentListener(this.profilesListener);
            this.taProperties.getDocument().removeDocumentListener(this.propertiesListener);
            this.cbRecursively.removeActionListener(this.recursiveListener);
            this.cbBuildWithDeps.removeActionListener(this.depsListener);
            this.txtGoals.setText(this.createSpaceSeparatedList(mapp != null ? mapp.getGoals() : Collections.EMPTY_LIST));
            this.txtProfiles.setText(this.createSpaceSeparatedList(mapp != null ? mapp.getActivatedProfiles() : Collections.EMPTY_LIST));
            this.taProperties.setText(this.createPropertiesList(mapp != null ? mapp.getProperties() : new Properties()));
            this.taProperties.setCaretPosition(0);
            if (this.handle != null && "pom".equals(this.handle.getProject().getPackaging())) {
                this.cbRecursively.setEnabled(true);
                this.cbRecursively.setSelected(mapp != null ? mapp.isRecursive() : true);
            }
            this.cbBuildWithDeps.setSelected(mapp != null && "build-with-dependencies".equals(mapp.getPreAction()));
            if (mapp != null && "build-with-dependencies".equals(mapp.getActionName())) {
                this.cbBuildWithDeps.setEnabled(false);
            } else {
                this.cbBuildWithDeps.setEnabled(true);
            }
            this.txtGoals.getDocument().addDocumentListener(this.goalsListener);
            this.txtProfiles.getDocument().addDocumentListener(this.profilesListener);
            this.taProperties.getDocument().addDocumentListener(this.propertiesListener);
            this.cbRecursively.addActionListener(this.recursiveListener);
            this.cbBuildWithDeps.addActionListener(this.depsListener);
            this.btnAddProps.setEnabled(true);
            this.updateColor(wr);
        }
    }

    private void btnAddPropsActionPerformed(ActionEvent evt) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new SkipTestsAction(this.taProperties));
        menu.add(new DebugMavenAction(this.taProperties));
        menu.add(new EnvVarAction(this.taProperties));
        menu.add(this.createGlobalVarSubmenu(this.taProperties));
        menu.add(new PluginPropertyAction(this.taProperties, this.txtGoals, this.project));
        menu.show(this.btnAddProps, this.btnAddProps.getSize().width, 0);
    }

    private void loadMappings() {
        List<NetbeansActionMapping> customs;
        DefaultListModel<MappingWrapper> model = new DefaultListModel<MappingWrapper>();
        if (this.handle != null) {
            boolean isWar = "war".equalsIgnoreCase(this.handle.getProject().getPackaging());
            this.addSingleAction("build", model);
            this.addSingleAction("clean", model);
            this.addSingleAction("rebuild", model);
            this.addSingleAction("build-with-dependencies", model);
            this.addSingleAction("test", model);
            this.addSingleAction("test.single", model);
            this.addSingleAction("run", model);
            this.addSingleAction("run.single.main", model);
            if (isWar) {
                this.addSingleAction("run.single.deploy", model);
            }
            this.addSingleAction("debug", model);
            this.addSingleAction("debug.single.main", model);
            if (isWar) {
                this.addSingleAction("debug.single.deploy", model);
            }
            this.addSingleAction("debug.test.single", model);
            this.addSingleAction("profile", model);
            this.addSingleAction("javadoc", model);
        }
        if ((customs = this.getActionMappings().getActions()) != null) {
            for (NetbeansActionMapping elem : customs) {
                if (!elem.getActionName().startsWith(CUSTOM_ACTION_PREFIX)) continue;
                MappingWrapper wr = new MappingWrapper(elem);
                model.addElement(wr);
                wr.setUserDefined(true);
            }
        }
        this.lstMappings.setModel(model);
    }

    private void addSingleAction(String action, DefaultListModel model) {
        NetbeansActionMapping mapp = null;
        List<NetbeansActionMapping> lst = this.getActionMappings().getActions();
        if (lst != null) {
            for (NetbeansActionMapping elem : lst) {
                if (!action.equals(elem.getActionName())) continue;
                mapp = elem;
                break;
            }
        }
        boolean userDefined = true;
        if (mapp == null) {
            mapp = ActionToGoalUtils.getDefaultMapping(action, this.project);
            userDefined = false;
        }
        MappingWrapper wr = mapp == null ? new MappingWrapper(action) : new MappingWrapper(mapp);
        wr.setUserDefined(userDefined);
        model.addElement(wr);
    }

    private String createSpaceSeparatedList(List list) {
        String str = "";
        if (list != null) {
            for (String elem : list) {
                str = str + elem + " ";
            }
        }
        return str;
    }

    private void clearFields() {
        this.comConfiguration.removeActionListener(this.comboListener);
        this.txtGoals.getDocument().removeDocumentListener(this.goalsListener);
        this.txtProfiles.getDocument().removeDocumentListener(this.profilesListener);
        this.taProperties.getDocument().removeDocumentListener(this.propertiesListener);
        this.txtGoals.setText("");
        this.txtProfiles.setText("");
        this.taProperties.setText("");
        this.txtGoals.getDocument().addDocumentListener(this.goalsListener);
        this.txtProfiles.getDocument().addDocumentListener(this.profilesListener);
        this.taProperties.getDocument().addDocumentListener(this.propertiesListener);
        this.txtGoals.setEnabled(false);
        this.taProperties.setEnabled(false);
        this.txtProfiles.setEnabled(false);
        this.updateColor(null);
        this.cbRecursively.setEnabled(false);
        this.btnAddProps.setEnabled(false);
    }

    private void updateColor(MappingWrapper wr) {
        Font fnt = this.lblGoals.getFont();
        fnt = fnt.deriveFont(wr != null && wr.isUserDefined() ? 1 : 0);
        this.lblGoals.setFont(fnt);
        this.lblProperties.setFont(fnt);
        this.lblProfiles.setFont(fnt);
    }

    private String createPropertiesList(Properties properties) {
        StringBuilder b = new StringBuilder();
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                if (b.length() > 0) {
                    b.append('\n');
                }
                b.append(entry.getKey()).append('=').append(entry.getValue());
            }
        }
        return b.toString();
    }

    private void writeProperties(NetbeansActionMapping mapp) {
        String text = this.taProperties.getText();
        PropertySplitter split = new PropertySplitter(text);
        String tok = split.nextPair();
        Properties props = new Properties();
        while (tok != null) {
            String[] prp = StringUtils.split((String)tok, (String)"=", (int)2);
            if (prp.length == 2) {
                String key = prp[0];
                if (key.startsWith("-D")) {
                    key = key.substring("-D".length());
                }
                if (key.startsWith("-")) {
                    key = key.substring(1);
                }
                props.setProperty(key, prp[1]);
            }
            tok = split.nextPair();
        }
        mapp.setProperties(props);
        if (this.handle != null) {
            this.handle.markAsModified(this.getActionMappings());
        }
    }

    private ActionToGoalMapping getActionMappings() {
        assert (this.handle != null || this.actionmappings != null);
        if (this.handle != null) {
            return this.handle.getActionMappings((ModelHandle.Configuration)this.comConfiguration.getSelectedItem());
        }
        return this.actionmappings;
    }

    private void setupConfigurations() {
        if (this.handle != null) {
            this.lblConfiguration.setVisible(true);
            this.comConfiguration.setVisible(true);
            DefaultComboBoxModel<ModelHandle.Configuration> comModel = new DefaultComboBoxModel<ModelHandle.Configuration>();
            for (ModelHandle.Configuration conf : this.handle.getConfigurations()) {
                comModel.addElement(conf);
            }
            this.comConfiguration.setModel(comModel);
            this.comConfiguration.setSelectedItem(this.handle.getActiveConfiguration());
        } else {
            this.lblConfiguration.setVisible(false);
            this.comConfiguration.setVisible(false);
            DefaultComboBoxModel comModel = new DefaultComboBoxModel();
            this.comConfiguration.setModel(comModel);
        }
    }

    private JMenu createGlobalVarSubmenu(JTextArea area) {
        JMenu menu = new JMenu();
        menu.setText(NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.globalVar"));
        Map<String, String> vars = DefaultReplaceTokenProvider.readVariables();
        boolean hasAny = false;
        for (Map.Entry<String, String> ent : vars.entrySet()) {
            hasAny = true;
            menu.add(new UseGlobalVarAction(area, ent.getKey()));
        }
        if (!hasAny) {
            menu.setEnabled(false);
        }
        return menu;
    }

    private static void replacePattern(String pattern, JTextArea area, String replace, boolean select) {
        String props = area.getText();
        Matcher match = Pattern.compile(pattern, 32).matcher(props);
        if (match.matches()) {
            int begin = props.indexOf("skipTests");
            props = props.replace("skipTests" + match.group(1), replace);
            area.setText(props);
            if (select) {
                area.setSelectionStart(begin);
                area.setSelectionEnd(begin + replace.length());
                area.requestFocusInWindow();
            }
        } else {
            String sep = "\n";
            if (props.endsWith("\n") || props.trim().length() == 0) {
                sep = "";
            }
            props = props + sep + replace;
            area.setText(props);
            if (select) {
                area.setSelectionStart(props.length() - replace.length());
                area.setSelectionEnd(props.length());
                area.requestFocusInWindow();
            }
        }
    }

    private static class NonEmptyInputLine
    extends NotifyDescriptor.InputLine
    implements DocumentListener {
        public NonEmptyInputLine(String text, String title) {
            super(text, title);
            this.textField.getDocument().addDocumentListener(this);
            this.checkValid();
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.checkValid();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.checkValid();
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.checkValid();
        }

        private void checkValid() {
            this.setValid(this.textField.getText() != null && this.textField.getText().trim().length() > 0);
        }
    }

    static class UseGlobalVarAction
    extends AbstractAction {
        private JTextArea area;
        private final String key;

        UseGlobalVarAction(JTextArea area, String key) {
            this.putValue("Name", "${" + key + "}");
            this.area = area;
            this.key = key;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.area.getDocument().insertString(this.area.getCaretPosition(), "${" + this.key + "}", null);
            }
            catch (BadLocationException ex) {
                String text = this.area.getText();
                text = text + "${" + this.key + "}";
                this.area.setText(text);
                this.area.requestFocusInWindow();
            }
        }
    }

    static class EnvVarAction
    extends AbstractAction {
        private JTextArea area;

        EnvVarAction(JTextArea area) {
            this.putValue("Name", NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.envVar"));
            this.area = area;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String props = this.area.getText();
            String sep = "\n";
            if (props.endsWith("\n") || props.trim().length() == 0) {
                sep = "";
            }
            props = props + sep + "Env.FOO=bar";
            this.area.setText(props);
            this.area.setSelectionStart(props.length() - "Env.FOO=bar".length());
            this.area.setSelectionEnd(props.length());
            this.area.requestFocusInWindow();
        }
    }

    static class PluginPropertyAction
    extends AbstractAction {
        private JTextArea area;
        private JTextField goals;
        private NbMavenProjectImpl project;

        PluginPropertyAction(JTextArea area, JTextField goals, NbMavenProjectImpl prj) {
            this.putValue("Name", NbBundle.getMessage(ActionMappings.class, (String)"TXT_PLUGIN_EXPRESSION"));
            this.area = area;
            this.goals = goals;
            this.project = prj;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GoalsProvider provider = (GoalsProvider)Lookup.getDefault().lookup(GoalsProvider.class);
            if (provider != null) {
                String expr;
                AddPropertyDialog panel = new AddPropertyDialog(this.project, this.goals.getText());
                DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(ActionMappings.class, (String)"TIT_PLUGIN_EXPRESSION"));
                dd.setOptions(new Object[]{panel.getOkButton(), DialogDescriptor.CANCEL_OPTION});
                dd.setClosingOptions(new Object[]{panel.getOkButton(), DialogDescriptor.CANCEL_OPTION});
                DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                if (dd.getValue() == panel.getOkButton() && (expr = panel.getSelectedExpression()) != null) {
                    String props = this.area.getText();
                    String sep = "\n";
                    if (props.endsWith("\n") || props.trim().length() == 0) {
                        sep = "";
                    }
                    props = props + sep + expr + "=";
                    this.area.setText(props);
                    this.area.setSelectionStart(props.length() - (expr + "=").length());
                    this.area.setSelectionEnd(props.length());
                    this.area.requestFocusInWindow();
                }
            }
        }
    }

    static class DebugMavenAction
    extends AbstractAction {
        private JTextArea area;

        DebugMavenAction(JTextArea area) {
            this.putValue("Name", NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.debugMaven"));
            this.area = area;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String replace = "jpda.listen=maven";
            String pattern = ".*jpda.listen([\\s]*=[\\s]*[\\S]+).*";
            ActionMappings.replacePattern(pattern, this.area, replace, true);
        }
    }

    static class SkipTestsAction
    extends AbstractAction {
        private JTextArea area;

        SkipTestsAction(JTextArea area) {
            this.putValue("Name", NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.skipTests"));
            this.area = area;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String replace = "skipTests=true";
            String pattern = ".*skipTests([\\s]*=[\\s]*[\\S]+).*";
            ActionMappings.replacePattern(pattern, this.area, replace, true);
        }
    }

    private class DepsListener
    implements ActionListener {
        private boolean shown = false;

        private DepsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingWrapper map = (MappingWrapper)ActionMappings.this.lstMappings.getSelectedValue();
            if (map != null) {
                if (!map.isUserDefined()) {
                    NetbeansActionMapping mapping = map.getMapping();
                    if (mapping == null) {
                        mapping = new NetbeansActionMapping();
                        mapping.setActionName(map.getActionName());
                    }
                    ActionMappings.this.getActionMappings().addAction(mapping);
                    map.setUserDefined(true);
                    ActionMappings.this.updateColor(map);
                }
                if (ActionMappings.this.cbBuildWithDeps.isSelected()) {
                    if (!this.shown && DontShowAgainSettings.getDefault().showWarningAboutBuildWithDependencies()) {
                        WarnPanel panel = new WarnPanel(NbBundle.getMessage(ActionMappings.class, (String)"HINT_Build_WithDependencies"));
                        NotifyDescriptor.Message dd = new NotifyDescriptor.Message((Object)panel, -1);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                        if (panel.disabledWarning()) {
                            DontShowAgainSettings.getDefault().dontShowWarningAboutBuildWithDependenciesAnymore();
                        }
                        this.shown = true;
                    }
                    map.getMapping().setPreAction("build-with-dependencies");
                } else {
                    map.getMapping().setPreAction(null);
                }
                if (ActionMappings.this.handle != null) {
                    ActionMappings.this.handle.markAsModified(ActionMappings.this.getActionMappings());
                }
            }
        }
    }

    private class RecursiveListener
    implements ActionListener {
        private RecursiveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingWrapper map = (MappingWrapper)ActionMappings.this.lstMappings.getSelectedValue();
            if (map != null) {
                if (!map.isUserDefined()) {
                    NetbeansActionMapping mapping = map.getMapping();
                    if (mapping == null) {
                        mapping = new NetbeansActionMapping();
                        mapping.setActionName(map.getActionName());
                    }
                    ActionMappings.this.getActionMappings().addAction(mapping);
                    map.setUserDefined(true);
                    ActionMappings.this.updateColor(map);
                }
                map.getMapping().setRecursive(ActionMappings.this.cbRecursively.isSelected());
                if (ActionMappings.this.handle != null) {
                    ActionMappings.this.handle.markAsModified(ActionMappings.this.getActionMappings());
                }
            }
        }
    }

    private class PropertiesListener
    extends TextFieldListener {
        private PropertiesListener() {
        }

        @Override
        protected MappingWrapper doUpdate() {
            MappingWrapper wr = super.doUpdate();
            if (wr != null) {
                NetbeansActionMapping mapp = wr.getMapping();
                ActionMappings.this.writeProperties(mapp);
            }
            return wr;
        }
    }

    private class ProfilesListener
    extends TextFieldListener {
        private ProfilesListener() {
        }

        @Override
        protected MappingWrapper doUpdate() {
            MappingWrapper wr = super.doUpdate();
            if (wr != null) {
                String text = ActionMappings.this.txtProfiles.getText();
                StringTokenizer tok = new StringTokenizer(text, " ,");
                NetbeansActionMapping mapp = wr.getMapping();
                ArrayList<String> profs = new ArrayList<String>();
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    profs.add(token);
                }
                mapp.setActivatedProfiles(profs);
                if (ActionMappings.this.handle != null) {
                    ActionMappings.this.handle.markAsModified(ActionMappings.this.getActionMappings());
                }
            }
            return wr;
        }
    }

    private class GoalsListener
    extends TextFieldListener {
        private GoalsListener() {
        }

        @Override
        protected MappingWrapper doUpdate() {
            MappingWrapper wr = super.doUpdate();
            if (wr != null) {
                String text = ActionMappings.this.txtGoals.getText();
                StringTokenizer tok = new StringTokenizer(text, " ");
                NetbeansActionMapping mapp = wr.getMapping();
                ArrayList<String> goals = new ArrayList<String>();
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    goals.add(token);
                }
                mapp.setGoals(goals);
                if (ActionMappings.this.handle != null) {
                    ActionMappings.this.handle.markAsModified(ActionMappings.this.getActionMappings());
                }
            }
            return wr;
        }
    }

    private abstract class TextFieldListener
    implements DocumentListener {
        private TextFieldListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.doUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.doUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.doUpdate();
        }

        protected MappingWrapper doUpdate() {
            MappingWrapper map = (MappingWrapper)ActionMappings.this.lstMappings.getSelectedValue();
            if (map != null && !map.isUserDefined()) {
                NetbeansActionMapping mapping = map.getMapping();
                if (mapping == null) {
                    mapping = new NetbeansActionMapping();
                    mapping.setActionName(map.getActionName());
                    map.setMapping(mapping);
                }
                ActionMappings.this.getActionMappings().addAction(mapping);
                if (ActionMappings.this.handle != null) {
                    ActionMappings.this.handle.markAsModified(ActionMappings.this.getActionMappings());
                }
                map.setUserDefined(true);
                ActionMappings.this.updateColor(map);
            }
            return map;
        }
    }

    private class MappingWrapper {
        private NetbeansActionMapping mapping;
        private String action;
        private boolean userDefined = false;

        public MappingWrapper(String action) {
            this.action = action;
        }

        public MappingWrapper(NetbeansActionMapping mapp) {
            this.action = mapp.getActionName();
            this.mapping = mapp;
        }

        public void setMapping(NetbeansActionMapping mapp) {
            this.mapping = mapp;
        }

        public String getActionName() {
            return this.action;
        }

        public NetbeansActionMapping getMapping() {
            return this.mapping;
        }

        public String toString() {
            if (ActionMappings.this.titles.get(this.action) != null) {
                return (String)ActionMappings.this.titles.get(this.action);
            }
            if (this.mapping != null) {
                if (this.mapping.getDisplayName() != null) {
                    return this.mapping.getDisplayName();
                }
                return this.mapping.getActionName();
            }
            return this.action;
        }

        public boolean isUserDefined() {
            return this.userDefined;
        }

        public void setUserDefined(boolean userDefined) {
            this.userDefined = userDefined;
        }
    }

    private static class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int arg2, boolean arg3, boolean arg4) {
            Component supers = super.getListCellRendererComponent((JList<?>)list, value, arg2, arg3, arg4);
            if (supers instanceof JLabel && value instanceof MappingWrapper) {
                MappingWrapper wr = (MappingWrapper)value;
                JLabel lbl = (JLabel)supers;
                if (wr.isUserDefined()) {
                    lbl.setFont(lbl.getFont().deriveFont(1));
                } else {
                    lbl.setFont(lbl.getFont().deriveFont(0));
                }
            }
            return supers;
        }
    }
}

