/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api.execute;

import java.io.File;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.execute.MavenCommandLineExecutor;
import org.netbeans.modules.maven.execute.MavenExecutor;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.openide.LifecycleManager;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;

public final class RunUtils {
    private static boolean warningShown = false;

    private RunUtils() {
    }

    public static ExecutorTask executeMaven(RunConfig config) {
        LifecycleManager.getDefault().saveAll();
        MavenCommandLineExecutor exec = new MavenCommandLineExecutor(config);
        return RunUtils.executeMavenImpl(config.getTaskDisplayName(), exec);
    }

    public static RunConfig createRunConfig(File execDir, Project prj, String displayName, List<String> goals) {
        BeanRunConfig brc = new BeanRunConfig();
        brc.setExecutionName(displayName);
        brc.setExecutionDirectory(execDir);
        brc.setProject(prj);
        brc.setTaskDisplayName(displayName);
        brc.setGoals(goals);
        return brc;
    }

    private static ExecutorTask executeMavenImpl(String runtimeName, MavenExecutor exec) {
        ExecutorTask task = ExecutionEngine.getDefault().execute(runtimeName, (Runnable)exec, exec.getInputOutput());
        exec.setTask(task);
        return task;
    }

    public static boolean hasApplicationCompileOnSaveEnabled(Project prj) {
        AuxiliaryProperties auxprops = (AuxiliaryProperties)prj.getLookup().lookup(AuxiliaryProperties.class);
        if (auxprops == null) {
            return false;
        }
        String cos = auxprops.get("netbeans.compile.on.save", true);
        return cos != null && ("all".equalsIgnoreCase(cos) || "app".equalsIgnoreCase(cos));
    }

    public static boolean hasApplicationCompileOnSaveEnabled(RunConfig config) {
        Project prj = config.getProject();
        if (prj != null) {
            return RunUtils.hasApplicationCompileOnSaveEnabled(prj);
        }
        return false;
    }

    public static boolean hasTestCompileOnSaveEnabled(Project prj) {
        AuxiliaryProperties auxprops = (AuxiliaryProperties)prj.getLookup().lookup(AuxiliaryProperties.class);
        if (auxprops == null) {
            return true;
        }
        String cos = auxprops.get("netbeans.compile.on.save", true);
        return cos == null || "all".equalsIgnoreCase(cos) || "test".equalsIgnoreCase(cos);
    }

    public static boolean hasTestCompileOnSaveEnabled(RunConfig config) {
        Project prj = config.getProject();
        if (prj != null) {
            return RunUtils.hasTestCompileOnSaveEnabled(prj);
        }
        return false;
    }
}

