/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.attribute;

import javax.lang.model.element.Element;
import org.netbeans.modules.db.api.sql.SQLKeywords;
import org.netbeans.modules.j2ee.jpa.model.AttributeWrapper;
import org.netbeans.modules.j2ee.jpa.verification.JPAEntityAttributeCheck;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.ProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.Rule;
import org.netbeans.modules.j2ee.persistence.dd.JavaPersistenceQLKeywords;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.util.NbBundle;

public class ValidColumnName
extends JPAEntityAttributeCheck {
    @Override
    public ErrorDescription[] check(JPAProblemContext ctx, AttributeWrapper attrib) {
        String columnName = attrib.getColumn().getName();
        Element javaElement = attrib.getJavaElement();
        if (columnName.length() == 0) {
            return new ErrorDescription[]{Rule.createProblem(javaElement, ctx, NbBundle.getMessage(ValidColumnName.class, (String)"MSG_AttrInvalidPersistenceQLIdentifier", (Object)columnName))};
        }
        if (JavaPersistenceQLKeywords.isKeyword((String)columnName)) {
            return new ErrorDescription[]{Rule.createProblem(javaElement, ctx, NbBundle.getMessage(ValidColumnName.class, (String)"MSG_AttrNamedWithJavaPersistenceQLKeyword", (Object)columnName))};
        }
        if (SQLKeywords.isSQL99ReservedKeyword((String)columnName)) {
            return new ErrorDescription[]{Rule.createProblem(javaElement, (ProblemContext)ctx, NbBundle.getMessage(ValidColumnName.class, (String)"MSG_AttrNamedWithReservedSQLKeyword", (Object)columnName), Severity.WARNING)};
        }
        return null;
    }
}

