/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.debug;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.groovy.support.debug.Context;
import org.netbeans.modules.groovy.support.debug.GroovyBreakpointAnnotationListener;
import org.netbeans.modules.groovy.support.debug.GroovyLineBreakpoint;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.filesystems.FileObject;

public class GroovyToggleBreakpointActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private JPDADebugger debugger;
    private GroovyBreakpointAnnotationListener GroovyBreakpointAnnotationListener;

    public GroovyToggleBreakpointActionProvider() {
        Context.addPropertyChangeListener(this);
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, false);
    }

    public GroovyToggleBreakpointActionProvider(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.debugger.addPropertyChangeListener("state", (PropertyChangeListener)this);
        Context.addPropertyChangeListener(this);
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, false);
    }

    private void destroy() {
        this.debugger.removePropertyChangeListener("state", (PropertyChangeListener)this);
        Context.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        FileObject fo = Context.getCurrentFile();
        boolean isGroovyFile = fo != null && "text/x-groovy".equals(fo.getMIMEType());
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, isGroovyFile);
        if (this.debugger != null && this.debugger.getState() == 4) {
            this.destroy();
        }
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
    }

    public void doAction(Object action) {
        DebuggerManager d = DebuggerManager.getDebuggerManager();
        int ln = Context.getCurrentLineNumber();
        String url = Context.getCurrentURL();
        if (url == null) {
            return;
        }
        GroovyLineBreakpoint lb = this.getGroovyBreakpointAnnotationListener().findBreakpoint(url, ln);
        if (lb != null) {
            d.removeBreakpoint((Breakpoint)lb);
            return;
        }
        lb = GroovyLineBreakpoint.create(url, ln);
        d.addBreakpoint((Breakpoint)lb);
    }

    private GroovyBreakpointAnnotationListener getGroovyBreakpointAnnotationListener() {
        if (this.GroovyBreakpointAnnotationListener == null) {
            this.GroovyBreakpointAnnotationListener = (GroovyBreakpointAnnotationListener)((Object)DebuggerManager.getDebuggerManager().lookupFirst(null, GroovyBreakpointAnnotationListener.class));
        }
        return this.GroovyBreakpointAnnotationListener;
    }
}

