/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.delete;

import java.util.Collections;
import java.util.Set;
import javax.swing.Action;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.ProblemDetails;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.php.delete.SafeDeleteSupport;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedQueryUI;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedSupport;
import org.netbeans.modules.refactoring.spi.ProblemDetailsFactory;
import org.netbeans.modules.refactoring.spi.ProblemDetailsImplementation;
import org.netbeans.modules.refactoring.spi.ProgressProviderAdapter;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.filesystems.FileObject;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class PhpDeleteRefactoringPlugin
extends ProgressProviderAdapter
implements RefactoringPlugin {
    private final SafeDeleteRefactoring refactoring;
    private final SafeDeleteSupport safeDeleteSupport;
    private WhereUsedQuery[] whereUsedQueries;

    public PhpDeleteRefactoringPlugin(SafeDeleteRefactoring refactoring) {
        this.refactoring = refactoring;
        this.safeDeleteSupport = (SafeDeleteSupport)this.refactoring.getRefactoringSource().lookup(SafeDeleteSupport.class);
    }

    public SafeDeleteRefactoring getRefactoring() {
        return this.refactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    public Problem checkParameters() {
        Set<ModelElement> visibleElements = this.safeDeleteSupport.getVisibleElements();
        this.whereUsedQueries = new WhereUsedQuery[visibleElements.size()];
        ElementQuery.Index idx = this.safeDeleteSupport.getIdx();
        int position = 0;
        for (ModelElement modelElement : visibleElements) {
            WhereUsedSupport support = WhereUsedSupport.getInstance(Collections.singleton(modelElement), idx, modelElement.getFileObject(), modelElement.getOffset());
            this.whereUsedQueries[position++] = new WhereUsedQuery(Lookups.singleton((Object)support));
        }
        return null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        RefactoringSession inner = RefactoringSession.create((String)"delete");
        FileObject file = this.safeDeleteSupport.getFile();
        this.fireProgressListenerStart(2, this.whereUsedQueries.length + 1);
        for (int i = 0; i < this.whereUsedQueries.length; ++i) {
            WhereUsedQuery whereUsedQuery = this.whereUsedQueries[i];
            whereUsedQuery.prepare(inner);
            this.fireProgressListenerStep();
            for (RefactoringElement refacElem : inner.getRefactoringElements()) {
                if (file == refacElem.getParentFile()) continue;
                WhereUsedSupport support = (WhereUsedSupport)whereUsedQuery.getRefactoringSource().lookup(WhereUsedSupport.class);
                ProblemDetailsImplemen problemDetailsImplemen = new ProblemDetailsImplemen(new WhereUsedQueryUI(support), inner);
                ProblemDetails problemDetails = ProblemDetailsFactory.createProblemDetails((ProblemDetailsImplementation)problemDetailsImplemen);
                Problem problem = new Problem(false, NbBundle.getMessage(PhpDeleteRefactoringPlugin.class, (String)"ERR_ReferencesFound"), problemDetails);
                if (problem == null) continue;
                this.fireProgressListenerStop();
                return problem;
            }
        }
        this.fireProgressListenerStep();
        return null;
    }

    private class ProblemDetailsImplemen
    implements ProblemDetailsImplementation {
        private RefactoringUI ui;
        private RefactoringSession rs;

        public ProblemDetailsImplemen(RefactoringUI ui, RefactoringSession rs) {
            this.ui = ui;
            this.rs = rs;
        }

        public void showDetails(Action callback, Cancellable parent) {
            parent.cancel();
            UI.openRefactoringUI((RefactoringUI)this.ui, (RefactoringSession)this.rs, (Action)callback);
        }

        public String getDetailsHint() {
            return NbBundle.getMessage(PhpDeleteRefactoringPlugin.class, (String)"LBL_ShowUsages");
        }
    }
}

