/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.spi;

import com.sun.javadoc.Doc;
import com.sun.javadoc.Tag;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.hints.jackpot.impl.JavaFixImpl;
import org.netbeans.modules.java.hints.jackpot.impl.Utilities;
import org.netbeans.modules.java.hints.jackpot.impl.pm.Pattern;
import org.netbeans.modules.java.hints.jackpot.spi.Hacks;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.modules.SpecificationVersion;

public abstract class JavaFix {
    private final TreePathHandle handle;
    private static java.util.regex.Pattern SPEC_VERSION = java.util.regex.Pattern.compile("[0-9]+(\\.[0-9]+)+");
    private static final Map<Tree.Kind, Integer> OPERATOR_PRIORITIES = new EnumMap<Tree.Kind, Integer>(Tree.Kind.class);

    protected JavaFix(CompilationInfo info, TreePath tp) {
        this.handle = TreePathHandle.create((TreePath)tp, (CompilationInfo)info);
    }

    protected abstract String getText();

    protected abstract void performRewrite(WorkingCopy var1, TreePath var2, UpgradeUICallback var3);

    final ChangeInfo process(WorkingCopy wc, UpgradeUICallback callback) throws Exception {
        TreePath tp = this.handle.resolve((CompilationInfo)wc);
        if (tp == null) {
            Logger.getLogger(JavaFix.class.getName()).log(Level.SEVERE, "Cannot resolve handle={0}", this.handle);
            return null;
        }
        this.performRewrite(wc, tp, callback);
        return null;
    }

    final FileObject getFile() {
        return this.handle.getFileObject();
    }

    public static Fix rewriteFix(HintContext ctx, String displayName, TreePath what, String to, String ... imports) {
        return JavaFix.rewriteFix(ctx, displayName, what, to, Collections.<String, TypeMirror>emptyMap(), imports);
    }

    public static Fix rewriteFix(HintContext ctx, String displayName, TreePath what, String to, Map<String, TypeMirror> constraints, String ... imports) {
        return JavaFix.rewriteFix(ctx.getInfo(), displayName, what, to, ctx.getVariables(), ctx.getMultiVariables(), ctx.getVariableNames(), constraints, imports);
    }

    public static Fix rewriteFix(CompilationInfo info, String displayName, TreePath what, String to, Map<String, TreePath> parameters, Map<String, Collection<? extends TreePath>> parametersMulti, Map<String, String> parameterNames, Map<String, TypeMirror> constraints, String ... imports) {
        HashMap<String, TreePathHandle> params = new HashMap<String, TreePathHandle>();
        for (Map.Entry<String, TreePath> e : parameters.entrySet()) {
            params.put(e.getKey(), TreePathHandle.create((TreePath)e.getValue(), (CompilationInfo)info));
        }
        HashMap<String, Collection<TreePathHandle>> paramsMulti = new HashMap<String, Collection<TreePathHandle>>();
        for (Map.Entry<String, Collection<? extends TreePath>> e : parametersMulti.entrySet()) {
            LinkedList<TreePathHandle> tph = new LinkedList<TreePathHandle>();
            for (TreePath treePath : e.getValue()) {
                tph.add(TreePathHandle.create((TreePath)treePath, (CompilationInfo)info));
            }
            paramsMulti.put(e.getKey(), tph);
        }
        HashMap constraintsHandles = new HashMap();
        for (Map.Entry<String, TypeMirror> c : constraints.entrySet()) {
            constraintsHandles.put(c.getKey(), TypeMirrorHandle.create((TypeMirror)c.getValue()));
        }
        if (displayName == null) {
            displayName = JavaFix.defaultFixDisplayName(info, parameters, to);
        }
        return JavaFix.toEditorFix(new JavaFixRealImpl(info, what, displayName, to, params, paramsMulti, parameterNames, constraintsHandles, Arrays.asList(imports)));
    }

    private static boolean isFakeBlock(Tree t) {
        if (!(t instanceof BlockTree)) {
            return false;
        }
        BlockTree bt = (BlockTree)t;
        if (bt.getStatements().isEmpty()) {
            return false;
        }
        CharSequence wildcardTreeName = Utilities.getWildcardTreeName(bt.getStatements().get(0));
        if (wildcardTreeName == null) {
            return false;
        }
        return ((Object)wildcardTreeName).toString().startsWith("$$");
    }

    private static boolean isFakeClass(Tree t) {
        if (!(t instanceof ClassTree)) {
            return false;
        }
        ClassTree ct = (ClassTree)t;
        if (ct.getMembers().isEmpty()) {
            return false;
        }
        CharSequence wildcardTreeName = Utilities.getWildcardTreeName(ct.getMembers().get(0));
        if (wildcardTreeName == null) {
            return false;
        }
        return ((Object)wildcardTreeName).toString().startsWith("$$");
    }

    private static String defaultFixDisplayName(CompilationInfo info, Map<String, TreePath> variables, String replaceTarget) {
        HashMap<String, String> stringsForVariables = new HashMap<String, String>();
        for (Map.Entry<String, TreePath> entry : variables.entrySet()) {
            Tree t = entry.getValue().getLeaf();
            SourcePositions sp = info.getTrees().getSourcePositions();
            int startPos = (int)sp.getStartPosition(info.getCompilationUnit(), t);
            int endPos = (int)sp.getEndPosition(info.getCompilationUnit(), t);
            if (startPos >= 0 && endPos >= 0) {
                stringsForVariables.put(entry.getKey(), info.getText().substring(startPos, endPos));
                continue;
            }
            stringsForVariables.put(entry.getKey(), "");
        }
        if (!stringsForVariables.containsKey("$this")) {
            stringsForVariables.put("$this", "this");
        }
        for (Map.Entry<String, TreePath> entry : stringsForVariables.entrySet()) {
            String quotedVariable = java.util.regex.Pattern.quote(entry.getKey());
            String quotedTarget = Matcher.quoteReplacement((String)((Object)entry.getValue()));
            replaceTarget = replaceTarget.replaceAll(quotedVariable, quotedTarget);
        }
        return "Rewrite to " + replaceTarget;
    }

    private static void checkDependency(WorkingCopy copy, Element e, UpgradeUICallback callback) {
        SpecificationVersion sv = JavaFix.computeSpecVersion((CompilationInfo)copy, e);
        while (sv == null && e.getKind() != ElementKind.PACKAGE) {
            e = e.getEnclosingElement();
            sv = JavaFix.computeSpecVersion((CompilationInfo)copy, e);
        }
        if (sv == null) {
            return;
        }
        Project currentProject = FileOwnerQuery.getOwner((FileObject)copy.getFileObject());
        if (currentProject == null) {
            return;
        }
        FileObject file = JavaFix.getFile(copy, e);
        if (file == null) {
            return;
        }
        Project referedProject = FileOwnerQuery.getOwner((FileObject)file);
        if (referedProject == null || currentProject.getProjectDirectory().equals(referedProject.getProjectDirectory())) {
            return;
        }
        JavaFix.resolveNbModuleDependencies(currentProject, referedProject, sv, callback);
    }

    public static SpecificationVersion computeSpecVersion(CompilationInfo info, Element el) {
        Doc javaDoc = info.getElementUtilities().javaDocFor(el);
        if (javaDoc == null) {
            return null;
        }
        for (Tag since : javaDoc.tags("@since")) {
            String text = since.text();
            Matcher m = SPEC_VERSION.matcher(text);
            if (!m.find()) continue;
            return new SpecificationVersion(m.group());
        }
        return null;
    }

    public static Fix toEditorFix(JavaFix jf) {
        return new JavaFixImpl(jf);
    }

    private static void resolveNbModuleDependencies(Project currentProject, Project referedProject, SpecificationVersion sv, UpgradeUICallback callback) throws IllegalArgumentException {
    }

    private static FileObject getFile(WorkingCopy copy, Element e) {
        return SourceUtils.getFile((Element)e, (ClasspathInfo)copy.getClasspathInfo());
    }

    private static boolean isStaticElement(Element el) {
        if (el == null) {
            return false;
        }
        if (el.getModifiers().contains((Object)Modifier.STATIC)) {
            return el.getKind().isClass() || el.getKind().isInterface();
        }
        if (el.getKind().isClass() || el.getKind().isInterface()) {
            return el.getEnclosingElement().getKind() == ElementKind.PACKAGE;
        }
        return false;
    }

    protected static boolean requiresParenthesis(Tree inner, Tree original, Tree outter) {
        if (!ExpressionTree.class.isAssignableFrom(inner.getKind().asInterface())) {
            return false;
        }
        if (!ExpressionTree.class.isAssignableFrom(outter.getKind().asInterface())) {
            return false;
        }
        if (outter.getKind() == Tree.Kind.PARENTHESIZED || inner.getKind() == Tree.Kind.PARENTHESIZED) {
            return false;
        }
        Integer innerPriority = OPERATOR_PRIORITIES.get((Object)inner.getKind());
        Integer outterPriority = OPERATOR_PRIORITIES.get((Object)outter.getKind());
        if (innerPriority == null || outterPriority == null) {
            Logger.getLogger(JavaFix.class.getName()).log(Level.WARNING, "Unknown tree kind(s): {0}/{1}", new Object[]{inner.getKind(), outter.getKind()});
            return true;
        }
        if (innerPriority > outterPriority) {
            return true;
        }
        if (innerPriority < outterPriority) {
            return false;
        }
        if (BinaryTree.class.isAssignableFrom(outter.getKind().asInterface())) {
            BinaryTree ot = (BinaryTree)outter;
            return ot.getRightOperand() == original;
        }
        if (CompoundAssignmentTree.class.isAssignableFrom(outter.getKind().asInterface())) {
            CompoundAssignmentTree ot = (CompoundAssignmentTree)outter;
            return ot.getVariable() == original;
        }
        if (AssignmentTree.class.isAssignableFrom(outter.getKind().asInterface())) {
            AssignmentTree ot = (AssignmentTree)outter;
            return ot.getVariable() == original;
        }
        return false;
    }

    static {
        OPERATOR_PRIORITIES.put(Tree.Kind.IDENTIFIER, 0);
        for (Tree.Kind k : Tree.Kind.values()) {
            if (k.asInterface() != LiteralTree.class) continue;
            OPERATOR_PRIORITIES.put(k, 0);
        }
        OPERATOR_PRIORITIES.put(Tree.Kind.ARRAY_ACCESS, 1);
        OPERATOR_PRIORITIES.put(Tree.Kind.METHOD_INVOCATION, 1);
        OPERATOR_PRIORITIES.put(Tree.Kind.MEMBER_SELECT, 1);
        OPERATOR_PRIORITIES.put(Tree.Kind.POSTFIX_DECREMENT, 1);
        OPERATOR_PRIORITIES.put(Tree.Kind.POSTFIX_INCREMENT, 1);
        OPERATOR_PRIORITIES.put(Tree.Kind.NEW_ARRAY, 1);
        OPERATOR_PRIORITIES.put(Tree.Kind.NEW_CLASS, 1);
        OPERATOR_PRIORITIES.put(Tree.Kind.BITWISE_COMPLEMENT, 2);
        OPERATOR_PRIORITIES.put(Tree.Kind.LOGICAL_COMPLEMENT, 2);
        OPERATOR_PRIORITIES.put(Tree.Kind.PREFIX_DECREMENT, 2);
        OPERATOR_PRIORITIES.put(Tree.Kind.PREFIX_INCREMENT, 2);
        OPERATOR_PRIORITIES.put(Tree.Kind.UNARY_MINUS, 2);
        OPERATOR_PRIORITIES.put(Tree.Kind.UNARY_PLUS, 2);
        OPERATOR_PRIORITIES.put(Tree.Kind.TYPE_CAST, 3);
        OPERATOR_PRIORITIES.put(Tree.Kind.DIVIDE, 4);
        OPERATOR_PRIORITIES.put(Tree.Kind.MULTIPLY, 4);
        OPERATOR_PRIORITIES.put(Tree.Kind.REMAINDER, 4);
        OPERATOR_PRIORITIES.put(Tree.Kind.MINUS, 5);
        OPERATOR_PRIORITIES.put(Tree.Kind.PLUS, 5);
        OPERATOR_PRIORITIES.put(Tree.Kind.LEFT_SHIFT, 6);
        OPERATOR_PRIORITIES.put(Tree.Kind.RIGHT_SHIFT, 6);
        OPERATOR_PRIORITIES.put(Tree.Kind.UNSIGNED_RIGHT_SHIFT, 6);
        OPERATOR_PRIORITIES.put(Tree.Kind.INSTANCE_OF, 7);
        OPERATOR_PRIORITIES.put(Tree.Kind.GREATER_THAN, 7);
        OPERATOR_PRIORITIES.put(Tree.Kind.GREATER_THAN_EQUAL, 7);
        OPERATOR_PRIORITIES.put(Tree.Kind.LESS_THAN, 7);
        OPERATOR_PRIORITIES.put(Tree.Kind.LESS_THAN_EQUAL, 7);
        OPERATOR_PRIORITIES.put(Tree.Kind.EQUAL_TO, 8);
        OPERATOR_PRIORITIES.put(Tree.Kind.NOT_EQUAL_TO, 8);
        OPERATOR_PRIORITIES.put(Tree.Kind.AND, 9);
        OPERATOR_PRIORITIES.put(Tree.Kind.OR, 11);
        OPERATOR_PRIORITIES.put(Tree.Kind.XOR, 10);
        OPERATOR_PRIORITIES.put(Tree.Kind.CONDITIONAL_AND, 12);
        OPERATOR_PRIORITIES.put(Tree.Kind.CONDITIONAL_OR, 13);
        OPERATOR_PRIORITIES.put(Tree.Kind.CONDITIONAL_EXPRESSION, 14);
        OPERATOR_PRIORITIES.put(Tree.Kind.AND_ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.DIVIDE_ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.LEFT_SHIFT_ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.MINUS_ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.MULTIPLY_ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.OR_ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.PLUS_ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.REMAINDER_ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, 15);
        OPERATOR_PRIORITIES.put(Tree.Kind.XOR_ASSIGNMENT, 15);
        JavaFixImpl.Accessor.INSTANCE = new JavaFixImpl.Accessor(){

            @Override
            public String getText(JavaFix jf) {
                return jf.getText();
            }

            @Override
            public ChangeInfo process(JavaFix jf, WorkingCopy wc, UpgradeUICallback callback) throws Exception {
                return jf.process(wc, callback);
            }

            @Override
            public FileObject getFile(JavaFix jf) {
                return jf.getFile();
            }
        };
    }

    private static class JavaFixRealImpl
    extends JavaFix {
        private final String displayName;
        private final Map<String, TreePathHandle> params;
        private final Map<String, Collection<TreePathHandle>> paramsMulti;
        private final Map<String, String> parameterNames;
        private final Map<String, TypeMirrorHandle<?>> constraintsHandles;
        private final Iterable<? extends String> imports;
        private final String to;

        public JavaFixRealImpl(CompilationInfo info, TreePath what, String displayName, String to, Map<String, TreePathHandle> params, Map<String, Collection<TreePathHandle>> paramsMulti, Map<String, String> parameterNames, Map<String, TypeMirrorHandle<?>> constraintsHandles, Iterable<? extends String> imports) {
            super(info, what);
            this.displayName = displayName;
            this.to = to;
            this.params = params;
            this.paramsMulti = paramsMulti;
            this.parameterNames = parameterNames;
            this.constraintsHandles = constraintsHandles;
            this.imports = imports;
        }

        @Override
        protected String getText() {
            return this.displayName;
        }

        @Override
        protected void performRewrite(final WorkingCopy wc, TreePath tp, final UpgradeUICallback callback) {
            TreePath parent;
            final HashMap<String, TreePath> parameters = new HashMap<String, TreePath>();
            for (Map.Entry<String, TreePathHandle> e : this.params.entrySet()) {
                TreePath p = e.getValue().resolve((CompilationInfo)wc);
                if (p == null) {
                    Logger.getLogger(JavaFix.class.getName()).log(Level.SEVERE, "Cannot resolve handle={0}", e.getValue());
                }
                parameters.put(e.getKey(), p);
            }
            final HashMap parametersMulti = new HashMap();
            for (Map.Entry<String, Collection<TreePathHandle>> e : this.paramsMulti.entrySet()) {
                LinkedList<TreePath> tps = new LinkedList<TreePath>();
                for (TreePathHandle tph : e.getValue()) {
                    TreePath p = tph.resolve((CompilationInfo)wc);
                    if (p == null) {
                        Logger.getLogger(JavaFix.class.getName()).log(Level.SEVERE, "Cannot resolve handle={0}", e.getValue());
                    }
                    tps.add(p);
                }
                parametersMulti.put(e.getKey(), tps);
            }
            HashMap<String, TypeMirror> constraints = new HashMap<String, TypeMirror>();
            for (Map.Entry<String, TypeMirrorHandle<?>> c : this.constraintsHandles.entrySet()) {
                constraints.put(c.getKey(), c.getValue().resolve((CompilationInfo)wc));
            }
            Tree parsed = Pattern.parseAndAttribute((CompilationInfo)wc, this.to, constraints, new Scope[1], this.imports);
            if (!(JavaFix.isFakeBlock(parsed) || JavaFix.isFakeClass(parsed) || tp.getLeaf().getKind() == Tree.Kind.BLOCK && parametersMulti.containsKey("$$1$") && parsed.getKind() != Tree.Kind.BLOCK)) {
                wc.rewrite(tp.getLeaf(), parsed);
            } else if (JavaFix.isFakeBlock(parsed)) {
                if (tp.getLeaf().getKind() == Tree.Kind.BLOCK && parametersMulti.containsKey("$$1$")) {
                    wc.rewrite(tp.getLeaf(), parsed);
                } else {
                    parent = tp.getParentPath();
                    List<? extends StatementTree> statements = ((BlockTree)parsed).getStatements();
                    statements = statements.subList(1, statements.size() - 1);
                    if (parent.getLeaf().getKind() == Tree.Kind.BLOCK) {
                        LinkedList<? extends StatementTree> newStatements = new LinkedList<StatementTree>();
                        for (StatementTree statementTree : ((BlockTree)parent.getLeaf()).getStatements()) {
                            if (statementTree == tp.getLeaf()) {
                                newStatements.addAll(statements);
                                continue;
                            }
                            newStatements.add(statementTree);
                        }
                        wc.rewrite(parent.getLeaf(), (Tree)wc.getTreeMaker().Block(newStatements, ((BlockTree)parent.getLeaf()).isStatic()));
                    } else {
                        wc.rewrite(tp.getLeaf(), (Tree)wc.getTreeMaker().Block(statements, false));
                    }
                }
            } else if (JavaFix.isFakeClass(parsed)) {
                parent = tp.getParentPath();
                List<? extends Tree> members = ((ClassTree)parsed).getMembers();
                members = members.subList(1, members.size());
                assert (TreeUtilities.CLASS_TREE_KINDS.contains((Object)parent.getLeaf().getKind()));
                LinkedList<? extends Tree> newMembers = new LinkedList<Tree>();
                ClassTree ct = (ClassTree)parent.getLeaf();
                for (Tree tree : ct.getMembers()) {
                    if (tree == tp.getLeaf()) {
                        newMembers.addAll(members);
                        continue;
                    }
                    newMembers.add(tree);
                }
                wc.rewrite(parent.getLeaf(), (Tree)wc.getTreeMaker().Class(ct.getModifiers(), (CharSequence)ct.getSimpleName(), ct.getTypeParameters(), ct.getExtendsClause(), ct.getImplementsClause(), newMembers));
            } else {
                LinkedList<StatementTree> newStatements = new LinkedList<StatementTree>();
                newStatements.add(wc.getTreeMaker().ExpressionStatement((ExpressionTree)wc.getTreeMaker().Identifier((CharSequence)"$$1$")));
                newStatements.add((StatementTree)parsed);
                newStatements.add(wc.getTreeMaker().ExpressionStatement((ExpressionTree)wc.getTreeMaker().Identifier((CharSequence)"$$2$")));
                parsed = wc.getTreeMaker().Block(newStatements, ((BlockTree)tp.getLeaf()).isStatic());
                wc.rewrite(tp.getLeaf(), parsed);
            }
            new TreePathScanner<Void, Void>(){

                @Override
                public Void visitIdentifier(IdentifierTree node, Void p) {
                    String variableName;
                    String name = node.getName().toString();
                    TreePath tp = (TreePath)parameters.get(name);
                    if (tp != null) {
                        if (tp.getLeaf() instanceof Hacks.RenameTree) {
                            Hacks.RenameTree rt = (Hacks.RenameTree)tp.getLeaf();
                            Tree nue = wc.getTreeMaker().setLabel(rt.originalTree, (CharSequence)rt.newName);
                            wc.rewrite((Tree)node, nue);
                            return null;
                        }
                        if (!JavaFixRealImpl.this.parameterNames.containsKey(name)) {
                            Tree target = tp.getLeaf();
                            if (JavaFix.requiresParenthesis(target, node, this.getCurrentPath().getParentPath().getLeaf())) {
                                target = wc.getTreeMaker().Parenthesized((ExpressionTree)target);
                            }
                            wc.rewrite((Tree)node, target);
                            return null;
                        }
                    }
                    if ((variableName = (String)JavaFixRealImpl.this.parameterNames.get(name)) != null) {
                        wc.rewrite((Tree)node, (Tree)wc.getTreeMaker().Identifier((CharSequence)variableName));
                        return null;
                    }
                    Element e = wc.getTrees().getElement(this.getCurrentPath());
                    if (e != null && JavaFix.isStaticElement(e)) {
                        wc.rewrite((Tree)node, (Tree)wc.getTreeMaker().QualIdent(e));
                    }
                    return (Void)super.visitIdentifier(node, p);
                }

                @Override
                public Void visitMemberSelect(MemberSelectTree node, Void p) {
                    Element e = wc.getTrees().getElement(this.getCurrentPath());
                    if (e == null || e.getKind() == ElementKind.CLASS && ((TypeElement)e).asType().getKind() == TypeKind.ERROR) {
                        String name;
                        if (node.getExpression().getKind() == Tree.Kind.IDENTIFIER && (name = ((IdentifierTree)node.getExpression()).getName().toString()).startsWith("$") && parameters.get(name) == null) {
                            wc.rewrite((Tree)node, (Tree)wc.getTreeMaker().Identifier((CharSequence)node.getIdentifier()));
                            return null;
                        }
                        return (Void)super.visitMemberSelect(node, p);
                    }
                    JavaFix.checkDependency(wc, e, callback);
                    if (JavaFix.isStaticElement(e)) {
                        wc.rewrite((Tree)node, (Tree)wc.getTreeMaker().QualIdent(e));
                        return null;
                    }
                    return (Void)super.visitMemberSelect(node, p);
                }

                @Override
                public Void visitVariable(VariableTree node, Void p) {
                    String nueName;
                    String name = node.getName().toString();
                    if (name.startsWith("$") && (nueName = (String)JavaFixRealImpl.this.parameterNames.get(name)) != null) {
                        VariableTree nue = wc.getTreeMaker().Variable(node.getModifiers(), (CharSequence)nueName, node.getType(), node.getInitializer());
                        wc.rewrite((Tree)node, (Tree)nue);
                        return (Void)super.visitVariable(nue, p);
                    }
                    return (Void)super.visitVariable(node, p);
                }

                @Override
                public Void visitExpressionStatement(ExpressionStatementTree node, Void p) {
                    TreePath tp;
                    CharSequence name = Utilities.getWildcardTreeName(node);
                    if (name != null && (tp = (TreePath)parameters.get(((Object)name).toString())) != null) {
                        wc.rewrite((Tree)node, tp.getLeaf());
                        return null;
                    }
                    return (Void)super.visitExpressionStatement(node, p);
                }

                @Override
                public Void visitBlock(BlockTree node, Void p) {
                    List<? extends StatementTree> nueStatement = this.resolveMultiParameters(node.getStatements());
                    BlockTree nue = wc.getTreeMaker().Block(nueStatement, node.isStatic());
                    wc.rewrite((Tree)node, (Tree)nue);
                    return (Void)super.visitBlock(nue, p);
                }

                @Override
                public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
                    List<? extends Tree> typeArgs = this.resolveMultiParameters(node.getTypeArguments());
                    List<? extends ExpressionTree> args = this.resolveMultiParameters(node.getArguments());
                    MethodInvocationTree nue = wc.getTreeMaker().MethodInvocation(typeArgs, node.getMethodSelect(), args);
                    wc.rewrite((Tree)node, (Tree)nue);
                    return (Void)super.visitMethodInvocation(nue, p);
                }

                @Override
                public Void visitNewClass(NewClassTree node, Void p) {
                    List<? extends Tree> typeArgs = this.resolveMultiParameters(node.getTypeArguments());
                    List<? extends ExpressionTree> args = this.resolveMultiParameters(node.getArguments());
                    NewClassTree nue = wc.getTreeMaker().NewClass(node.getEnclosingExpression(), typeArgs, node.getIdentifier(), args, node.getClassBody());
                    wc.rewrite((Tree)node, (Tree)nue);
                    return (Void)super.visitNewClass(nue, p);
                }

                @Override
                public Void visitParameterizedType(ParameterizedTypeTree node, Void p) {
                    List<? extends Tree> typeArgs = this.resolveMultiParameters(node.getTypeArguments());
                    ParameterizedTypeTree nue = wc.getTreeMaker().ParameterizedType(node.getType(), typeArgs);
                    wc.rewrite((Tree)node, (Tree)nue);
                    return (Void)super.visitParameterizedType(node, p);
                }

                @Override
                public Void visitTry(TryTree node, Void p) {
                    List<? extends CatchTree> catches = this.resolveMultiParameters(node.getCatches());
                    TryTree nue = wc.getTreeMaker().Try(node.getResources(), node.getBlock(), catches, node.getFinallyBlock());
                    wc.rewrite((Tree)node, (Tree)nue);
                    return (Void)super.visitTry(node, p);
                }

                private <T extends Tree> List<T> resolveMultiParameters(List<T> list) {
                    if (!Utilities.containsMultistatementTrees(list)) {
                        return list;
                    }
                    LinkedList<Tree> result = new LinkedList<Tree>();
                    for (Tree t : list) {
                        if (Utilities.isMultistatementWildcardTree(t)) {
                            Collection embedded = (Collection)parametersMulti.get(((Object)Utilities.getWildcardTreeName(t)).toString());
                            if (embedded == null) continue;
                            for (TreePath tp : embedded) {
                                result.add(tp.getLeaf());
                            }
                            continue;
                        }
                        result.add(t);
                    }
                    return result;
                }
            }.scan(new TreePath(tp.getParentPath(), parsed), (Void)null);
        }
    }

    public static interface UpgradeUICallback {
        public boolean shouldUpgrade(String var1);
    }
}

