/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.impl;

import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.jackpot.spi.ClassPathBasedHintProvider;
import org.netbeans.modules.java.hints.jackpot.spi.ElementBasedHintProvider;
import org.netbeans.modules.java.hints.jackpot.spi.HintDescription;
import org.netbeans.modules.java.hints.jackpot.spi.HintMetadata;
import org.netbeans.modules.java.hints.jackpot.spi.HintProvider;
import org.netbeans.modules.java.hints.options.HintsSettings;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public class RulesManager {
    private final Map<Tree.Kind, List<HintDescription>> kind2Hints = new HashMap<Tree.Kind, List<HintDescription>>();
    private final Map<HintDescription.PatternDescription, List<HintDescription>> pattern2Hint = new HashMap<HintDescription.PatternDescription, List<HintDescription>>();
    public final Map<HintMetadata, Collection<? extends HintDescription>> allHints = new HashMap<HintMetadata, Collection<? extends HintDescription>>();
    private static final RulesManager INSTANCE = new RulesManager();

    public static RulesManager getInstance() {
        return INSTANCE;
    }

    private RulesManager() {
        for (HintProvider p : Lookup.getDefault().lookupAll(HintProvider.class)) {
            Map<HintMetadata, ? extends Collection<? extends HintDescription>> pHints = p.computeHints();
            for (Collection<? extends HintDescription> collection : pHints.values()) {
                RulesManager.sortOut(collection, this.kind2Hints, this.pattern2Hint);
            }
            this.allHints.putAll(pHints);
        }
    }

    public Map<Tree.Kind, List<HintDescription>> getKindBasedHints() {
        return this.kind2Hints;
    }

    public Map<HintDescription.PatternDescription, List<HintDescription>> getPatternBasedHints() {
        return this.pattern2Hint;
    }

    public static void computeElementBasedHintsXXX(CompilationInfo info, AtomicBoolean cancel, Map<Tree.Kind, List<HintDescription>> kind2Hints, Map<HintDescription.PatternDescription, List<HintDescription>> pattern2Hint) {
        RulesManager.computeElementBasedHintsXXX(info, cancel, Lookup.getDefault().lookupAll(ElementBasedHintProvider.class), Lookup.getDefault().lookupAll(ClassPathBasedHintProvider.class), kind2Hints, pattern2Hint);
    }

    public static void computeElementBasedHintsXXX(CompilationInfo info, AtomicBoolean cancel, Collection<? extends ElementBasedHintProvider> providers, Collection<? extends ClassPathBasedHintProvider> cpBasedProviders, Map<Tree.Kind, List<HintDescription>> kind2Hints, Map<HintDescription.PatternDescription, List<HintDescription>> pattern2Hint) {
        for (ElementBasedHintProvider elementBasedHintProvider : providers) {
            RulesManager.sortOut(elementBasedHintProvider.computeHints(info), kind2Hints, pattern2Hint);
        }
        ClasspathInfo cpInfo = info.getClasspathInfo();
        LinkedList<ClassPath> linkedList = new LinkedList<ClassPath>();
        linkedList.add(cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT));
        linkedList.add(cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE));
        linkedList.add(cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE));
        ClassPath compound = ClassPathSupport.createProxyClassPath((ClassPath[])linkedList.toArray(new ClassPath[0]));
        for (ClassPathBasedHintProvider classPathBasedHintProvider : cpBasedProviders) {
            RulesManager.sortOut(classPathBasedHintProvider.computeHints(compound), kind2Hints, pattern2Hint);
        }
    }

    public static void sortOut(Iterable<? extends HintDescription> hints, Map<Tree.Kind, List<HintDescription>> kind2Hints, Map<HintDescription.PatternDescription, List<HintDescription>> pattern2Hint) {
        for (HintDescription hintDescription : hints) {
            List<HintDescription> l;
            if (hintDescription.getTriggerKind() != null) {
                l = kind2Hints.get((Object)hintDescription.getTriggerKind());
                if (l == null) {
                    l = new LinkedList<HintDescription>();
                    kind2Hints.put(hintDescription.getTriggerKind(), l);
                }
                l.add(hintDescription);
            }
            if (hintDescription.getTriggerPattern() == null) continue;
            l = pattern2Hint.get(hintDescription.getTriggerPattern());
            if (l == null) {
                l = new LinkedList<HintDescription>();
                pattern2Hint.put(hintDescription.getTriggerPattern(), l);
            }
            l.add(hintDescription);
        }
    }

    public static Preferences getPreferences(String hintId, String profile) {
        Preferences p;
        Map<String, Preferences> override = HintsSettings.getPreferencesOverride();
        if (override != null && (p = override.get(hintId)) != null) {
            return p;
        }
        profile = profile == null ? HintsSettings.getCurrentProfileId() : profile;
        return NbPreferences.forModule(RulesManager.class).node(profile).node(hintId);
    }
}

