/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.java.hints.errors.AddParameterOrLocalFix;
import org.netbeans.modules.java.hints.errors.CreateClassFix;
import org.netbeans.modules.java.hints.errors.CreateElementUtilities;
import org.netbeans.modules.java.hints.errors.CreateEnumConstant;
import org.netbeans.modules.java.hints.errors.CreateFieldFix;
import org.netbeans.modules.java.hints.errors.CreateMethodFix;
import org.netbeans.modules.java.hints.errors.ErrorFixesFakeHint;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.infrastructure.ErrorHintsProvider;
import org.netbeans.modules.java.hints.infrastructure.Pair;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class CreateElement
implements ErrorRule<Void> {
    @Override
    public Set<String> getCodes() {
        return new HashSet<String>(Arrays.asList("compiler.err.cant.resolve.location", "compiler.err.cant.resolve.location.args", "compiler.err.cant.apply.symbol", "compiler.err.cant.apply.symbol.1", "compiler.err.cant.resolve", "compiler.err.cant.resolve.args"));
    }

    @Override
    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        try {
            return CreateElement.analyze(info, offset);
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
        catch (ClassCastException e) {
            Logger.getLogger(CreateElement.class.getName()).log(Level.FINE, null, e);
            return null;
        }
    }

    static List<Fix> analyze(CompilationInfo info, int offset) throws IOException {
        TypeElement outermostTypeElement;
        TreePath errorPath = ErrorHintsProvider.findUnresolvedElement(info, offset);
        if (errorPath == null) {
            return Collections.emptyList();
        }
        if (info.getElements().getTypeElement("java.lang.Object") == null) {
            return Collections.emptyList();
        }
        TreePath parent = null;
        TreePath firstClass = null;
        TreePath firstMethod = null;
        TreePath firstInitializer = null;
        TreePath methodInvocation = null;
        TreePath newClass = null;
        boolean baseType = false;
        boolean lookupMethodInvocation = true;
        boolean lookupNCT = true;
        for (TreePath path = info.getTreeUtilities().pathFor(Math.max((int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), errorPath.getLeaf()), offset) + 1); path != null; path = path.getParentPath()) {
            Tree leaf = path.getLeaf();
            Tree.Kind leafKind = leaf.getKind();
            if (!baseType && TreeUtilities.CLASS_TREE_KINDS.contains((Object)leafKind) && parent != null && (((ClassTree)leaf).getExtendsClause() == parent.getLeaf() || ((ClassTree)leaf).getImplementsClause().contains(parent.getLeaf()))) {
                baseType = true;
            }
            if (parent != null && parent.getLeaf() == errorPath.getLeaf()) {
                parent = path;
            }
            if (leaf == errorPath.getLeaf() && parent == null) {
                parent = path;
            }
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)leafKind) && firstClass == null) {
                firstClass = path;
            }
            if (leafKind == Tree.Kind.METHOD && firstMethod == null && firstClass == null) {
                firstMethod = path;
            }
            if (leafKind == Tree.Kind.BLOCK && TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getParentPath().getLeaf().getKind()) && firstMethod == null && firstClass == null) {
                firstInitializer = path;
            }
            if (lookupMethodInvocation && leafKind == Tree.Kind.METHOD_INVOCATION) {
                methodInvocation = path;
            }
            if (lookupNCT && leafKind == Tree.Kind.NEW_CLASS) {
                newClass = path;
            }
            if (leafKind == Tree.Kind.MEMBER_SELECT) {
                boolean bl = lookupMethodInvocation = leaf == errorPath.getLeaf();
            }
            if (leafKind != Tree.Kind.MEMBER_SELECT && leafKind != Tree.Kind.IDENTIFIER) {
                lookupMethodInvocation = false;
            }
            if (leafKind == Tree.Kind.MEMBER_SELECT || leafKind == Tree.Kind.IDENTIFIER || leafKind == Tree.Kind.PARAMETERIZED_TYPE) continue;
            lookupNCT = false;
        }
        if (parent == null || parent.getLeaf() == errorPath.getLeaf()) {
            return Collections.emptyList();
        }
        Element e = info.getTrees().getElement(errorPath);
        if (e == null) {
            return Collections.emptyList();
        }
        EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
        Name name = e.getSimpleName();
        if (name == null) {
            if (ErrorHintsProvider.ERR.isLoggable(1)) {
                ErrorHintsProvider.ERR.log(1, "e.simpleName=null");
                ErrorHintsProvider.ERR.log(1, "offset=" + offset);
                ErrorHintsProvider.ERR.log(1, "errorTree=" + errorPath.getLeaf());
            }
            return Collections.emptyList();
        }
        String simpleName = name.toString();
        TypeElement source = firstClass != null ? (TypeElement)info.getTrees().getElement(firstClass) : null;
        Element target = null;
        boolean wasMemberSelect = false;
        if (errorPath.getLeaf().getKind() == Tree.Kind.MEMBER_SELECT) {
            TreePath exp = new TreePath(errorPath, ((MemberSelectTree)errorPath.getLeaf()).getExpression());
            TypeMirror targetType = info.getTrees().getTypeMirror(exp);
            if (targetType != null) {
                if (targetType.getKind() == TypeKind.DECLARED) {
                    Element targetElement;
                    Element expElement = info.getTrees().getElement(exp);
                    if (CreateElement.isClassLikeElement(expElement)) {
                        modifiers.add(Modifier.STATIC);
                    }
                    if (CreateElement.isClassLikeElement(targetElement = info.getTypes().asElement(targetType))) {
                        target = (TypeElement)targetElement;
                    }
                } else if (targetType.getKind() == TypeKind.PACKAGE) {
                    target = info.getTrees().getElement(exp);
                }
            }
            wasMemberSelect = true;
        } else {
            Element enclosingElement = e.getEnclosingElement();
            if (enclosingElement != null && enclosingElement.getKind() == ElementKind.ANNOTATION_TYPE) {
                target = enclosingElement;
            } else if (errorPath.getLeaf().getKind() == Tree.Kind.IDENTIFIER) {
                target = source;
                if (firstMethod != null) {
                    if (((MethodTree)firstMethod.getLeaf()).getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
                        modifiers.add(Modifier.STATIC);
                    }
                } else if (firstInitializer != null && ((BlockTree)firstInitializer.getLeaf()).isStatic()) {
                    modifiers.add(Modifier.STATIC);
                }
            }
        }
        if (target == null) {
            if (ErrorHintsProvider.ERR.isLoggable(1)) {
                ErrorHintsProvider.ERR.log(1, "target=null");
                ErrorHintsProvider.ERR.log(1, "offset=" + offset);
                ErrorHintsProvider.ERR.log(1, "errorTree=" + errorPath.getLeaf());
            }
            return Collections.emptyList();
        }
        if (target instanceof TypeElement) {
            modifiers.addAll(CreateElement.getAccessModifiers(info, source, (TypeElement)target));
        } else {
            modifiers.add(Modifier.PUBLIC);
        }
        ArrayList<Fix> result = new ArrayList<Fix>();
        if (methodInvocation != null) {
            MethodInvocationTree mit = (MethodInvocationTree)methodInvocation.getLeaf();
            EnumSet<ElementKind> fixTypes = EnumSet.noneOf(ElementKind.class);
            List<? extends TypeMirror> types = CreateElementUtilities.resolveType(fixTypes, info, methodInvocation.getParentPath(), methodInvocation.getLeaf(), offset, null, null);
            if (types == null || types.isEmpty()) {
                return Collections.emptyList();
            }
            result.addAll(CreateElement.prepareCreateMethodFix(info, methodInvocation, modifiers, (TypeElement)target, simpleName, mit.getArguments(), types));
        }
        EnumSet<ElementKind> fixTypes = EnumSet.noneOf(ElementKind.class);
        TypeMirror[] superType = new TypeMirror[1];
        int[] numTypeParameters = new int[1];
        List<? extends TypeMirror> types = CreateElementUtilities.resolveType(fixTypes, info, parent, errorPath.getLeaf(), offset, superType, numTypeParameters);
        ElementKind classType = CreateElement.getClassType(fixTypes);
        if (target.getKind() == ElementKind.PACKAGE) {
            result.addAll(CreateElement.prepareCreateOuterClassFix(info, null, target, modifiers, simpleName, null, superType[0], classType != null ? classType : ElementKind.CLASS, numTypeParameters[0]));
            return result;
        }
        TypeMirror type = types != null && !types.isEmpty() && types.get(0) != null ? Utilities.resolveCapturedType(info, types.get(0)) : null;
        TypeElement typeElement = outermostTypeElement = source != null ? info.getElementUtilities().outermostTypeElement((Element)source) : null;
        if (newClass != null) {
            NewClassTree nct = (NewClassTree)newClass.getLeaf();
            Element clazz = info.getTrees().getElement(new TreePath(newClass, nct.getIdentifier()));
            if (clazz == null || clazz.asType().getKind() == TypeKind.ERROR || !clazz.getKind().isClass() && !clazz.getKind().isInterface()) {
                ExpressionTree ident = nct.getIdentifier();
                int numTypeArguments = 0;
                if (ident.getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
                    numTypeArguments = ((ParameterizedTypeTree)((Object)ident)).getTypeArguments().size();
                }
                if (wasMemberSelect) {
                    return CreateElement.prepareCreateInnerClassFix(info, newClass, (TypeElement)target, modifiers, simpleName, nct.getArguments(), type, ElementKind.CLASS, numTypeArguments);
                }
                LinkedList<Fix> currentResult = new LinkedList<Fix>();
                currentResult.addAll(CreateElement.prepareCreateOuterClassFix(info, newClass, source, EnumSet.noneOf(Modifier.class), simpleName, nct.getArguments(), type, ElementKind.CLASS, numTypeArguments));
                if (!baseType || outermostTypeElement != source) {
                    currentResult.addAll(CreateElement.prepareCreateInnerClassFix(info, newClass, outermostTypeElement, EnumSet.of(outermostTypeElement != null && outermostTypeElement.getKind().isInterface() ? Modifier.PUBLIC : Modifier.PRIVATE, Modifier.STATIC), simpleName, nct.getArguments(), type, ElementKind.CLASS, numTypeArguments));
                }
                return currentResult;
            }
            if (nct.getClassBody() != null) {
                return Collections.emptyList();
            }
            TypeElement clazzTarget = (TypeElement)clazz;
            result.addAll(CreateElement.prepareCreateMethodFix(info, newClass, CreateElement.getAccessModifiers(info, source, clazzTarget), clazzTarget, "<init>", nct.getArguments(), null));
        }
        if (classType != null) {
            if (wasMemberSelect) {
                result.addAll(CreateElement.prepareCreateInnerClassFix(info, null, (TypeElement)target, modifiers, simpleName, null, superType[0], classType, numTypeParameters[0]));
            } else {
                result.addAll(CreateElement.prepareCreateOuterClassFix(info, null, source, EnumSet.noneOf(Modifier.class), simpleName, null, superType[0], classType, numTypeParameters[0]));
                if (!baseType || outermostTypeElement != source) {
                    result.addAll(CreateElement.prepareCreateInnerClassFix(info, null, outermostTypeElement, EnumSet.of(outermostTypeElement != null && outermostTypeElement.getKind().isInterface() ? Modifier.PUBLIC : Modifier.PRIVATE, Modifier.STATIC), simpleName, null, superType[0], classType, numTypeParameters[0]));
                }
            }
        }
        if (type == null || type.getKind() == TypeKind.VOID || type.getKind() == TypeKind.OTHER || type.getKind() == TypeKind.EXECUTABLE) {
            return result;
        }
        if (Utilities.containsErrorsRecursively(type)) {
            return result;
        }
        Collection<TypeVariable> typeVars = Utilities.containedTypevarsRecursively(type);
        if (!Utilities.allTypeVarsAccessible(typeVars, target)) {
            fixTypes.remove((Object)ElementKind.FIELD);
        }
        if (fixTypes.contains((Object)ElementKind.FIELD) && CreateElement.isTargetWritable((TypeElement)target, info)) {
            FileObject targetFile;
            Element enclosingElement = e.getEnclosingElement();
            if (enclosingElement != null && enclosingElement.getKind() == ElementKind.ANNOTATION_TYPE) {
                targetFile = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)target), (ClasspathInfo)info.getClasspathInfo());
                if (targetFile != null) {
                    result.add(new CreateMethodFix(info, simpleName, modifiers, (TypeElement)target, type, types, Collections.<String>emptyList(), targetFile));
                }
                return result;
            }
            targetFile = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)target), (ClasspathInfo)info.getClasspathInfo());
            if (targetFile != null) {
                if (target.getKind() == ElementKind.ENUM) {
                    if (source.equals(target)) {
                        result.add(new CreateFieldFix(info, simpleName, modifiers, (TypeElement)target, type, targetFile));
                    } else {
                        result.add(new CreateEnumConstant(info, simpleName, modifiers, (TypeElement)target, type, targetFile));
                    }
                } else {
                    if (firstMethod != null && info.getTrees().getElement(firstMethod).getKind() == ElementKind.CONSTRUCTOR && ErrorFixesFakeHint.isCreateFinalFieldsForCtor()) {
                        modifiers.add(Modifier.FINAL);
                    }
                    if (ErrorFixesFakeHint.enabled(ErrorFixesFakeHint.FixKind.CREATE_FINAL_FIELD_CTOR)) {
                        result.add(new CreateFieldFix(info, simpleName, modifiers, (TypeElement)target, type, targetFile));
                    }
                }
            }
        }
        if (!wasMemberSelect && (fixTypes.contains((Object)ElementKind.LOCAL_VARIABLE) || fixTypes.contains((Object)ElementKind.PARAMETER))) {
            ExecutableElement ee = null;
            if (firstMethod != null) {
                ee = (ExecutableElement)info.getTrees().getElement(firstMethod);
            }
            int identifierPos = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), errorPath.getLeaf());
            if (ee != null && fixTypes.contains((Object)ElementKind.PARAMETER) && !Utilities.isMethodHeaderInsideGuardedBlock(info, (MethodTree)firstMethod.getLeaf())) {
                result.add(new AddParameterOrLocalFix(info, type, simpleName, true, identifierPos));
            }
            if ((firstMethod != null || firstInitializer != null) && fixTypes.contains((Object)ElementKind.LOCAL_VARIABLE) && ErrorFixesFakeHint.enabled(ErrorFixesFakeHint.FixKind.CREATE_LOCAL_VARIABLE)) {
                result.add(new AddParameterOrLocalFix(info, type, simpleName, false, identifierPos));
            }
        }
        return result;
    }

    private static List<Fix> prepareCreateMethodFix(CompilationInfo info, TreePath invocation, Set<Modifier> modifiers, TypeElement target, String simpleName, List<? extends ExpressionTree> arguments, List<? extends TypeMirror> returnTypes) {
        TypeMirror returnType;
        Pair<List<? extends TypeMirror>, List<String>> formalArguments = Utilities.resolveArguments(info, invocation, arguments, target);
        TypeMirror typeMirror = returnType = returnTypes != null ? Utilities.resolveCapturedType(info, returnTypes.get(0)) : null;
        if (formalArguments == null || returnType != null && Utilities.containsErrorsRecursively(returnType)) {
            return Collections.emptyList();
        }
        Collection<TypeVariable> typeVars = Utilities.containedTypevarsRecursively(returnType);
        if (!Utilities.allTypeVarsAccessible(typeVars, target)) {
            return Collections.emptyList();
        }
        if (!CreateElement.isTargetWritable(target, info)) {
            return Collections.emptyList();
        }
        FileObject targetFile = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)target), (ClasspathInfo)info.getClasspathInfo());
        if (targetFile == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new CreateMethodFix(info, simpleName, modifiers, target, returnType, formalArguments.getA(), formalArguments.getB(), targetFile));
    }

    private static List<Fix> prepareCreateOuterClassFix(CompilationInfo info, TreePath invocation, Element source, Set<Modifier> modifiers, String simpleName, List<? extends ExpressionTree> realArguments, TypeMirror superType, ElementKind kind, int numTypeParameters) {
        Pair<List<? extends TypeMirror>, List<String>> formalArguments;
        Pair<List<? extends TypeMirror>, List<String>> pair = formalArguments = invocation != null ? Utilities.resolveArguments(info, invocation, realArguments, null) : new Pair<List<? extends TypeMirror>, List<String>>(null, null);
        if (formalArguments == null) {
            return Collections.emptyList();
        }
        ClassPath cp = info.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
        FileObject root = cp.findOwnerRoot(info.getFileObject());
        if (root == null) {
            return Collections.emptyList();
        }
        PackageElement packageElement = (PackageElement)(source instanceof PackageElement ? source : info.getElementUtilities().outermostTypeElement(source).getEnclosingElement());
        return Collections.singletonList(new CreateClassFix.CreateOuterClassFix(info, root, packageElement.getQualifiedName().toString(), simpleName, modifiers, formalArguments.getA(), formalArguments.getB(), superType, kind, numTypeParameters));
    }

    private static List<Fix> prepareCreateInnerClassFix(CompilationInfo info, TreePath invocation, TypeElement target, Set<Modifier> modifiers, String simpleName, List<? extends ExpressionTree> realArguments, TypeMirror superType, ElementKind kind, int numTypeParameters) {
        Pair<List<? extends TypeMirror>, List<String>> formalArguments;
        Pair<List<? extends TypeMirror>, List<String>> pair = formalArguments = invocation != null ? Utilities.resolveArguments(info, invocation, realArguments, target) : new Pair<List<? extends TypeMirror>, List<String>>(null, null);
        if (formalArguments == null) {
            return Collections.emptyList();
        }
        if (!CreateElement.isTargetWritable(target, info)) {
            return Collections.emptyList();
        }
        FileObject targetFile = SourceUtils.getFile((Element)target, (ClasspathInfo)info.getClasspathInfo());
        if (targetFile == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new CreateClassFix.CreateInnerClassFix(info, simpleName, modifiers, target, formalArguments.getA(), formalArguments.getB(), superType, kind, numTypeParameters, targetFile));
    }

    private static ElementKind getClassType(Set<ElementKind> types) {
        if (types.contains((Object)ElementKind.CLASS)) {
            return ElementKind.CLASS;
        }
        if (types.contains((Object)ElementKind.ANNOTATION_TYPE)) {
            return ElementKind.ANNOTATION_TYPE;
        }
        if (types.contains((Object)ElementKind.INTERFACE)) {
            return ElementKind.INTERFACE;
        }
        if (types.contains((Object)ElementKind.ENUM)) {
            return ElementKind.ENUM;
        }
        return null;
    }

    private static boolean isClassLikeElement(Element expElement) {
        return expElement != null && (expElement.getKind().isClass() || expElement.getKind().isInterface());
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return CreateElement.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(CreateElement.class, (String)"LBL_Create_Field");
    }

    public String getDescription() {
        return NbBundle.getMessage(CreateElement.class, (String)"DSC_Create_Field");
    }

    private static boolean isTargetWritable(TypeElement target, CompilationInfo info) {
        TypeElement outermostType = info.getElementUtilities().outermostTypeElement((Element)target);
        FileObject fo = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)outermostType), (ClasspathInfo)info.getClasspathInfo());
        return fo != null && fo.canWrite();
    }

    static EnumSet<Modifier> getAccessModifiers(CompilationInfo info, TypeElement source, TypeElement target) {
        Element targetPackage;
        if (target.getKind().isInterface()) {
            return EnumSet.of(Modifier.PUBLIC);
        }
        TypeElement outterMostSource = source != null ? info.getElementUtilities().outermostTypeElement((Element)source) : null;
        TypeElement outterMostTarget = info.getElementUtilities().outermostTypeElement((Element)target);
        if (outterMostTarget.equals(outterMostSource)) {
            return EnumSet.of(Modifier.PRIVATE);
        }
        Element sourcePackage = outterMostSource != null ? outterMostSource.getEnclosingElement() : info.getTrees().getElement(new TreePath(new TreePath(info.getCompilationUnit()), info.getCompilationUnit().getPackageName()));
        if (((Object)sourcePackage).equals(targetPackage = outterMostTarget.getEnclosingElement())) {
            return EnumSet.noneOf(Modifier.class);
        }
        return EnumSet.of(Modifier.PUBLIC);
    }
}

