/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.CaretAwareJavaSourceTaskFactory;
import org.netbeans.api.java.source.support.SelectionAwareJavaSourceTaskFactory;
import org.netbeans.modules.java.editor.rename.InstantRenamePerformer;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.infrastructure.Pair;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ConvertAnonymousToInner
extends AbstractHint {
    private static final String NEW_CLASS_TREE_TAG = "new-class-tree-tag";

    public ConvertAnonymousToInner() {
        super(true, true, AbstractHint.HintSeverity.CURRENT_LINE_WARNING, new String[0]);
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.NEW_CLASS);
    }

    static Fix computeFix(CompilationInfo info, int selStart, int selEnd, boolean onlyHeader) {
        TreePath tp = ConvertAnonymousToInner.findNCT(info, info.getTreeUtilities().pathFor((selStart + selEnd + 1) / 2), selStart, selEnd, onlyHeader);
        if (tp == null) {
            tp = ConvertAnonymousToInner.findNCT(info, info.getTreeUtilities().pathFor((selStart + selEnd + 1) / 2 + 1), selStart, selEnd, onlyHeader);
        }
        if (tp == null) {
            return null;
        }
        return new FixImpl(TreePathHandle.create((TreePath)tp, (CompilationInfo)info), info.getJavaSource(), info.getFileObject());
    }

    private static TreePath findNCT(CompilationInfo info, TreePath tp, int selStart, int selEnd, boolean onlyHeader) {
        while (tp != null) {
            long start;
            if (tp.getLeaf().getKind() != Tree.Kind.NEW_CLASS) {
                tp = tp.getParentPath();
                continue;
            }
            NewClassTree nct = (NewClassTree)tp.getLeaf();
            if (nct.getClassBody() == null) {
                tp = tp.getParentPath();
                continue;
            }
            if (selStart == selEnd) {
                if (!onlyHeader || (long)selStart <= (start = info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), nct.getClassBody()))) break;
                return null;
            }
            start = info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), nct);
            long end = info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), nct);
            if (start == (long)selStart && end == (long)selEnd) break;
            tp = tp.getParentPath();
        }
        return tp;
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        int pos = CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)compilationInfo.getFileObject());
        int[] selection = SelectionAwareJavaSourceTaskFactory.getLastSelection((FileObject)compilationInfo.getFileObject());
        Fix f = ConvertAnonymousToInner.computeFix(compilationInfo, selection[0], selection[1], true);
        if (f == null) {
            return null;
        }
        List<Fix> fixes = Collections.singletonList(f);
        String hintDescription = NbBundle.getMessage(ConvertAnonymousToInner.class, (String)"HINT_ConvertAnonymousToInner");
        return Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.HINT, (String)hintDescription, fixes, (FileObject)compilationInfo.getFileObject(), (int)pos, (int)pos));
    }

    @Override
    public String getId() {
        return ConvertAnonymousToInner.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(ConvertAnonymousToInner.class, (String)"DN_ConvertAnonymousToInner");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(ConvertAnonymousToInner.class, (String)"DESC_ConvertAnonymousToInner");
    }

    private static boolean isParent(TreePath tp1, TreePath tp2) {
        while (tp2 != null && tp1.getLeaf() != tp2.getLeaf()) {
            tp2 = tp2.getParentPath();
        }
        if (tp2 == null) {
            return false;
        }
        return tp1.getLeaf() == tp2.getLeaf();
    }

    private static String generateName(CompilationInfo info, TreePath newClassToConvert, String prototype) {
        Scope s = info.getTrees().getScope(newClassToConvert);
        Integer extension = null;
        if (s == null) {
            return prototype + "Impl";
        }
        while (true) {
            String currentProposal = prototype + "Impl" + (extension == null ? "" : extension.toString());
            boolean found = false;
            block1: for (Scope currentScope = s; currentScope != null; currentScope = currentScope.getEnclosingScope()) {
                for (Element e : info.getElementUtilities().getLocalMembersAndVars(s, new ElementUtilities.ElementAcceptor(){

                    public boolean accept(Element e, TypeMirror type) {
                        return true;
                    }
                })) {
                    String sn;
                    if (!e.getKind().isClass() && !e.getKind().isInterface() || !currentProposal.equals(sn = e.getSimpleName().toString())) continue;
                    found = true;
                    break block1;
                }
            }
            if (!found) {
                return currentProposal;
            }
            extension = extension != null ? extension + 1 : 1;
        }
    }

    static void convertAnonymousToInner(WorkingCopy copy, TreePath newClassToConvert) {
        Pair<List<? extends TypeMirror>, List<String>> resolvedArguments;
        Element currentElement;
        TreePath tp;
        TreeMaker make = copy.getTreeMaker();
        NewClassTree nct = (NewClassTree)newClassToConvert.getLeaf();
        nct = (NewClassTree)GeneratorUtilities.get((WorkingCopy)copy).importComments((Tree)nct, newClassToConvert.getCompilationUnit());
        LinkedHashSet usedElementVariables = new LinkedHashSet();
        new DetectUsedVars((CompilationInfo)copy, newClassToConvert).scan(new TreePath(newClassToConvert, nct.getClassBody()), usedElementVariables);
        boolean usesNonStaticMembers = new DetectUseOfNonStaticMembers((CompilationInfo)copy, newClassToConvert).scan(new TreePath(newClassToConvert, nct.getClassBody()), null) == Boolean.TRUE;
        for (tp = newClassToConvert; tp != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind()); tp = tp.getParentPath()) {
        }
        ClassTree target = (ClassTree)tp.getLeaf();
        Element targetElement = copy.getTrees().getElement(tp);
        boolean isInAnonymousClass = false;
        for (TreePath treePath = newClassToConvert.getParentPath(); treePath != null; treePath = treePath.getParentPath()) {
            if (treePath.getLeaf().getKind() != Tree.Kind.NEW_CLASS) continue;
            isInAnonymousClass = true;
            break;
        }
        TypeMirror superType = copy.getTrees().getTypeMirror(new TreePath(newClassToConvert, nct.getIdentifier()));
        Element superTypeElement = copy.getTrees().getElement(new TreePath(newClassToConvert, nct.getIdentifier()));
        boolean isStaticContext = true;
        Element currElement = superTypeElement;
        while (currElement.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
            if (!currElement.getModifiers().contains((Object)Modifier.STATIC)) {
                isStaticContext = false;
                break;
            }
            currElement = currElement.getEnclosingElement();
        }
        if (isStaticContext) {
            while (targetElement.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
                if (!targetElement.getModifiers().contains((Object)Modifier.STATIC)) {
                    isStaticContext = false;
                    break;
                }
                targetElement = targetElement.getEnclosingElement();
            }
        }
        Tree superTypeTree = make.Type(superType);
        Logger.getLogger(ConvertAnonymousToInner.class.getName()).log(Level.FINE, "usesNonStaticMembers = {0}", usesNonStaticMembers);
        TreePath superConstructorCall = ConvertAnonymousToInner.findSuperConstructorCall(newClassToConvert);
        boolean errorConstructor = currentElement == null || currentElement.asType() == null || currentElement.asType().getKind() == TypeKind.ERROR;
        boolean isEnclosedByStaticElem = false;
        for (currentElement = copy.getTrees().getElement(newClassToConvert); currentElement != null && currentElement.getEnclosingElement() != null && currentElement.getKind() != ElementKind.METHOD; currentElement = currentElement.getEnclosingElement()) {
            if (!currentElement.getModifiers().contains((Object)Modifier.STATIC)) continue;
            isEnclosedByStaticElem = true;
            break;
        }
        EnumSet<Modifier> modifset = null;
        modifset = isInAnonymousClass ? (isStaticContext && !usesNonStaticMembers || isEnclosedByStaticElem ? EnumSet.of(Modifier.STATIC) : EnumSet.noneOf(Modifier.class)) : (isStaticContext && !usesNonStaticMembers || isEnclosedByStaticElem ? EnumSet.of(Modifier.PRIVATE, Modifier.STATIC) : EnumSet.of(Modifier.PRIVATE));
        ModifiersTree classModifiers = make.Modifiers(modifset);
        ArrayList<? extends Tree> members = new ArrayList<Tree>();
        ArrayList<VariableTree> constrArguments = new ArrayList<VariableTree>();
        ArrayList<ExpressionStatementTree> constrBodyStatements = new ArrayList<ExpressionStatementTree>();
        ArrayList<? extends ExpressionTree> constrRealArguments = new ArrayList<ExpressionTree>();
        ModifiersTree emptyMods = make.Modifiers(EnumSet.noneOf(Modifier.class));
        LinkedList<IdentifierTree> nueSuperConstructorCallRealArguments = null;
        if (superConstructorCall != null && !errorConstructor) {
            Element superConstructor = copy.getTrees().getElement(superConstructorCall);
            if (superConstructor != null && superConstructor.getKind() == ElementKind.CONSTRUCTOR) {
                ExecutableElement ee = (ExecutableElement)superConstructor;
                TypeMirror nctTypes = copy.getTrees().getTypeMirror(newClassToConvert);
                assert (nctTypes.getKind() == TypeKind.DECLARED);
                ExecutableType et = (ExecutableType)copy.getTypes().asMemberOf((DeclaredType)nctTypes, ee);
                if (!ee.getParameters().isEmpty()) {
                    nueSuperConstructorCallRealArguments = new LinkedList();
                    Iterator<? extends VariableElement> names = ee.getParameters().iterator();
                    Iterator<? extends TypeMirror> types = et.getParameterTypes().iterator();
                    while (names.hasNext() && types.hasNext()) {
                        Name name = names.next().getSimpleName();
                        constrArguments.add(make.Variable(emptyMods, (CharSequence)name, make.Type(types.next()), null));
                        nueSuperConstructorCallRealArguments.add(make.Identifier((CharSequence)name));
                    }
                }
            }
        } else if (errorConstructor && (resolvedArguments = Utilities.resolveArguments((CompilationInfo)copy, newClassToConvert, nct.getArguments(), targetElement)) != null) {
            nueSuperConstructorCallRealArguments = new LinkedList<IdentifierTree>();
            Iterator<? extends TypeMirror> typeIt = resolvedArguments.getA().iterator();
            Iterator<String> nameIt = resolvedArguments.getB().iterator();
            while (typeIt.hasNext() && nameIt.hasNext()) {
                TypeMirror tm = typeIt.next();
                String argName = nameIt.next();
                constrArguments.add(make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)argName, make.Type(tm), null));
                nueSuperConstructorCallRealArguments.add(make.Identifier((CharSequence)argName));
            }
        }
        if (nueSuperConstructorCallRealArguments != null) {
            constrBodyStatements.add(make.ExpressionStatement((ExpressionTree)make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.Identifier((CharSequence)"super"), nueSuperConstructorCallRealArguments)));
        }
        constrRealArguments.addAll(nct.getArguments());
        ModifiersTree privateFinalMods = make.Modifiers(EnumSet.of(Modifier.PRIVATE, Modifier.FINAL));
        ModifiersTree emptyArgs = make.Modifiers(EnumSet.noneOf(Modifier.class));
        for (VariableElement ve : usedElementVariables) {
            members.add(make.Variable(privateFinalMods, (CharSequence)ve.getSimpleName(), make.Type(ve.asType()), null));
            constrArguments.add(make.Variable(emptyArgs, (CharSequence)ve.getSimpleName(), make.Type(ve.asType()), null));
            constrBodyStatements.add(make.ExpressionStatement((ExpressionTree)make.Assignment((ExpressionTree)make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"this"), (CharSequence)ve.getSimpleName()), (ExpressionTree)make.Identifier((CharSequence)ve.getSimpleName()))));
            constrRealArguments.add(make.Identifier((CharSequence)ve.getSimpleName()));
        }
        ArrayList<? extends Tree> oldMembers = new ArrayList<Tree>(nct.getClassBody().getMembers());
        oldMembers.remove(0);
        ModifiersTree constructorModifiers = make.Modifiers(EnumSet.of(Modifier.PUBLIC));
        MethodTree constr = make.Method(constructorModifiers, (CharSequence)"<init>", null, Collections.emptyList(), constrArguments, Collections.emptyList(), make.Block(constrBodyStatements, false), null);
        members.add(constr);
        members.addAll(oldMembers);
        String newClassName = ConvertAnonymousToInner.generateName((CompilationInfo)copy, newClassToConvert, superTypeElement.getSimpleName().toString());
        ClassTree clazz = make.Class(classModifiers, (CharSequence)newClassName, Collections.emptyList(), superTypeElement.getKind().isClass() ? superTypeTree : null, superTypeElement.getKind().isClass() ? Collections.emptyList() : Collections.singletonList(superTypeTree), members);
        copy.rewrite((Tree)target, (Tree)make.addClassMember(target, (Tree)clazz));
        IdentifierTree classNameTree = make.Identifier((CharSequence)newClassName);
        NewClassTree nueNCT = make.NewClass(null, Collections.emptyList(), (ExpressionTree)classNameTree, constrRealArguments, null);
        copy.rewrite((Tree)nct, (Tree)nueNCT);
        copy.tag((Tree)classNameTree, (Object)NEW_CLASS_TREE_TAG);
    }

    @Override
    public void cancel() {
    }

    private static TreePath findSuperConstructorCall(TreePath nct) {
        class FindSuperConstructorCall
        extends TreePathScanner<TreePath, Void> {
            private boolean stop;

            FindSuperConstructorCall() {
            }

            @Override
            public TreePath scan(Tree tree, Void p) {
                if (this.stop) {
                    return null;
                }
                return (TreePath)super.scan(tree, p);
            }

            @Override
            public TreePath visitMethodInvocation(MethodInvocationTree tree, Void v) {
                if (tree.getMethodSelect().getKind() == Tree.Kind.IDENTIFIER && "super".equals(((IdentifierTree)tree.getMethodSelect()).getName().toString())) {
                    this.stop = true;
                    return this.getCurrentPath();
                }
                return null;
            }

            @Override
            public TreePath reduce(TreePath first, TreePath second) {
                if (first == null) {
                    return second;
                }
                return first;
            }
        }
        return (TreePath)new FindSuperConstructorCall().scan(nct, null);
    }

    private static final class DetectUseOfNonStaticMembers
    extends TreePathScanner<Boolean, Void> {
        private CompilationInfo info;
        private TreePath newClassToConvert;

        private DetectUseOfNonStaticMembers(CompilationInfo info, TreePath newClassToConvert) {
            this.info = info;
            this.newClassToConvert = newClassToConvert;
        }

        @Override
        public Boolean visitIdentifier(IdentifierTree node, Void p) {
            Element el = this.info.getTrees().getElement(this.getCurrentPath());
            if (el != null && (el.getKind().isField() || el.getKind() == ElementKind.METHOD) && !el.getModifiers().contains((Object)Modifier.STATIC)) {
                return true;
            }
            return (Boolean)super.visitIdentifier(node, p);
        }

        @Override
        public Boolean reduce(Boolean r1, Boolean r2) {
            return r1 == Boolean.TRUE || r2 == Boolean.TRUE;
        }
    }

    private static final class DetectUsedVars
    extends TreePathScanner<Void, Set<VariableElement>> {
        private CompilationInfo info;
        private TreePath newClassToConvert;
        private static final Set<ElementKind> VARIABLES = EnumSet.of(ElementKind.EXCEPTION_PARAMETER, ElementKind.PARAMETER, ElementKind.LOCAL_VARIABLE);

        private DetectUsedVars(CompilationInfo info, TreePath newClassToConvert) {
            this.info = info;
            this.newClassToConvert = newClassToConvert;
        }

        @Override
        public Void visitIdentifier(IdentifierTree node, Set<VariableElement> p) {
            TreePath elPath;
            Element el = this.info.getTrees().getElement(this.getCurrentPath());
            TreePath treePath = elPath = el != null ? this.info.getTrees().getPath(el) : null;
            if (el != null && elPath != null && VARIABLES.contains((Object)el.getKind()) && !ConvertAnonymousToInner.isParent(this.newClassToConvert, elPath)) {
                p.add((VariableElement)el);
            }
            return (Void)super.visitIdentifier(node, p);
        }
    }

    private static class FixImpl
    implements Fix,
    Task<WorkingCopy> {
        private TreePathHandle tph;
        private JavaSource js;
        private FileObject file;

        public FixImpl(TreePathHandle tph, JavaSource js, FileObject file) {
            this.tph = tph;
            this.js = js;
            this.file = file;
        }

        public String getText() {
            return NbBundle.getMessage(ConvertAnonymousToInner.class, (String)"FIX_ConvertAnonymousToInner");
        }

        public ChangeInfo implement() throws IOException {
            ModificationResult mr = this.js.runModificationTask((Task)this);
            mr.commit();
            final int[] newClassNameSpan = mr.getSpan((Object)ConvertAnonymousToInner.NEW_CLASS_TREE_TAG);
            if (newClassNameSpan != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            EditorCookie cook = (EditorCookie)DataObject.find((FileObject)FixImpl.this.file).getLookup().lookup(EditorCookie.class);
                            JEditorPane[] arr = cook.getOpenedPanes();
                            if (arr == null) {
                                return;
                            }
                            arr[0].setCaretPosition((newClassNameSpan[0] + newClassNameSpan[1]) / 2);
                            InstantRenamePerformer.invokeInstantRename((JTextComponent)arr[0]);
                        }
                        catch (DataObjectNotFoundException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            }
            return null;
        }

        public void run(WorkingCopy parameter) throws Exception {
            parameter.toPhase(JavaSource.Phase.RESOLVED);
            TreePath tp = this.tph.resolve((CompilationInfo)parameter);
            ConvertAnonymousToInner.convertAnonymousToInner(parameter, tp);
        }
    }
}

