/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.extras.api.support;

import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.dlight.spi.indicator.IndicatorNotificationsListener;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.NativeProcessExecutionService;

public final class CollectorRunner
implements Runnable {
    private static final int SMALL_TIMEOUT = 5;
    private static final int BIG_TIMEOUT = 30;
    private final IndicatorNotificationsListener listener;
    private final Future<Integer> collectorTask;
    private final AtomicBoolean dataFlag;
    private final AtomicBoolean eofFlag;
    private final AtomicBoolean shutdownFlag;
    private final String eofMarker;

    public CollectorRunner(IndicatorNotificationsListener listener, NativeProcessBuilder npb, LineProcessor outProcessor, String eofMarker, String taskName) {
        this.listener = listener;
        this.dataFlag = new AtomicBoolean();
        this.eofFlag = new AtomicBoolean();
        this.shutdownFlag = new AtomicBoolean();
        this.eofMarker = eofMarker;
        LineProcessorWrapper wrappedOutProcessor = new LineProcessorWrapper(outProcessor);
        this.collectorTask = NativeProcessExecutionService.newService((NativeProcessBuilder)npb, (LineProcessor)wrappedOutProcessor, null, (String)taskName).start();
        DLightExecutorService.submit((Runnable)this, (String)("Monitoring task " + taskName));
    }

    public void shutdown() {
        this.shutdown(false);
    }

    public void shutdown(boolean forceTerminate) {
        this.shutdownFlag.set(true);
        if (forceTerminate) {
            this.shutdownImmediately();
        }
    }

    @Override
    public void run() {
        while (!this.collectorTask.isDone()) {
            if (this.eofFlag.get()) {
                this.shutdownImmediately();
                break;
            }
            if (this.shutdownFlag.get()) {
                this.shutdownGracefully();
                break;
            }
            if (CollectorRunner.sleepOneSecond()) continue;
            this.shutdownImmediately();
            break;
        }
    }

    private void shutdownGracefully() {
        int ticksWithoutData = 0;
        for (int i = 0; i < 30; ++i) {
            if (this.collectorTask.isDone()) {
                return;
            }
            if (this.eofFlag.get() || !CollectorRunner.sleepOneSecond()) break;
            this.listener.suggestRepaint();
            if (this.dataFlag.getAndSet(false)) {
                ticksWithoutData = 0;
                continue;
            }
            if (5 <= ++ticksWithoutData) break;
        }
        this.shutdownImmediately();
    }

    private void shutdownImmediately() {
        this.collectorTask.cancel(true);
    }

    public String toString() {
        return this.collectorTask.toString();
    }

    private static boolean sleepOneSecond() {
        try {
            Thread.sleep(1000L);
            return true;
        }
        catch (InterruptedException ex) {
            return false;
        }
    }

    private class LineProcessorWrapper
    implements LineProcessor {
        private final LineProcessor originalProcessor;

        public LineProcessorWrapper(LineProcessor originalProcessor) {
            this.originalProcessor = originalProcessor;
        }

        public AtomicBoolean getDataFlag() {
            return CollectorRunner.this.dataFlag;
        }

        public AtomicBoolean getEOFFlag() {
            return CollectorRunner.this.eofFlag;
        }

        public void processLine(String line) {
            if (CollectorRunner.this.eofMarker.equals(line)) {
                CollectorRunner.this.eofFlag.set(true);
            } else {
                CollectorRunner.this.dataFlag.set(true);
                this.originalProcessor.processLine(line);
            }
        }

        public void reset() {
            this.originalProcessor.reset();
        }

        public void close() {
            this.originalProcessor.close();
        }
    }
}

