/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.ui.options;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.ui.ServerListUIEx;
import org.netbeans.modules.cnd.api.toolchain.ui.ToolsPanelGlobalCustomizer;
import org.netbeans.modules.cnd.api.toolchain.ui.ToolsPanelModel;
import org.netbeans.modules.cnd.api.toolchain.ui.ToolsPanelSupport;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetImpl;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetManagerImpl;
import org.netbeans.modules.cnd.toolchain.ui.options.AddCompilerSetPanel;
import org.netbeans.modules.cnd.toolchain.ui.options.DuplicateCompilerSetPanel;
import org.netbeans.modules.cnd.toolchain.ui.options.GlobalToolsPanelModel;
import org.netbeans.modules.cnd.toolchain.ui.options.ToolCollectionPanel;
import org.netbeans.modules.cnd.toolchain.ui.options.ToolsCacheManagerImpl;
import org.netbeans.modules.cnd.toolchain.ui.options.ToolsUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public final class ToolsPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
ItemListener {
    public static final String PROP_VALID = "valid";
    private static final String PROP_COMPILER_SET_NAME = "compilerSetName";
    private boolean initialized = false;
    private boolean changed;
    private boolean changingCompilerSet;
    private boolean updating;
    private ValidState valid = ValidState.UNKNOWN;
    private ToolsPanelModel model = null;
    private boolean customizeDebugger;
    private ExecutionEnvironment execEnv;
    private CompilerSetManagerImpl csm;
    private CompilerSet currentCompilerSet;
    private ToolsCacheManagerImpl tcm = (ToolsCacheManagerImpl)ToolsPanelSupport.getToolsCacheManager();
    private static final Logger log = Logger.getLogger("cnd.remote.logger");
    private static final RequestProcessor RP = new RequestProcessor(ToolsPanel.class.getName(), 1);
    private JPanel ToolSetPanel;
    private JButton btAdd;
    private JButton btDefault;
    private JButton btDuplicate;
    private JButton btEditDevHost;
    private JButton btRemove;
    private JButton btRestore;
    private JButton btVersions;
    private JPanel buttomPanel;
    private JPanel buttonPanel;
    private JComboBox cbDevHost;
    private JLabel lbDevHost;
    private JLabel lbToolCollections;
    private JLabel lblErrors;
    private JLabel lblLoadToolsProgress;
    private JPanel loadingToolCollectionPanel;
    private JList lstDirlist;
    private JScrollPane spDirlist;
    private JPanel toolCollectionPanel;

    public ToolsPanel(String helpContext) {
        this.initComponents();
        this.setName("TAB_ToolsTab");
        this.changed = false;
        this.currentCompilerSet = null;
        this.execEnv = ServerList.getDefaultRecord().getExecutionEnvironment();
        this.lstDirlist.setCellRenderer(new MyCellRenderer());
        this.cbDevHost.setRenderer(new MyDevHostListCellRenderer());
        if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
            this.setOpaque(false);
        }
        this.tcm.clear();
        HelpCtx.setHelpIDString((JComponent)this, (String)helpContext);
    }

    public ToolsPanel(ToolsPanelModel model, String heplContext) {
        this(heplContext);
        this.model = model;
        ExecutionEnvironment env = model.getSelectedDevelopmentHost();
        if (env != null) {
            this.execEnv = env;
        }
    }

    private void initializeLong() {
        this.csm = (CompilerSetManagerImpl)this.tcm.getCompilerSetManagerCopy(this.execEnv, true);
    }

    ToolsPanelModel getModel() {
        return this.model;
    }

    ExecutionEnvironment getExecutionEnvironment() {
        return this.execEnv;
    }

    private void showHideToolchainInitialization(boolean show) {
        if (show) {
            this.cbDevHost.setEnabled(this.model.getEnableDevelopmentHostChange());
        } else {
            this.cbDevHost.setEnabled(false);
        }
        this.btEditDevHost.setEnabled(show);
        this.buttomPanel.setVisible(show);
        this.buttonPanel.setVisible(show);
        this.toolCollectionPanel.setVisible(show);
        this.loadingToolCollectionPanel.setVisible(!show);
    }

    private void initializeUI() {
        this.changingCompilerSet = true;
        if (this.model == null) {
            this.model = new GlobalToolsPanelModel();
        }
        this.showHideToolchainInitialization(true);
        this.cbDevHost.removeItemListener(this);
        ExecutionEnvironment selectedEnv = this.model.getSelectedDevelopmentHost();
        ServerRecord selectedRec = null;
        Collection<? extends ServerRecord> hostList = this.tcm.getHosts();
        if (hostList != null) {
            this.cbDevHost.removeAllItems();
            for (ServerRecord serverRecord : hostList) {
                if (serverRecord.getExecutionEnvironment().equals(selectedEnv)) {
                    selectedRec = serverRecord;
                }
                this.cbDevHost.addItem(serverRecord);
            }
        } else {
            this.cbDevHost.addItem(ServerList.get((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal()));
        }
        if (selectedRec == null) {
            selectedRec = this.tcm.getDefaultHostRecord();
        }
        if (selectedRec == null) {
            selectedRec = ServerList.get((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
        }
        this.cbDevHost.setSelectedItem(selectedRec);
        this.cbDevHost.addItemListener(this);
        this.cbDevHost.setEnabled(this.model.getEnableDevelopmentHostChange());
        this.btEditDevHost.setEnabled(this.model.getEnableDevelopmentHostChange());
        this.execEnv = this.getSelectedRecord().getExecutionEnvironment();
        this.btVersions.setEnabled(false);
        this.initCustomizableDebugger();
        this.getToolCollectionPanel().initializeUI();
    }

    private ToolCollectionPanel getToolCollectionPanel() {
        return (ToolCollectionPanel)this.toolCollectionPanel;
    }

    private void addCompilerSet() {
        if (this.csm == null) {
            return;
        }
        boolean oldHostValid = ToolsUtils.isDevHostValid(this.execEnv);
        final CompilerSet cs = AddCompilerSetPanel.invokeMe(this.csm);
        if (cs == null) {
            boolean newHostValid = ToolsUtils.isDevHostValid(this.execEnv);
            if (oldHostValid != newHostValid) {
                this.dataValid();
            }
            return;
        }
        this.updating = true;
        this.setCursor(Cursor.getPredefinedCursor(3));
        RP.post(new Runnable(){

            @Override
            public void run() {
                ToolsPanel.this.csm.add(cs);
                ToolsPanel.this.changed = true;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ToolsPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                        ToolsPanel.this.update(false, cs, null);
                    }
                });
            }
        });
    }

    private void duplicateCompilerSet() {
        final CompilerSet selectedCompilerSet = (CompilerSet)this.lstDirlist.getSelectedValue();
        DuplicateCompilerSetPanel panel = new DuplicateCompilerSetPanel(this.csm, selectedCompilerSet);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)panel, ToolsPanel.getString("COPY_TOOL_SET_TITLE"));
        panel.setDialogDescriptor(dialogDescriptor);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (dialogDescriptor.getValue() != DialogDescriptor.OK_OPTION) {
            return;
        }
        final String compilerSetName = panel.getCompilerSetName().trim();
        this.updating = true;
        this.setCursor(Cursor.getPredefinedCursor(3));
        RP.post(new Runnable(){

            @Override
            public void run() {
                final CompilerSetImpl cs = ((CompilerSetImpl)selectedCompilerSet).createCopy(selectedCompilerSet.getCompilerFlavor(), selectedCompilerSet.getDirectory(), compilerSetName, false, selectedCompilerSet.getEncoding(), true);
                ToolsPanel.this.csm.add(cs);
                ToolsPanel.this.changed = true;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ToolsPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                        ToolsPanel.this.update(false, cs, null);
                    }
                });
            }
        });
    }

    private void onCompilerSetChanged() {
        boolean cbRemoveEnabled = this.model.showRequiredTools() ? this.lstDirlist.getSelectedIndex() >= 0 : this.csm.getCompilerSets().size() > 1 && this.lstDirlist.getSelectedIndex() >= 0;
        this.changeCompilerSet((CompilerSet)this.lstDirlist.getSelectedValue());
        this.btAdd.setEnabled(this.isHostValidForEditing());
        this.btRemove.setEnabled(cbRemoveEnabled && this.isHostValidForEditing());
        this.btDuplicate.setEnabled(this.lstDirlist.getSelectedIndex() >= 0 && this.isHostValidForEditing());
        this.btDefault.setEnabled(this.lstDirlist.getSelectedIndex() >= 0 && !((CompilerSetImpl)this.lstDirlist.getSelectedValue()).isDefault());
    }

    private void onNewDevHostSelected() {
        if (!this.execEnv.equals(this.getSelectedRecord().getExecutionEnvironment())) {
            log.fine("TP.itemStateChanged: About to update");
            this.changed = true;
            if (!this.tcm.hasCache()) {
                ArrayList<ServerRecord> nulist = new ArrayList<ServerRecord>(this.cbDevHost.getItemCount());
                for (int i = 0; i < this.cbDevHost.getItemCount(); ++i) {
                    nulist.add((ServerRecord)this.cbDevHost.getItemAt(i));
                }
                this.tcm.setHosts(nulist);
            }
            this.tcm.setDefaultRecord((ServerRecord)this.cbDevHost.getSelectedItem());
            this.execEnv = this.getSelectedRecord().getExecutionEnvironment();
            this.model.setSelectedDevelopmentHost(this.execEnv);
            this.update(true);
        } else {
            this.update(false);
        }
    }

    private void removeCompilerSet() {
        CompilerSetImpl cs = (CompilerSetImpl)this.lstDirlist.getSelectedValue();
        if (cs != null) {
            int index = this.csm.getCompilerSets().indexOf(cs);
            boolean wasDefault = this.csm.isDefaultCompilerSet(cs);
            this.csm.remove(cs);
            if (wasDefault && this.csm.getCompilerSets().size() > 0) {
                this.csm.setDefault(this.csm.getCompilerSet(0));
            }
            if (index >= 0 && index < this.csm.getCompilerSets().size()) {
                this.update(false, this.csm.getCompilerSets().get(index), null);
            } else if (index > 0) {
                this.update(false, this.csm.getCompilerSets().get(index - 1), null);
            } else {
                this.getToolCollectionPanel().removeCompilerSet();
                this.update(false);
            }
            this.changed = true;
        }
    }

    private void setSelectedAsDefault() {
        CompilerSet cs = (CompilerSet)this.lstDirlist.getSelectedValue();
        this.csm.setDefault(cs);
        this.changed = true;
        this.update(false);
    }

    public void update() {
        this.tcm.clear();
        this.update(true, null, null);
    }

    public void update(List<String> errs) {
        this.update(true, null, errs);
    }

    private void update(boolean doInitialize) {
        this.update(doInitialize, null, null);
    }

    private void update(final boolean doInitialize, final CompilerSet selectedCS, final List<String> errs) {
        this.updating = true;
        if (!this.initialized || doInitialize) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.showHideToolchainInitialization(false);
            RP.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ToolsPanel.this.initializeLong();
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ToolsPanel.this.initializeUI();
                                ToolsPanel.this.updateUI(doInitialize, selectedCS, errs);
                                ToolsPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            });
        } else {
            this.updateUI(doInitialize, selectedCS, errs);
        }
    }

    private void updateUI(boolean doInitialize, CompilerSet selectedCS, List<String> errs) {
        this.getToolCollectionPanel().updateUI(doInitialize, selectedCS);
        if (doInitialize && !this.csm.getCompilerSets().isEmpty()) {
            String selectedName;
            if (this.csm.getDefaultCompilerSet() == null) {
                String name = this.getCompilerSetName();
                if (name.length() == 0 || this.csm.getCompilerSet(name) == null) {
                    this.csm.setDefault(this.csm.getCompilerSet(0));
                } else {
                    this.csm.setDefault(this.csm.getCompilerSet(name));
                }
            }
            if ((selectedName = this.model.getSelectedCompilerSetName()) != null) {
                selectedCS = this.csm.getCompilerSet(selectedName);
            }
            if (selectedCS == null) {
                selectedCS = this.csm.getDefaultCompilerSet();
            }
        }
        if (selectedCS == null) {
            selectedCS = (CompilerSet)this.lstDirlist.getSelectedValue();
        }
        this.lstDirlist.setListData(this.csm.getCompilerSets().toArray());
        if (selectedCS != null) {
            this.lstDirlist.setSelectedValue(selectedCS, true);
        }
        if (this.lstDirlist.getSelectedIndex() < 0) {
            this.lstDirlist.setSelectedIndex(0);
        }
        this.lstDirlist.invalidate();
        this.lstDirlist.repaint();
        this.onCompilerSetChanged();
        this.updating = false;
        this.dataValid(errs);
        this.initialized = true;
    }

    private String getCompilerSetName() {
        String name = NbPreferences.forModule(ToolsPanel.class).get(PROP_COMPILER_SET_NAME, null);
        if (name == null) {
            return "";
        }
        return name;
    }

    private void setCompilerSetName(String name) {
        String n = this.getCompilerSetName();
        if (n == null || !n.equals(name)) {
            NbPreferences.forModule(ToolsPanel.class).put(PROP_COMPILER_SET_NAME, name);
            this.firePropertyChange(PROP_COMPILER_SET_NAME, n, name);
        }
    }

    boolean isRemoteHostSelected() {
        return ((ServerRecord)this.cbDevHost.getSelectedItem()).isRemote();
    }

    private ServerRecord getSelectedRecord() {
        return (ServerRecord)this.cbDevHost.getSelectedItem();
    }

    private boolean isHostValidForEditing() {
        return true;
    }

    private void changeCompilerSet(CompilerSet cs) {
        this.getToolCollectionPanel().preChangeCompilerSet(cs);
        if (cs == null) {
            String errorMsg = "";
            if (!ToolsUtils.isDevHostValid(this.execEnv)) {
                String key = this.model.getEnableDevelopmentHostChange() ? "TP_ErrorMessage_BadDevHost" : "TP_ErrorMessage_BadDevHostReadOnly";
                errorMsg = NbBundle.getMessage(ToolsPanel.class, (String)key, (Object)this.execEnv.toString());
            }
            this.lblErrors.setText("<html>" + errorMsg + "</html>");
            this.updateToolsControls(false, false, true);
            return;
        }
        if (this.currentCompilerSet != null && this.currentCompilerSet != cs) {
            this.getToolCollectionPanel().updateCompilerSet(this.currentCompilerSet, false);
        }
        this.changingCompilerSet = true;
        this.getToolCollectionPanel().changeCompilerSet(cs);
        this.changingCompilerSet = false;
        this.currentCompilerSet = cs;
        this.fireCompilerSetChange();
        this.dataValid();
    }

    public String getSelectedToolchain() {
        return this.currentCompilerSet != null ? this.currentCompilerSet.getName() : "";
    }

    public void applyChanges(boolean force) {
        this.changed = force;
        this.applyChanges();
    }

    public void applyChanges() {
        boolean changedInOtherPanels = ToolsPanelSupport.isChangedInOtherPanels();
        if (this.changed || changedInOtherPanels) {
            List<Runnable> fireChanges = null;
            if (changedInOtherPanels) {
                fireChanges = ToolsPanelSupport.saveChangesInOtherPanels();
            }
            CompilerSet cs = (CompilerSet)this.lstDirlist.getSelectedValue();
            this.changed = false;
            if (cs != null) {
                this.getToolCollectionPanel().updateCompilerSet(cs, true);
                this.model.setCompilerSetName(this.csm.getDefaultCompilerSet().getName());
                this.model.setSelectedCompilerSetName(cs.getName());
            }
            this.currentCompilerSet = cs;
            this.tcm.applyChanges((ServerRecord)this.cbDevHost.getSelectedItem());
            if (fireChanges != null) {
                for (Runnable fire : fireChanges) {
                    fire.run();
                }
            }
        }
        this.getToolCollectionPanel().applyChanges();
    }

    public void cancel() {
        this.tcm.cancel();
        this.changed = false;
    }

    public CompilerSet getCurrentCompilerSet() {
        return this.currentCompilerSet;
    }

    CompilerSetManager getCompilerSetManager() {
        return this.csm;
    }

    boolean isUpdatindOrChangingCompilerSet() {
        return this.updating || this.changingCompilerSet;
    }

    public boolean dataValid() {
        return this.dataValid(null);
    }

    private boolean dataValid(List<String> errs) {
        if (this.csm.getCompilerSets().isEmpty()) {
            if (this.valid != ValidState.INVALID) {
                this.valid = ValidState.INVALID;
                this.firePropertyChange(PROP_VALID, true, false);
            }
            return false;
        }
        if (this.updating || this.changingCompilerSet) {
            return true;
        }
        boolean csmValid = this.csm.getCompilerSets().size() > 0;
        boolean isToolsValid = this.getToolCollectionPanel().isToolsValid();
        boolean devhostValid = ToolsUtils.isDevHostValid(this.execEnv);
        if (csmValid && isToolsValid && devhostValid) {
            if (this.valid != ValidState.VALID) {
                this.valid = ValidState.VALID;
                this.firePropertyChange(PROP_VALID, false, true);
            }
        } else if (this.valid != ValidState.INVALID) {
            this.valid = ValidState.INVALID;
            this.firePropertyChange(PROP_VALID, true, false);
        }
        if (this.valid == ValidState.INVALID || errs != null && errs.size() > 0) {
            this.lblErrors.setText("<html>");
            ArrayList<String> errors = new ArrayList<String>();
            if (errs != null) {
                errors.addAll(errs);
            }
            if (!devhostValid) {
                String key = this.model.getEnableDevelopmentHostChange() ? "TP_ErrorMessage_BadDevHost" : "TP_ErrorMessage_BadDevHostReadOnly";
                errors.add(NbBundle.getMessage(ToolsPanel.class, (String)key, (Object)this.execEnv.toString()));
            }
            this.getToolCollectionPanel().getErrors(errors);
            StringBuilder errorString = new StringBuilder();
            for (int i = 0; i < errors.size(); ++i) {
                errorString.append(errors.get(i));
                if (i >= errors.size() - 1) continue;
                errorString.append("<br>");
            }
            this.lblErrors.setText("<html>" + errorString.toString() + "</html>");
            this.validate();
            this.repaint();
        } else {
            this.lblErrors.setText("");
        }
        boolean baseDirValid = this.getToolCollectionPanel().isBaseDirValid();
        boolean enableText = baseDirValid || this.isRemoteHostSelected() && this.isHostValidForEditing();
        boolean enableVersions = (baseDirValid || this.isRemoteHostSelected()) && this.isHostValidForEditing();
        this.updateToolsControls(enableText, enableVersions, false);
        return this.valid == ValidState.VALID;
    }

    private void updateToolsControls(boolean enableText, boolean enableVersions, boolean cleanText) {
        this.btVersions.setEnabled(enableVersions);
        this.getToolCollectionPanel().updateToolsControls(enableText, enableVersions, cleanText);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public void fireCompilerSetChange() {
        ToolsPanelSupport.fireCompilerSetChange(this.currentCompilerSet);
    }

    public void fireCompilerSetModified() {
        ToolsPanelSupport.fireCompilerSetModified(this.currentCompilerSet);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o instanceof JButton) {
            if (o == this.btAdd) {
                this.addCompilerSet();
            } else if (o == this.btRemove) {
                this.removeCompilerSet();
            } else if (o == this.btDuplicate) {
                this.duplicateCompilerSet();
            } else if (o == this.btEditDevHost) {
                this.editDevHosts();
            } else if (o == this.btDefault) {
                this.setSelectedAsDefault();
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent ev) {
        Object o = ev.getSource();
        if (!this.updating && o == this.cbDevHost && ev.getStateChange() == 1) {
            this.onNewDevHostSelected();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent ev) {
        if (!ev.getValueIsAdjusting() && !this.updating && ev.getSource() == this.lstDirlist) {
            this.onCompilerSetChanged();
        }
    }

    private void editDevHosts() {
        if (ServerListUIEx.showServerListDialog(this.tcm, null)) {
            this.changed = true;
            this.cbDevHost.removeItemListener(this);
            log.fine("TP.editDevHosts: Removing all items from cbDevHost");
            this.cbDevHost.removeAllItems();
            log.log(Level.FINE, "TP.editDevHosts: Adding {0} items to cbDevHost", this.tcm.getHosts().size());
            for (ServerRecord serverRecord : this.tcm.getHosts()) {
                log.log(Level.FINE, "    Adding {0}", serverRecord);
                this.cbDevHost.addItem(serverRecord);
            }
            log.log(Level.FINE, "TP.editDevHosts: cbDevHost has {0} items", this.cbDevHost.getItemCount());
            log.log(Level.FINE, "TP.editDevHosts: getDefaultHostRecord returns {0}", this.tcm.getDefaultHostRecord());
            this.cbDevHost.setSelectedItem(this.tcm.getDefaultHostRecord());
            ToolsUtils.ensureHostSetup(this.getSelectedRecord().getExecutionEnvironment());
            this.cbDevHost.addItemListener(this);
            this.onNewDevHostSelected();
        }
    }

    private void initComponents() {
        this.buttomPanel = new JPanel();
        this.lblErrors = new JLabel();
        this.btVersions = new JButton();
        this.btRestore = new JButton();
        this.ToolSetPanel = new JPanel();
        this.spDirlist = new JScrollPane(this.lstDirlist);
        this.lstDirlist = new JList();
        this.lbToolCollections = new JLabel();
        this.buttonPanel = new JPanel();
        this.btAdd = new JButton();
        this.btAdd.addActionListener(this);
        this.btRemove = new JButton();
        this.btRemove.addActionListener(this);
        this.btDuplicate = new JButton();
        this.btDuplicate.addActionListener(this);
        this.btDefault = new JButton();
        this.btDefault.addActionListener(this);
        this.lbDevHost = new JLabel();
        this.cbDevHost = new JComboBox();
        this.cbDevHost.addItemListener(this);
        this.btEditDevHost = new JButton();
        this.btEditDevHost.addActionListener(this);
        this.toolCollectionPanel = new ToolCollectionPanel(this);
        this.loadingToolCollectionPanel = new JPanel();
        this.lblLoadToolsProgress = new JLabel();
        this.setMinimumSize(new Dimension(600, 420));
        this.setPreferredSize(new Dimension(600, 420));
        this.setLayout(new GridBagLayout());
        this.buttomPanel.setMinimumSize(new Dimension(150, 26));
        this.buttomPanel.setOpaque(false);
        this.buttomPanel.setPreferredSize(new Dimension(150, 26));
        this.buttomPanel.setLayout(new GridBagLayout());
        this.lblErrors.setForeground(new Color(255, 51, 51));
        this.lblErrors.setHorizontalAlignment(2);
        this.lblErrors.setText(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.lblErrors.text"));
        this.lblErrors.setEnabled(false);
        this.lblErrors.setFocusable(false);
        this.lblErrors.setPreferredSize(new Dimension(0, 26));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.buttomPanel.add((Component)this.lblErrors, gridBagConstraints);
        this.lblErrors.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.lblErrors.AccessibleContext.accessibleName"));
        Mnemonics.setLocalizedText((AbstractButton)this.btVersions, (String)NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.btVersions.text"));
        this.btVersions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolsPanel.this.btVersionsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.buttomPanel.add((Component)this.btVersions, gridBagConstraints);
        this.btVersions.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.btVersions.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.btRestore, (String)NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.btRestore.text"));
        this.btRestore.setHorizontalAlignment(4);
        this.btRestore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolsPanel.this.btRestoreActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.buttomPanel.add((Component)this.btRestore, gridBagConstraints);
        this.btRestore.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.btRestore.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        this.add((Component)this.buttomPanel, gridBagConstraints);
        this.ToolSetPanel.setOpaque(false);
        this.ToolSetPanel.setLayout(new GridBagLayout());
        this.spDirlist.setMinimumSize(new Dimension(180, 20));
        this.spDirlist.setPreferredSize(new Dimension(180, 20));
        this.lstDirlist.setSelectionMode(0);
        this.lstDirlist.setAutoscrolls(false);
        this.lstDirlist.addListSelectionListener(this);
        this.spDirlist.setViewportView(this.lstDirlist);
        this.lstDirlist.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.lstDirlist.AccessibleContext.accessibleName"));
        this.lstDirlist.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.lstDirlist.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.ToolSetPanel.add((Component)this.spDirlist, gridBagConstraints);
        this.lbToolCollections.setLabelFor(this.spDirlist);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/toolchain/ui/options/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.lbToolCollections, (String)bundle.getString("LBL_DirlistLabel"));
        this.lbToolCollections.setToolTipText(bundle.getString("HINT_DirListLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 4);
        this.ToolSetPanel.add((Component)this.lbToolCollections, gridBagConstraints);
        this.lbToolCollections.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_DirlistLabel"));
        this.lbToolCollections.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_DirlistLabel"));
        this.buttonPanel.setOpaque(false);
        this.buttonPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.btAdd, (String)bundle.getString("LBL_AddButton"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.buttonPanel.add((Component)this.btAdd, gridBagConstraints);
        this.btAdd.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_AddButton"));
        this.btAdd.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_AddButton"));
        Mnemonics.setLocalizedText((AbstractButton)this.btRemove, (String)bundle.getString("LBL_RemoveButton"));
        this.btRemove.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.buttonPanel.add((Component)this.btRemove, gridBagConstraints);
        this.btRemove.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_RemoveButton"));
        this.btRemove.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_RemoveButton"));
        Mnemonics.setLocalizedText((AbstractButton)this.btDuplicate, (String)bundle.getString("LBL_UpButton"));
        this.btDuplicate.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.buttonPanel.add((Component)this.btDuplicate, gridBagConstraints);
        this.btDuplicate.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_UpButton"));
        this.btDuplicate.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_UpButton"));
        Mnemonics.setLocalizedText((AbstractButton)this.btDefault, (String)bundle.getString("LBL_DownButton"));
        this.btDefault.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.buttonPanel.add((Component)this.btDefault, gridBagConstraints);
        this.btDefault.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_DownButton"));
        this.btDefault.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_DownButton"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.ToolSetPanel.add((Component)this.buttonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.ToolSetPanel, gridBagConstraints);
        this.lbDevHost.setLabelFor(this.cbDevHost);
        Mnemonics.setLocalizedText((JLabel)this.lbDevHost, (String)NbBundle.getMessage(ToolsPanel.class, (String)"LBL_DevelopmentHosts"));
        this.lbDevHost.setToolTipText(NbBundle.getMessage(ToolsPanel.class, (String)"HINT_DevelopmentHosts"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.add((Component)this.lbDevHost, gridBagConstraints);
        this.cbDevHost.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.add((Component)this.cbDevHost, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btEditDevHost, (String)NbBundle.getMessage(ToolsPanel.class, (String)"Lbl_AddDevHost"));
        this.btEditDevHost.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.btEditDevHost, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)this.toolCollectionPanel, gridBagConstraints);
        this.loadingToolCollectionPanel.setEnabled(false);
        this.loadingToolCollectionPanel.setFocusable(false);
        this.loadingToolCollectionPanel.setMinimumSize(new Dimension(0, 0));
        this.loadingToolCollectionPanel.setRequestFocusEnabled(false);
        this.loadingToolCollectionPanel.setVerifyInputWhenFocusTarget(false);
        this.loadingToolCollectionPanel.setLayout(new BorderLayout());
        this.lblLoadToolsProgress.setHorizontalAlignment(0);
        this.lblLoadToolsProgress.setText(NbBundle.getMessage(ToolsPanel.class, (String)"ToolsPanel.lblLoadToolsProgress.text"));
        this.loadingToolCollectionPanel.add((Component)this.lblLoadToolsProgress, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.loadingToolCollectionPanel, gridBagConstraints);
    }

    private void btVersionsActionPerformed(ActionEvent evt) {
        this.btVersions.setEnabled(false);
        final CompilerSet set = this.currentCompilerSet;
        if (set == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        RP.post(new Runnable(){

            @Override
            public void run() {
                if (!ConnectionManager.getInstance().isConnectedTo(ToolsPanel.this.getSelectedRecord().getExecutionEnvironment())) {
                    try {
                        ConnectionManager.getInstance().connectTo(ToolsPanel.this.getSelectedRecord().getExecutionEnvironment());
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (CancellationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                String versions = null;
                if (ConnectionManager.getInstance().isConnectedTo(ToolsPanel.this.getSelectedRecord().getExecutionEnvironment())) {
                    versions = ToolsPanel.this.getToolCollectionPanel().getVersion(set);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ToolsPanel.this.btVersions.setEnabled(true);
                        ToolsPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                });
                if (versions != null) {
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)versions);
                    nd.setTitle(ToolsPanel.getString("LBL_VersionInfo_Title"));
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                }
            }
        });
    }

    private void initCustomizableDebugger() {
        ToolsPanelGlobalCustomizer customizer = (ToolsPanelGlobalCustomizer)Lookup.getDefault().lookup(ToolsPanelGlobalCustomizer.class);
        this.customizeDebugger = customizer == null ? true : customizer.isDebuggerCustomizable();
    }

    boolean isCustomizableDebugger() {
        return this.customizeDebugger;
    }

    private void btRestoreActionPerformed(ActionEvent evt) {
        if (this.csm == null) {
            return;
        }
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)ToolsPanel.getString("RESTORE_TXT"), ToolsPanel.getString("RESTORE_TITLE"), 2);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) != NotifyDescriptor.OK_OPTION) {
            return;
        }
        CompilerSet selected = (CompilerSet)this.lstDirlist.getSelectedValue();
        final String selectedName = selected == null ? null : selected.getName();
        final AtomicBoolean newCsmCreated = new AtomicBoolean();
        final Runnable postWork = new Runnable(){

            @Override
            public void run() {
                ToolsPanel.this.showHideToolchainInitialization(true);
                if (newCsmCreated.get()) {
                    ToolsPanel.this.changed = true;
                    CompilerSet selected = ToolsPanel.this.csm.getCompilerSet(selectedName);
                    if (selected != null) {
                        ToolsPanel.this.update(false, selected, null);
                    } else {
                        ToolsPanel.this.update(false);
                    }
                }
            }
        };
        Runnable longWork = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CompilerSetManagerImpl newCsm = null;
                try {
                    HostInfoUtils.updateHostInfo((ExecutionEnvironment)ToolsPanel.this.execEnv);
                    newCsm = ToolsPanel.this.tcm.restoreCompilerSets(ToolsPanel.this.csm);
                    if (newCsm != null) {
                        ToolsPanel.this.csm = newCsm;
                        newCsmCreated.set(true);
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    SwingUtilities.invokeLater(postWork);
                }
            }
        };
        this.showHideToolchainInitialization(false);
        RP.post(longWork);
    }

    static String getString(String key) {
        return NbBundle.getMessage(ToolsPanel.class, (String)key);
    }

    static String getString(String key, Object param) {
        return NbBundle.getMessage(ToolsPanel.class, (String)key, (Object)param);
    }

    static String getString(String key, Object param1, Object param2) {
        return NbBundle.getMessage(ToolsPanel.class, (String)key, (Object)param1, (Object)param2);
    }

    static String getString(String key, Object param1, Object param2, Object param3) {
        return NbBundle.getMessage(ToolsPanel.class, (String)key, (Object)param1, (Object)param2, (Object)param3);
    }

    private class MyDevHostListCellRenderer
    extends DefaultListCellRenderer {
        private MyDevHostListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            ServerRecord rec = (ServerRecord)value;
            if (rec != null) {
                label.setText(rec.getDisplayName());
                if (rec.equals(ToolsPanel.this.tcm.getDefaultHostRecord())) {
                    label.setFont(label.getFont().deriveFont(1));
                }
            }
            return label;
        }
    }

    private static class MyCellRenderer
    extends DefaultListCellRenderer {
        private MyCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            CompilerSetImpl cs = (CompilerSetImpl)value;
            if (cs != null && cs.isDefault()) {
                comp.setFont(comp.getFont().deriveFont(1));
            }
            return comp;
        }
    }

    private static enum ValidState {
        VALID,
        INVALID,
        UNKNOWN;

    }
}

