/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen;

import com.sun.source.tree.ClassTree;
import com.sun.source.util.TreePath;
import java.awt.Dialog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.codegen.ConstructorGenerator;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.editor.codegen.ui.ElementNode;
import org.netbeans.modules.java.editor.codegen.ui.GetterSetterPanel;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class GetterSetterGenerator
implements CodeGenerator {
    private JTextComponent component;
    private ElementNode.Description description;
    private int type;

    private GetterSetterGenerator(JTextComponent component, ElementNode.Description description, int type) {
        this.component = component;
        this.description = description;
        this.type = type;
    }

    public String getDisplayName() {
        if (this.type == 1) {
            return NbBundle.getMessage(GetterSetterGenerator.class, (String)"LBL_getter");
        }
        if (this.type == 2) {
            return NbBundle.getMessage(GetterSetterGenerator.class, (String)"LBL_setter");
        }
        return NbBundle.getMessage(GetterSetterGenerator.class, (String)"LBL_getter_and_setter");
    }

    public void invoke() {
        JavaSource js;
        final int caretOffset = this.component.getCaretPosition();
        final GetterSetterPanel panel = new GetterSetterPanel(this.description, this.type);
        String title = this.type == 1 ? NbBundle.getMessage(ConstructorGenerator.class, (String)"LBL_generate_getter") : (this.type == 2 ? NbBundle.getMessage(ConstructorGenerator.class, (String)"LBL_generate_setter") : NbBundle.getMessage(ConstructorGenerator.class, (String)"LBL_generate_getter_and_setter"));
        DialogDescriptor dialogDescriptor = GeneratorUtils.createDialogDescriptor(panel, title);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == dialogDescriptor.getDefaultValue() && (js = JavaSource.forDocument((Document)this.component.getDocument())) != null) {
            try {
                ModificationResult mr = js.runModificationTask((Task)new Task<WorkingCopy>(){

                    public void run(WorkingCopy copy) throws IOException {
                        copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TreePath path = copy.getTreeUtilities().pathFor(caretOffset);
                        path = Utilities.getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, path);
                        int idx = GeneratorUtils.findClassMemberIndex(copy, (ClassTree)path.getLeaf(), caretOffset);
                        ArrayList<VariableElement> variableElements = new ArrayList<VariableElement>();
                        for (ElementHandle<? extends Element> elementHandle : panel.getVariables()) {
                            variableElements.add((VariableElement)elementHandle.resolve((CompilationInfo)copy));
                        }
                        GeneratorUtils.generateGettersAndSetters(copy, path, variableElements, GetterSetterGenerator.this.type, idx);
                    }
                });
                GeneratorUtils.guardedCommit(this.component, mr);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static class Factory
    implements CodeGenerator.Factory {
        private static final String ERROR = "<error>";

        public List<? extends CodeGenerator> create(Lookup context) {
            ArrayList<ElementNode.Description> descriptions;
            ArrayList<GetterSetterGenerator> ret = new ArrayList<GetterSetterGenerator>();
            JTextComponent component = (JTextComponent)context.lookup(JTextComponent.class);
            CompilationController controller = (CompilationController)context.lookup(CompilationController.class);
            TreePath path = (TreePath)context.lookup(TreePath.class);
            TreePath treePath = path = path != null ? Utilities.getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, path) : null;
            if (component == null || controller == null || path == null) {
                return ret;
            }
            try {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            }
            catch (IOException ioe) {
                return ret;
            }
            Elements elements = controller.getElements();
            TypeElement typeElement = (TypeElement)controller.getTrees().getElement(path);
            if (typeElement == null || !typeElement.getKind().isClass()) {
                return ret;
            }
            HashMap<String, List<ExecutableElement>> methods = new HashMap<String, List<ExecutableElement>>();
            for (ExecutableElement method : ElementFilter.methodsIn(elements.getAllMembers(typeElement))) {
                ArrayList<ExecutableElement> l = (ArrayList<ExecutableElement>)methods.get(method.getSimpleName().toString());
                if (l == null) {
                    l = new ArrayList<ExecutableElement>();
                    methods.put(method.getSimpleName().toString(), l);
                }
                l.add(method);
            }
            LinkedHashMap gDescriptions = new LinkedHashMap();
            LinkedHashMap sDescriptions = new LinkedHashMap();
            LinkedHashMap gsDescriptions = new LinkedHashMap();
            for (VariableElement variableElement : ElementFilter.fieldsIn(elements.getAllMembers(typeElement))) {
                List<ElementNode.Description> descriptions2;
                boolean hasSetter;
                if (ERROR.contentEquals(variableElement.getSimpleName())) continue;
                ElementNode.Description description = ElementNode.Description.create((CompilationInfo)controller, variableElement, null, true, false);
                boolean hasGetter = GeneratorUtils.hasGetter((CompilationInfo)controller, typeElement, variableElement, methods);
                boolean bl = hasSetter = variableElement.getModifiers().contains((Object)Modifier.FINAL) || GeneratorUtils.hasSetter((CompilationInfo)controller, typeElement, variableElement, methods);
                if (!hasGetter) {
                    descriptions2 = (ArrayList<ElementNode.Description>)gDescriptions.get(variableElement.getEnclosingElement());
                    if (descriptions2 == null) {
                        descriptions2 = new ArrayList<ElementNode.Description>();
                        gDescriptions.put(variableElement.getEnclosingElement(), descriptions2);
                    }
                    descriptions2.add(description);
                }
                if (!hasSetter) {
                    descriptions2 = (List)sDescriptions.get(variableElement.getEnclosingElement());
                    if (descriptions2 == null) {
                        descriptions2 = new ArrayList();
                        sDescriptions.put(variableElement.getEnclosingElement(), descriptions2);
                    }
                    descriptions2.add(description);
                }
                if (hasGetter || hasSetter) continue;
                descriptions2 = (List)gsDescriptions.get(variableElement.getEnclosingElement());
                if (descriptions2 == null) {
                    descriptions2 = new ArrayList();
                    gsDescriptions.put(variableElement.getEnclosingElement(), descriptions2);
                }
                descriptions2.add(description);
            }
            if (!gDescriptions.isEmpty()) {
                descriptions = new ArrayList<ElementNode.Description>();
                for (Map.Entry entry : gDescriptions.entrySet()) {
                    descriptions.add(ElementNode.Description.create((CompilationInfo)controller, (Element)entry.getKey(), (List)entry.getValue(), false, false));
                }
                Collections.reverse(descriptions);
                ret.add(new GetterSetterGenerator(component, ElementNode.Description.create((CompilationInfo)controller, typeElement, descriptions, false, false), 1));
            }
            if (!sDescriptions.isEmpty()) {
                descriptions = new ArrayList();
                for (Map.Entry entry : sDescriptions.entrySet()) {
                    descriptions.add(ElementNode.Description.create((CompilationInfo)controller, (Element)entry.getKey(), (List)entry.getValue(), false, false));
                }
                Collections.reverse(descriptions);
                ret.add(new GetterSetterGenerator(component, ElementNode.Description.create((CompilationInfo)controller, typeElement, descriptions, false, false), 2));
            }
            if (!gsDescriptions.isEmpty()) {
                descriptions = new ArrayList();
                for (Map.Entry entry : gsDescriptions.entrySet()) {
                    descriptions.add(ElementNode.Description.create((CompilationInfo)controller, (Element)entry.getKey(), (List)entry.getValue(), false, false));
                }
                Collections.reverse(descriptions);
                ret.add(new GetterSetterGenerator(component, ElementNode.Description.create((CompilationInfo)controller, typeElement, descriptions, false, false), 0));
            }
            return ret;
        }
    }
}

