/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony.commands;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.phpmodule.PhpProgram;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.spi.commands.FrameworkCommand;
import org.netbeans.modules.php.spi.commands.FrameworkCommandSupport;
import org.netbeans.modules.php.symfony.SymfonyPhpFrameworkProvider;
import org.netbeans.modules.php.symfony.SymfonyScript;
import org.netbeans.modules.php.symfony.commands.SymfonyCommand;
import org.netbeans.modules.php.symfony.commands.SymfonyCommandVO;
import org.netbeans.modules.php.symfony.commands.SymfonyCommandsXmlParser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

public final class SymfonyCommandSupport
extends FrameworkCommandSupport {
    static final Logger LOGGER = Logger.getLogger(SymfonyCommandSupport.class.getName());
    static final Pattern COMMAND_PATTERN = Pattern.compile("^\\:(\\S+)\\s+(.+)$");
    static final Pattern PREFIX_PATTERN = Pattern.compile("^(\\w+)$");

    public SymfonyCommandSupport(PhpModule phpModule) {
        super(phpModule);
    }

    public String getFrameworkName() {
        return NbBundle.getMessage(SymfonyCommandSupport.class, (String)"MSG_Symfony");
    }

    public void runCommand(FrameworkCommandSupport.CommandDescriptor commandDescriptor) {
        ExternalProcessBuilder callable = this.createCommand(commandDescriptor.getFrameworkCommand().getCommands(), commandDescriptor.getCommandParams());
        ExecutionDescriptor descriptor = this.getDescriptor();
        String displayName = this.getOutputTitle(commandDescriptor);
        ExecutionService service = ExecutionService.newService((Callable)callable, (ExecutionDescriptor)descriptor, (String)displayName);
        service.run();
    }

    public File redirectScriptOutput(String command, String ... arguments) {
        ExternalProcessBuilder processBuilder = this.createSilentCommand(command, arguments);
        if (processBuilder == null) {
            return null;
        }
        File output = null;
        try {
            final RedirectOutputProcessor inputProcessor = new RedirectOutputProcessor();
            ExecutionDescriptor executionDescriptor = new ExecutionDescriptor().inputOutput(InputOutput.NULL).outProcessorFactory(new ExecutionDescriptor.InputProcessorFactory(){

                public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                    return inputProcessor;
                }
            });
            ExecutionService service = ExecutionService.newService((Callable)processBuilder, (ExecutionDescriptor)executionDescriptor, (String)("output redirect for: " + this.getOutputTitle(command, arguments)));
            Future task = service.run();
            try {
                if ((Integer)task.get() == 0) {
                    output = inputProcessor.getOutputFile();
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException ex) {
                UiUtils.processExecutionException((ExecutionException)ex, (String)SymfonyScript.getOptionsSubPath());
            }
        }
        catch (IOException exc) {
            LOGGER.log(Level.WARNING, null, exc);
        }
        return output;
    }

    protected String getOptionsPath() {
        return SymfonyScript.getOptionsPath();
    }

    protected ExternalProcessBuilder getProcessBuilder(boolean warnUser) {
        ExternalProcessBuilder externalProcessBuilder = super.getProcessBuilder(warnUser);
        if (externalProcessBuilder == null) {
            return null;
        }
        SymfonyScript symfonyScript = null;
        try {
            symfonyScript = SymfonyScript.forPhpModule(this.phpModule, warnUser);
        }
        catch (PhpProgram.InvalidPhpProgramException ex) {
            if (warnUser) {
                UiUtils.invalidScriptProvided((String)ex.getMessage(), (String)SymfonyScript.getOptionsSubPath());
            }
            return null;
        }
        assert (symfonyScript.isValid());
        externalProcessBuilder = externalProcessBuilder.workingDirectory(FileUtil.toFile((FileObject)this.phpModule.getSourceDirectory())).addArgument(symfonyScript.getProgram());
        for (String param : symfonyScript.getParameters()) {
            externalProcessBuilder = externalProcessBuilder.addArgument(param);
        }
        return externalProcessBuilder;
    }

    protected List<FrameworkCommand> getFrameworkCommandsInternal() {
        List<Object> freshCommands = this.getFrameworkCommandsInternalXml();
        if (freshCommands != null) {
            return freshCommands;
        }
        ExternalProcessBuilder processBuilder = this.createCommand("list", new String[0]);
        if (processBuilder == null) {
            return null;
        }
        processBuilder = processBuilder.redirectErrorStream(true);
        final CommandsLineProcessor lineProcessor = new CommandsLineProcessor();
        ExecutionDescriptor executionDescriptor = new ExecutionDescriptor().inputOutput(InputOutput.NULL).outProcessorFactory(new ExecutionDescriptor.InputProcessorFactory(){

            public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                return InputProcessors.ansiStripping((InputProcessor)InputProcessors.bridge((LineProcessor)lineProcessor));
            }
        });
        freshCommands = Collections.emptyList();
        ExecutionService service = ExecutionService.newService((Callable)processBuilder, (ExecutionDescriptor)executionDescriptor, (String)"help");
        Future task = service.run();
        try {
            String error;
            if ((Integer)task.get() == 0) {
                freshCommands = lineProcessor.getCommands();
            }
            if (freshCommands.isEmpty() && StringUtils.hasText((String)(error = lineProcessor.getError()))) {
                NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(SymfonyCommandSupport.class, (String)"MSG_NoCommands"), 0);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == NotifyDescriptor.YES_OPTION) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)error));
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(error);
                }
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        return freshCommands;
    }

    private List<FrameworkCommand> getFrameworkCommandsInternalXml() {
        BufferedReader reader;
        File output = this.redirectScriptOutput("list", "--xml");
        if (output == null) {
            return null;
        }
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(output), "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.log(Level.WARNING, null, ex);
            return null;
        }
        catch (FileNotFoundException ex) {
            assert (false);
            return null;
        }
        ArrayList<SymfonyCommandVO> commandsVO = new ArrayList<SymfonyCommandVO>();
        SymfonyCommandsXmlParser.parse(reader, commandsVO);
        if (commandsVO.isEmpty()) {
            LOGGER.info("Symfony commands from XML should be parsed");
            return null;
        }
        ArrayList<FrameworkCommand> commands = new ArrayList<FrameworkCommand>(commandsVO.size());
        for (SymfonyCommandVO command : commandsVO) {
            commands.add(new SymfonyCommand(this.phpModule, command.getCommand(), command.getDescription(), command.getCommand()));
        }
        return commands;
    }

    protected File getPluginsDirectory() {
        FileObject plugins = SymfonyPhpFrameworkProvider.locate(this.phpModule, "plugins", true);
        if (plugins != null && plugins.isFolder()) {
            return FileUtil.toFile((FileObject)plugins);
        }
        return null;
    }

    class CommandsLineProcessor
    implements LineProcessor {
        private final StringBuffer error = new StringBuffer(200);
        private final String newLine = System.getProperty("line.separator");
        private final List<FrameworkCommand> commands = new ArrayList<FrameworkCommand>();
        private String prefix;

        CommandsLineProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processLine(String line) {
            Matcher commandMatcher;
            if (!StringUtils.hasText((String)line)) {
                this.prefix = null;
                return;
            }
            this.error.append(line);
            this.error.append(this.newLine);
            String trimmed = line.trim();
            Matcher prefixMatcher = PREFIX_PATTERN.matcher(trimmed);
            if (prefixMatcher.matches()) {
                this.prefix = prefixMatcher.group(1);
            }
            if ((commandMatcher = COMMAND_PATTERN.matcher(trimmed)).matches()) {
                String command = commandMatcher.group(1);
                if (this.prefix != null) {
                    command = this.prefix + ":" + command;
                }
                String description = commandMatcher.group(2);
                List<FrameworkCommand> list = this.commands;
                synchronized (list) {
                    this.commands.add(new SymfonyCommand(SymfonyCommandSupport.this.phpModule, command, description, command));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<FrameworkCommand> getCommands() {
            ArrayList<FrameworkCommand> copy = null;
            List<FrameworkCommand> list = this.commands;
            synchronized (list) {
                copy = new ArrayList<FrameworkCommand>(this.commands);
            }
            return copy;
        }

        public String getError() {
            return this.error.toString();
        }

        public void close() {
        }

        public void reset() {
        }
    }

    private static class RedirectOutputProcessor
    implements InputProcessor {
        private final File outputFile = File.createTempFile("nb-symfony-xml-", ".xml");
        private final FileOutputStream fos = new FileOutputStream(this.outputFile);
        private final BufferedOutputStream bos = new BufferedOutputStream(this.fos);

        public RedirectOutputProcessor() throws IOException {
            this.outputFile.deleteOnExit();
        }

        public void processInput(char[] chars) throws IOException {
            for (char c : chars) {
                this.bos.write((byte)c);
            }
        }

        public void reset() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            try {
                this.bos.close();
            }
            catch (IOException exc) {
                LOGGER.log(Level.WARNING, null, exc);
            }
            finally {
                try {
                    this.fos.close();
                }
                catch (IOException exc) {
                    LOGGER.log(Level.WARNING, null, exc);
                }
            }
        }

        public File getOutputFile() {
            return this.outputFile;
        }
    }
}

