/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.storage;

import org.netbeans.modules.dlight.api.storage.DataRow;

public final class DataUtil {
    private DataUtil() {
    }

    public static int[] toInts(Object obj) {
        if (obj instanceof Number) {
            return new int[]{((Number)obj).intValue()};
        }
        if (obj instanceof String) {
            String[] split = ((String)obj).split(" ");
            int[] out = new int[split.length];
            for (int i = 0; i < split.length; ++i) {
                String string = split[i];
                out[i] = DataUtil.toInt(string);
            }
            return out;
        }
        return new int[0];
    }

    public static int toInt(Object obj) {
        return DataUtil.toInt(obj, 0);
    }

    public static int toInt(Object obj, int defaultValue) {
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        if (obj instanceof String) {
            try {
                return Integer.parseInt((String)obj);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static long toLong(Object obj) {
        return DataUtil.toLong(obj, 0L);
    }

    public static long toLong(Object obj, long defaultValue) {
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof String) {
            try {
                return Long.parseLong((String)obj);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static float toFloat(Object obj) {
        return DataUtil.toFloat(obj, 0.0f);
    }

    public static float toFloat(Object obj, float defaultValue) {
        if (obj instanceof Number) {
            return ((Number)obj).floatValue();
        }
        if (obj instanceof String) {
            try {
                return Float.parseFloat(((String)obj).replace(',', '.'));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static double toDouble(Object obj) {
        return DataUtil.toDouble(obj, 0.0);
    }

    public static double toDouble(Object obj, double defaultValue) {
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        if (obj instanceof String) {
            try {
                return Double.parseDouble(((String)obj).replace(',', '.'));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static long getTimestamp(DataRow row) {
        Object timestamp = row.getData("timestamp");
        return DataUtil.toLong(timestamp, -1L);
    }
}

