/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.dlight.api.storage.ForeignKeyConstraint;

public final class DataTableMetadata {
    private final String name;
    private final List<Column> columns;
    private final List<Column> indexedColumns;
    private final List<String> columnNames;
    private final List<DataTableMetadata> sourceTables;
    private final String statement;
    private final List<Column> primaryKeyColumns = new ArrayList<Column>();
    private final List<Column> autoIncrementList = new ArrayList<Column>();
    private final List<ForeignKeyConstraint> fKeys;

    public DataTableMetadata(String name, List<Column> columns, List<Column> indexedColumns) {
        this(name, columns, indexedColumns, null, null);
    }

    public DataTableMetadata(String name, List<Column> columns, String statement, List<DataTableMetadata> sourceTables) {
        this(name, columns, null, statement, sourceTables);
    }

    private DataTableMetadata(String name, List<Column> columns, List<Column> indexedColumns, String statement, List<DataTableMetadata> sourceTables) {
        this.name = name;
        this.columns = columns;
        this.indexedColumns = indexedColumns == null ? Collections.emptyList() : indexedColumns;
        this.statement = statement;
        this.sourceTables = sourceTables;
        this.fKeys = new ArrayList<ForeignKeyConstraint>();
        this.columnNames = new ArrayList<String>(columns.size());
        for (Column c : columns) {
            this.columnNames.add(c.getColumnName());
        }
    }

    public void addForeignKey(Column c, DataTableMetadata referenceTable, Column referenceColumn) {
        if (!this.getColumns().contains(c)) {
            throw new IllegalArgumentException("Column " + c.getColumnName() + " doesn't belong to the table " + this.getName());
        }
        if (!referenceTable.getColumns().contains(referenceColumn)) {
            throw new IllegalArgumentException("Column " + referenceColumn.getColumnName() + " doesn't belong to the table " + referenceTable.getName());
        }
        ForeignKeyConstraint fk = new ForeignKeyConstraint(this, c, referenceTable, referenceColumn);
        this.fKeys.add(fk);
    }

    public List<ForeignKeyConstraint> getForeignKeyConstraints() {
        return Collections.unmodifiableList(this.fKeys);
    }

    public void setPrimaryKey(List<Column> primaryKeys) {
        this.primaryKeyColumns.clear();
        this.primaryKeyColumns.addAll(primaryKeys);
    }

    public void setAutoIncrement(Column c) {
        if (this.autoIncrementList.contains(c)) {
            return;
        }
        this.autoIncrementList.add(c);
    }

    public boolean isPrimaryKey(Column c) {
        return this.primaryKeyColumns.contains(c);
    }

    public boolean isAutoIncrement(Column c) {
        return this.autoIncrementList.contains(c);
    }

    public List<String> getColumnNames() {
        return this.columnNames == null ? null : Collections.unmodifiableList(this.columnNames);
    }

    public List<DataTableMetadata> getSourceTables() {
        return this.sourceTables == null ? null : Collections.unmodifiableList(this.sourceTables);
    }

    public String getName() {
        return this.name;
    }

    public List<Column> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public List<Column> getIndexedColumns() {
        return Collections.unmodifiableList(this.indexedColumns);
    }

    public String getViewStatement() {
        return this.statement;
    }

    public Column getColumnByName(String columnName) {
        for (Column c : this.columns) {
            if (!c.getColumnName().equals(columnName)) continue;
            return c;
        }
        for (Column c : this.columns) {
            if (!c.getColumnUName().equals(columnName)) continue;
            return c;
        }
        return null;
    }

    public int getColumnsCount() {
        return this.columns.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append(' ');
        if (this.columns != null) {
            for (Column column : this.columns) {
                sb.append("\n\t");
                sb.append(column);
            }
        }
        return sb.toString();
    }

    public boolean isProvidedBy(List<DataTableMetadata> list) {
        if (this.sourceTables != null) {
            for (DataTableMetadata tableWeSearch : this.sourceTables) {
                boolean found = false;
                for (DataTableMetadata tableWeHave : list) {
                    if (!tableWeSearch.getName().equalsIgnoreCase(tableWeHave.getName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        for (DataTableMetadata md : list) {
            if (!md.getName().equalsIgnoreCase(this.getName())) continue;
            return true;
        }
        return false;
    }

    public static final class Column {
        final String name;
        final Class<?> columnClass;
        final String shortUName;
        final String longUName;
        final String expression;

        public Column(String name, Class<?> columnClass) {
            this(name, columnClass, name, null);
        }

        public Column(String name, Class<?> columnClass, String shortName, String expression) {
            this(name, columnClass, shortName, shortName, expression);
        }

        public Column(String name, Class<?> columnClass, String shortName, String longName, String expression) {
            this.name = name;
            this.columnClass = columnClass;
            this.shortUName = shortName;
            this.longUName = longName;
            this.expression = expression;
        }

        public Class<?> getColumnClass() {
            return this.columnClass;
        }

        public String getColumnName() {
            return this.name;
        }

        public String getColumnLongUName() {
            return this.longUName;
        }

        public String getColumnUName() {
            return this.shortUName;
        }

        public String getExpression() {
            return this.expression;
        }

        public String toString() {
            return this.name + " : (" + this.getColumnClass().getName() + ")";
        }
    }
}

