/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.discovery.api.ApplicableImpl;
import org.netbeans.modules.cnd.discovery.api.Configuration;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.api.FolderProperties;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.DwarfProvider;

public class DwarfAnalyzer {
    public static void analyze(String[] stringArray) {
        DwarfProvider dwarfProvider = new DwarfProvider(){

            public DiscoveryExtensionInterface.Applicable canAnalyze(ProjectProxy projectProxy) {
                return new ApplicableImpl(true, null, null, 1, false, null, null, null, null);
            }
        };
        dwarfProvider.getProperty("binaries").setValue((Object)stringArray);
        DwarfAnalyzer.dumpProject(dwarfProvider, new ProjectProxy(){

            public boolean createSubProjects() {
                return false;
            }

            public Project getProject() {
                return null;
            }

            public String getMakefile() {
                return null;
            }

            public String getSourceRoot() {
                return null;
            }

            public String getExecutable() {
                return null;
            }

            public String getWorkingFolder() {
                return null;
            }
        });
    }

    private static void dumpProject(DwarfProvider dwarfProvider, ProjectProxy projectProxy) {
        List<Configuration> list = dwarfProvider.analyze(projectProxy, null);
        for (Configuration configuration : list) {
            List list2 = configuration.getProjectConfiguration();
            for (ProjectProperties projectProperties : list2) {
                String string = ItemProperties.LanguageKind.CPP == projectProperties.getLanguageKind() ? "c++" : "c";
                System.out.println("Project " + string);
                System.out.println("User include paths:");
                StringBuilder stringBuilder = new StringBuilder();
                for (String string2 : projectProperties.getUserInludePaths()) {
                    System.out.println(string2);
                    if (!string2.startsWith(File.separator)) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(":");
                    }
                    stringBuilder.append(string2);
                }
                System.out.println("Configuration string:");
                System.out.println("    " + stringBuilder.toString());
                System.out.println("User macros:");
                for (Map.Entry entry : projectProperties.getUserMacros().entrySet()) {
                    System.out.println((String)entry.getKey() + "=" + (String)entry.getValue());
                }
                List list3 = projectProperties.getConfiguredFolders();
                Iterator iterator2 = list3.iterator();
                while (iterator2.hasNext()) {
                    FolderProperties folderProperties = (FolderProperties)iterator2.next();
                    DwarfAnalyzer.dumpFolder(folderProperties);
                }
            }
        }
    }

    private static void dumpFolder(FolderProperties folderProperties) {
        System.out.println("Folder " + folderProperties.getItemPath());
        System.out.println("User include paths:");
        StringBuilder stringBuilder = new StringBuilder();
        for (String object : folderProperties.getUserInludePaths()) {
            System.out.println(object);
            if (!object.startsWith(File.separator)) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(":");
            }
            stringBuilder.append(object);
        }
        System.out.println("Configuration string:");
        System.out.println("    " + stringBuilder.toString());
        System.out.println("User macros:");
        for (Map.Entry entry : folderProperties.getUserMacros().entrySet()) {
            System.out.println((String)entry.getKey() + "=" + (String)entry.getValue());
        }
    }
}

