/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.FieldDescriptor;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.StaticFieldInitializer;
import com.sun.javacard.jcasm.cap.Component;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;

public class StaticFieldComponent
extends Component {
    protected Vector<NonDefaultValue> primitiveInitVector;
    protected Vector<NonDefaultValue> arrayInitVector = new Vector();
    protected int reference_count;
    protected int non_default_value_count;
    protected int default_value_count;
    protected Vector<Field> segment1;
    protected Vector<Field> segment2;
    protected Vector<Field> segment3;
    protected Vector<Field> segment4;
    boolean isLibrary;

    public StaticFieldComponent(JCPackage jCPackage) {
        super(jCPackage);
        this.primitiveInitVector = new Vector();
        this.segment1 = new Vector();
        this.segment2 = new Vector();
        this.segment3 = new Vector();
        this.segment4 = new Vector();
        this.isLibrary = jCPackage.appletCount() <= 0;
    }

    int getImageSize() {
        return this.default_value_count + this.non_default_value_count + this.reference_count * 2;
    }

    int getArrayInitCount() {
        return this.arrayInitVector.size();
    }

    int getArrayInitSize() {
        int n = 0;
        for (NonDefaultValue nonDefaultValue : this.arrayInitVector) {
            int n2 = nonDefaultValue.size() - 3;
            n += n2;
        }
        return n;
    }

    @Override
    public int dataSize() {
        int n = 10;
        for (NonDefaultValue nonDefaultValue : this.arrayInitVector) {
            n += nonDefaultValue.size();
        }
        return n += this.non_default_value_count;
    }

    @Override
    protected byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            byte[] byArray;
            byte[] byArray2 = super.toByteArray();
            dataOutputStream.write(byArray2, 0, byArray2.length);
            dataOutputStream.writeShort(this.getImageSize());
            dataOutputStream.writeShort(this.reference_count);
            dataOutputStream.writeShort(this.arrayInitVector.size());
            for (NonDefaultValue nonDefaultValue : this.arrayInitVector) {
                byArray = nonDefaultValue.toByteArray();
                dataOutputStream.write(byArray, 0, byArray.length);
            }
            dataOutputStream.writeShort(this.default_value_count);
            dataOutputStream.writeShort(this.non_default_value_count);
            for (NonDefaultValue nonDefaultValue : this.primitiveInitVector) {
                byArray = nonDefaultValue.toByteArray();
                dataOutputStream.write(byArray, 0, byArray.length);
            }
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            return null;
        }
        assert (this.size() == byteArrayOutputStream.size()) : "size() != bos.size()";
        return byteArrayOutputStream.toByteArray();
    }

    protected void getDebugOffsets(Map<String, Integer> map) {
        Vector[] vectorArray = new Vector[]{this.segment1, this.segment2, this.segment3, this.segment4};
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            Enumeration enumeration = vectorArray[i].elements();
            while (enumeration.hasMoreElements()) {
                Field field = (Field)enumeration.nextElement();
                map.put(field.getName(), new Integer(n));
                n += field.size();
            }
        }
    }

    public void add(JCClass jCClass) {
        Enumeration<Field> enumeration = jCClass.fieldElements();
        while (enumeration.hasMoreElements()) {
            Field field = enumeration.nextElement();
            if (!Modifier.isStatic(field.getAttributes()) || Modifier.isFinal(field.getAttributes()) && field.getDescriptor().isPrimitive()) continue;
            FieldDescriptor fieldDescriptor = field.getDescriptor();
            StaticFieldInitializer staticFieldInitializer = field.getFieldInitializer();
            if (fieldDescriptor.isPrimitive()) {
                if (staticFieldInitializer != null) {
                    this.non_default_value_count += field.size();
                    this.primitiveInitVector.addElement(new NonDefaultValue(field.size(), staticFieldInitializer.getPrimitiveData()));
                    this.segment4.addElement(field);
                    continue;
                }
                this.default_value_count += field.size();
                this.segment3.addElement(field);
                continue;
            }
            ++this.reference_count;
            if (staticFieldInitializer == null) {
                this.segment2.addElement(field);
                continue;
            }
            if (staticFieldInitializer.isArrayDataNull()) {
                this.segment2.addElement(field);
                continue;
            }
            if (this.isLibrary) {
                Object[] objectArray = new Object[]{jCClass.getName()};
                Msg.error("static.1", objectArray);
            }
            if (!fieldDescriptor.isArray() && staticFieldInitializer.getType() != null) {
                this.arrayInitVector.addElement(new NonDefaultValue(staticFieldInitializer.getType().getDescriptorString(), staticFieldInitializer.getArrayData()));
            } else {
                this.arrayInitVector.addElement(new NonDefaultValue(fieldDescriptor.getDescriptorString(), staticFieldInitializer.getArrayData()));
            }
            this.segment1.addElement(field);
        }
    }

    void assignAddresses() {
        int n = 0;
        for (Field field : this.segment1) {
            field.relocate(n);
            n += field.size();
        }
        for (Field field : this.segment2) {
            field.relocate(n);
            n += field.size();
        }
        for (Field field : this.segment3) {
            field.relocate(n);
            n += field.size();
        }
        for (Field field : this.segment4) {
            field.relocate(n);
            n += field.size();
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("Image Size: " + this.getImageSize() + Msg.eol);
        stringBuffer.append("First Reference Count: " + this.reference_count + Msg.eol);
        stringBuffer.append("Array Init Count: " + this.arrayInitVector.size() + Msg.eol);
        for (NonDefaultValue nonDefaultValue : this.arrayInitVector) {
            stringBuffer.append("Array Init: " + Msg.toHexString(nonDefaultValue.toByteArray()) + Msg.eol);
        }
        stringBuffer.append("Default Value Count: " + this.default_value_count + Msg.eol);
        stringBuffer.append("Non-Default Value Count: " + this.non_default_value_count + Msg.eol);
        for (NonDefaultValue nonDefaultValue : this.primitiveInitVector) {
            stringBuffer.append("Primitive Init: " + Msg.toHexString(nonDefaultValue.toByteArray()) + Msg.eol);
        }
        return stringBuffer.toString();
    }

    public short getReferenceFieldCount() {
        return (short)this.reference_count;
    }

    public Vector<Field> getSegment(int n) {
        switch (n) {
            case 1: {
                return this.segment1;
            }
            case 2: {
                return this.segment2;
            }
            case 3: {
                return this.segment3;
            }
            case 4: {
                return this.segment4;
            }
        }
        return null;
    }

    static class NonDefaultValue {
        protected int width;
        protected int value;
        protected String descriptor;
        protected int[] arrayValue;
        private boolean isPrimitive;

        NonDefaultValue(int n, int n2) {
            this.width = n;
            this.value = n2;
            this.isPrimitive = true;
        }

        NonDefaultValue(String string, int[] nArray) {
            this.descriptor = string;
            this.arrayValue = nArray;
            if (string.equals("[B")) {
                this.width = 1;
            } else if (string.equals("[Z")) {
                this.width = 1;
            } else if (string.equals("[S")) {
                this.width = 2;
            } else if (string.equals("[I")) {
                this.width = 4;
            }
        }

        int size() {
            if (this.isPrimitive) {
                return this.width;
            }
            return 3 + this.width * this.arrayValue.length;
        }

        byte[] toByteArray() {
            byte[] byArray = new byte[this.size()];
            if (this.isPrimitive) {
                this.setArrayElement(byArray, 0, this.width, this.value);
            } else {
                if (this.descriptor.equals("[B")) {
                    byArray[0] = 3;
                } else if (this.descriptor.equals("[Z")) {
                    byArray[0] = 2;
                } else if (this.descriptor.equals("[S")) {
                    byArray[0] = 4;
                } else if (this.descriptor.equals("[I")) {
                    byArray[0] = 5;
                }
                this.setArrayElement(byArray, 1, 2, this.arrayValue.length * this.width);
                int n = 3;
                for (int n2 : this.arrayValue) {
                    this.setArrayElement(byArray, n, this.width, n2);
                    n += this.width;
                }
            }
            return byArray;
        }

        private void setArrayElement(byte[] byArray, int n, int n2, int n3) {
            switch (n2) {
                case 1: {
                    byArray[n] = (byte)n3;
                    break;
                }
                case 2: {
                    byArray[n] = (byte)(n3 >> 8 & 0xFF);
                    byArray[n + 1] = (byte)(n3 & 0xFF);
                    break;
                }
                case 4: {
                    byArray[n] = (byte)(n3 >> 24 & 0xFF);
                    byArray[n + 1] = (byte)(n3 >> 16 & 0xFF);
                    byArray[n + 2] = (byte)(n3 >> 8 & 0xFF);
                    byArray[n + 3] = (byte)(n3 & 0xFF);
                }
            }
        }

        public String toString() {
            return Msg.toHexString(this.toByteArray());
        }
    }
}

