/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2;

import java.util.HashSet;
import java.util.Set;

public class ValuePresenter {
    private static Presenter[] presenters = new Presenter[]{new StdStringPresenter()};

    private ValuePresenter() {
    }

    public static String getValue(String value) {
        return ValuePresenter.getValue(null, value);
    }

    public static String getValue(String type, String value) {
        for (Presenter vp : presenters) {
            if (!vp.accepts(type, value)) continue;
            return vp.present(type, value);
        }
        return value;
    }

    public static boolean acceptsType(String type) {
        for (Presenter vp : presenters) {
            if (!vp.acceptsType(type)) continue;
            return true;
        }
        return false;
    }

    private static int findEndOfString(String s, int idx) {
        int len = s.length();
        while (idx < len) {
            char ch = s.charAt(idx);
            if (ch == '\"' && !ValuePresenter.isSlashBefore(s, idx)) {
                return idx;
            }
            ++idx;
        }
        throw new IllegalStateException("Failed to find end of string: " + s);
    }

    private static boolean isSlashBefore(String source, int pos) {
        int count = 0;
        --pos;
        while (pos > 0 && source.charAt(pos) == '\\') {
            --pos;
            ++count;
        }
        return count % 2 == 1;
    }

    private static class StdStringPresenter
    implements Presenter {
        private static final String VALUE_PREFIX = "_M_p";
        private static final Set<String> TYPES = new HashSet<String>();

        private StdStringPresenter() {
        }

        public boolean acceptsType(String type) {
            return TYPES.contains(type);
        }

        public boolean accepts(String type, String value) {
            if (type == null) {
                return StdStringPresenter.checkValue(value);
            }
            return this.acceptsType(type) && value != null && value.contains(VALUE_PREFIX);
        }

        private static boolean checkValue(String value) {
            if (value == null || value.length() < 10) {
                return false;
            }
            int start = value.indexOf(123);
            if (start == -1) {
                return false;
            }
            int end = value.lastIndexOf(125);
            if (end == -1 || end < start + 1) {
                return false;
            }
            if ((value = value.substring(start + 1, end)).indexOf("static npos") == -1) {
                return false;
            }
            return value.indexOf(VALUE_PREFIX) != -1;
        }

        public String present(String type, String value) {
            int pos = value.indexOf(VALUE_PREFIX);
            assert (pos > 0);
            if ((pos = value.indexOf(34, pos)) > 0) {
                if (value.charAt(pos - 1) == '\\') {
                    return this.present(type, value.replace("\\\"", "\""));
                }
                int end = ValuePresenter.findEndOfString(value, pos + 1);
                if (end != -1) {
                    return value.substring(pos, end + 1);
                }
            }
            return value;
        }

        static {
            TYPES.add("string");
            TYPES.add("string &");
            TYPES.add("std::string");
            TYPES.add("std::string &");
        }
    }

    private static interface Presenter {
        public boolean acceptsType(String var1);

        public boolean accepts(String var1, String var2);

        public String present(String var1, String var2);
    }
}

