/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.lucene;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.search.Query;
import org.netbeans.modules.parsing.lucene.IndexDocumentImpl;
import org.netbeans.modules.parsing.lucene.support.Convertor;
import org.netbeans.modules.parsing.lucene.support.DocumentIndex;
import org.netbeans.modules.parsing.lucene.support.Index;
import org.netbeans.modules.parsing.lucene.support.IndexDocument;
import org.netbeans.modules.parsing.lucene.support.Queries;

public final class DocumentIndexImpl
implements DocumentIndex {
    private final Index luceneIndex;
    private static final Convertor<IndexDocumentImpl, Document> ADD_CONVERTOR = new AddConvertor();
    private static final Convertor<String, Query> REMOVE_CONVERTOR = new RemoveConvertor();
    private static final Convertor<Document, IndexDocumentImpl> QUERY_CONVERTOR = new QueryConvertor();
    private static final Logger LOGGER = Logger.getLogger(DocumentIndexImpl.class.getName());
    private final List<IndexDocumentImpl> toAdd = new LinkedList<IndexDocumentImpl>();
    private final List<String> toRemove = new LinkedList<String>();
    private final Set<String> dirtyKeys = new HashSet<String>();
    private Reference<List[]> dataRef;

    public DocumentIndexImpl(Index index) {
        assert (index != null);
        this.luceneIndex = index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDocument(IndexDocument document) {
        boolean forceFlush;
        DocumentIndexImpl documentIndexImpl = this;
        synchronized (documentIndexImpl) {
            assert (document instanceof IndexDocumentImpl);
            Reference<List[]> ref = this.getDataRef();
            assert (ref != null);
            forceFlush = ref.get() == null;
            this.toAdd.add((IndexDocumentImpl)document);
            this.toRemove.add(document.getPrimaryKey());
        }
        if (forceFlush) {
            try {
                LOGGER.fine("Extra flush forced");
                this.store(false);
                System.gc();
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, null, ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDocument(String primaryKey) {
        boolean forceFlush;
        DocumentIndexImpl documentIndexImpl = this;
        synchronized (documentIndexImpl) {
            Reference<List[]> ref = this.getDataRef();
            assert (ref != null);
            forceFlush = ref.get() == null;
            this.toRemove.add(primaryKey);
        }
        if (forceFlush) {
            try {
                LOGGER.fine("Extra flush forced");
                this.store(false);
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, null, ioe);
            }
        }
    }

    @Override
    public boolean isValid() throws IOException {
        return this.luceneIndex.isValid(true);
    }

    @Override
    public void close() throws IOException {
        this.luceneIndex.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(boolean optimize) throws IOException {
        ArrayList<String> _toRemove;
        ArrayList<IndexDocumentImpl> _toAdd;
        DocumentIndexImpl documentIndexImpl = this;
        synchronized (documentIndexImpl) {
            _toAdd = new ArrayList<IndexDocumentImpl>(this.toAdd);
            _toRemove = new ArrayList<String>(this.toRemove);
            this.toAdd.clear();
            this.toRemove.clear();
            this.dataRef = null;
            if (!this.dirtyKeys.isEmpty()) {
                for (IndexDocumentImpl ldoc : _toAdd) {
                    this.dirtyKeys.remove(ldoc.getPrimaryKey());
                }
                this.dirtyKeys.removeAll(_toRemove);
            }
        }
        if (_toAdd.size() > 0 || _toRemove.size() > 0) {
            LOGGER.log(Level.FINE, "Flushing: {0}", this.luceneIndex.toString());
            this.luceneIndex.store(_toAdd, _toRemove, ADD_CONVERTOR, REMOVE_CONVERTOR, optimize);
        }
    }

    @Override
    public Collection<? extends IndexDocument> query(String fieldName, String value, Queries.QueryKind kind, String ... fieldsToLoad) throws IOException, InterruptedException {
        assert (fieldName != null);
        assert (value != null);
        assert (kind != null);
        LinkedList result = new LinkedList();
        Query query = Queries.createQuery(fieldName, fieldName, value, kind);
        FieldSelector selector = null;
        if (fieldsToLoad != null && fieldsToLoad.length > 0) {
            String[] fieldsWithSource = new String[fieldsToLoad.length + 1];
            System.arraycopy(fieldsToLoad, 0, fieldsWithSource, 0, fieldsToLoad.length);
            fieldsWithSource[fieldsToLoad.length] = "_sn";
            selector = Queries.createFieldSelector(fieldsWithSource);
        }
        this.luceneIndex.query(result, QUERY_CONVERTOR, selector, null, query);
        return result;
    }

    @Override
    public Collection<? extends IndexDocument> findByPrimaryKey(String primaryKeyValue, Queries.QueryKind kind, String ... fieldsToLoad) throws IOException, InterruptedException {
        return this.query("_sn", primaryKeyValue, kind, fieldsToLoad);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markKeyDirty(String primaryKey) {
        DocumentIndexImpl documentIndexImpl = this;
        synchronized (documentIndexImpl) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "{0}, adding dirty key: {1}", new Object[]{this, primaryKey});
            }
            this.dirtyKeys.add(primaryKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDirtyKeys(Collection<? extends String> keysToRemove) {
        DocumentIndexImpl documentIndexImpl = this;
        synchronized (documentIndexImpl) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "{0}, Removing dirty keys: {1}", new Object[]{this, keysToRemove});
            }
            this.dirtyKeys.removeAll(keysToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<? extends String> getDirtyKeys() {
        DocumentIndexImpl documentIndexImpl = this;
        synchronized (documentIndexImpl) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "{0}, dirty keys: {1}", new Object[]{this, this.dirtyKeys});
            }
            return new ArrayList<String>(this.dirtyKeys);
        }
    }

    public String toString() {
        return "DocumentIndex[" + this.luceneIndex.toString() + "]";
    }

    private Reference<List[]> getDataRef() {
        assert (Thread.holdsLock(this));
        if (this.toAdd.isEmpty() && this.toRemove.isEmpty()) {
            assert (this.dataRef == null);
            this.dataRef = new SoftReference<List[]>(new List[]{this.toAdd, this.toRemove});
        }
        return this.dataRef;
    }

    private static final class QueryConvertor
    implements Convertor<Document, IndexDocumentImpl> {
        private QueryConvertor() {
        }

        @Override
        public IndexDocumentImpl convert(Document p) {
            return new IndexDocumentImpl(p);
        }
    }

    private static final class RemoveConvertor
    implements Convertor<String, Query> {
        private RemoveConvertor() {
        }

        @Override
        public Query convert(String p) {
            return IndexDocumentImpl.sourceNameQuery(p);
        }
    }

    private static final class AddConvertor
    implements Convertor<IndexDocumentImpl, Document> {
        private AddConvertor() {
        }

        @Override
        public Document convert(IndexDocumentImpl p) {
            return p.doc;
        }
    }
}

