/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.event.Event;
import com.sun.jdi.request.EventRequest;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ThreadBreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsReader;
import org.netbeans.modules.debugger.jpda.breakpoints.ClassBreakpointImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.ExceptionBreakpointImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.FieldBreakpointImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.LineBreakpointImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.MethodBreakpointImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.PersistenceManager;
import org.netbeans.modules.debugger.jpda.breakpoints.ThreadBreakpointImpl;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.Exceptions;

public class BreakpointsEngineListener
extends LazyActionsManagerListener
implements PropertyChangeListener,
DebuggerManagerListener {
    private static Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.breakpoints");
    private JPDADebuggerImpl debugger;
    private SourcePath engineContext;
    private boolean started = false;
    private Session session;
    private BreakpointsReader breakpointsReader;
    private final Map<Breakpoint, BreakpointImpl> breakpointToImpl = new IdentityHashMap<Breakpoint, BreakpointImpl>();
    private final BreakpointImpl preliminaryBreakpointImpl = new PreliminaryBreakpointImpl();

    public BreakpointsEngineListener(ContextProvider lookupProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)lookupProvider.lookupFirst(null, JPDADebugger.class));
        this.engineContext = (SourcePath)lookupProvider.lookupFirst(null, SourcePath.class);
        this.session = (Session)lookupProvider.lookupFirst(null, Session.class);
        this.debugger.addPropertyChangeListener("state", this);
        this.breakpointsReader = PersistenceManager.findBreakpointsReader();
    }

    protected void destroy() {
        this.debugger.removePropertyChangeListener("state", this);
        DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", (DebuggerManagerListener)this);
        this.removeBreakpointImpls();
    }

    public String[] getProperties() {
        return new String[]{"asd"};
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.debugger.getState() == 2) {
            if (this.started) {
                return;
            }
            this.started = true;
            this.createBreakpointImpls();
            DebuggerManager.getDebuggerManager().addDebuggerListener("breakpoints", (DebuggerManagerListener)this);
        }
        if (this.debugger.getState() == 4) {
            this.removeBreakpointImpls();
            this.started = false;
            DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", (DebuggerManagerListener)this);
        }
    }

    public void actionPerformed(Object action) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void breakpointAdded(final Breakpoint breakpoint) {
        final boolean[] started = new boolean[]{false};
        if (!EventQueue.isDispatchThread() && this.debugger.accessLock.readLock().tryLock()) {
            try {
                this.createBreakpointImpl(breakpoint);
                return;
            }
            finally {
                this.debugger.accessLock.readLock().unlock();
            }
        }
        this.debugger.getRequestProcessor().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ((BreakpointsEngineListener)BreakpointsEngineListener.this).debugger.accessLock.readLock().lock();
                try {
                    boolean[] blArray = started;
                    synchronized (started) {
                        started[0] = true;
                        started.notify();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        BreakpointsEngineListener.this.createBreakpointImpl(breakpoint);
                    }
                }
                finally {
                    ((BreakpointsEngineListener)BreakpointsEngineListener.this).debugger.accessLock.readLock().unlock();
                }
                {
                    return;
                }
            }
        });
        if (EventQueue.isDispatchThread()) return;
        boolean[] blArray = started;
        synchronized (started) {
            if (started[0]) return;
            try {
                started.wait();
            }
            catch (InterruptedException iex) {
                // empty catch block
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void breakpointRemoved(final Breakpoint breakpoint) {
        final boolean[] started = new boolean[]{false};
        if (!EventQueue.isDispatchThread() && this.debugger.accessLock.readLock().tryLock()) {
            try {
                this.removeBreakpointImpl(breakpoint);
                return;
            }
            finally {
                this.debugger.accessLock.readLock().unlock();
            }
        }
        this.debugger.getRequestProcessor().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ((BreakpointsEngineListener)BreakpointsEngineListener.this).debugger.accessLock.readLock().lock();
                try {
                    boolean[] blArray = started;
                    synchronized (started) {
                        started[0] = true;
                        started.notify();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        BreakpointsEngineListener.this.removeBreakpointImpl(breakpoint);
                    }
                }
                finally {
                    ((BreakpointsEngineListener)BreakpointsEngineListener.this).debugger.accessLock.readLock().unlock();
                }
                {
                    return;
                }
            }
        });
        if (EventQueue.isDispatchThread()) return;
        boolean[] blArray = started;
        synchronized (started) {
            if (started[0]) return;
            try {
                started.wait();
            }
            catch (InterruptedException iex) {
                // empty catch block
            }
            return;
        }
    }

    public Breakpoint[] initBreakpoints() {
        return new Breakpoint[0];
    }

    public void initWatches() {
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void engineAdded(DebuggerEngine engine) {
    }

    public void engineRemoved(DebuggerEngine engine) {
    }

    private void createBreakpointImpls() {
        Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
        int k = bs.length;
        for (int i = 0; i < k; ++i) {
            this.createBreakpointImpl(bs[i]);
        }
        Properties p = Properties.getDefault().getProperties("debugger.options.JPDA");
        boolean doCatchExceptions = p.getBoolean("CatchExceptions", false);
        if (doCatchExceptions) {
            ExceptionBreakpoint eb = ExceptionBreakpoint.create((String)Throwable.class.getName(), (int)2);
            this.createBreakpointImpl((Breakpoint)eb);
        }
    }

    private void removeBreakpointImpls() {
        Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
        int k = bs.length;
        for (int i = 0; i < k; ++i) {
            Object bDebugger;
            boolean removed = this.removeBreakpointImpl(bs[i]);
            if (!removed || !(bs[i] instanceof JPDABreakpoint)) continue;
            JPDABreakpoint jb = (JPDABreakpoint)bs[i];
            try {
                Method getSessionMethod = JPDABreakpoint.class.getDeclaredMethod("getSession", new Class[0]);
                getSessionMethod.setAccessible(true);
                bDebugger = (JPDADebugger)getSessionMethod.invoke((Object)jb, new Object[0]);
            }
            catch (Exception ex) {
                bDebugger = null;
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (bDebugger == null || !bDebugger.equals((Object)this.debugger)) continue;
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)jb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixBreakpointImpls() {
        ArrayList<BreakpointImpl> bpis;
        Map<Breakpoint, BreakpointImpl> map = this.breakpointToImpl;
        synchronized (map) {
            bpis = new ArrayList<BreakpointImpl>(this.breakpointToImpl.size());
            for (BreakpointImpl bpi : this.breakpointToImpl.values()) {
                if (bpi == this.preliminaryBreakpointImpl) continue;
                bpis.add(bpi);
            }
        }
        for (BreakpointImpl bpi : bpis) {
            bpi.fixed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBreakpointImpl(Breakpoint b) {
        Map<Breakpoint, BreakpointImpl> map = this.breakpointToImpl;
        synchronized (map) {
            Object bDebugger;
            if (this.breakpointToImpl.containsKey(b)) {
                return;
            }
            if (!(b instanceof JPDABreakpoint)) {
                return;
            }
            try {
                Method getSessionMethod = JPDABreakpoint.class.getDeclaredMethod("getSession", new Class[0]);
                getSessionMethod.setAccessible(true);
                bDebugger = (JPDADebugger)getSessionMethod.invoke((Object)b, new Object[0]);
            }
            catch (Exception ex) {
                bDebugger = null;
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (bDebugger != null && !bDebugger.equals((Object)this.debugger)) {
                return;
            }
            this.breakpointToImpl.put(b, this.preliminaryBreakpointImpl);
        }
        BreakpointImpl bpi = b instanceof LineBreakpoint ? new LineBreakpointImpl((LineBreakpoint)b, this.breakpointsReader, this.debugger, this.session, this.engineContext) : (b instanceof ExceptionBreakpoint ? new ExceptionBreakpointImpl((ExceptionBreakpoint)b, this.debugger, this.session) : (b instanceof MethodBreakpoint ? new MethodBreakpointImpl((MethodBreakpoint)b, this.debugger, this.session) : (b instanceof FieldBreakpoint ? new FieldBreakpointImpl((FieldBreakpoint)b, this.debugger, this.session) : (b instanceof ThreadBreakpoint ? new ThreadBreakpointImpl((ThreadBreakpoint)b, this.debugger, this.session) : (b instanceof ClassLoadUnloadBreakpoint ? new ClassBreakpointImpl((ClassLoadUnloadBreakpoint)b, this.debugger, this.session) : null)))));
        BreakpointImpl bpiToRemove = null;
        Map<Breakpoint, BreakpointImpl> map2 = this.breakpointToImpl;
        synchronized (map2) {
            if (bpi == null) {
                this.breakpointToImpl.remove(b);
            } else if (!this.breakpointToImpl.containsKey(b)) {
                bpiToRemove = bpi;
            } else {
                this.breakpointToImpl.put(b, bpi);
            }
        }
        logger.finer("BreakpointsEngineListener: created impl " + bpi + " for " + b);
        if (bpiToRemove != null) {
            bpiToRemove.remove();
            logger.finer("BreakpointsEngineListener: removed impl " + bpiToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeBreakpointImpl(Breakpoint b) {
        BreakpointImpl impl;
        Map<Breakpoint, BreakpointImpl> map = this.breakpointToImpl;
        synchronized (map) {
            impl = this.breakpointToImpl.remove(b);
            if (impl == null) {
                return false;
            }
        }
        logger.finer("BreakpointsEngineListener: removed impl " + impl + " for " + b);
        impl.remove();
        return true;
    }

    private static final class PreliminaryBreakpointImpl
    extends BreakpointImpl {
        public PreliminaryBreakpointImpl() {
            super(null, null, null, null);
        }

        @Override
        protected void setRequests() {
        }

        @Override
        protected EventRequest createEventRequest(EventRequest oldRequest) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean processCondition(Event event) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean exec(Event event) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void removed(EventRequest eventRequest) {
        }

        @Override
        protected void remove() {
        }
    }
}

