/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.copylibstask;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class CopyLibs
extends Jar {
    private static final String LIB = "lib";
    private static final String ATTR_CLASS_PATH = "Class-Path";
    private static final String MANIFEST = "META-INF/MANIFEST.MF";
    private static final String INDEX = "META-INF/INDEX.LIST";
    Path runtimePath;
    private boolean rebase = true;

    public void setRuntimeClassPath(Path path) {
        assert (path != null);
        this.runtimePath = path;
    }

    public Path getRuntimeClassPath() {
        return this.runtimePath;
    }

    public boolean isRebase() {
        return this.rebase;
    }

    public void setRebase(boolean rebase) {
        this.rebase = rebase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.runtimePath == null) {
            throw new BuildException("RuntimeClassPath must be set.");
        }
        String[] pathElements = this.runtimePath.list();
        ArrayList<File> filesToCopy = new ArrayList<File>(pathElements.length);
        for (int i = 0; i < pathElements.length; ++i) {
            File f = new File(pathElements[i]);
            if (!f.canRead()) {
                this.log(String.format("Not copying library %s , it can't be read.", f.getAbsolutePath()), 1);
                continue;
            }
            if (f.isDirectory()) {
                this.log(String.format("Not copying library %s , it's a directory.", f.getAbsolutePath()), 1);
                continue;
            }
            filesToCopy.add(f);
        }
        File destFile = this.getDestFile();
        File destFolder = destFile.getParentFile();
        assert (destFolder != null && destFolder.canWrite());
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.java.j2seproject.copylibstask.Bundle");
            assert (bundle != null);
            File readme = new File(destFolder, bundle.getString("TXT_README_FILE_NAME"));
            if (!readme.exists()) {
                readme.createNewFile();
            }
            PrintWriter out = new PrintWriter(new FileWriter(readme));
            try {
                String content = bundle.getString("TXT_README_FILE_CONTENT");
                out.println(MessageFormat.format(content, destFile.getName()));
            }
            finally {
                out.close();
            }
        }
        catch (IOException ioe) {
            this.log("Cannot generate readme file.", 3);
        }
        if (!filesToCopy.isEmpty()) {
            File libFolder = new File(destFolder, LIB);
            if (!libFolder.exists()) {
                libFolder.mkdir();
                this.log("Create lib folder " + libFolder.toString() + ".", 3);
            }
            assert (libFolder.canWrite());
            FileUtils utils = FileUtils.getFileUtils();
            this.log("Copy libraries to " + libFolder.toString() + ".");
            for (File fileToCopy : filesToCopy) {
                this.log("Copy " + fileToCopy.getName() + " to " + libFolder + ".", 3);
                try {
                    File libFile = new File(libFolder, fileToCopy.getName());
                    if (this.rebase(fileToCopy, libFile)) continue;
                    libFile.delete();
                    utils.copyFile(fileToCopy, libFile);
                }
                catch (IOException ioe) {
                    throw new BuildException((Throwable)ioe);
                }
            }
            FileSet fs = new FileSet();
            fs.setDir(libFolder);
            Path p = new Path(this.getProject());
            p.addFileset(fs);
            this.addConfiguredIndexJars(p);
        } else {
            this.log("Nothing to copy.");
        }
        super.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private boolean rebase(File source, File target) {
        if (!this.rebase) {
            return false;
        }
        try {
            Manifest manifest = null;
            ZipFile zf = new ZipFile(source);
            try {
                boolean bl;
                if (zf.getEntry(INDEX) != null) {
                    boolean bl2 = false;
                    return bl2;
                }
                java.util.zip.ZipEntry manifestEntry = zf.getEntry(MANIFEST);
                if (manifestEntry != null) {
                    InputStreamReader in = new InputStreamReader(zf.getInputStream(manifestEntry), Charset.forName("UTF-8"));
                    try {
                        manifest = new Manifest((Reader)in);
                    }
                    finally {
                        ((Reader)in).close();
                    }
                }
                if (manifest == null) {
                    boolean in = false;
                    return in;
                }
                Manifest.Section mainSection = manifest.getMainSection();
                String classPath = mainSection.getAttributeValue(ATTR_CLASS_PATH);
                if (classPath == null) {
                    boolean bl3 = false;
                    return bl3;
                }
                if (CopyLibs.isSigned(manifest)) {
                    boolean bl4 = false;
                    return bl4;
                }
                StringBuilder result = new StringBuilder();
                boolean changed = false;
                for (String path : classPath.split(" ")) {
                    int index;
                    if (result.length() > 0) {
                        result.append(' ');
                    }
                    if ((index = path.lastIndexOf(47)) >= 0 && index < path.length() - 1) {
                        path = path.substring(index + 1);
                        changed = true;
                    }
                    result.append(path);
                }
                if (!changed) {
                    boolean arr$ = false;
                    return arr$;
                }
                Enumeration<? extends java.util.zip.ZipEntry> zent = zf.entries();
                ZipOutputStream out = new ZipOutputStream(target);
                try {
                    while (zent.hasMoreElements()) {
                        java.util.zip.ZipEntry entry = zent.nextElement();
                        InputStream in = zf.getInputStream(entry);
                        try {
                            if (MANIFEST.equals(entry.getName())) {
                                out.putNextEntry(new ZipEntry(entry));
                                mainSection.removeAttribute(ATTR_CLASS_PATH);
                                mainSection.addAttributeAndCheck(new Manifest.Attribute(ATTR_CLASS_PATH, result.toString()));
                                PrintWriter manifestOut = new PrintWriter(new OutputStreamWriter((OutputStream)out, Charset.forName("UTF-8")));
                                manifest.write(manifestOut);
                                manifestOut.flush();
                                continue;
                            }
                            out.putNextEntry(new ZipEntry(entry));
                            CopyLibs.copy(in, (OutputStream)out);
                        }
                        finally {
                            in.close();
                        }
                    }
                    bl = true;
                }
                catch (Throwable throwable) {
                    out.close();
                    throw throwable;
                }
                out.close();
                return bl;
            }
            finally {
                zf.close();
            }
        }
        catch (Exception e) {
            this.log("Cannot fix dependencies for: " + target.getAbsolutePath(), 1);
            return false;
        }
    }

    private static boolean isSigned(Manifest manifest) {
        Manifest.Section section = manifest.getSection(MANIFEST);
        if (section != null) {
            Enumeration sectionKeys = section.getAttributeKeys();
            while (sectionKeys.hasMoreElements()) {
                if (!((String)sectionKeys.nextElement()).endsWith("-Digest")) continue;
                return true;
            }
        }
        return false;
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] BUFFER = new byte[4096];
        int len;
        while ((len = in.read(BUFFER)) != -1) {
            out.write(BUFFER, 0, len);
        }
        return;
    }
}

