/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.widget;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.ImageWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class ImageLabelWidget
extends Widget {
    private ImageWidget imageWidget;
    private LabelWidget labelWidget;
    private LabelWidget commentWidget;
    private TextFieldInplaceEditor editor = null;
    public static final int DEFAULT_GAP = 4;

    public ImageLabelWidget(Scene scene, Image image, String text) {
        this(scene, image, text, null, 4);
    }

    public ImageLabelWidget(Scene scene, Image image, String text, int hgap) {
        this(scene, image, text, null, hgap);
    }

    public ImageLabelWidget(Scene scene, Image image, String text, String comment) {
        this(scene, image, text, comment, 4);
    }

    public ImageLabelWidget(Scene scene, Image image, String label, String comment, int hgap) {
        super(scene);
        this.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.CENTER, (int)hgap));
        this.setImage(image);
        this.setLabel(label);
        this.setComment(comment);
    }

    public final void setLabel(String label) {
        if (this.labelWidget == null) {
            this.labelWidget = new LabelWidget(this.getScene(), label);
            this.labelWidget.setUseGlyphVector(true);
            this.labelWidget.setAlignment(LabelWidget.Alignment.CENTER);
            this.addChild(this.imageWidget == null || this.getChildren().isEmpty() ? 0 : 1, (Widget)this.labelWidget, 1);
        } else {
            this.labelWidget.setLabel(label);
        }
        this.labelWidget.setVisible(label != null);
    }

    public final void setImage(Image image) {
        if (this.imageWidget == null) {
            this.imageWidget = new ImageWidget(this.getScene(), image);
            this.addChild(0, (Widget)this.imageWidget, 1);
        } else {
            this.imageWidget.setImage(image);
            this.imageWidget.removeChildren();
        }
        this.imageWidget.setVisible(image != null);
    }

    public final void setImage(Widget widget) {
        if (this.imageWidget == null) {
            this.imageWidget = new ImageWidget(this.getScene(), null);
            this.addChild(0, (Widget)this.imageWidget, 1);
        } else {
            this.imageWidget.setImage(null);
            this.imageWidget.removeChildren();
        }
        if (widget != null) {
            this.imageWidget.addChild(widget);
        }
        this.imageWidget.setVisible(widget != null);
    }

    public final void setComment(String comment) {
        if (this.commentWidget == null) {
            this.commentWidget = new LabelWidget(this.getScene(), comment);
            this.addChild((Widget)this.commentWidget, 1);
            this.commentWidget.setPaintAsDisabled(true);
        } else {
            this.commentWidget.setLabel(comment);
        }
        this.commentWidget.setVisible(comment != null);
    }

    public final String getLabel() {
        return this.labelWidget == null ? null : this.labelWidget.getLabel();
    }

    public final Image getImage() {
        return this.imageWidget == null ? null : this.imageWidget.getImage();
    }

    protected final Widget getImageWidget() {
        return this.imageWidget == null || this.imageWidget.getChildren().isEmpty() ? null : (Widget)this.imageWidget.getChildren().get(0);
    }

    public final String getComment() {
        return this.commentWidget == null ? null : this.commentWidget.getLabel();
    }

    public final boolean isPaintAsDisabled() {
        if (this.labelWidget != null) {
            return this.labelWidget.isPaintAsDisabled();
        }
        if (this.imageWidget != null) {
            return this.imageWidget.isPaintAsDisabled();
        }
        if (this.commentWidget != null) {
            return this.commentWidget.isPaintAsDisabled();
        }
        return false;
    }

    public final void setPaintAsDisabled(boolean flag) {
        if (this.labelWidget != null) {
            this.labelWidget.setPaintAsDisabled(flag);
        }
        if (this.imageWidget != null) {
            this.imageWidget.setPaintAsDisabled(flag);
        }
        if (this.commentWidget != null) {
            this.commentWidget.setPaintAsDisabled(flag);
        }
    }

    public final void setLabelForeground(Color forground) {
        if (this.labelWidget != null) {
            this.labelWidget.setForeground(forground);
        }
        if (this.commentWidget != null) {
            this.commentWidget.setForeground(forground);
        }
    }

    public final void setLabelFont(Font font) {
        this.labelWidget.setFont(font);
    }

    public final void setLabelEditor(TextFieldInplaceEditor editor) {
        if (this.editor != null) {
            throw new IllegalStateException("An editor is already specified.");
        }
        this.editor = editor;
        this.getActions().addAction(ActionFactory.createInplaceEditorAction((TextFieldInplaceEditor)editor));
    }

    public final boolean isEditable() {
        return this.editor != null && this.editor.isEnabled((Widget)this);
    }

    protected final LabelWidget getLabelWidget() {
        return this.labelWidget;
    }

    protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
        if (previousState.isFocused() != state.isFocused()) {
            this.labelWidget.setBorder(state.isFocused() ? BorderFactory.createDashedBorder((Color)this.getForeground(), (int)2, (int)2, (boolean)true) : BorderFactory.createEmptyBorder());
            this.revalidate(true);
        }
    }

    public static abstract class PaintableImageWidget
    extends Widget {
        private static final Stroke STROKE = new BasicStroke(1.0f, 2, 0);
        private Shape shape;

        public PaintableImageWidget(Scene scene, Color color, int preferredWidth, int preferredHeight) {
            super(scene);
            this.setPreferredSize(new Dimension(preferredWidth, preferredHeight));
            this.setForeground(color);
        }

        protected abstract Shape createImage(int var1, int var2);

        protected final Shape getImage() {
            if (this.shape == null) {
                this.shape = this.createImage(this.getBounds().width, this.getBounds().height);
            }
            return this.shape;
        }

        protected Stroke getImageStroke() {
            return STROKE;
        }

        protected void paintWidget() {
            Graphics2D gr = this.getGraphics();
            Stroke previousStroke = gr.getStroke();
            Paint oldPaint = gr.getPaint();
            gr.setStroke(this.getImageStroke());
            gr.setPaint(this.getForeground());
            gr.draw(this.getImage());
            gr.setStroke(previousStroke);
            gr.setPaint(oldPaint);
        }
    }
}

