/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.classpath;

import java.util.List;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.WeakSet;

public class IncludePathClassPathProvider
implements ClassPathProvider {
    private static final Set<ClassPath> PROJECT_INCLUDES = new WeakSet();

    public static synchronized void addProjectIncludePath(ClassPath cp) {
        PROJECT_INCLUDES.add(cp);
    }

    public static synchronized void removeProjectIncludePath(ClassPath classPath) {
        PROJECT_INCLUDES.remove(classPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ClassPath findClassPath(FileObject file, String type) {
        if (!FileUtils.isPhpFile((FileObject)file)) return null;
        PhpSourcePath.FileType fileType = PhpSourcePath.getFileType(file);
        switch (fileType) {
            case UNKNOWN: {
                Class<IncludePathClassPathProvider> clazz = IncludePathClassPathProvider.class;
                // MONITORENTER : org.netbeans.modules.php.project.classpath.IncludePathClassPathProvider.class
                for (ClassPath classPath : PROJECT_INCLUDES) {
                    if (!classPath.contains(file)) continue;
                    // MONITOREXIT : clazz
                    return classPath;
                }
                // MONITOREXIT : clazz
            }
            case INCLUDE: {
                List<FileObject> includePath = PhpSourcePath.getIncludePath(file);
                return ClassPathSupport.createClassPath((FileObject[])includePath.toArray(new FileObject[includePath.size()]));
            }
        }
        return null;
    }
}

