/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo.options;

import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoder;
import org.netbeans.modules.cnd.gizmo.options.GizmoOptionsXMLCodec;
import org.netbeans.modules.cnd.gizmo.options.GizmoStringConfiguration;
import org.netbeans.modules.cnd.gizmo.spi.GizmoOptions;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectOptions;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.utils.ui.UIGesturesSupport;
import org.netbeans.modules.dlight.api.tool.DLightConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightConfigurationManager;
import org.netbeans.modules.dlight.api.tool.DLightTool;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.util.NbBundle;

public class GizmoOptionsImpl
implements ConfigurationAuxObject,
GizmoOptions {
    public static final String PROFILE_ID = "gizmo_options";
    public static final String PROFILE_ON_RUN_PROP = "profileOnRun";
    public static final String DATA_PROVIDER_PROP = "dataProvider";
    public static final String CONFIGURATION_PROP = "configuration";
    private static final String GIZMO_CATEGORY = "Gizmo";
    private static final String GIZMO_SIMPLE_CONFIGURATION = "GizmoSimple";
    private final PropertyChangeSupport pcs;
    private boolean needSave = false;
    private BooleanConfiguration profileOnRun;
    private GizmoStringConfiguration dlightConfigurationName;
    private String preferredConfigurationName = null;
    private boolean initialized = false;
    private MakeConfiguration makeConfiguration = null;
    private static ResourceBundle bundle;

    public GizmoOptionsImpl(PropertyChangeSupport pcs) {
        this.pcs = pcs;
        this.profileOnRun = new BooleanConfiguration(MakeProjectOptions.getShowIndicatorsOnRun());
        this.dlightConfigurationName = new GizmoStringConfiguration(this);
    }

    @Override
    public DLightConfiguration getDLightConfiguration() {
        List<DLightConfiguration> list = this.getValidConfigurations();
        if (list == null) {
            return null;
        }
        DLightConfiguration conf = this.getConfigurationByDisplayName(list, this.dlightConfigurationName.getValue());
        if (conf == null) {
            this.setInitialized(false);
            this.init((Configuration)this.getMakeConfiguration());
            conf = this.getConfigurationByDisplayName(list, this.dlightConfigurationName.getValue());
        }
        if (conf == null) {
            conf = this.getConfigurationByName(list, GIZMO_SIMPLE_CONFIGURATION);
        }
        return conf;
    }

    public void setPreferredDLightConfiguration(String name) {
        this.preferredConfigurationName = name;
    }

    public DLightConfiguration getConfigurationByName(List<DLightConfiguration> list, String name) {
        for (DLightConfiguration dlightConf : list) {
            if (!dlightConf.getConfigurationName().equals(name)) continue;
            return dlightConf;
        }
        return null;
    }

    public DLightConfiguration getConfigurationByDisplayName(List<DLightConfiguration> list, String displayName) {
        if (list == null) {
            return null;
        }
        for (DLightConfiguration dlightConf : list) {
            if (!dlightConf.getDisplayedName().equals(displayName)) continue;
            return dlightConf;
        }
        return null;
    }

    public List<String> getValidConfigurationDisplayNames() {
        List<DLightConfiguration> list = this.getValidConfigurations();
        return this.getConfigurationDisplayNames(list);
    }

    public List<String> getValidConfigurationNames() {
        List<DLightConfiguration> list = this.getValidConfigurations();
        return this.getConfigurationNames(list);
    }

    public List<String> getConfigurationDisplayNames(List<DLightConfiguration> list) {
        ArrayList<String> namelist = new ArrayList<String>();
        for (DLightConfiguration dlightConf : list) {
            namelist.add(dlightConf.getDisplayedName());
        }
        return namelist;
    }

    public List<String> getConfigurationNames(List<DLightConfiguration> list) {
        ArrayList<String> namelist = new ArrayList<String>();
        for (DLightConfiguration dlightConf : list) {
            namelist.add(dlightConf.getConfigurationName());
        }
        return namelist;
    }

    public List<DLightConfiguration> getValidConfigurations() {
        if (this.getMakeConfiguration() == null || this.getMakeConfiguration().getDevelopmentHost() == null) {
            return null;
        }
        String platform = this.getMakeConfiguration().getDevelopmentHost().getBuildPlatformDisplayName();
        ArrayList<DLightConfiguration> confs = new ArrayList<DLightConfiguration>();
        block0: for (DLightConfiguration dlightConfiguration : DLightConfigurationManager.getInstance().getConfigurationsByCategoryName(GIZMO_CATEGORY)) {
            if (dlightConfiguration.getPlatforms() == null) continue;
            List platforms = dlightConfiguration.getPlatforms();
            for (String supportedPlatform : platforms) {
                if (platform.indexOf(supportedPlatform) == -1) continue;
                confs.add(dlightConfiguration);
                continue block0;
            }
        }
        if (confs.isEmpty()) {
            DLightConfiguration config = DLightConfigurationManager.getInstance().getConfigurationByName(GIZMO_SIMPLE_CONFIGURATION);
            confs.add(config);
        }
        return confs;
    }

    @Override
    public void init(Configuration conf) {
        if (this.isInitialized()) {
            return;
        }
        this.setMakeConfiguration((MakeConfiguration)conf);
        List<DLightConfiguration> list = this.getValidConfigurations();
        DLightConfiguration preferredConf = null;
        if (this.preferredConfigurationName != null) {
            preferredConf = this.getConfigurationByName(list, this.preferredConfigurationName);
            this.preferredConfigurationName = null;
        }
        ExecutionEnvironment execEnv = this.getMakeConfiguration().getDevelopmentHost().getExecutionEnvironment();
        CompilerSetManager compilerSetManager = CompilerSetManager.get((ExecutionEnvironment)execEnv);
        List compilers = compilerSetManager.getCompilerSets();
        boolean hasSunStudio = false;
        for (CompilerSet cs : compilers) {
            if (!cs.getCompilerFlavor().isSunStudioCompiler()) continue;
            hasSunStudio = true;
            break;
        }
        DLightConfiguration defConf = null;
        for (DLightConfiguration dlightConf : list) {
            if (!dlightConf.isDefault() || dlightConf.getCollectorProviders().contains("SunStudio") && !hasSunStudio) continue;
            defConf = dlightConf;
            break;
        }
        if (defConf == null) {
            defConf = list.get(0);
        }
        if (preferredConf == null) {
            preferredConf = defConf;
        }
        this.dlightConfigurationName.setDefaultValue(defConf.getDisplayedName());
        this.dlightConfigurationName.setValue(preferredConf.getDisplayedName());
        this.setInitialized(true);
    }

    @Override
    public Collection<String> getNames() {
        ArrayList tools = new ArrayList(this.getDLightConfiguration().getToolsSet());
        ArrayList<String> result = new ArrayList<String>();
        for (DLightTool tool : tools) {
            if (!tool.isEnabled()) continue;
            result.add(tool.getID());
        }
        return result;
    }

    public void initialize() {
        this.clearChanged();
    }

    public static GizmoOptionsImpl getOptions(Configuration conf) {
        GizmoOptionsImpl gizmoOptions = (GizmoOptionsImpl)conf.getAuxObject(PROFILE_ID);
        gizmoOptions.init(conf);
        return gizmoOptions;
    }

    public boolean isModified() {
        return this.getProfileOnRun().getModified();
    }

    public String getId() {
        return PROFILE_ID;
    }

    private void checkPropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (oldValue != newValue && this.pcs != null) {
            this.pcs.firePropertyChange(propertyName, oldValue, newValue);
        }
        if (oldValue != newValue && PROFILE_ON_RUN_PROP.equals(propertyName)) {
            UIGesturesSupport.submit((String)"USG_CND_PROFILE_ON_RUN", (Object[])new Object[]{newValue ? "ON" : "OFF"});
        }
    }

    public BooleanConfiguration getProfileOnRun() {
        return this.profileOnRun;
    }

    @Override
    public boolean getProfileOnRunValue() {
        return this.getProfileOnRun().getValue();
    }

    public void setProfileOnRun(BooleanConfiguration profileOnRun) {
        this.profileOnRun = profileOnRun;
    }

    @Override
    public void setProfileOnRunValue(boolean profileOnRunValue) {
        boolean oldValue = this.getProfileOnRunValue();
        this.getProfileOnRun().setValue(profileOnRunValue);
        this.checkPropertyChange(PROFILE_ON_RUN_PROP, oldValue, this.getProfileOnRunValue());
    }

    public boolean shared() {
        return false;
    }

    public XMLDecoder getXMLDecoder() {
        return new GizmoOptionsXMLCodec(this);
    }

    public XMLEncoder getXMLEncoder() {
        return new GizmoOptionsXMLCodec(this);
    }

    public boolean hasChanged() {
        return this.needSave;
    }

    public void clearChanged() {
        this.needSave = false;
    }

    public void assign(ConfigurationAuxObject auxObject) {
        DLightConfiguration conf;
        GizmoOptionsImpl gizmoOptions = (GizmoOptionsImpl)auxObject;
        boolean oldBoolValue = this.getProfileOnRun().getValue();
        this.getProfileOnRun().assign(gizmoOptions.getProfileOnRun());
        this.checkPropertyChange(PROFILE_ON_RUN_PROP, oldBoolValue, this.getProfileOnRunValue());
        this.getDlightConfigurationName().assign(gizmoOptions.getDlightConfigurationName());
        this.setMakeConfiguration(gizmoOptions.getMakeConfiguration());
        this.preferredConfigurationName = null;
        List<DLightConfiguration> list = this.getValidConfigurations();
        if (list != null && (conf = this.getConfigurationByDisplayName(list, this.getDlightConfigurationName().getValue())) != null) {
            this.preferredConfigurationName = conf.getConfigurationName();
        }
    }

    public GizmoOptionsImpl clone(Configuration c) {
        this.init(c);
        GizmoOptionsImpl clone = new GizmoOptionsImpl(null);
        clone.setProfileOnRun(this.getProfileOnRun().clone());
        clone.setDlightConfigurationName(this.getDlightConfigurationName());
        clone.setMakeConfiguration((MakeConfiguration)c);
        clone.setInitialized(true);
        return clone;
    }

    protected static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(GizmoOptionsImpl.class);
        }
        return bundle.getString(s);
    }

    public GizmoStringConfiguration getDlightConfigurationName() {
        return this.dlightConfigurationName;
    }

    public void setDlightConfigurationName(GizmoStringConfiguration dlightConfigurationName) {
        this.dlightConfigurationName = dlightConfigurationName;
    }

    public MakeConfiguration getMakeConfiguration() {
        return this.makeConfiguration;
    }

    public void setMakeConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }
}

