/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.facelets;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import org.netbeans.modules.web.jsf.editor.facelets.DefaultFaceletLibraries;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibrarySupport;
import org.netbeans.modules.web.jsf.editor.facelets.LibraryDescriptor;
import org.netbeans.modules.web.jsfapi.api.Attribute;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.api.LibraryComponent;
import org.netbeans.modules.web.jsfapi.api.Tag;

public abstract class FaceletsLibrary
implements Library {
    protected FaceletsLibrarySupport support;
    private String namespace;

    public FaceletsLibrary(FaceletsLibrarySupport support, String namespace) {
        this.namespace = namespace;
        this.support = support;
    }

    public abstract Collection<? extends NamedComponent> getComponents();

    public abstract URL getLibraryDescriptorSource();

    public abstract LibraryDescriptor getLibraryDescriptor();

    public String getNamespace() {
        return this.namespace;
    }

    public NamedComponent getComponent(String componentName) {
        for (NamedComponent namedComponent : this.getComponents()) {
            if (!namedComponent.getName().equals(componentName)) continue;
            return namedComponent;
        }
        return null;
    }

    public String getDefaultPrefix() {
        return DefaultFaceletLibraries.getLibraryDefaultPrefix(this.getNamespace());
    }

    public String getDisplayName() {
        String displayName = DefaultFaceletLibraries.getLibraryDisplayName(this.getNamespace());
        return displayName != null ? displayName : this.getNamespace();
    }

    public String toString() {
        return "FaceletsLibrary(namespace=" + this.getNamespace() + ", default prefix= " + this.getDefaultPrefix() + ", descriptor= " + this.getLibraryDescriptor();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FaceletsLibrary)) {
            return false;
        }
        FaceletsLibrary other = (FaceletsLibrary)obj;
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return !(this.getNamespace() == null ? other.getNamespace() != null : !this.getNamespace().equals(other.getNamespace()));
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.namespace != null ? this.namespace.hashCode() : 0);
        return hash;
    }

    private static final class ProxyTag
    implements Tag {
        private Tag tag1;
        private Tag tag2;

        public ProxyTag(Tag tag1, Tag tag2) {
            this.tag1 = tag1;
            this.tag2 = tag2;
            assert (tag1 != null);
        }

        public String getName() {
            return this.tag1.getName() == null && this.tag2 != null ? this.tag2.getName() : this.tag1.getName();
        }

        public String getDescription() {
            return this.tag1.getDescription() == null && this.tag2 != null ? this.tag2.getDescription() : this.tag1.getDescription();
        }

        public boolean hasNonGenenericAttributes() {
            return !this.tag1.hasNonGenenericAttributes() && this.tag2 != null ? this.tag2.hasNonGenenericAttributes() : this.tag1.hasNonGenenericAttributes();
        }

        public Collection<Attribute> getAttributes() {
            return !this.tag1.hasNonGenenericAttributes() && this.tag2 != null ? this.tag2.getAttributes() : this.tag1.getAttributes();
        }

        public Attribute getAttribute(String name) {
            return this.tag1.getAttribute(name) == null && this.tag2 != null ? this.tag2.getAttribute(name) : this.tag1.getAttribute(name);
        }
    }

    public class Function
    extends NamedComponent {
        protected Method function;

        protected Function(String name, Method function) {
            super(name);
            this.function = function;
        }

        public Method getFunction() {
            return this.function;
        }

        @Override
        public String[][] getDescription() {
            String[][] myDescr = new String[][]{{"type", "function"}, {"function name", this.getFunction() == null ? "N/A" : this.getFunction().toGenericString()}};
            return this.merge(super.getDescription(), myDescr);
        }
    }

    public class UserTag
    extends NamedComponent {
        protected URL source;

        protected UserTag(String name, URL source) {
            super(name);
            this.source = source;
        }

        public URL getUrl() {
            return this.source;
        }

        @Override
        public String[][] getDescription() {
            String[][] myDescr = new String[][]{{"type", "user tag"}, {"URL", this.getUrl() == null ? "N/A" : this.getUrl().toExternalForm()}};
            return this.merge(super.getDescription(), myDescr);
        }
    }

    public class Component
    extends NamedComponent {
        protected String componentType;
        protected String rendererType;
        protected Class handlerClass;

        protected Component(String name, String componentType, String rendererType, Class handlerClass) {
            super(name);
            this.componentType = componentType;
            this.rendererType = rendererType;
            this.handlerClass = handlerClass;
        }

        public String getComponentType() {
            return this.componentType;
        }

        public String getRendererType() {
            return this.rendererType;
        }

        public Class getHandlerClass() {
            return this.handlerClass;
        }

        @Override
        public String[][] getDescription() {
            String[][] myDescr = new String[][]{{"type", "component"}, {"component type", this.getComponentType() == null ? "N/A" : this.getComponentType()}, {"renderer type", this.getRendererType() == null ? "N/A" : this.getRendererType()}, {"handler class", this.getHandlerClass() == null ? "N/A" : this.getHandlerClass().getName()}};
            return this.merge(super.getDescription(), myDescr);
        }
    }

    public class TagHandler
    extends NamedComponent {
        protected Class type;

        protected TagHandler(String name, Class type) {
            super(name);
            this.type = type;
        }

        public Class getType() {
            return this.type;
        }

        @Override
        public String[][] getDescription() {
            String[][] myDescr = new String[][]{{"type", "tag handler"}, {"class type", this.getType() == null ? "N/A" : this.getType().getName()}};
            return this.merge(super.getDescription(), myDescr);
        }
    }

    public class Behavior
    extends BaseComponent {
        protected Behavior(String name, String id, Class handlerClass) {
            super(name, id, handlerClass);
        }

        @Override
        public String[][] getDescription() {
            String[][] myDescr = new String[][]{{"type", "behavior"}};
            return this.merge(super.getDescription(), myDescr);
        }
    }

    public class Validator
    extends BaseComponent {
        protected Validator(String name, String id, Class handlerClass) {
            super(name, id, handlerClass);
        }

        @Override
        public String[][] getDescription() {
            String[][] myDescr = new String[][]{{"type", "validator"}};
            return this.merge(super.getDescription(), myDescr);
        }
    }

    public class Converter
    extends BaseComponent {
        protected Converter(String name, String id, Class handlerClass) {
            super(name, id, handlerClass);
        }

        @Override
        public String[][] getDescription() {
            String[][] myDescr = new String[][]{{"type", "converter"}};
            return this.merge(super.getDescription(), myDescr);
        }
    }

    public class BaseComponent
    extends NamedComponent {
        protected String id;
        protected Class handlerClass;

        private BaseComponent(String name, String id, Class handlerClass) {
            super(name);
            this.id = id;
            this.handlerClass = handlerClass;
        }

        public Class getHandlerClass() {
            return this.handlerClass;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String[][] getDescription() {
            String[][] myDescr = new String[][]{{"id", this.getId()}, {"handler class", this.getHandlerClass() == null ? "N/A" : this.getHandlerClass().getName()}};
            return this.merge(super.getDescription(), myDescr);
        }
    }

    public class NamedComponent
    implements LibraryComponent {
        protected String name;

        protected NamedComponent(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Tag getTag() {
            return FaceletsLibrary.this.getLibraryDescriptor().getTags().get(this.getName());
        }

        public FaceletsLibrary getLibrary() {
            return FaceletsLibrary.this;
        }

        public String[][] getDescription() {
            return new String[][]{{"name", this.getName()}};
        }

        protected String[][] merge(String[][] first, String[][] second) {
            String[][] merged = new String[first.length + second.length][];
            System.arraycopy(first, 0, merged, 0, first.length);
            System.arraycopy(second, 0, merged, first.length, second.length);
            return merged;
        }
    }
}

