/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.el;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.netbeans.editor.ext.html.parser.api.AstNode;
import org.netbeans.editor.ext.html.parser.api.AstNodeUtils;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.jsf.editor.JsfSupportImpl;
import org.netbeans.modules.web.jsf.editor.el.JsfVariableContext;

public class JsfVariablesModel {
    static boolean inTest = false;
    private static final String VARIABLE_NAME = "var";
    private static final String VALUE_NAME = "value";
    private static WeakReference<JsfVariablesModel> lastModelCache;
    private HtmlParserResult result;
    private SortedSet<JsfVariableContext> contextsList = new TreeSet<JsfVariableContext>();
    private Snapshot topLevelSnapshot;

    public static JsfVariablesModel getModel(HtmlParserResult result, Snapshot topLevelSnapshot) {
        JsfVariablesModel cachedModel;
        if (lastModelCache != null && (cachedModel = (JsfVariablesModel)lastModelCache.get()) != null && cachedModel.result == result) {
            return cachedModel;
        }
        JsfVariablesModel model = new JsfVariablesModel(result, topLevelSnapshot);
        lastModelCache = new WeakReference<JsfVariablesModel>(model);
        return model;
    }

    private JsfVariablesModel(HtmlParserResult result, Snapshot topLevelSnapshot) {
        this.result = result;
        this.topLevelSnapshot = topLevelSnapshot;
        this.initModel();
    }

    private void initModel() {
        JsfSupportImpl sup = JsfSupportImpl.findFor(this.result.getSnapshot().getSource());
        if (sup == null) {
            return;
        }
        Set<String> faceletsLibsNamespaces = inTest ? null : sup.getLibraries().keySet();
        Set declaredNamespaces = this.result.getNamespaces().keySet();
        for (String namespace : declaredNamespaces) {
            if (!inTest && !faceletsLibsNamespaces.contains(namespace)) continue;
            AstNode root = this.result.root(namespace);
            List matches = AstNodeUtils.getChildrenRecursivelly((AstNode)root, (AstNode.NodeFilter)new AstNode.NodeFilter(){

                public boolean accepts(AstNode node) {
                    return node.getAttribute(JsfVariablesModel.VALUE_NAME) != null && node.getAttribute(JsfVariablesModel.VARIABLE_NAME) != null;
                }
            }, (boolean)false);
            for (AstNode node : matches) {
                AstNode.Attribute valueAttr = node.getAttribute(VALUE_NAME);
                if (valueAttr.unquotedValue().isEmpty()) continue;
                int doc_from = this.result.getSnapshot().getOriginalOffset(valueAttr.valueOffset());
                int doc_to = this.result.getSnapshot().getOriginalOffset(valueAttr.valueOffset() + valueAttr.value().length());
                if (doc_from == -1 || doc_to == -1) continue;
                String documentValueContent = ((Object)this.topLevelSnapshot.getText().subSequence(doc_from, doc_to)).toString();
                JsfVariableContext context = new JsfVariableContext(node.logicalStartOffset(), node.logicalEndOffset(), node.getAttribute(VARIABLE_NAME).unquotedValue(), this.unquotedValue(documentValueContent));
                this.contextsList.add(context);
            }
        }
    }

    private String unquotedValue(String value) {
        return this.isValueQuoted(value) ? value.substring(1, value.length() - 1) : value;
    }

    private boolean isValueQuoted(String value) {
        if (value.length() < 2) {
            return false;
        }
        return !(value.charAt(0) != '\'' && value.charAt(0) != '\"' || value.charAt(value.length() - 1) != '\'' && value.charAt(value.length() - 1) != '\"');
    }

    public SortedSet<JsfVariableContext> getContexts() {
        return this.contextsList;
    }

    public JsfVariableContext getContainingContext(int offset) {
        JsfVariableContext match = null;
        for (JsfVariableContext c : this.getContexts()) {
            if (c.getFrom() <= offset && c.getTo() > offset) {
                match = c;
            }
            if (match == null || c.getTo() >= offset) continue;
            break;
        }
        return match;
    }

    public JsfVariableContext getPrecedingContext(int offset) {
        JsfVariableContext c;
        JsfVariableContext match = null;
        Iterator i$ = this.getContexts().iterator();
        while (i$.hasNext() && (c = (JsfVariableContext)i$.next()).getFrom() < offset) {
            match = c;
        }
        return match;
    }

    List<JsfVariableContext> getAncestors(JsfVariableContext context, boolean includeItself) {
        SortedSet<JsfVariableContext> head = this.getContexts().headSet(context);
        JsfVariableContext[] head_array = head.toArray(new JsfVariableContext[0]);
        ArrayList<JsfVariableContext> ancestors = new ArrayList<JsfVariableContext>();
        for (int i = head_array.length - 1; i >= 0; --i) {
            JsfVariableContext c = head_array[i];
            if (c.getTo() <= context.getTo()) continue;
            ancestors.add(c);
        }
        if (includeItself) {
            ancestors.add(0, context);
        }
        return ancestors;
    }

    List<JsfVariableContext> getPredecessors(JsfVariableContext context, boolean includeItself) {
        SortedSet<JsfVariableContext> head = this.getContexts().headSet(context);
        ArrayList<JsfVariableContext> pre = new ArrayList<JsfVariableContext>();
        for (JsfVariableContext c : head) {
            pre.add(0, c);
        }
        if (includeItself) {
            pre.add(0, context);
        }
        return pre;
    }

    String resolveVariable(JsfVariableContext context, boolean nestingAware) {
        List<JsfVariableContext> ancestors;
        Expression expr = Expression.parse(context.getVariableValue());
        String resolved = expr.getPostfix() != null ? expr.getPostfix() : "";
        List<JsfVariableContext> list = ancestors = nestingAware ? this.getAncestors(context, false) : this.getPredecessors(context, false);
        if (ancestors.isEmpty()) {
            return expr.getCleanExpression();
        }
        ArrayList<JsfVariableContext> matching = new ArrayList<JsfVariableContext>();
        for (JsfVariableContext c : ancestors) {
            if (!c.getVariableName().equals(expr.getBase())) continue;
            expr = Expression.parse(c.getVariableValue());
            matching.add(c);
        }
        if (matching.isEmpty()) {
            return expr.getCleanExpression();
        }
        Iterator itr = matching.iterator();
        while (itr.hasNext()) {
            JsfVariableContext c;
            c = (JsfVariableContext)itr.next();
            expr = Expression.parse(c.getVariableValue());
            if (itr.hasNext()) {
                resolved = expr.getPostfix() + "." + resolved;
                continue;
            }
            resolved = expr.getCleanExpression() + "." + resolved;
        }
        return resolved;
    }

    public String resolveExpression(String expression, int offset, boolean nestingAware) {
        JsfVariableContext leaf;
        Expression parsedExpression = Expression.parse(expression);
        JsfVariableContext jsfVariableContext = leaf = nestingAware ? this.getContainingContext(offset) : this.getPrecedingContext(offset);
        if (leaf == null) {
            return null;
        }
        List<JsfVariableContext> ancestors = nestingAware ? this.getAncestors(leaf, true) : this.getPredecessors(leaf, true);
        JsfVariableContext match = null;
        for (JsfVariableContext c : ancestors) {
            if (!c.getVariableName().equals(parsedExpression.getBase())) continue;
            match = c;
            break;
        }
        if (match == null) {
            return null;
        }
        return this.resolveVariable(match, nestingAware) + (parsedExpression.getPostfix() != null ? "." + parsedExpression.getPostfix() : "");
    }

    public List<JsfVariableContext> getAllAvailableVariables(int offset, boolean nestingAware) {
        JsfVariableContext leaf;
        ArrayList<JsfVariableContext> vars = new ArrayList<JsfVariableContext>();
        JsfVariableContext jsfVariableContext = leaf = nestingAware ? this.getContainingContext(offset) : this.getPrecedingContext(offset);
        if (leaf == null) {
            return vars;
        }
        List<JsfVariableContext> ancestors = nestingAware ? this.getAncestors(leaf, true) : this.getPredecessors(leaf, true);
        for (JsfVariableContext c : ancestors) {
            c.setResolvedType(this.resolveVariable(c, nestingAware));
            vars.add(c);
        }
        return vars;
    }

    private static class Expression {
        private String base;
        private String postfix;
        private String expression;

        public static Expression parse(String expression) {
            return new Expression(expression);
        }

        private Expression(String expression) {
            if ((expression.charAt(0) == '#' || expression.charAt(0) == '$') && expression.charAt(1) == '{') {
                expression = expression.substring(2);
            }
            if (expression.charAt(expression.length() - 1) == '}') {
                expression = expression.substring(0, expression.length() - 1);
            }
            this.expression = expression;
            int dotIndex = expression.indexOf(46);
            this.base = dotIndex == -1 ? expression : expression.substring(0, dotIndex);
            this.postfix = dotIndex == -1 ? null : expression.substring(dotIndex + 1);
        }

        public String getCleanExpression() {
            return this.expression;
        }

        public String getBase() {
            return this.base;
        }

        public String getPostfix() {
            return this.postfix;
        }

        public String toString() {
            return super.toString() + " (base=" + this.base + ", postfix=" + this.postfix;
        }
    }
}

