/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.api.project.BrokenIncludes;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.MakeProjectType;
import org.netbeans.modules.cnd.makeproject.actions.AddExistingFolderItemsAction;
import org.netbeans.modules.cnd.makeproject.actions.AddExistingItemAction;
import org.netbeans.modules.cnd.makeproject.actions.NewFolderAction;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configurations;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakefileConfiguration;
import org.netbeans.modules.cnd.makeproject.ui.AnnotatedNode;
import org.netbeans.modules.cnd.makeproject.ui.LogicalViewChildren;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.makeproject.ui.MoreBuildActionsAction;
import org.netbeans.modules.cnd.makeproject.ui.NodeActionFactory;
import org.netbeans.modules.cnd.makeproject.ui.ProjectTabBridge;
import org.netbeans.modules.cnd.makeproject.ui.RemoteDevelopmentAction;
import org.netbeans.modules.cnd.makeproject.ui.SetConfigurationAction;
import org.netbeans.modules.cnd.makeproject.ui.ViewItemNode;
import org.netbeans.modules.cnd.makeproject.ui.ViewItemPasteType;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

final class MakeLogicalViewRootNode
extends AnnotatedNode
implements ChangeListener,
LookupListener,
PropertyChangeListener {
    private static final boolean SYNC_PROJECT_ACTION = Boolean.getBoolean("cnd.remote.sync.project.action");
    private boolean brokenLinks;
    private boolean brokenIncludes;
    private boolean brokenProject;
    private Folder folder;
    private final Lookup.Result<BrokenIncludes> brokenIncludesResult;
    private final MakeLogicalViewProvider provider;
    private final InstanceContent ic;

    public MakeLogicalViewRootNode(Folder folder, MakeLogicalViewProvider provider, InstanceContent ic) {
        this(new ProjectRootChildren(folder, provider), folder, provider, ic);
    }

    private MakeLogicalViewRootNode(ProjectRootChildren children, Folder folder, MakeLogicalViewProvider provider, InstanceContent ic) {
        super((Children)children, (Lookup)new AbstractLookup((AbstractLookup.Content)ic), MakeLogicalViewProvider.ANNOTATION_RP);
        children.setMakeLogicalViewRootNode(this);
        this.ic = ic;
        this.folder = folder;
        this.provider = provider;
        this.setIconBaseWithExtension("org/netbeans/modules/cnd/makeproject/ui/resources/makeProject.gif");
        this.setName(ProjectUtils.getInformation((Project)provider.getProject()).getDisplayName());
        this.brokenIncludesResult = Lookup.getDefault().lookup(new Lookup.Template(BrokenIncludes.class));
        this.brokenIncludesResult.addLookupListener((LookupListener)this);
        this.resultChanged(null);
        this.brokenLinks = MakeLogicalViewProvider.hasBrokenLinks();
        this.brokenIncludes = this.hasBrokenIncludes(provider.getProject());
        this.setForceAnnotation(true);
        if (folder != null) {
            this.updateAnnotationFiles();
        }
        ProjectInformation pi = (ProjectInformation)provider.getProject().getLookup().lookup(ProjectInformation.class);
        pi.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)pi));
    }

    public String getHtmlDisplayName() {
        ExecutionEnvironment env = this.provider.getProject().getRemoteFileSystemHost();
        if (env != null && env.isRemote()) {
            return NbBundle.getMessage(MakeLogicalViewProvider.class, (String)"ProjectHtmlDisplayName", (Object)this.getName(), (Object)env.getDisplayName());
        }
        return super.getHtmlDisplayName();
    }

    public void reInit(MakeConfigurationDescriptor configurationDescriptor) {
        Folder logicalFolders = configurationDescriptor.getLogicalFolders();
        if (this.folder != null) {
            this.ic.remove((Object)this.folder);
        }
        this.folder = logicalFolders;
        this.ic.add((Object)logicalFolders);
        this.setChildren((Children)new LogicalViewChildren(this.folder, this.provider));
        this.stateChanged(null);
    }

    private void setRealProjectFolder(Folder folder) {
        assert (folder != null);
        if (this.folder != null) {
            this.ic.remove((Object)this.folder);
        }
        this.folder = folder;
        this.ic.add((Object)folder);
        this.stateChanged(null);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Node[] selectedNodes = ProjectTabBridge.getInstance().getExplorerManager().getSelectedNodes();
                    ProjectTabBridge.getInstance().getExplorerManager().setSelectedNodes(new Node[0]);
                    ProjectTabBridge.getInstance().getExplorerManager().setSelectedNodes(selectedNodes);
                }
                catch (PropertyVetoException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public Folder getFolder() {
        return this.folder;
    }

    private MakeProject getProject() {
        return this.provider.getProject();
    }

    private boolean gotMakeConfigurationDescriptor() {
        return this.provider.gotMakeConfigurationDescriptor();
    }

    MakeConfigurationDescriptor getMakeConfigurationDescriptor() {
        return this.provider.getMakeConfigurationDescriptor();
    }

    private void updateAnnotationFiles() {
        HashSet<FileObject> set = new HashSet<FileObject>();
        FileObject fo = this.getProject().getProjectDirectory();
        if (fo == null || !fo.isValid()) {
            Logger.getLogger("cnd.makeproject").log(Level.WARNING, "project.getProjectDirectory() == null - {0}", this.getProject());
        }
        set.add(this.getProject().getProjectDirectory());
        if (!this.gotMakeConfigurationDescriptor()) {
            return;
        }
        MakeConfigurationDescriptor makeConfigurationDescriptor = this.getMakeConfigurationDescriptor();
        if (makeConfigurationDescriptor == null) {
            return;
        }
        Configurations confs = makeConfigurationDescriptor.getConfs();
        if (confs == null) {
            return;
        }
        for (Configuration conf : confs.toArray()) {
            MakefileConfiguration makefileConfiguration;
            FileObject buildCommandFO;
            MakeConfiguration makeConfiguration = (MakeConfiguration)conf;
            if (!makeConfiguration.isMakefileConfiguration() || (buildCommandFO = (makefileConfiguration = makeConfiguration.getMakefileConfiguration()).getAbsBuildCommandFileObject()) == null || !buildCommandFO.isValid()) continue;
            try {
                FileObject fileObject = CndFileUtils.getCanonicalFileObject((FileObject)buildCommandFO);
                if (fileObject == null || !fileObject.isValid()) continue;
                set.add(fileObject);
            }
            catch (IOException ioe) {
                ioe.printStackTrace(System.err);
            }
        }
        this.setFiles(set);
        Folder aFolder = this.folder;
        if (aFolder != null) {
            ArrayList<Folder> allFolders = new ArrayList<Folder>();
            allFolders.add(aFolder);
            allFolders.addAll(aFolder.getAllFolders(true));
            Iterator iter = allFolders.iterator();
            while (iter.hasNext()) {
                ((Folder)iter.next()).addChangeListener(this);
            }
        }
    }

    public String getShortDescription() {
        return MakeLogicalViewProvider.getShortDescription(this.provider.getProject());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setName(ProjectUtils.getInformation((Project)this.provider.getProject()).getDisplayName());
        String prop = evt.getPropertyName();
        if ("displayName".equals(prop)) {
            this.fireDisplayNameChange(null, null);
        } else if ("name".equals(prop)) {
            this.fireNameChange(null, null);
        } else if ("icon".equals(prop)) {
            this.fireIconChange();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.brokenLinks = MakeLogicalViewProvider.hasBrokenLinks();
        this.brokenIncludes = this.hasBrokenIncludes(this.getProject());
        this.brokenProject = this.provider.getMakeConfigurationDescriptor().getState() == ConfigurationDescriptor.State.BROKEN || this.provider.getMakeConfigurationDescriptor().getConfs().size() == 0;
        this.updateAnnotationFiles();
        EventQueue.invokeLater(new VisualUpdater());
    }

    public Object getValue(String valstring) {
        if (valstring == null) {
            return super.getValue(null);
        }
        if (valstring.equals("Folder")) {
            return this.folder;
        }
        if (valstring.equals("Project")) {
            return this.getProject();
        }
        if (valstring.equals("This")) {
            return this;
        }
        return super.getValue(valstring);
    }

    public Image getIcon(int type) {
        ProjectInformation pi = (ProjectInformation)this.provider.getProject().getLookup().lookup(ProjectInformation.class);
        return this.mergeBadge(this.annotateIcon(ImageUtilities.icon2Image((Icon)pi.getIcon()), type));
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    private Image mergeBadge(Image original) {
        if (this.brokenLinks) {
            return ImageUtilities.mergeImages((Image)original, (Image)MakeLogicalViewProvider.brokenProjectBadge, (int)8, (int)0);
        }
        if (this.brokenIncludes) {
            return ImageUtilities.mergeImages((Image)original, (Image)MakeLogicalViewProvider.brokenIncludeBadge, (int)8, (int)0);
        }
        if (this.brokenProject) {
            return ImageUtilities.mergeImages((Image)original, (Image)MakeLogicalViewProvider.brokenProjectBadge, (int)8, (int)0);
        }
        return original;
    }

    public Action[] getActions(boolean context) {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (!this.gotMakeConfigurationDescriptor()) {
            actions.add(CommonProjectActions.closeProjectAction());
        } else {
            MakeConfigurationDescriptor descriptor = this.getMakeConfigurationDescriptor();
            if (descriptor != null) {
                descriptor.getLogicalFolders();
            }
            MakeConfiguration active = descriptor == null ? null : descriptor.getActiveConfiguration();
            Action[] standardActions = descriptor == null || active == null || active.isMakefileConfiguration() ? this.getAdditionalDiskFolderActions() : this.getAdditionalLogicalFolderActions();
            actions.addAll(Arrays.asList(standardActions));
            actions.add(null);
            MakeProjectType projectKind = (MakeProjectType)this.provider.getProject().getLookup().lookup(MakeProjectType.class);
            List actionsForMakeProject = Utilities.actionsForPath((String)projectKind.projectActionsPath());
            if (!actionsForMakeProject.isEmpty()) {
                actions.addAll(actionsForMakeProject);
                actions.add(null);
            }
            actions.add((Action)SystemAction.get(FindAction.class));
            actions.addAll(Utilities.actionsForPath((String)"Projects/Actions"));
            actions.add(null);
            actions.add(CommonProjectActions.customizeProjectAction());
        }
        return actions.toArray(new Action[actions.size()]);
    }

    public boolean canRename() {
        return false;
    }

    public PasteType getDropType(Transferable transferable, int action, int index) {
        DataFlavor[] flavors = transferable.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].getSubType().equals("x-org-netbeans-modules-cnd-makeproject-uidnd")) continue;
            return super.getDropType(transferable, action, index);
        }
        return null;
    }

    protected void createPasteTypes(Transferable transferable, List<PasteType> list) {
        DataFlavor[] flavors = transferable.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].getSubType().equals("x-org-netbeans-modules-cnd-makeproject-uidnd")) continue;
            try {
                ViewItemNode viewItemNode = (ViewItemNode)transferable.getTransferData(flavors[i]);
                int type = new Integer(flavors[i].getParameter("mask"));
                list.add(new ViewItemPasteType(this.getFolder(), viewItemNode, type, this.provider));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        super.createPasteTypes(transferable, list);
    }

    private Action[] getAdditionalLogicalFolderActions() {
        ResourceBundle bundle = NbBundle.getBundle(MakeLogicalViewProvider.class);
        Action[] result = new Action[]{CommonProjectActions.newFileAction(), null, SystemAction.get(AddExistingItemAction.class), SystemAction.get(AddExistingFolderItemsAction.class), SystemAction.get(NewFolderAction.class), null, ProjectSensitiveActions.projectCommandAction((String)"build", (String)bundle.getString("LBL_BuildAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)bundle.getString("LBL_RebuildAction_Name"), null), new MoreBuildActionsAction(new Action[]{ProjectSensitiveActions.projectCommandAction((String)"clean", (String)bundle.getString("LBL_CleanAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"batch_build", (String)bundle.getString("LBL_BatchBuildAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"build_packages", (String)bundle.getString("LBL_BuildPackagesAction_Name"), null)}), new SetConfigurationAction(this.getProject()), new RemoteDevelopmentAction(this.getProject()), null, ProjectSensitiveActions.projectCommandAction((String)"run", (String)bundle.getString("LBL_RunAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"debug", (String)bundle.getString("LBL_DebugAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"debug.stepinto", (String)bundle.getString("LBL_DebugAction_Step_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"test", (String)bundle.getString("LBL_TestAction_Name"), null), null, CommonProjectActions.setAsMainProjectAction(), CommonProjectActions.openSubprojectsAction(), CommonProjectActions.closeProjectAction(), null, CommonProjectActions.renameProjectAction(), CommonProjectActions.moveProjectAction(), CommonProjectActions.copyProjectAction(), CommonProjectActions.deleteProjectAction(), null};
        if (SYNC_PROJECT_ACTION) {
            result = NodeActionFactory.insertSyncActions(result, RemoteDevelopmentAction.class);
        }
        return result;
    }

    private Action[] getAdditionalDiskFolderActions() {
        ResourceBundle bundle = NbBundle.getBundle(MakeLogicalViewProvider.class);
        Action[] result = new Action[]{CommonProjectActions.newFileAction(), null, ProjectSensitiveActions.projectCommandAction((String)"build", (String)bundle.getString("LBL_BuildAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)bundle.getString("LBL_RebuildAction_Name"), null), new MoreBuildActionsAction(new Action[]{ProjectSensitiveActions.projectCommandAction((String)"clean", (String)bundle.getString("LBL_CleanAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"batch_build", (String)bundle.getString("LBL_BatchBuildAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"build_packages", (String)bundle.getString("LBL_BuildPackagesAction_Name"), null)}), new SetConfigurationAction(this.getProject()), new RemoteDevelopmentAction(this.getProject()), null, ProjectSensitiveActions.projectCommandAction((String)"run", (String)bundle.getString("LBL_RunAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"debug", (String)bundle.getString("LBL_DebugAction_Name"), null), ProjectSensitiveActions.projectCommandAction((String)"debug.stepinto", (String)bundle.getString("LBL_DebugAction_Step_Name"), null), null, CommonProjectActions.setAsMainProjectAction(), CommonProjectActions.openSubprojectsAction(), CommonProjectActions.closeProjectAction(), null, CommonProjectActions.renameProjectAction(), CommonProjectActions.moveProjectAction(), CommonProjectActions.copyProjectAction(), CommonProjectActions.deleteProjectAction(), null};
        if (SYNC_PROJECT_ACTION) {
            result = NodeActionFactory.insertSyncActions(result, RemoteDevelopmentAction.class);
        }
        return result;
    }

    public void resultChanged(LookupEvent ev) {
        for (BrokenIncludes elem : this.brokenIncludesResult.allInstances()) {
            elem.addChangeListener((ChangeListener)this);
        }
    }

    private boolean hasBrokenIncludes(Project project) {
        NativeProject id;
        BrokenIncludes biProvider = (BrokenIncludes)Lookup.getDefault().lookup(BrokenIncludes.class);
        if (biProvider != null && (id = (NativeProject)project.getLookup().lookup(NativeProject.class)) != null) {
            return biProvider.isBroken(id);
        }
        return false;
    }

    private static final class ProjectRootChildren
    extends LogicalViewChildren {
        private MakeLogicalViewRootNode parent;

        private ProjectRootChildren(Folder folder, MakeLogicalViewProvider provider) {
            super(folder, provider);
        }

        @Override
        protected void onFolderChange(Folder folder) {
            assert (this.parent != null);
            this.parent.setRealProjectFolder(folder);
        }

        private void setMakeLogicalViewRootNode(MakeLogicalViewRootNode parent) {
            assert (this.parent == null);
            this.parent = parent;
        }

        @Override
        protected boolean isRoot() {
            return true;
        }
    }

    private final class VisualUpdater
    implements Runnable {
        private VisualUpdater() {
        }

        @Override
        public void run() {
            if (MakeLogicalViewRootNode.this.brokenProject) {
                MakeLogicalViewRootNode.this.setChildren(Children.LEAF);
            }
            MakeLogicalViewRootNode.this.fireIconChange();
            MakeLogicalViewRootNode.this.fireOpenedIconChange();
            MakeLogicalViewRootNode.this.fireDisplayNameChange(null, null);
        }
    }
}

